C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  Routine:  hdrfil.F                                                  *
C  Purpose:  hdrfil will read a dataset containing seismic data and    *
C            read a dataset containing a plane of traceheader values   *
C            and insert one keyword value into each traceheader        *
C            location indicated by the user-specified keyword          *
c
C  Author:   Mary Ann Thornton    V: 1.0                     10/21/94  *
C***********************************************************************
C***********************************************************************
c**********************************************************************c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
      integer   lhed (SZLNHD)
      integer*2 itr  (SZLNHD)
      real      head (SZLNHD)

      integer   nsamp, nsi, ntrc, nrec, iform, obytes
      integer   luin, luin2, luout, lbytes, nbytes, lbyout
      integer   irs,ire,ns,ne
c------
      real      plane(SZLNHD)
      character ntap * 100, ntap2 * 100, otap * 100, name*6, version*4
      character keyword*6
      logical   verbos, hlp, query
      integer   argis
c-----
      equivalence (itr(1), lhed(1), head(1))

      data lbytes /0/, nbytes/0/, name/'HDRFIL'/, version /' 1.0'/ 
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query.or.hlp )then
            call help()
            stop
      endif
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(ntap,ntap2,otap,ns,ne,irs,ire,keyword,verbos)
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luin2, ntap2,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'hdrfil: no header read from unit ',luin
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c------
c-----read the seismic dataset first
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c----------------------
c-----
      nrout = ire - irs + 1
      call savew(itr, 'NumRec', nrout,  LINHED)
      jtr = ne - ns + 1
      call savew(itr, 'NumTrc', jtr,  LINHED)
c-----
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
 
      lbytes = 0
      call rtape(luin2, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'hdrfil: no header read from unit ',luin2
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c------
c-----read the dataset containing the traceheader values
      call saver(itr, 'NumSmp', nsampc, LINHED)
      call saver(itr, 'SmpInt', nsic  , LINHED)
      call saver(itr, 'NumTrc', ntrcc , LINHED)
      call saver(itr, 'NumRec', nrecc , LINHED)
      call saver(itr, 'Format', iformc, LINHED)
c-----
c-----see if the datasets match in size 
      iflag = -1
      if(ntrc.eq.nsampc .and. ntrcc.eq.nrec)then
c       the datasets match before skipping traces/records
        iflag = 1
      endif
      if(jtr.eq.nsampc .and. ntrcc.eq.nrout)then
c       the datasets match after skipping traces/records
        iflag = 2
      endif
      if(iflag.lt.1)then
         write(LOT,*)'The input datasets do not match in size.'
         write(LOT,*)'The number of traces on the seismic dataset'
         write(LOT,*)'should match the number of samples per trace'
         write(LOT,*)'on the traceheader_value dataset.'
         write(LOT,*)'The number of records on the seismic dataset'
         write(LOT,*)'should match the number of traces per record'
         write(LOT,*)'on the traceheader_value dataset.'
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c-----
      if(verbos) then
         call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               irs,ire,ns,ne,
     &               ntap,ntap2,otap,keyword,nrecc,ntrcc,nsampc)
      endif
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
c--------------------------------------------------
c--------------------------------------------------
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------
c--------------------------------------------------
      call recskp(1,irs-1,luin,ntrc,itr)
      do 1000 jj = irs, ire
         call trcskp(jj,1,ns-1,luin,ntrc,itr)
c        if I skip records on luin, then skip same no. traces on luin2
         if(iflag.eq.2)call trcskp(jj,1,irs-1,luin2,ntrcc,itr)
         nbytes = 0
         call rtape(luin2, itr, nbytes)
         if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)' rec= ',jj,'  trace= ',nn
            go to 999
         endif
         call vmov(lhed(ITHWP1),1,plane,1,nsampc)
         do 1001 nn = ns,ne
            nbytes = 0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)' rec= ',jj,'  trace= ',nn
               go to 999
            endif
            ip = plane(nn)
            call savew(itr, keyword, ip, TRACEHEADER)
            call wrtape(luout, itr, obytes)
 1001    continue
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000 continue
 
  999 continue
      call lbclos ( luin )
      call lbclos ( luin2 )
      call lbclos ( luout )
 
      write(LERR,*)'end of hdrfil, processed',nrec,' record(s)',
     :             ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)'hdrfil reads a seismic dataset and a dataset'
        write(LER,*)'containing traceheader values and inserts one'
        write(LER,*)'of the values into each trace header at a location'
        write(LER,*)'specified by the user-supplied keyword'
#ifdef CRAYSYSTEM
        write(LER,*)'See manual pages by typing: tman hdrfil '
#else
        write(LER,*)'See manual pages by typing: man hdrfil ',
     &              'or:   mman hdrfil'
#endif
        write(LER,*)'See pattern file by typing:   catpat hdrfil'
        write(LER,*)'Build an executable script by typing: ',
     &              '     catpat hdrfil > hdrfil.job'
        write(LER,*)'Execute hdrfil by typing hdrfil and the ',
     &              'program parameters.'
        write(LER,*)'Note that each parameter is proceeded by -a ',
     &              'where "a" is a character(s) corresponding ',
     &              'to some parameter.'
        write(LER,*)'Users enter the following parameters, or use ',
     &              'the default values.'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   : input seismic dataset'    
        write(LER,*)'-N2[ntap2] : input traceheader value dataset'    
        write(LER,*)'-O[otap]   : output dataset'  
        write(LER,*)'-ns[ns]    : start trace number       (default=1)'    
        write(LER,*)'-ne[ne]    : end trace number       (default=all)'
        write(LER,*)'-rs[irs]   : start record number      (default=1)'
        write(LER,*)'-re[ire]   : end record number      (default=all)'
        write(LER,*)'-key[word] : the keyword to insert   (No default)'
        write(LER,*)'-V         : for verbose printout'
        write(LER,*)' '
        write(LER,*)'usage:  '
        write(LER,*)'hdrfil -N[ntap] -N2[ntap2] -O[otap]'
        write(LER,*)'        -ns[ns] -ne[ne] -rs[irs] -re[ire]'
        write(LER,*)'        -key[word] [-V] '
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine gcmdln(ntap,ntap2,otap,ns,ne,irs,ire,keyword,verbos)
c-----
c     get command arguments
c
c     ntap    - C*100     input file name seismic
c     ntap2   - C*100     input file name traceheader plane
c     otap    - C*100     output file name
c     ns      - int       starting trace index
c     ne      - int       ending trace index
c     irs     - int       starting record index
c     ire     - int       ending record index
c     keyword - C*6       keyword to be inserted
c     verbos  - L         verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), ntap2*(*), otap*(*), keyword*(*)
      integer     ns, ne, irs, ire
      logical     verbos
      integer     argis
 
c-------
       call argstr('-N2',ntap2,' ', ' ')
       call argstr('-N', ntap, ' ', ' ')
       call argstr('-O', otap, ' ', ' ')
       call argi4 ('-ns', ns ,1   ,   1)
       call argi4 ('-ne', ne ,0   ,   0)
       call argi4 ('-rs', irs,1   ,   1)
       call argi4 ('-re', ire,0   ,   0)
       call argstr('-key',keyword ,'      ','      ')
       verbos =   (argis('-V') .gt. 0)
c-------

      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     &               irs,ire,ns,ne,
     &               ntap,ntap2,otap,keyword,nrecc,ntrcc,nsampc)
c-----
c     nsamp - I*4     number input samples in trace
c     nsampc- I*4     number output samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     input traces per record
c     ntrcc - I*4     output traces per record
c     nrec  - I*4     input number of records per line
c     nrecc - I*4     output number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name (seismic)
c     ntap2 - C*100   input file name (plane of traceheader values)
c     otap  - C*100   output file name
c     ns    - Int     starting record
c     ne    - Int     ending record
c     irs   - Int     starting trace
c     ire   - Int     ending trace
c     keyword- C*6    keyword to extract
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,ns,ne,irs,ire
      integer     nsampc, ntrcc, nrecc
      character   ntap*100, ntap2*100, otap*100, keyword*6
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*)' # of samples/trace input    =  ', nsamp
      write(LERR,*)' sample interval             =  ', nsi
      write(LERR,*)' traces per record input     =  ', ntrc
      write(LERR,*)' records per line input      =  ', nrec
      write(LERR,*)' format of data              =  ', iform
      write(LERR,*)' input dataset (seismic)     =  ', ntap
      write(LERR,*)' input traceheader values    =  ', ntap2
      write(LERR,*)' output dataset              =  ', otap
      write(LERR,*)' starting record             =  ', irs
      write(LERR,*)' ending record               =  ', ire
      write(LERR,*)' starting trace              =  ', ns
      write(LERR,*)' ending trace                =  ', ne
      write(LERR,*)' keyword to insert           =  ', keyword
      write(LERR,*)' '
 
      return
      end
 
