C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      HELP            -                                               *
C      OPENPR          -                                               *
C      GCMDLN          -                                               *
C      GETLN           -                                               *
C      RTAPE           -                                               *
C      SAVELU          -                                               *
C      SAVER           -                                               *
C      HLHPRT          -                                               *
C      CMDCHK          -                                               *
C      GALLOC          -                                               *
C      SAVEW           -                                               *
C      SAVHLH          -                                               *
C      WRTAPE          -                                               *
C      VERBAL          -                                               *
C      RDPIC           -                                               *
C      RECSKP          -                                               *
C      TRCSKP          -                                               *
C      VMOV            -                                               *
C      SAVER2          -                                               *
C      PUTFP2          -                                               *
C      GETFP2          -                                               *
C      VCLR            -                                               *
C      BIGAR1  REAL    -                                               *
C      ITRHDR  INTEGER -                                               *
C      SUBS            -                                               *
C      BIGAR2  REAL    -                                               *
C      WRPICK          -                                               *
C      LBCLOS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      REAL    REAL -                                                  *
C      FLOAT   REAL -                                                  *
C  FILES:                                                              *
C      LER   ( OUTPUT SEQUENTIAL ) -                                   *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C      LOT   ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 4) -                                                 *
C      50       ( 2) -                                                 *
C      100      ( 2) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      5 DETECTED                               *
C      INTEGER*                                                        *
C      POINTER     (WKADRI, ITRHDR(1))                                 *
C      POINTER     (WKADR1, BIGAR1(1))                                 *
C      POINTER     (WKADR2, BIGAR2(1))                                 *
C      POINTER     (WKADR3, BIGAR3(1))                                 *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 93/11/10 ==================   *
C  NONSTANDARD FEATURES:      6 DETECTED                               *
C      d*********************************************************      *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
c performs gamma scans and propagates picks along best curve.
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c revision history
c Gary Murphy              February 24, 1994             Version 1.1
c     Made arguments compatible with the new xsdprop.
c     Changed slicing procedure to average in window instead
c     of taking the maximum.  The graphical pick is still from
c     the maximum.  The actual pick is from the average.
c
c Gary Murphy              April 05, 1995                Version 1.2
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer * 2 itr  ( SZLNHD )
      real        head ( SZLNHD )
 
      integer     nsamp, nsi, ntrc, nrec, nrecs, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
 
c-----------------------------------------------------------------------
c     next lines needed for reading picks
 
      parameter (lpck=27, lupout=28)
      parameter (maxseg = 3000, maxpnt = 3000, maxnum = maxseg*maxpnt)
      parameter (maxfil = 100, maxmed = maxfil*maxseg)
      integer icolor(1), ocolor(1), npts(1)
      integer npicko(1)
      real rec(1),trac(1),samp(1)
      real reco(1),traco(1),sampo(1)
      real sego(1)
      integer imed(1),nmed(1)
      real jgamin(1),jgamot(1)
      pointer     (prec, rec)
      pointer     (ptrac, trac)
      pointer     (psamp, samp)
      pointer     (preco, reco)
      pointer     (ptraco, traco)
      pointer     (psampo, sampo)
      pointer     (psego, sego)
      pointer     (picolor, icolor)
      pointer     (pocolor, ocolor)
      pointer     (pnpts, npts)
      pointer     (pnpicko, npicko)
      pointer     (pnmed, nmed)
      pointer     (pimed, imed)
      pointer     (pjgamin, jgamin)
      pointer     (pjgamot, jgamot)
      character*20 segnam(maxseg)
      real units(3),offset(3)
      character*128 picks, pout
      integer nout
 
c     maxseg is maximum number of segments allowed
c     maxpnt is maximum number of points for any one segment
c-----------------------------------------------------------------------
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhdr, jzm, nzmin, nzmax
      real        bigar1, bigar2, dist
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkadr5, dist(1))
      pointer     (wkadrj, jzm(1))
      pointer     (wkadrn, nzmin(1))
      pointer     (wkadrx, nzmax(1))
      pointer     (wkadrz, jfnz(1))
c------
      integer     recnum, trcnum
      integer     srcloc, recind, dphind, dstsgn, stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 100, otap * 100, name*4, version*4
      logical     verbos, hlp, query
      logical     heap1, heap2, heap5, heapi
      logical     heapj, heapx, heapn, heapz
      logical     luinop, luouto, lpout
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )
 
      data lbytes / 0 /, nbytes / 0 /, name/'HORGAM'/, version /' 1.2'/
      data luinop /.FALSE./, luouto /.FALSE./
      data no_seg / 0 /, no_pnt / 0 /
      data nout / 0 /
      data iabort / 0 /
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
      if ( hlp ) then
           call help()
           stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             picks,pout,dgamma,jwin,jmed,dz,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      luinop=.TRUE.
      call getln(luout, otap,'w', 1)
      luouto=.TRUE.
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'HORGAM: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
c-----------
c format values are:
 
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------
 
c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.
 
c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs.
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)
 
      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)
 
      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrecs , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 4, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrecs)
 
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
      heap5 = .true.
      heapj = .true.
      heapn = .true.
      heapx = .true.
      heapz = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      if(picks.ne.' ')then
         open(unit=lpck,file=picks,status='old',iostat=jerr)
         if(jerr.ne.0)then
            write(LERR,*)'  Error opening picks file'
            write(LOT,*)' job completed abnormally'
            stop 50
         endif
      else
         write(LERR,*)' Picks filename must be supplied'
         write(LOT,*)' job completed abnormally'
         stop 100
      endif
 
      call rdpici(lprt,lpck,jerr,no_seg,no_pnt)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error reading pick file header'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      itemi = nrecs * no_seg * ITRWRD * SZSMPD
      item1 = ntrc * nsamp  * SZSMPD
      item2 = no_seg * ntrc * nrecs * SZSMPD
      item5 = ntrc * SZSMPD
      itemj = ntrc * ntrc * nsamp  * SZSMPD
      itemn = ntrc * SZSMPD
      itemx = ntrc * SZSMPD
      itemz = ntrc * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadri, itemi, errcdi, aborti)
      call galloc (wkadr1, item1, errcd1, abort1)
      call galloc (wkadr2, item2, errcd2, abort2)
      call galloc (wkadr5, item5, errcd5, abort5)
      call galloc (wkadrj, itemj, errcdj, abortj)
      call galloc (wkadrn, itemn, errcdn, abortn)
      call galloc (wkadrx, itemx, errcdx, abortx)
      call galloc (wkadrz, itemz, errcdz, abortz)
 
      if (errcdi .ne. 0.) heapi = .false.
      if (errcd1 .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
      if (errcd5 .ne. 0.) heap5 = .false.
      if (errcdj .ne. 0.) heapj = .false.
      if (errcdn .ne. 0.) heapn = .false.
      if (errcdx .ne. 0.) heapx = .false.
      if (errcdz .ne. 0.) heapz = .false.
 
      if (.not. heap1 .or. .not. heap1 .or. .not. heap2
     1                .or. .not. heapn .or. .not. heapx
     1                .or. .not. heapz                     
     1                .or. .not. heapi .or. .not. heapj) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item5,'  bytes'
         write(LERR,*) itemj,'  bytes'
         write(LERR,*) itemn,'  bytes'
         write(LERR,*) itemx,'  bytes'
         write(LERR,*) itemz,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item5,'  bytes'
         write(LERR,*) itemj,'  bytes'
         write(LERR,*) itemn,'  bytes'
         write(LERR,*) itemx,'  bytes'
         write(LERR,*) itemz,'  bytes'
         write(LERR,*)' '
      endif

c---------------------------------------------------
 
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
C-----------------------------------------------------------------------
C Read the picks file with rdpic - parameter explanation:
c rec    = x point, trac = y point, samp = z point (returned from rdpic)
c icolor = color number for segment                (returned from rdpic)
c segnam  = name of segment                        (returned from rdpic)
c npts   = npts(1) = no. points in segment 1       (returned from rdpic)
c          npts(2) = no. points in segment 2, etc.
c units  = units for rec,trac,samp                 (returned from rdpic)
c offset = offset for rec,trac,samp                (returned from rdpic)
c maxseg = maximum no. of segments allowed
C no_seg = the no. of segments read                (returned from rdpic)
c maxpnt = maximum no. of pnts/segment allowed
C no_pnt = maximum no. of points in any 1 segment  (returned from rdpic)
C SZSMPD = size of a sample (defined in lhdrsz.h)
C nrec   = no. records in original 'picked' data   (returned from rdpic)
c ntrac  = no. traces in original 'picked' data    (returned from rdpic)
c nsamp  = no. samples in original 'picked' data   (returned from rdpic)
C LERR   = printfile
C lpck   = the input pick file
c jerr   = error flag                              (returned from rdpic)
C-----------------------------------------------------------------------
      if(pout.ne.' ')then
         open(unit=lupout,file=pout,iostat=jerr)
         if(jerr.ne.0)then
            write(LERR,*)'  Error opening output picks file'
            write(LOT,*)' job completed abnormally'
            stop 50
         endif
         lpout=.TRUE.
      else
         write(LERR,*)' Output picks filename must be supplied'
         lpout=.FALSE.
      endif
      write(LERR,10)
   10 format (//, 27X, 'program parameters',//)
      write(LERR,37)picks
      write(LERR,38)pout
   37 format(' input picks dataset = ',A128)
   38 format(' output picks dataset = ',A128)
      if (no_seg .gt. maxseg) then
         write(LERR,*)'  Too many segments in picks file'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(prec,no_seg*no_pnt*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(ptrac,no_seg*no_pnt*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(psamp,no_seg*no_pnt*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(preco,no_seg*nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(ptraco,no_seg*nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(psampo,no_seg*nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(psego,no_seg*nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(picolor,no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pocolor,nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pnpts,no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pnpicko,nrecs*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pnmed,no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pimed,no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      call galloc(pjgamin,nrecs*no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      do i=1,nrecs*no_seg
         jgamin(i)=jtr/2+1
      enddo
      call galloc(pjgamot,nrecs*no_seg*SZSMPD,jerr,iabort)
      if (jerr .ne. 0) then
         write(LERR,*)'  Error allocating memory'
         write(LOT,*)' job completed abnormally'
         goto 999
      endif
      mxseg=no_seg
      mxpnt=no_pnt
      do i=1,mxseg
         nmed(i)=0
      enddo
      do i=1,nrecs
         npicko(i)=0
         ocolor(i)=1
      enddo
      do i = 1,no_seg * ntrc * nrecs
         bigar2(i)=0.
      enddo
      do i = 1, ntrc*nsamp
         bigar1(i)=0.
      enddo
      call rdpic(rec,trac,samp,icolor,segnam,npts,
     &           units,offset,mxseg,no_seg,mxpnt,no_pnt,SZSMPD,
     &           nrec,ntrac,nsmp,LERR,lpck,jerr)
      print *, ' number of segments ', no_seg, mxseg
      print *, ' number of points ', no_pnt, mxpnt
      if (jerr .ne. 0) goto 999
 
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', no_seg, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', nrecc  , LINHED)
      call savew(itr, 'NumSmp', jtr  , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + ntrc * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrecs, iform,
     1                  picks,pout,dgamma,jwin,jmed,dz,ntap,otap)
      end if
 

 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      do jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            ic = 0
            do kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
 
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc , TRACEHEADER)
                  call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
 
 
c------
 
 
                  if (stacor .eq. 30000) then
                     call vclr (tri,1,nsamp)
                  endif
 
c----------------------
c  pack data into array
                  ic = ic + 1
                  dist(ic) = .5*dstsgn
                  istrc = (ic-1) * nsamp
                  call vmov (tri,1, bigar1(istrc+1),1, nsamp)
 
            enddo
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
c-----------------------
c  here's the meat...
c  do something to data
 
                     call subs (jtr, nsamp, bigar1, 
     1                          jzm, dist, nzmin, nzmax, 
     1                          dgamma, dz, jfnz)
                  ishdr = (kk-1) * ITRWRD
                  call vmov (bigar2(istrc+1),1,lhed(ITHWP1),1, jtr)
 
c  (USER: insert your subroutine above)
c-----------------------
 

c  find the stacked trace for this record
            inpick=0
            do i=1,no_seg
               do j=1,npts(i)
                  inpick=inpick+1
                  if (nint(trac(inpick)) .eq. jj) then

c  find the biggest semblance at this sample (return in jgam)
                     isamp=nint(samp(inpick))
                     call fndgam(isamp,bigar1,nsamp,jtr,jgam,jfnz,jwin,
     1                           jgamin,nrecc,no_seg,i,jj,nmed,imed,
     1                           bigar2)

                  endif
               enddo
            enddo
 
        enddo
 
c filter the gammas
        do i=1,no_seg
           call medfil(i,nrecs,mxseg,nmed,imed,jmed,jgamin,jgamot)
        enddo

c generate the output picks
        nout=0
        do jj = irs, ire
 
            inpick=0
            do i=1,no_seg
               do j=1,npts(i)
                  inpick=inpick+1
                  if (nint(trac(inpick)) .eq. jj) then
 
                     isamp=nint(samp(inpick))
                     call getgam (jgamot,nrecs,mxseg,jj,i,jgam,isamp,
     1                            nmed,imed,
     1                            itrhdr,ITRWRD,TRACEHEADER,LERR,
     1                            ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                            ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1                            ifmt_StaCor,l_StaCor,ln_StaCor)
 
                             nout=nout+1
                             if (npicko(jj).eq.0)no_sego=no_sego+1
                             npicko(jj)=npicko(jj)+1
                             reco(nout)=trac(inpick)
                             traco(nout)=jgam
                             sampo(nout)=isamp
                             sego(nout)=jj
                             if (npicko(jj) .gt. no_pnt) then
                                no_pnt=npicko(jj)
                             endif
 
                  endif
               enddo
            enddo
        enddo

      offset(3)=0
      units(3)=1
      nrec=ntrac
      ntrac=jtr
      write(LERR,*)' offsets=',offset(1),offset(2),offset(3)
      write(LERR,*)' units=',units(1),units(2),units(3)
      write(LERR,*)' nrec,ntrac,nsmp=',nrec,ntrac,nsmp
C-----------------------------------------------------------------------
C     This section will write out a new picks file
c     parameters are the same as in the rdpic call
C     To add or delete segments, change value of no_seg
c     To add or delete picks in segment 1, change value of npts(1), etc.
C-----------------------------------------------------------------------
c---------------------
c  extract traces from
c  output array and
c  write output data
      do jj = 1, no_seg
            do kk = 1, nrecc
 
                  istrc = (jj-1)*(nrecc*jtr)+(kk-1)*jtr
                  ishdr = (jj-1)*(nrecc*ITRWRD)+(kk-1)*ITRWRD
                  call vmov (bigar2(istrc+1),1,lhed(ITHWP1),1, jtr)
                  call vmov (itrhdr(ishdr+1),1,lhed,1,ITRWRD)
                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        jj , TRACEHEADER)
                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        kk , TRACEHEADER)
                  call wrtape (luout, itr, obytes)
 
 
            enddo
      enddo
 

      jerr = 0
      if(lpout)
     &call swrpck(reco,traco,sampo,ocolor,segnam,npicko,units,offset,
     &           no_seg,nrecc,jtr,no_sego,no_pnt,LERR,lupout,
     &           sego,nout,jerr)
 
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      if (luinop) call lbclos ( luin )
      if (luouto) call lbclos ( luout )
 
            write(LERR,*)'end of horgam, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'horgam extracts semblance horizons from gamma scans:'
        write(LER,*)
     :'see manual pages for details ( online by typing xmbsman )'
        write(LER,*)' '
        write(LER,*)
     :'execute horgam by typing horgam and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]       (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]       (no default)      : output data file name'
        write(LER,*)
     :' -ns[ns]         (default = first) : start trace number'
        write(LER,*)
     :' -ne[ne]         (default = last)  : end trace number'
        write(LER,*)
     :' -rs[irs]        (default = first) : start record number'
        write(LER,*)
     :' -re[ire]        (default = last)  : end record number'
        write(LER,*)
     :' -P1[picks]      (no default)      : input xsd pick file'
        write(LER,*)
     :' -P2[pout]       (no default)      : output pick file'
        write(LER,*)
     :' -dgamma[dgamma] (default .020)    : delta gamma'
        write(LER,*)
     :' -jwin[jwin]     (default 5)       : window search size'
        write(LER,*)
     :' -jmed[jmed]     (default 3)       : median filter length'
        write(LER,*)
     :' -dz[dz]         (no default)      : delta z'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   horgam -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] -P1[picks] -P2[pout]'
        write(LER,*)
     :'                 -dgamma[dgamma] -jwin[jwin] -jmed[jmed] ',
     :'                 -dz[dz] [-V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GCMDLN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GCMDLN  (NTAP,OTAP,NS,NE,IRS,IRE,PICKS,POUT,VERBOS,REV)         *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C      NS      INTEGER   ??IOU* -                                      *
C      NE      INTEGER   ??IOU* -                                      *
C      IRS     INTEGER   ??IOU* -                                      *
C      IRE     INTEGER   ??IOU* -                                      *
C      PICKS   CHAR*(*)  ??IOU* -                                      *
C      POUT    CHAR*(*)  ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      REV     LOGICAL   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR          -                                               *
C      ARGI4           -                                               *
C      ARGIS   INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  picks,pout,dgamma,jwin,jmed,dz,verbos)
c-----
c     get command arguments
c
c     ntap    - C*100    input file name
c     otap    - C*100    output file name
c     ns      - I*4      starting trace index
c     ne      - I*4      ending trace index
c     irs     - I*4      starting record index
c     ire     - I*4      ending record index
c     picks   - C*100    input file name
c     pout    - C*100    output file name
c     dgamma  - R*4      delta gamma
c     jwin    - I*4      search window size
c     jmed    - I*4      median filter length
c     dz      - R*4      output file name
c     verbos  - L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), picks*(*), pout*(*)
      integer     ns, ne, irs, ire
      logical     verbos
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program horgam might be invoked in the following way:
 
c     horgam  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into horgam and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argstr( '-P1', picks, ' ', ' ' )
            call argstr( '-P2', pout, ' ', ' ' )
            call argr4 ( '-dgamma', dgamma ,   0.020 ,  0.020    )
            call argi4 ( '-jwin', jwin ,  5,  5    )
            call argi4 ( '-jmed', jmed ,  3,  3    )
            call argr4 ( '-dz', dz,   10.,  10.    )
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VERBAL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VERBAL  (NSAMP,NSI,NTRC,NREC,IFORM,PICKS,POUT,NTAP,OTAP)        *
C  ARGUMENTS:                                                          *
C      NSAMP   INTEGER   ??IOU* -                                      *
C      NSI     INTEGER   ??IOU* -                                      *
C      NTRC    INTEGER   ??IOU* -                                      *
C      NREC    INTEGER   ??IOU* -                                      *
C      IFORM   INTEGER   ??IOU* -                                      *
C      PICKS   CHAR*(*)  ??IOU* -                                      *
C      POUT    CHAR*(*)  ??IOU* -                                      *
C      NTAP    CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FLUSH -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  picks,pout,dgamma,jwin,jmed,dz,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp   - I*4     number of samples in trace
c     nsi     - I*4     sample interval in ms
c     ntrc    - I*4     traces per record
c     nrec    - I*4     number of records per line
c     iform   - I*4     format of data
c     ntap    - C*100   input file name
c     otap    - C*100   output file name
c     picks   - C*100   input pick
c     pout    - C*100   output pick
c     dgamma  - R*4     delta gamma
c     jwin    - I*4     search window size
c     jmed    - I*4     median filter length
c     dz      - R*4     delta z
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), picks*(*), pout*(*)
      real        dgamma, dz
      integer     jwin,jmed
 
            write(LERR,*) ' '
            write(LERR,*) ' line header values after default check '
            write(LERR,*) ' # of samples/trace     =  ', nsamp
            write(LERR,*) ' sample interval        =  ', nsi
            write(LERR,*) ' traces per record      =  ', ntrc
            write(LERR,*) ' records per line       =  ', nrec
            write(LERR,*) ' format of data         =  ', iform
            write(LERR,*) ' input data set name    =  ', ntap
            write(LERR,*) ' output data set name   =  ', otap
            write(LERR,*) ' input pick file        =  ', picks
            write(LERR,*) ' output pick file       =  ', pout
            write(LERR,*) ' delta gamma            =  ', dgamma
            write(LERR,*) ' search window size     =  ', jwin
            write(LERR,*) ' median filter length   =  ', jmed
            write(LERR,*) ' delta z                =  ', dz
            write(LERR,*) ' '
            write(LERR,*) ' '
 
 
      return
      end
