C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SUBS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SUBS  (NTR,NSAMP,ARRAY1,ARRAY2,ARRAY3)                          *
C  ARGUMENTS:                                                          *
C      NTR     INTEGER  ??IOU*              -                          *
C      NSAMP   INTEGER  ??IOU*              -                          *
C      ARRAY1  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY2  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY3  REAL     ??IOU*  (NSAMP,NTR) -                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      HILBER -                                                        *
C      VMMA   -                                                        *
C      VSQRT  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c  dummy subroutine - does precisely nothing
 
c  but it is an example of rearranging a vector in main
c  into a matrix
 
      subroutine subs (ntr, nsamp, array1,
     1                 jzm, dist, nzmin, nzmax, dgamma, dz, jfnz)
 
      real      array1(nsamp, ntr)
      integer   jzm(nsamp, ntr, ntr)
      real      dist(ntr)
      integer   jfnz(ntr)
      integer   nzmin(ntr),nzmax(ntr)
      real      dgamma, dz
      logical   first
      data first /.true./
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c---------------


      do i=1,ntr
 
c  find first non-zero sample
                  do jz = 1, nsamp
                    if (array1(jz,i) .ne. 0) goto 543
                  enddo
  543             jfnz(i)=jz

      enddo

      return
      end
 
      subroutine fndgam(isamp,semb,nsamp,jtr,jgam,jfnz,jwin,
     1 jgamin,nrecs,no_seg,iseg,irec,nmed,imed,out)
      real semb(nsamp,jtr)
      integer jfnz(jtr)
      real jgamin(nrecs,no_seg)
      integer nmed(no_seg),imed(no_seg)
      real out(jtr,nrecs,no_seg)
      
      jgam=0
      smbmax=-999999999.
      do i = 1, jtr

       sum = 0.0
       nsum = 0
       do j = 1, jwin

        ksamp = isamp - jwin/2 + j - 1

        if((ksamp.ge.jfnz(i)) .and. (ksamp.le.nsamp))then
c find the biggest value
           if (semb(ksamp,i) .gt. smbmax) then
              smbmax=semb(ksamp,i)
              jgam=i
              ksampx=ksamp
           endif
           sum = semb(ksamp,i) + sum
           nsum = nsum + 1
        endif

       enddo

       if (nsum .ne. 0) sum = sum / nsum
       out(i,irec,iseg)=sum

      enddo

      if (jgam .eq. 0) then
         jgam=jtr/2+1
         ksampx=isamp
      endif

      do i = 1, jtr
         if(i.eq.jgam)then
            out(i,irec,iseg)=-out(i,irec,iseg)
c           out(i,irec,iseg)=-semb(ksampx,i)
c        else
c           out(i,irec,iseg)=semb(ksampx,i)
         endif
      enddo

      jgamin(irec,iseg)=jgam

      if (nmed(iseg) .eq. 0) imed(iseg)=irec
      nmed(iseg)=nmed(iseg)+1

      return
      end

      subroutine medfil(iseg,nrec,maxseg,nmed,imed,jwin,
     1                  jgamin,jgamot)
      integer nmed(nrec),imed(nrec)
      real jgamin(nrec,maxseg)
      real jgamot(nrec,maxseg)
      if (jwin .gt. 1) then
         call median(jgamin(imed(iseg),iseg),nmed(iseg),
     1               jwin,jgamot(imed(iseg),iseg))
      else
         do i=1,nmed(iseg)
            jgamot(imed(iseg),iseg)=jgamin(imed(iseg),iseg)
         enddo
      endif
      return
      end

      subroutine getgam (jgamot,nrecs,mxseg,jj,i,jgam,isamp,
     1                   nmed,imed,
     1                   itrchdr,itrchrdln,TRACEHEADER,lerr,
     1                   ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                   ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1                   ifmt_StaCor,l_StaCor,ln_StaCor)
      integer itrchdr(itrchrdln,nrecs,mxseg)
      integer TRACEHEADER
      integer nmed(mxseg),imed(mxseg)
      integer jsamp,gam,seg
      real jgamot(nrecs,mxseg)

      jgam=nint(jgamot(jj,i))

      jsamp=isamp
      gam=jgam
      seg=i
      if ((jj .lt. imed(i)) .or. (jj .gt. (imed(i)+nmed(i)-1))) then
        jsamp=0
      endif
      call savew(itrchdr(1,jj,i),'StaCor',jsamp,TRACEHEADER)
      call savew(itrchdr(1,jj,i),'DstSgn',gam,TRACEHEADER)
      call savew(itrchdr(1,jj,i),'DstUsg',seg,TRACEHEADER)
      return
      end
