C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c
c    Subroutine histo
c
c    Build a histogram of an input volume.
c
c***********************************************************************

      subroutine histo (irecord,irs,ire,itrace,ns,ne,ntrc,ithed,
     1                  nbytes,nsamp,vmin,vmax,dtrace,luin,lthed,
     2                  hstogrm,hstnm,histout,luhist)

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


      integer     irs, ire, ns, ne
      integer     ntrc, nbytes, nsamp, luin, stacor
      integer     hstnm, luhist
c     integer * 2 ithed(nsamp +(int(SZTRHD/SZSMPD)) + 1)
      integer * 2 ithed(20000)
      integer     lthed(10000)

      real        dtrace(nsamp), hstogrm(hstnm)
      real        vmin, vmax
      real        BucketWidth, Bucket0
      logical     histout

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----
c    Skip over unwanted initial records.
c

      call recskp(1,irs-1,luin,ntrc,ithed)
 
c
c-----
 
c-----
c    We're at the start of the correct record (gather)... now
c    skip to the desired starting trace within that record.
c
      DO 990 irecord = irs, ire

        if (ns .gt. 1) then
          call trcskp(irecord,1,ns-1,luin,ntrc,ithed)
        endif

c
c-----

c-----
c    Process desired traces within a record.
c----
        do 991  itrace = ns, ne
 
          nbytes = 0
          call rtape( luin, ithed, nbytes)

c*****************************************************************
c-----
c    Use previously derived pointers to get trace header values
c    efficiently.
c
          call saver2(lthed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                stacor , TRACEHEADER)
 
c
c    By convention, a "Station Correction" of 30000 is used as
c    a dead trace flag! If the trace is dead, don't use it.
c
          if (stacor .eq. 30000) then
            goto 991
          endif
c*****************************************************************

c-----
c    Copy the data part of the trace across to dtrace. Then 
c    accumulate histogram information.
c
          call vmov (lthed(ITHWP1), 1, dtrace, 1, nsamp)
          call hist (dtrace,1,hstogrm,nsamp,hstnm,vmax,vmin)
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c
c-----
  991   continue
c-----
c    Skip to the end of the record.
c
        if (ne .lt. ntrc) then
          call trcskp(irecord,ne+1,ntrc,luin,ntrc,ithed)
        endif
c
c-----

  990 CONTINUE

      if (histout) then
        BucketWidth = (vmax-vmin)/float(hstnm)
        Bucket0 = vmin - (BucketWidth/2.)
        write (luhist,*) ' '
        write (luhist,*) '"Histogram '
        do i = 1,hstnm   
          write (luhist,*) Bucket0 + float(i)*BucketWidth,hstogrm(i)
        enddo
      endif
 
      return
      end
