C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getvel(ltrm, lprt, luv, ihead, rxx, irx, data, dxout,
     &                  nap, v, nzmax, nxmax, nzgrid, nxgrid,
     &                  nzout, nx, dzgrid, dxgrid, strch, xbegin,
     &                  nxdim, nzdim)

c     THIS ROUTINE READS A VELOCITY TAPE AND MAPS IT INTO
c     A VELOCITY MATRIX WHICH IS IN LOCAL COORDINATES WITH PADS
c
C These are the include files for Saver and Savew.
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c
c     MEMORY ALLOCATION

      integer*2 irx(*)
      integer ihead(*)
      real    rxx(*), data(*), v(nzdim,nxdim)
c
c ****************************************************************
c     Code was added here to allow for the computation of several 
c     varaibles in the Main Kmpw routine used for Heap storage.
C     The getvel is called twice instead of once.  The first call 
C     computes the Heap parameters and the second call executes
c     the remainder of the Getvel routine.  The values computed
c     in the first call are saved.
c
c     Changes made by James Childress MSC, June 3, 1991.
c

      logical lfirst
      integer ltr, jeof, ksamp, lxbias
      integer izmov, ixmov, ixchkd, ixchkv
      real    dxn, dzn

      save jeof, ltr, ksamp, lxbias, izmov,ixmov,ixchkd,ixchkv,
     &     dxn, dzn, lfirst

      data jeof/0/, ltr/0/, ksamp/0/, lxbias/0/, izmov/0/, ixmov/0/
      data ixchkd/0/, ixchkv/0/, dxn/0./, dzn/0./, lfirst/.true./
C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************
C
C     This if block test fo lfirst is done to make sure that this part
C     of the code is only executed one time.
c
      
      if ( lfirst ) then

         jeof = 0
         call rtape (luv, ihead, jeof)

         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING LINE HEADER'
            stop 75
         endif

         call saver( ihead, 'NumTrc', ltr,   LINHED )
         call saver( ihead, 'NumSmp', ksamp, LINHED )
         call saver( ihead, 'Dx1000', jx,    LINHED )
         call saver( ihead, 'Dz1000', jz,    LINHED )
         dxn   = float(jx)/1000.0
         dzn   = float(jz)/1000.0
         jx    = 0
         jz    = 0

         if (dzgrid .gt. 0.0) dzn = dzgrid
         if (dxgrid .gt. 0.0) dxn = dxgrid
         if(dzgrid.le.0.0 .and. dzn.le.0.0 .or.
     &      dxgrid.le.0.0 .and. dxn.le.0.0)then
            write(lprt,77)
  77        format(' DX and/or DZ are zero in the velocity tape line ',
     &     'header. Enter them on command line with flags: -DXT -DZT')
            write(ltrm,77)
            ierr = 100
            return
          endif
czndw06
c     set bias to model origin (in velocity tape traces)
         lxbias = (xbegin/dxn +.5) 
         if(lxbias.gt.ltr) then
c     write(ltrm,*) 'model origin out of range of velocity tape'
            write(lprt,*) 'model origin out of range of velocity tape'
            stop 200
         endif
c     if model origin is positive skip traces on vel tape
         if(lxbias.gt.0) then 
            call skipt(luv, lxbias)
            ltr = ltr-lxbias
         endif

C    check for z limits of the velocity array 
         izmov = 1
89       if (ksamp .gt. nzmax-5) then
            dzn   = dzn * 2.0
            izmov = izmov*2
            ksamp = ksamp / 2
            go to 89
         endif

C    check for x limits of the velocity array 
         ixmov = 1
  90     ixchkd = (nx +  2 * nap) * dxout / dxn + 0.5
         ixchkv = ltr + (2 * nap) * dxout / dxn + 0.5
         if (ixchkd.gt. nxmax-5 .or. ixchkv.gt. nxmax ) then
            dxn   = dxn * 2.0
            ixmov = ixmov*2
            ltr = ltr / 2
            go to 90
         endif 
      

C     define node spacings

         dxgrid = dxn 
         dzgrid = dzn
         nxgrid = ixchkd
         nzgrid = ksamp

         lfirst = .false.
         return
      end if
c
c*******************************************************************
c     Start here when this routine, (Getvel) is called for the second 
c     time.
C*******************************************************************
C     READ DATA INTO ARRAY V
C*******************************************************************

c     check to see if data or velocity tape is bigger and set parms
      lread = ltr
      if(ixchkd.gt.ixchkv) then
         ixtra = ixchkd - ixchkv 
      else
         lread = ixchkd - ixchkv + ltr
         ixtra = 0
      endif
      ixpad   = nap * dxout / dxgrid + 0.5 
cndw06
      if(lxbias.lt.0) ixpad = ixpad - lxbias
      la      = ixpad  
      if(la.lt.0) la = 0
      do 110 l = 1, lread*ixmov
         jeof = 0
         call rtape (luv, rxx, jeof)
         v(1,1) = data(1)

         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING TRACE', l
            stop 75
         endif

         call saver(irx, 'StaCor',istat,TRCHED)
         if (istat .eq. 30000) then
            write (lprt, *) 'DEAD TRACE ON VELOCITY TAPE, trace = ', l
            write (lprt, *) 'JOB TERMINATED'
            stop 75
         endif

         if((l-1)/ixmov*ixmov.eq.l-1) then
            la = la +1
            ja = 3
c           if(l.eq.1) write(ltrm,*) 'la',la
c           if(l.eq.lread*ixmov) write(ltrm,*) 'la',la
            do 105 jz=1,ksamp*izmov,izmov
                  v(ja,la) = data(jz)
                  ja = ja +1
  105       continue
            v(1,la) = v(3,la) 
            v(2,la) = v(3,la) 
         endif
  110 continue
 
C*******************************************************************
C     PAD V IN X DIRECTIONS - to fit data and to allow pads
C*******************************************************************

c     expand velocity to fit the data if necessary
      lleft = la + 1
      if(ixtra.gt.0) then
      do 210 lx = lleft, lleft+ixtra
      do 220 lz = 1,ksamp+2
  220  v(lz,lx) = v(lz,la)
  210 continue
      endif

c     pad lead in
      if(ixpad.gt.0) then
      do 230 lx = 1, ixpad
      do 240 lz = 1,ksamp+2
  240  v(lz,lx) = v(lz,ixpad+1)
  230 continue
      endif

c     pad lead out
      lleft = lleft + ixtra -1
      if(ixpad.gt.0) then
      do 250 lx = lleft+1, lleft+ixpad+1
      do 260 lz = 1,ksamp+2
  260  v(lz,lx) = v(lz,lleft)
  250 continue
      endif

C*******************************************************************
C     CHECK VELOCITY GRID FOR ZEROES
C*******************************************************************

      izz = 0
      do 340 lx = 1, nxgrid
c     do 9340 lz = 1,nzgrid 
c9340 write(ltrm,*) 'lz,lx ,v = ', lz,lx,v(lz,lx)
         call zerock (lprt, v(1,lx), nzgrid, i, iz1)
         izz = izz + iz1
  340 continue

      if (izz .eq. 0) then     
      write(ltrm,*) 'something wrong with velocity input'
      stop 500
      endif

C*******************************************************************
C     STRETCH VELOCITY VALUES 
C*******************************************************************

      do 440 jx = 1, nxgrid
         do 430 jz = 1, nzgrid+2
         v(jz,jx) = v(jz,jx) * strch
c        if(v(jz,jx).le.0.0) write(ltrm,*) '0 v at',jz,jx
c        if(v(jz,jx).le.0.0) write(ltrm,*) v(jz,jx-1),v(jz,jx+1)
  430    continue
  440 continue

      nzgrid = nzgrid + 2

C*******************************************************************
C     EXPAND VELOCITIES TO FILL UP V
C*******************************************************************

c     if (nxgrid .lt. nxmax) then
c        do 460 jx = nxgrid+1, nxmax
c           do 450 jz = 1, nzgrid
c              v(jz,jx) = v(jz,nxgrid)
c 450       continue
c 460    continue
c        nxgrid = nxmax
c     endif

      if (nzgrid .lt. nzmax) then
         do 480 jx = 1, nxmax
            do 470 jz = nzgrid+1, nzmax
               v(jz,jx) = v(nzgrid,jx)
  470       continue
  480    continue
         nzgrid = nzmax
      endif

       call lbclos (luv)
       return
       end
