C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       XZNOD                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Scatters a scalar value to elements of the output matrix that  *
C       correspond to a set of input (x,z) node coordinates and,       *
C       optionally, interpolates additional nodes.                     *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      XZNOD   (XIN,ZIN,NXIN,NXOUT,NRSMP,DX,DZ,DATA2D,NZBIG,TIMOUT,    *
C               XBIAS,ZBIAS)                                           *
C      FXZNOD   (XIN,ZIN,NXIN,NXOUT,NRSMP,DX,DZ,DATA2D,NZBIG,TIMOUT,   *
C                XBIAS,ZBIAS)                                          *
C      CXZNOD   (XIN,ZIN,NXIN,NXOUT,NRSMP,DX,DZ,DATA2D,NZBIG,TIMOUT,   *
C                XBIAS,ZBIAS)                                                *
C  ARGUMENTS:                                                          *
C      XIN     REAL     ??IOU*  (*)   -                                *
C      ZIN     REAL     ??IOU*  (*)   -                                *
C      NXIN    INTEGER  ??IOU*        -                                *
C      NXOUT   INTEGER  ??IOU*        -                                *
C      NRSMP   INTEGER  ??IOU*        -                                *
C      DX      REAL     ??IOU*        -                                *
C      DZ      REAL     ??IOU*        -                                *
C      DATA2D  REAL     ??IOU*  (0:*) -                                *
C      NZBIG   INTEGER  ??IOU*        -                                *
C      TIMOUT  REAL     ??IOU*        -                                *
C      XBIAS   REAL     ??IOU*        -                                *
C      ZBIAS   REAL     ??IOU*        -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/07/22  *
C       CRAY 2 VERSION: ASSEMBLY LANGUAGE                              *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C  HISTORY:                                                            *
C       Original        Dec 90                  R.D. Coleman, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  XZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,            *
C      &              DATA2D, NZMAX, TIMOUT, XBIAS, ZBIAS)             *
C       CALL FXZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,            *
C      &              DATA2D, NZMAX, TIMOUT, XBIAS, ZBIAS )            *
C       CALL CXZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,            *
C      &              DATA2D, NZMAX, TIMOUT, XBIAS, ZBIAS )            *
C                                                                      *
C  PARAMETERS:                                                         *
C       XIN     Real input vector of length NXIN                       *
C               X position of rays.                                    *
C                                                                      *
C       ZIN     Real input vector of length NXIN                       *
C               Z position of rays.                                    *
C                                                                      *
C       NXIN    Integer input scalar                                   *
C               Element count of vectors XIN and ZIN.                  *
C                                                                      *
C       NXOUT   Integer input scalar                                   *
C               Number of elements updated in DATA2D.                  *
C                                                                      *
C       NRSMP   Integer input scalar                                   *
C               Resampling rate.                                       *
C                                                                      *
C       DX      Real input scalar                                      *
C               Delta x.                                               *
C                                                                      *
C       DZ      Real input scalar                                      *
C               Delta z.                                               *
C                                                                      *
C       DATA2D  Real input/output matrix of dimension NZMAX by NXMAX   *
C               Result matrix.                                         *
C                                                                      *
C       NZMAX   Integer input scalar                                   *
C               Leading dimension of matrix DATA2D                     *
C                                                                      *
C       TIMOUT  Real input scalar                                      *
C               Value of time to output.                               *
C                                                                      *
C       XBIAS   Real input scalar                                      *
C               X position bias (subtract xbias/dx from x index)       *
C                                                                      *
C       ZBIAS   Real input scalar                                      *
C               Z position bias (subtract zbias from z         )       *
C
C  DESCRIPTION:                                                        *
C       See FORTRAN equivalent.                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: FXZNOD    INTERPOLATE & SCATTER TO NODES       REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  XZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,
     &                    DATA2D, NZBIG, TIMOUT, XBIAS ,ZBIAS )
      ENTRY      FXZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,
     &                    DATA2D, NZBIG, TIMOUT, XBIAS ,ZBIAS )
      ENTRY      CXZNOD ( XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,
     &                    DATA2D, NZBIG, TIMOUT, XBIAS ,ZBIAS )
c
CDAN WARNING ORIGIN OF data2d is 1
      real xin(*), zin(*), data2d(1:*)
c
c------------------------------------------------------------------
c
      nxout  = nxin
      zover  = 1.0 / dz
      xover  = 1.0 / dx
c
      do j = 1,nxin
      xin(j) = xin(j) - xbias
      zin(j) = zin(j) - zbias
      enddo

      do 10 j = 1, nxin
         jz = nint( zin(j) * zover ) + 1
         jx = nint( xin(j) * xover ) 
         jd = jz + jx * nzbig
         data2d(jd) = timout
   10 continue
c
      nrsmp2 = nrsmp - 2
      if (nrsmp2 .lt. 0) return
c
      nxin1  = nxin - 1
      nxout  = nxin1 * nrsmp + 1
      step   = 1.0 / float( nrsmp )
      stepz  = zover * step
      stepx  = xover * step
      alphaz = zover
      alphax = xover
      betaz  = 0.0
      betax  = 0.0
      do 30 i = 0, nrsmp2
         alphaz = alphaz - stepz
         alphax = alphax - stepx
         betaz  = betaz  + stepz
         betax  = betax  + stepx
         do 20 j = 1, nxin1
            jz = ifix( alphaz * zin(j) + betaz * zin(j+1) )+1
            jx = nint( alphax * xin(j) + betax * xin(j+1) )
            jd = jz + jx * nzbig
            data2d(jd) = timout
   20    continue
   30 continue
c
      return
      end
