C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       logm2vz                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C         Program reads gma logm data and output a vlmx compatible     *
C         file                                                         *
C                                                                      *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Gary Murphy                        ORIGIN DATE: 93/01/11  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/01/11  *
C                                                                      *
C  Revision history                                                    *
C        version 1.1     Gary Murphy                date: 93/02/16  *
C           Added kelly bushing logic                                  *
C        version 1.2     Gary Murphy                date: 93/02/25  *
C           Added better error handling and better water-bottom logic  *
C        version 1.3     Mary Ann Thornton          date: 93/05/18  *
C           Added an include file for the HP to set the logical units  *
C           and changed stderr=0 to stderr=ler                         *
C        version 1.4     Mary Ann Thornton          date: 94/01/04  *
C           Changed the help information written to show correct program
C           name.
C        version 1.5     Gary Murphy                date: 94/04/14  *
C           Changed the help information written to show default for    
C           logm file header length
C        version 1.6     Gary Murphy                date: 94/05/07  *
C           Fixed last sample if last input value falls on boundary
C        version 1.7     Gary Murphy                date: 94/05/16  *
C           Added f2m flag and fixed a bug when log contained blank
C           lines.
C        version 1.8     Mary Ann Thornton          date: 95/04/24  *
C           Program would not compile on Crays under Unicos 8    
C           I changed 2 do loops (look for "cmat" to see changes)
C        version 1.9     Gary Murphy                date: 96/04/17  *
C           Reordered the reading of the command line arguments to get
C           the unique flags first to avoid conflicts. Updated man page
C           to show -DV and Zblock should be multiples of one another.      
C        version 2.0     Gary Murphy                date: 97/01/09  *
C           Convert from microseconds per foot to feet per seconds.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
 
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
 
       parameter (MXSAMP=2048,MXTRC=2048)
       parameter (MXPIKS=2048, MXCRD=2048)
       parameter (LLIST=27, LPRT=26, LOLH=1500)
       parameter (BIGNUMBER=10000.)
       parameter (F2MFAC=.304785126)
 
       integer pairs, stdin, stdout, stderr
       integer trc(1)
       pointer (ptrc, trc)
       integer opf, i, j, k
       integer*2 trchd(1)
       pointer (ptrchd, trchd)
       integer nzgrid, numpic
       integer jerr, nlin, nblock, ndzs, hdln
       integer argis
       real zb, depth, tracpik(1), samppik(1)
       pointer     (ptracpik, tracpik)
       pointer     (psamppik, samppik)
       real vmax, dv, zmax, dz, zmin, trcd(1)
       real vels(1), velsb(1)
       real bacvel(1), bacdep(1)
       real dummy(1)
       pointer (pdummy, dummy)
       pointer (pbakvel, bacvel)
       pointer (pbacdep, bacdep)
       pointer (pvels, vels)
       pointer (pvelsb, velsb)
       pointer (ptrcd, trcd)
       character*80 card
       character*200 logm, vcrds
       character*4 version
       character*6 ppname
       character*1 parr(66), name(35)
       logical help, verbos, f2md, f2mv, micro
 
       data parr/6*' ',' ',' ','L','O','G','M',' ',' ','-',' ',' ',
     1'W','E','L','L',' ','L','O','G',' ','T','O',' ','P',
     2'W','M','V','Z','N',' ','F','O','R','M','A','T',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',15*' '/
 
       data name/'L','O','G','M',31*' '/
       data version/' 1.9'/
       data ppname/'LOGMVZ'/
 
C Set trap for IEEE errors
c      ieeer = ieee_handler ('set','inexact',inkill)
c      if (ieeer .ne. 0)
c    1    print *,' ieee_handler can not set exception '
 
      i = 0
      k = 0
      j = 0
      stdin = 5
      stdout = 1
      stderr = ler
 
C Do help if the user needs it
      help = (argis('-h').gt.0) .or. (argis('-?').gt.0)
      if (help) then
        write(stderr,*)'Command Line Arguments for logm2vz'
        write(stderr,*)'       '
        write(stderr,*)'logm2vz reads a gma logm file'
        write(stderr,*)'and creates a velocity function file'
        write(stderr,*)'that can be fed into pwmvzn.'
        write(stderr,*)'          '
        write(stderr,*)'-L[logm]      .. input logm file'
        write(stderr,*)'               (If logm is "pipe" then'
        write(stderr,*)'                logm2vz uses standard in as'
        write(stderr,*)'                input.)'
        write(stderr,*)'-VC[vcrds]    .. output velocity-depth pairs'
        write(stderr,*)'               (blocked by -zblock)'
        write(stderr,*)'-zblock[zb]   .. depth increment'
        write(stderr,*)'               (Should be multiple of input dz)'
        write(stderr,*)'               (no default)'
        write(stderr,*)'-l[hdln]      .. header length at beginning of'
        write(stderr,*)'               logm file'
        write(stderr,*)'               (default is 10)'
        write(stderr,*)'-v[ivel]      .. column with velocities'
        write(stderr,*)'               (default = 2)'
        write(stderr,*)'-d[idep]      .. column with depths'
        write(stderr,*)'               (default = 3)'
        write(stderr,*)'-Z[zmaxpad]   .. maximum z to pad'
        write(stderr,*)'               (default = end of log)'
        write(stderr,*)'-ZV[zmaxv]    .. velocity to use at end'
        write(stderr,*)'               (default = last velocity on log'
        write(stderr,*)'-W[watbot]    .. water bottom depth'
        write(stderr,*)'               (default = not used)'
        write(stderr,*)'-WV[watvel]   .. water bottom velocity'
        write(stderr,*)'               (default = not used)'
        write(stderr,*)'-kb[bushing]  .. kelly-bushing height'
        write(stderr,*)'               (default = not used)'
        write(stderr,*)'-D[delimiter] .. skip these velocities'
        write(stderr,*)'               (default = not used)'
        write(stderr,*)'-n[ncols]     .. number of columns in file'
        write(stderr,*)'               (default = 6)'
        write(stderr,*)'-DV[dv]       .. threshold on velocity change'
        write(stderr,*)'                 (default = smallest change)'
        write(stderr,*)'-f2md         .. convert from feet to meters'
        write(stderr,*)'                 (default = do nothing)'
        write(stderr,*)'-f2mv         .. convert from feet to meters'
        write(stderr,*)'                 (default = do nothing)'
        write(stderr,*)'-micro        .. convert from mircosec/foot'
        write(stderr,*)'                 (default = do nothing)'
        write(stderr,*)'-V            .. verbos'
        write(stderr,*)' '
        write(stderr,*)'USAGE:'
        write(stderr,*)'logm2vz -L[] -VC[] -zblock[] -V'
        write(stderr,*)' '
        write(stderr,*)' '
        write(stderr,*)' '
        stop
      endif
 
C Get the command line arguments
      call argstr('-L', logm, ' ', ' ')
      call argstr('-VC', vcrds, ' ', ' ')
      call argr4('-zblock', zb, -1.0, -1.0)
      call argi4('-l', hdln, 10, 10)
      call argi4('-v', ivel, 2, 2)
      call argi4('-d', idep, 3, 3)
      call argr4('-ZV', zmaxv, -1.0, -1.0)
      call argr4('-Z', zmaxpad, -1.0, -1.0)
      call argr4('-WV', watvel, -1.0, -1.0)
      call argr4('-W', watbot, -1.0, -1.0)
      call argr4('-kb', bushing, 0.0, 0.0)
      call argr4('-DV', dv, -1.0, -1.0)
      call argr4('-D', delimiter, 0.0, 0.0)
      call argi4('-n', ncols, 6, 6)
      f2md =   (argis( '-f2md' ).GT.0)
      f2mv =   (argis( '-f2mv' ).GT.0)
      micro =   (argis( '-micro' ).GT.0)
      verbos =   (argis( '-V' ).GT.0) 
 
C Check command line arguments
      if(vcrds.eq.' ') then
         write(stderr,*)' must specify velocity card file.'
         stop
      endif
      pairs = 19
      open( unit=pairs,file=vcrds,status='unknown',err=2080)

      if (verbos) then
         write(stderr,*)' -L ', logm
         write(stderr,*)' -VC ', vcrds
         write(stderr,*)' -zblock ', zb
         write(stderr,*)' -l ', hdln
         write(stderr,*)' -v ', ivel
         write(stderr,*)' -d ', idep
         write(stderr,*)' -Z ', zmaxpad
         write(stderr,*)' -ZV ', zmaxv
         write(stderr,*)' -W ', watbot
         write(stderr,*)' -WV ', watvel
         write(stderr,*)' -kb ', bushing
         write(stderr,*)' -D ', delimiter
         write(stderr,*)' -n ', ncols
         write(stderr,*)' -DV ', dv
      endif

      if (ivel .gt. ncols) then
         write(stderr,*)' ivel must be less than number of columns'
         stop
      endif

      if (idep .gt. ncols) then
         write(stderr,*)' idep must be less than number of columns'
         stop
      endif

      if (zb .le. 0) then
         write(stderr,*)' must specify zblock.'
         stop
      endif
 
      if (logm.eq.' ') then
         opf = -1
      else if (logm.eq.'pipe') then
         opf = stdin
      else
         opf = 20
         open(unit=opf, file=logm, status='old', err=2000)
      endif
 
C Open print file
      call openpr( llist, lprt, ppname, jerr)
      if (jerr.ne.0) goto 2110
#include <mbsdate.h>
      nlin = 1
      call gamoco( parr, nlin, lprt)
 
C Read the well log header
cmat  cray compiler will not allow the label "1" to be on the enddo 
cmat  statment, so I made the "1 continue" card for errors on reads
      do i = 1,hdln
         read(opf,*,err=1,end=2060) card
    1    continue
      enddo

C Scan for maximum depth and maximum velocity
      ldummy = ncols * SZSMPD
      call galloc (pdummy, ldummy, errcd0, abort0)
      vmax = 0.
      zmin = 0.
      zmax = 0.
      dz = BIGNUMBER
      autodv = BIGNUMBER
      old_depth = 0.
      old_velocity = 0.
      i=0
  100    read(opf,*,end=110,err=100) (dummy(idum), idum=1,ncols)
  105    format (f9.0, f14.0, 4f13.0)
           if (micro) then
              dummy(ivel)=1000000.0/dummy(ivel)
           endif
           if (dummy(ivel) .gt. delimiter) then
             if (f2md) then
                dummy(idep)=dummy(idep)*F2MFAC
             endif
             if (f2mv) then
                dummy(ivel)=dummy(ivel)*F2MFAC
             endif
             velocity=dummy(ivel)
             depth=dummy(idep)-bushing
             vmax=max(velocity,vmax)
             zmax=max(depth,zmax)
             if (depth .ne. old_depth) then
              dz=min(abs(depth-old_depth),dz)
              old_depth=depth
              if (velocity .ne. old_velocity) then
                 autodv=min(abs(velocity-old_velocity),autodv)
              endif
              old_velocity=velocity
              if (i .eq. 0) then
                 if (verbos)
     &              print *, 'depth = ', depth, ' velocity = ', velocity
              endif
              i=i+1
             endif
           endif
          goto 100
  110 rewind opf
      if (verbos)
     &   print *,'vmax = ',vmax,' zmax = ',zmax,' dz = ',dz, 
     &           ' dv = ',autodv

C Allocate arrays to hold the velocity and depths
      if (autodv .eq. BIGNUMBER) then
         write(stderr,*)' all velocities on the log are the same'
         stop
      endif
      if (dz .le. 0. .or. dz .ge. zb) then
         dz=zb/3
         write(stderr,*)' unusual depth increments encountered on log'
      endif
      nzgrid=(zmax-zmin)/dz
      nblock = (zmax-zmin)/zb
      ndzs = zb/dz
      if (verbos) then
         write (lprt, *) 'zblock = ', zb
         write (lprt, *) 'dz = ', dz
         write (lprt, *) 'nblock = ', nblock
         write (lprt, *) 'ndzs = ', ndzs
      endif
      i = i + 3
      lptracpik = i * SZSMPD
      lpsamppik = i * SZSMPD
      lptrc = (nzgrid + ITRWRD) * SZSMPD
      lpbakvel = (nzgrid) * SZSMPD
      lpbacdep = (nzgrid) * SZSMPD
      lpvels = (nzgrid) * SZSMPD
      lpvelsb = (nzgrid) * SZSMPD
      call galloc (ptracpik, lptracpik, errcd1, abort1)
      call galloc (psamppik, lpsamppik, errcd2, abort2)
      call galloc (ptrc, lptrc, errcd3, abort3)
      call galloc (pbakvel, lpbakvel, errcd4, abort4)
      call galloc (pbacdep, lpbacdep, errcd5, abort5)
      call galloc (pvels, lpvels, errcd6, abort6)
      call galloc (pvelsb, lpvelsb, errcd7, abort7)
      ptrchd = ptrc
#ifdef CRAYSYSTEM
      ibyte = 1
      iplus = 1
#else
      ibyte = ISZBYT
      iplus = 0
#endif
      ptrcd=ptrc+(ithwp1+iplus)*ibyte
      if (verbos) write(stderr, *) 'arrays allocated'


C Read the well log
cmat  cray compiler will not allow the label "1" to be on the enddo 
cmat  statment, so I made the "1 continue" card for errors on reads
      do i = 1, hdln
         read(opf,*,err=124) card
  124    continue
      enddo
      j = 0
      k = 2
      velfst = 0.
      samppik(1) = 0.
      old_depth=-dz
  125 read(opf,*,end=150,err=125)(dummy(idum), idum=1,ncols)
        if (micro) then
           dummy(ivel)=1000000.0/dummy(ivel)
        endif
        if (dummy(ivel) .gt. delimiter) then
          if (f2md) then
             dummy(idep)=dummy(idep)*F2MFAC
          endif
          if (f2mv) then
             dummy(ivel)=dummy(ivel)*F2MFAC
          endif
          if (old_depth.ne.dummy(idep)) then
           old_depth = dummy(idep)
           tracpik(k)=dummy(ivel)
           samppik(k)=dummy(idep)-bushing
           if (velfst .eq. 0.) velfst = tracpik(k)
           vellst = tracpik(k)
           if (samppik(k) .gt. samppik(k-1)) k = k+1
         endif
        endif
      goto 125
  150 continue

C Take care of first and last velocity
       samppik(1) = 0
       tracpik(1) = velfst
       numpic = k-1
       if (samppik(numpic) .lt. zmax) then
          numpic = numpic + 1
          samppik(numpic) = zmax
          tracpik(numpic) = vellst
       endif
       if (verbos) then
          do i = 1, numpic
             write (lprt, *) ' i = ', i,
     &       ' samppik = ', samppik(i), ' tracpik = ', tracpik(i)
          enddo
          write(stderr, *) 'vellst = ', vellst
       endif
       if (numpic.lt.2) goto 2060
 
C Interpolate a velocity at every grid node and put result in vels
       v1=tracpik(1)
       v2=tracpik(2)
       z1=0.
       z2=samppik(2)
       twopnt = (v2-v1)/(z2-z1)
       ipic=2
       depth = -dz
       if (verbos) write(stderr, *) 'starting to grid velocities'
       do izgrid = 1, nzgrid
          depth = depth + dz

C See if it is time to pick up a new pair of velocities (s1,s2,z1,z2)
          if (depth.gt.samppik(ipic))then
             ipic=ipic + 1
               if (ipic .gt. numpic) then
                  ipic = numpic
                  v1 = v2
                  v2 = tracpik(ipic)
                  z1 = z2
                  z2 = samppik(ipic)
                  twopnt = 0
               else
                  v1 = v2
                  z1 = z2
                  v2 = tracpik(ipic)
                  z2 = samppik(ipic)
                  twopnt = (v2-v1)/(z2-z1)
               endif
            endif
            vels(izgrid) = twopnt*(depth-z2) + v2
            if (verbos) then
               write (lprt, *) ' ipic = ', ipic,
     &                         ' vels(izgrid) = ', vels(izgrid),
     &                         ' izgrid = ', izgrid
            endif
       enddo
       if (verbos) write(stderr, *) 'velocities gridded'

C Block the velocities and put them in in velsb
       time=0
       z = 0.
       zdepth = 0.
       bdepth = 0.
       izgrid = 1
       velsb(1) = vels(1)
       print *,'dv before = ', dv
       if (dv .le. 0.0) dv = autodv
       print *,'dv after = ', dv
       velsb(1) = float(ifix((velsb(1)/dv+.5)))*dv
       do iblock = 1, nblock-1
          bdepth = zb*iblock
          ndzs = (bdepth - zdepth) / dz
          do idz = 1, ndzs
             z = z + dz
             izgrid = izgrid + 1
             zdepth=dz*(izgrid-1)
             time = dz/vels(izgrid) + time
          enddo
          rem = bdepth - zdepth
          if (rem .eq. 0.) then
             velsb(iblock+1)=z/time
             velsb(iblock+1)=float(ifix((velsb(iblock+1)/dv+.5)))*dv
             z = 0.
             time = 0.
          else
             z = z + rem
             time = rem/vels(izgrid+1) + time
             velsb(iblock+1) = z/time
             z = dz - rem
             time = z/vels(izgrid+1)
          endif
          if (verbos) then
             write (lprt, *) ' bdepth = ', bdepth,
     &                       ' zdepth = ', zdepth,
     &                       ' velsb(iblock+1) = ', velsb(iblock+1)
          endif
       enddo
       if (bdepth .lt. zmax) then
          if((nblock*zb).lt.zmax)nblock=nblock+1
          velsb(nblock) = vels(nzgrid)
       endif
       if (verbos) write(stderr, *) 'velocities blocked'

C Edit down the number of cards by looping through the cards backwards
C   count the number of necessary cards and put the value in iout
C   put the depths and velocities in bacvel and bacdep
       iout = 1
       bacvel(iout)=vellst
       bacdep(iout)=nblock*zb
       if (zmaxv .lt. 0.) then
          if (bacdep(iout) .lt. zmaxpad) then
             bacdep(iout) = zmaxpad
             if (verbos) 
     &          write(stderr, *) 'changing bacdep(iout) to zmaxpad',
     &                             zmaxpad, zmaxv
          endif
       else
          if (bacdep(iout) .lt. zmaxpad) then
             if (verbos) 
     &          write(stderr, *) 'changing bacdep(iout) to zmaxpad',
     &                             zmaxpad, zmaxv
             bacdep(iout) = zmaxpad
             if (verbos) 
     &          write(stderr, *) 'changing bacvel(iout) to zmaxv',
     &                             zmaxpad, zmaxv
             bacvel(iout) = zmaxv
             if (zmaxv .ne. vellst) then
                iout = iout + 1
                bacvel(iout)=vellst
                bacdep(iout)=nblock*zb
                print *, 'whoops'
             endif
          endif
       endif
       do iblock = nblock, 1, -1
          if (nint(velsb(iblock)) .ne. nint(bacvel(iout))) then
            if ((iblock-1)*zb .gt. watbot) then
             iout = iout + 1
             bacvel(iout) = velsb(iblock)
             bacdep(iout) = (iblock-1)*zb
            endif
          endif
       enddo
       if (watbot .gt. 0.0) then
          iout = iout + 1
          if (watvel .le. 0.) then
             bacvel(iout) = velfst
             bacdep(iout) = watbot
          else
             bacvel(iout) = watvel
             bacdep(iout) = watbot
          endif
       endif

 
C Write out the velocity card file if we were supposed to
       if (pairs.eq.19) then
           write(pairs, 430)
  430      format('NOVEL',5x,'# VELOCITY')
           write(pairs, 435) iout
  435      format('NOVEL',5x,I10)
           write (pairs, 440)
  440      format('VELOCITIES REFLECTED  INCIDENT END DEPTH')
           j=0
           do i = iout,1,-1
              j=j+1
              write (pairs,450) j,bacvel(i),bacdep(i)
  450         format(I10,F10.3,10x,F10.3)
           enddo
       endif
       if (verbos) write(stderr, *) 'velocities printed'
 
       goto 5000
 
C Error messages
 2000  write(stderr,*)' error opening logm file'
       stop
 2060  write(stderr,*)' end of logm file was found'
       stop
 2080  write(stderr,*)' could not open the velocity card file'
       stop
 2110  write(stderr,*)' error opening printout'
       stop
 
 5000  continue
       close(opf)
       if (vcrds.ne.' ') close(pairs)
       end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       INKILL                                               *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/09/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/09/20  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/09/18 ==================   *
C      =BLANK=  ( 1) -                                                 *
C  =============================== DATE: 91/09/20 ==================   *
C  ROUTINE TYPE:  FUNCTION  INTEGER                                    *
C      INKILL  INTEGER  (SIG,CODE,SIGCONTEXT)                          *
C      SIG     INTEGER  ??IOU*      -                                  *
C      CODE    INTEGER  ??IOU*      -                                  *
C      SIGCON  INTEGER  ??IOU*  (5) -                                  *
C      LOC     INTEGER -                                               *
C      196  ( 1) -                                                     *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
c
c      integer function inkill(sig,code,sigcontext)
c      integer sig,code,sigcontext(5)
c      print*,'inexact: ieee exception code',loc(code)
c      stop 196
c      return
c      end
