C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine linear(file1,file2,coeff1,coeff2,lerr,verbose,
     1                  file_temp)
c-----------------------------------------------------------------------
c     Calculate linear combination of data in file1 and file2.
c     Put the result in file1
c-----------------------------------------------------------------------

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      logical       verbose
      character*256 file1,file2,file_temp
      integer       lerr
      real          coeff1,coeff2

c     Declaration for local variables
      character*512 string
      integer       lengstring
      parameter     (lengstring=512)
      character*20  real_to_str,str_coeff1,str_coeff2
      integer       ld_file1,ld_file2,ld_temp,lnst
      integer       lds_coeff1,lde_coeff1,lds_coeff2,lde_coeff2
c-----------------------------------------------------------------------



c-----------------------------------------------------------------------
c     Define the length of the different file name used
c-----------------------------------------------------------------------
      ld_file1 = lnst(file1)
      ld_file2 = lnst(file2)
      ld_temp = lnst(file_temp)


c-----------------------------------------------------------------------
c     Define the length of the different variables used
c-----------------------------------------------------------------------
      str_coeff1 = real_to_str(coeff1,lds_coeff1,lde_coeff1)
      str_coeff2 = real_to_str(coeff2,lds_coeff2,lde_coeff2)


c-----------------------------------------------------------------------
c     Define the command line
c-----------------------------------------------------------------------
      string = 'linear -N1'//file1(1:ld_file1)
     1         //' -N2'//file2(1:ld_file2)
     2         //' -amp1'//str_coeff1(lds_coeff1:lde_coeff1)
     3         //' -amp2'//str_coeff2(lds_coeff2:lde_coeff2)
     4         //' -O'//file_temp(1:ld_temp)


c-----------------------------------------------------------------------
c     Call system
c-----------------------------------------------------------------------
      call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c     Copy file_temp in file1
c-----------------------------------------------------------------------
      string = '/bin/rm -f '//file1(1:ld_file1)//' ; mv '
     1         //file_temp(1:ld_temp)//' '//file1(1:ld_file1)
      call callsys(string,lengstring,lerr,verbose)



      return
      end
