C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Merge  n  Data Sets
C
C**********************************************************************C
C
C MBSMERG READS SEISMIC TRACE DATA FROM N INPUT FILES,
C and either merges trace-by-trace or record-by-record, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, savhlh, saver, savew
C
C**********************************************************************C
C
C     DECLARE VARIABLES

#define C_COMMENTS_DISALLOWED
#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


      INTEGER * 2 ITR ( SZLNHD )
      INTEGER     LHED( 1500 ),luin(10)
      INTEGER     NSAMP, NSI, NTRC(10), NREC(10), IFORM
      INTEGER     LUOUT, LBYTES, NBYTES,obytes
      integer     argis, pipes(10), npipes, pipcnt
#include <f77/pid.h>
      CHARACTER   NAME * 7, otap * 100, version * 4
      character   ntap(10)*100
      character*1 icc(10)
      logical     verbos,mpx,query,nblk,oneblk,wye,back
C
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'MBSMERG'/
      DATA VERSION  /' 1.0'/
      DATA  LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./,nblk/.false./,oneblk/.false./,mpx/.false./
      data icc/'0','1','2','3','4','5','6','7','8','9'/
      data pipes / 0,3,4,5,6,7,8,9,10,11 /,npipes / 0 /

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = (argis('-h').gt.0) .or. (argis('-?').gt.0)
      if(query) then
        call help()
        stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/mbsopen.h>

C**********************************************************************C
C     get commandline arguments
C**********************************************************************C
      call cmdln(icc,ntap,otap,nu,nblk,oneblk,mpx,verbos,wye,back)

C**********************************************************************C
C     open logical i/o units
C**********************************************************************C
      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            call getln(luin(i),ntap(i),'r',0)
            if(luin(i) .eq. 0) then
               write(LOT,*)'Data set cannot be a pipe'
               write(LOT,*)'check command line args & rerun'
               stop
            endif
1        continue
      ELSE
         nu = pipcnt (pipes,10)
         if (nu .gt. 10) then
               write(LOT,*)'Cannot have more then 10 inputs'
               write(LOT,*)'You have  ',nu,'  inputs'
               stop
         endif
         do 2 i = 1, nu
            call sisfdfit (luin(i), pipes(i))
            write(LOT,*)'MBSMERG: got socket number= ',luin(i)
2        continue
      ENDIF

      call getln(luout, otap, 'w', 1)
 
C**********************************************************************C
C     read line headers of input data sets
C     get critical values from line header
C**********************************************************************C
      do 12 i = 1, nu
          lbytes=0
          CALL RTAPE  ( LUIN(i), ITR, LBYTES                  )
          if(lbytes .eq. 0) then
             write(LOT,*)'MBSMERG: no header read on unit ',luin(i)
             write(LOT,*)'FATAL'
             stop
      endif
      call saver(itr, 'NumSmp', nsamp ,  LINHED)
      call saver(itr, 'SmpInt', nsi   ,  LINHED)
      call saver(itr, 'NumTrc', ntrc(i), LINHED)
      call saver(itr, 'NumRec', nrec(i), LINHED)
      call saver(itr, 'Format', iform ,  LINHED)
c     CALL HLHprt ( ITR , LBYTES, NAME, 4, LOT        )
   12 continue

c+++++++++++++++++++++++++++++++++++
      IF (.not. wye) THEN
        iflag=0
          do 13 i=2,nu
             if(ntrc(i) .ne. ntrc(1)) then
               write(LOT,*)'Input trc/rec not alike for unit= ',i
             endif
             if(nrec(i) .ne. nrec(1)) then
               write(LOT,*)'Input rec/line not alike for unit= ',i
               iflag=1
             endif
   13     continue

      write(LOT,*)' '
      if(iflag .eq. 1 .and. oneblk) then
         write(LOT,*)'Input record # or trace # not all alike'
         do  92  i = 1, nu
             write(LOT,*)'DSN= ',i,' # recs= ',nrec(i),
     1       ' # trc/rec= ',ntrc(i)
92       continue
         write(LOT,*)'Last superblock will be a short record'
c        stop
      endif
      write(LOT,*)' '

      ENDIF
c+++++++++++++++++++++++++++++++++++

      nrout = nrec(1)
      nrr   = nrec(1)
      ntrm  = ntrc(1)
c     write(LOT,*)nrout,nrr,ntrm

c**************************************************************
c  multiplex option: put ntuple # in 1/2 wd 70 & flag in wd 69

      if (mpx) then

         write(LOT,*)'multiplex output'
c        ntrcc = ntrm * nu
         do  63  i = 1, nu
             ntrcc = ntrcc + ntrc(i)
63       continue
         call savew( itr, 'RATTrc',  nu , LINHED)
         call savew( itr, 'RATFld',  0  , LINHED)

c-------------------
c  separate blocks back-to-back

      elseif (nblk) then

         write(LOT,*)'blocks back to back'
         ntrcc = ntrm
         nrout = 0
         do  91  i = 1, nu
             nrout = nrout + nrec(i)
91       continue
         call savew( itr, 'RATTrc',  nu , LINHED)
         call savew( itr, 'RATFld',  1  , LINHED)

c-------------------
c  input blocks put into 1 super block

      elseif (oneblk) then

         write(LOT,*)'super block'
         ntrcc = 0
         do  14  iu = 1, nu
             ntrcc = ntrcc + ntrc(iu)
14       continue
         call savew( itr, 'RATTrc',  nu , LINHED)
         call savew( itr, 'RATFld',  2  , LINHED)

c-------------------
c  output data sets one after the other

      elseif (wye) then

         write(LOT,*)'wye'
         ir = 0
         do  19  i = 1, nu
             ir = ir + nrec(i)
19       continue
         nrout = nrec(1) * ntrc(1)
         ntrcc = nu

      elseif (back) then
 
         write(LOT,*)'back'
         ir = 0
         do  i = 1, nu
             ir = ir + nrec(i)
         enddo
         nrout = ir
         ntrcc = ntrc(1)

      endif
c**************************************************************
     
       call savew( itr, 'NumTrc', ntrcc , LINHED)
       call savew( itr, 'NumRec', nrout , LINHED)
      if(nsamp .gt. SZSMPM) nsamp=szsmpm
      nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo
 
C**********************************************************************C
C     write to printout file
C**********************************************************************C
      write(LOT,*)' '
      if( verbos ) then
         write(LOT,*)
         write(LOT,*)' Values read from input data set line header'
         write(LOT,*)
         write(LOT,*) ' # of Samples/Trace =  ', nsamp
         write(LOT,*) ' Sample Interval    =  ', nsi  
         do 17 i=1,nu
            write(LOT,*) ' Traces per Record = ', ntrc(i),' NTAP= ',
     1                 ntap(i),'   Records= ',nrec(i)
   17    continue
         if(mpx) write(LOT,*)' Multiplex option: ntuples created'
         if(nblk) write(LOT,*)' Input blocks placed back-to-back'
         if(oneblk)write(LOT,*)' Input blocks placed in 1 super block'
         if(wye)write(LOT,*)' Output data sets one after the other'
         if(wye)write(LOT,*)' trace by trace'
         if(back)write(LOT,*)' Output data sets one after the other'
         if(back)write(LOT,*)' all of DSN1 followed by all of DSN2...'
         write(LOT,*)' New traces/record = ',ntrcc,' OTAP= ',otap
         write(LOT,*)' New samples/trace= ',nsampo
         write(LOT,*)' Output Records per Line   =  ', nrout 
         write(LOT,*)' Output Traces per Rec     =  ', ntrcc
         write(LOT,*)' Format of Data     =  ', iform
      endif
      write(LOT,*)' '

C**********************************************************************C
C     write to printout file
C**********************************************************************C
      call savhlh(itr,lbytes,lbyout)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

C**********************************************************************C
C     READ TRACES,  WRITE TO OUTPUT FILE
C**********************************************************************C


c--------------------------------------------------------------
c      IF mpx (multiplex) is true  read data sets
c--------------------------------------------------------------
      if(mpx) then

      iuu = 0
      itrcnt = 0
      do 55 iu = 1, nu
      DO 100 JJ = 1, nrec(iu)
         DO 99 KK = 1, ntrc(iu)
           nbytes = 0
           iiu = iiu + 1
           if (iiu .gt. nu) iiu = 1
           itrcnt = itrcnt + 1
           if (itrcnt .gt. ntrcc) then
              itrcnt = 1
              iiu = 1
           endif
           CALL RTAPE  ( LUIN(iiu) , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LOT,*)'End of file on input:'
                  write(LOT,*)'  rec= ',jj,'  trace= ',kk,
     1                         ' DSN= ',ntap(iu)
                  go to 999
               endif
           if(verbos) then
             irec = itr(106)
             itrc = itr(107)
             write(LOT,*)'LUIN= ',luin(iiu),' Rec= ',irec,' Trace= ',
     1       itrc
           endif
c--------------------------------------------------------------
c               put ntuple # in header & write to output
c--------------------------------------------------------------
             call savew( itr, 'FlReFN', iiu   , TRCHED)
             call wrtape(luout,itr,obytes)

 
   99    continue
  100 continue
   55    continue

c--------------------------------------------------------------
c     ELSE IF nblk or oneblk are true  read data sets
c--------------------------------------------------------------
      elseif(nblk .or. oneblk) then

      DO 299 JJ = 1, NRR

      k1=0
      do 155 iu = 1, nu

         ntrace = ntrc(iu)

         DO 199 KK = 1, ntrace
           nbytes = 0
           CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )

               if(nbytes .eq. 0) then
                  write(LOT,*)'End of file on input:'
                  write(LOT,*)'  rec= ',jj,'  trace= ',kk,
     1                         ' DSN= ',ntap(iu)
                  go to 999
               endif
c-------------------------------------------------------------
c            adjust headers
c-------------------------------------------------------------
             call savew( itr, 'FlReFN', 1    , TRCHED)

             if(nblk) then
               irec = nu * (jj-1) + iu
             endif

             if(oneblk) then
               irec = jj
               k1   = k1 + 1
             endif

             call wrtape(luout,itr,obytes)

           if(verbos) then
              call saver( itr, 'TrcNum', itrc , TRCHED)
              write(LOT,*)'LUIN= ',luin(iu),' Trace= ',itrc,' LUOUT= ',
     &                   luout
           endif
 
  199    continue
  155 continue
  299 continue
c--------------------------------------------------------------
c     ELSE IF nblk or oneblk are true  read data sets
c--------------------------------------------------------------
      elseif(wye) then
       ir = 0
       
       DO 398 JJ = 1, nrr
        
          ir = ir + 1
          it = 0
          DO 397 KK = 1, ntrm

             it = it + 1
             do 399 iu = 1, nu
                nbytes = 0
                CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                if(nbytes .eq. 0) then
                   write(LOT,*)'End of file on input:'
                   write(LOT,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                   go to 999
                endif

                call wrtape(luout,itr,obytes)

                if(verbos) then
                  call saver( itr, 'TrcNum', itrc , TRCHED)
                  call saver( itr, 'TrcNum', irec , TRCHED)
                  write(LOT,*)'LUIN= ',iu,luin(iu),' Trace= ',itrc,
     1                    ' Record= ',irec,' LUOUT= ',luout,
     2                    ' written as rec= ',ir,' trc= ',it
                endif

399          continue


397       CONTINUE
398    CONTINUE
c-------------------------------------------------------------
c     all data set1, all data set2, ...
c-------------------------------------------------------------
      elseif(back) then
 
       DO 498 iu = 1, nu
 
          DO 497 JJ = 1, nrec(iu)
 
             do 499 KK = 1, ntrcc
                nbytes = 0
                CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                if(nbytes .eq. 0) then
                   write(LOT,*)'End of file on input:'
                   write(LOT,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                   go to 999
                endif
 
                call wrtape(luout,itr,obytes)
 
                if(verbos) then
                  call saver( itr, 'TrcNum', itrc , TRCHED)
                  call saver( itr, 'TrcNum', irec , TRCHED)
                  write(LOT,*)'LUIN= ',iu,luin(iu),' Trace= ',KK,
     1                    ' Record= ',JJ,' LUOUT= ',luout
                endif
 
499          continue
 
 
497       CONTINUE
498       CONTINUE

c-------------------------------------------------------------
c     end of mpx/nblk/oneblk/wye if
c-------------------------------------------------------------
      endif

  999 continue

c-------------------------------------------------------------
c     close all open units
c-------------------------------------------------------------
      do 21 i=1,nu
         if(verbos)write(LOT,*)'Closing unit ',i
         call lbclos(luin(i))
   21 continue
        call lbclos(luout)
         if(verbos)write(LOT,*)'Closing output unit '
      END

      subroutine help
#include <f77/iounit.h>
 
c----------------------------------------------------------------------
c       help panel
c----------------------------------------------------------------------
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for MBSMERG'
        write(LER,*)'        merge N data sets'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-Ni[ntap]-- input data sets (i=0,1,...,9)'
        write(LER,*)'-O[otap] -- output data set'
        write(LER,*)'-V       -- verbos printout'
        write(LER,*)'-m       -- multiplex input traces'
        write(LER,*)'-b       -- concatenate records back-to-back'
        write(LER,*)'-B       -- back-to-back input records merged into'
        write(LER,*)'            a single output record.'               
        write(LER,*)'-S       -- output data sets one after the other'
        write(LER,*)'            (all of DSN1 followed by DSN2, etc'
        write(LER,*)'-Y       -- same as -m but each output record'
        write(LER,*)'            contains one trace from each unit'
        write(LER,*)'            (useful for rejoining a Y output)'
        write(LER,*)'   ' 
        write(LER,*)'Usage:'
        write(LER,*)'   mbsmerg -N0[] -N1[] ... -N9[] -O[] -[mbBSY] -V'
        write(LER,*)' '

      return
      end

      subroutine cmdln(icc,ntap,otap,nu,nblk,oneblk,mpx,verbos,wye,back)
c-----
c     get command arguments 
c
c      icc  - C*1       characters 0 - 9
c     ntap  - C*100     vector of strings defining input data sets
c     otap  - C*100     string defining output data set
c  flags:
c     nblk  - L         input records are placed back-to-back on output
c   oneblk  - L         input records are combined into one output rec
c      mpx  - L         input traces are multiplexed on output
c   verbos  - L         verbos output flag
c-----
#include <f77/iounit.h>
      character*100  ntap(*), otap
      integer        nu, argis
      character*3    keyh
      character*1    icc(10)
      logical        nblk,oneblk,mpx,verbos,wye,back

c                        get input data set names
      nu=0
         do 21 i=1,10
           keyh='-N'//icc(i)
              call argstr(keyh,ntap(i),' ',' ')
           if(ntap(i) .eq. ' ') go to 1
           nu=nu+1
   21    continue
    1    continue
         if(nu .eq. 0) then
           write(LOT,*)'Since no input files are explicitly'
           write(LOT,*)'named it is assumed mergn is running'
           write(LOT,*)'inside the iconic processor - ikp'
         endif

c                       get output data set name
              call argstr('-O', otap, ' ',' ')

c                       get flags
              nblk = .false.
            oneblk = .false.
               mpx = .false.
            verbos = .false.
              nblk = (argis('-b') .gt. 0)
            oneblk = (argis('-B') .gt. 0)
               mpx = (argis('-m') .gt. 0)
               wye = (argis('-Y') .gt. 0)
              back = (argis('-S') .gt. 0)
            verbos = (argis('-V') .gt. 0)
         if(.not.nblk .and. .not.oneblk .and. .not.mpx .and. .not.wye
     1   .and. .not.back) then
            write(LOT,*)'One of the flags -b, -B, -m -S must be set'
            write(LOT,*)'rerun'
            stop
         endif


      return
      end

