C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine mkgcmdln( otap, nrec, ntrc, nsmp, time, off, rad
     &     , icmplx, ffile, nsi, nxshft, nyshft, lbnd, ubnd, iseed
     &     , verbos, icase )
c***********************************************************************

c     GET COMMAND LINE ARGUMENTS

c***********************************************************************

      implicit none

c     output parameters:

      integer   icase           ! case index
      integer   iseed           ! random number generator seed
      integer   icmplx          ! 1 if real, 2 if complex samples
      character ffile*(*)       ! frequency file name
      real      lbnd            ! lower bound for random samples
      integer   nrec            ! number of records in output dataset
      integer   nsi             ! sample interval (in msec)
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record
      integer   nxshft          ! sample shift in x direction
      integer   nyshft          ! sample shift in y direction
      integer   off             ! offset for icase=2
      character otap*128        ! name of output dataset
      integer   rad             ! radix for icase=2
      real      time            ! time per trace (sec)
      real      ubnd            ! upper bound for random samples
      logical   verbos          ! verbose output flag

c     local variables:

      integer ier               ! error flag

c     functions:

      integer   argis           ! is argument present function
      logical errchk            ! check if error, print warning message

c***********************************************************************

c     get command line arguments

      icmplx = 1

      verbos =   ( argis('-V') .gt. 0 )

      call argstr( '-O'   , otap, ' ', ' ' )

      call argi4 ( '-nrec', nrec, -1  , -1   )
      call argi4 ( '-ntrc', ntrc, -1  , -1   )
      call argi4 ( '-nsmp', nsmp, -1  , -1   )

      if( errchk(nrec.le.0,'nrec<=0', ier ) ) stop
      if( errchk(ntrc.le.0,'ntrc<=0', ier ) ) stop
      if( errchk(nsmp.le.0,'nsmp<=0', ier ) ) stop

c     determine case (-RAN is default)

      icase = 4

      if( argis( '-COS' ) .gt. 0 ) icase = 1
      if( argis( '-INT' ) .gt. 0 ) icase = 2
      if( argis( '-SIG' ) .gt. 0 ) icase = 3
      if( argis( '-RAN' ) .gt. 0 ) icase = 4

      if( icase .eq. 1 ) then
c     COS case

         call argr4 ( '-t'   , time, 1.0, 1.0 )

      elseif( icase .eq. 2 ) then
c     INT case

         call argr4 ( '-t'   , time, 1.0, 1.0 )
         call argi4 ( '-off' , off , 0  , 0   )
         call argi4 ( '-rad' , rad , 512, 512 )

      elseif( icase .eq. 3 ) then
c     SIG case

         call argstr( '-F'     , ffile , ' ', ' ' )
         call argi4 ( '-nsi'   , nsi   , 1  , 1   )
         call argi4 ( '-nxshft', nxshft, 2  , 2   )
         call argi4 ( '-nyshft', nyshft, 3  , 3   )
         if( argis('-C') .gt. 0 ) icmplx = 2

         if( errchk(ffile.eq.' ','ffile must be specified',ier)) stop
         if( errchk(nsi.le.0,'nsi must be > 0',ier)) stop
         if( errchk(nxshft.lt.0.or.nyshft.lt.0
     &        , 'nxshft and nyshft must be > 0', ier ) ) stop

      elseif( icase .eq. 4 ) then
c     RAN case

         call argr4 ( '-t'   , time, 1.0, 1.0 )
         call argr4 ( '-lbnd', lbnd , 0.0, 0.0 )
         call argr4 ( '-ubnd', ubnd , 1.0, 1.0 )
         call argi4 ( '-seed', iseed, 987654321, 987654321 )

      endif
c***********************************************************************
      return
      end
c***********************************************************************
