C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine mkrec1( jrec, nrec, ntrc, nsmp, dt, rec )
c***********************************************************************
c     MAKE A USP RECORD
c***********************************************************************
      implicit none

c     input variables:

      real      dt              ! delta t
      integer   jrec            ! record index of current record
      integer   nrec            ! number of records in output dataset
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record

c     output variables:

      real      rec(0:nsmp-1,ntrc) ! data record

c     local variables:

      integer   inc
      integer   jx              ! trace index
      integer   jt              ! sample index
      integer   jtbias          ! time bias index
      real      t               ! time
      real      twopi           ! 2*pi
      real      w               ! omega (angular frequency)

c***********************************************************************

      inc = 10
 100  continue
      if( inc*(nrec-1) .gt. nsmp/2 ) then
         inc = inc - 1
         if( inc .gt. 1 ) go to 100
      endif

      jtbias = nsmp/2 + inc * ( jrec - 1 )
      twopi  = 2.0 * acos( -1.0 )

      do jx = 1, ntrc
         w = twopi * float( jx )
         do jt = 0, nsmp-1
            t = dt * float( jt - jtbias )
            rec(jt,jx) = cos( w*t )
         enddo
      enddo

c***********************************************************************
      return
      end
c***********************************************************************
c***********************************************************************
      subroutine mkrec2( jrec, ntrc, nsmp, off, rad, rec )
c***********************************************************************

      implicit none

c input variables:

      integer   jrec            ! record index of current record
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record
      integer   off             ! offset for icase=2
      integer   rad             ! radix for icase=2

c output variables:

      real      rec(nsmp,ntrc)  ! data record

c local variables:

      integer   jx              ! trace index
      integer   jt              ! sample index
      integer n1, n2, ibase, n3

c***********************************************************************

      n1 = mod( jrec, rad )

      do jx = 1, ntrc
         n2    = mod( jx, rad )
         ibase = rad * ( rad * n1 + n2 ) + off
         n3    = 0

         do jt = 1, nsmp
            n3 = n3 + 1
            if( n3 .ge. rad ) n3 = 0
            rec(jt,jx) = float( ibase + n3 )
         enddo

      enddo
c***********************************************************************
      return
      end
c***********************************************************************
c***********************************************************************
      subroutine mkrec3( jrec, ntrc, nsmp, icmplx, nxshft, nyshft
     &     , sig, rec )
c***********************************************************************

      implicit none

c     input variables:

      integer   icmplx          ! 1 if real, 2 if complex samples
      integer   jrec            ! record index of current record
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record
      integer   nxshft          ! sample shift in x direction
      integer   nyshft          ! sample shift in y direction
      real      sig(0:nsmp)     ! generated signal

c     output variables:

      real      rec(icmplx,0:nsmp-1,ntrc) ! data record

c     local variables:

      integer   it              ! shifted sample index
      integer   jx              ! trace index
      integer   jt              ! sample index
      integer   nshift          ! shift index

c***********************************************************************

      do jx = 1, ntrc
         nshift = mod( (jx-1)*nxshft + (jrec-1)*nyshft, nsmp )

         do jt = 0, nsmp-1
            it = jt + nshift
            if( it .ge. nsmp ) it = it - nsmp
            rec(1,jt,jx) = sig(it)
         enddo

      enddo
c***********************************************************************
      return
      end
c***********************************************************************
c***********************************************************************
      subroutine mkrec4( iseed, lbnd, ubnd, ntrc, nsmp, rec )
c***********************************************************************

      implicit none

c     input variables:

      real      lbnd            ! lower bound for random samples
      real      ubnd            ! upper bound for random samples
      integer   iseed           !
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record

c     output variables:

      real      rec(nsmp,ntrc)  ! data record

c***********************************************************************

      call vrand( iseed, rec, 1, nsmp*ntrc )

      if( lbnd .ne. 0.0 .or. ubnd .ne. 1.0 )
     &     call vsmsa( rec, 1, ubnd-lbnd, lbnd, rec, 1, nsmp*ntrc )

c***********************************************************************
      return
      end
c***********************************************************************
