C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine mkwrlhdr( luout, ppname, nrec, ntrc, nsmp, nsi, iform )
c***********************************************************************
c     MAKE AND WRITE USP LINE HEADER
c***********************************************************************

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c     input parameters:

      integer   iform           ! form of output file
      integer   luout           ! logical unit of output dataset
      integer   nrec            ! number of records in output dataset
      integer   nsi             ! sample interval (msecs or microsecs)
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record
      character ppname*(*)      ! program name

c     local parameters:

      integer*2 lhdr(SZLNHD)    ! line header
      integer   nbytes          ! number of bytes for usp i/o

c     data initialization:

      data lhdr / SZLNHD * 0 /

c***********************************************************************

      call savew(lhdr, 'NumSmp', nsmp,  LINHED)
      call savew(lhdr, 'NumRec', nrec , LINHED)
      call savew(lhdr, 'NumTrc', ntrc , LINHED)
      call savew(lhdr, 'Format', iform, LINHED)
      call savew(lhdr, 'SmpInt', nsi  , LINHED)

c     inject command line into historical lhdr:
c     inputs are current line header in vector "lhdr" and length HSTOFF (bytes)
c     outputs are line header modified by insertion of the command line into
c     the historical LH and the modified length of the new lhdr (nbytes)

      call savew(  lhdr, 'HlhEnt', 0, LINHED)
      call savew(  lhdr, 'HlhByt', 2*SZHFWD, LINHED)
      call savhlh( lhdr, HSTOFF, nbytes)
      call hlhprt( lhdr, nbytes, ppname, len(ppname), LUPRT)

c     write to unit number luout nbytes bytes contained in vector lhdr

      call wrtape( luout, lhdr, nbytes)

c***********************************************************************
      return
      end
c***********************************************************************

