C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C     AUTHOR:  Curtis Kruse
C     REVISED: Mary Ann Thornton     0l/30/92
C     Moved to sun for maintenance/distribution
C     REVISED: Mary Ann Thornton     06/04/92
C     added calls to saver,savew, removed unused variables
C     added dynamic memory allocation for the largest arrays
C     Code is now portable to 32 bit machine
C     REVISED: David Nelson          09/23/92
C     Call VRECIP before average velocity is smoothed so that
C     it is done in average slowness, see lpinv.c function velextr
C     Postfiltering order was switched to T then X, not X than T
C     REVISED: David Nelson          11/24/92
C     Changed name TIV2TLP to TINT2TLP for compatiblility with vmod
C     Changed call to LINTERP to call NL2L which preserves travel time
C     Corrected bug in computation of sizes for dynamic allocations
C     Made line header buffer bigger, 6000 words
C     REVISED:  Mary Ann Thornton  V: 4.1      July 8, 1993 	
C     Included hp.h so logical unit for LTRM will not be 0 on the HP
C     REVISED:  David Nelson       V: 4.2      18 oct 94
C     Dynamically allocate velocity buffers in velextract instead
C     of using the extra space at the end of another buffer, which
C     fails when the number of depth samples is not significantly
C     greater than the number of time samples.
C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

C***********************************************************************
C lpinv using the new cube velocity model data format
CCCCC
C     TAPE DATA AND HEADER ARRAYS
CCCCC
      PARAMETER (LHEAD=6000,LCRD=25,LPRT=26,LLIST=27)
      DIMENSION IHEAD(LHEAD)

      PARAMETER (MXTRA=3000, MXSAM=4096)

      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM)
      INTEGER*2 IRX(LNTRHD),THDR(LNTRHD,MXTRA)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))

      REAL A(1),B(1),VELMOD(1),TIME(1),LPVELMOD(1),VINTZ(1)
      real tempvel(1)
      pointer (pa,a),(pb,b),(pvelmod,velmod),(ptime,time) 
      pointer (plpvel,lpvelmod),(pvintz,vintz)
      pointer (ptemp,tempvel)
 
      CHARACTER*1  PARR(66)
      CHARACTER*4 PPNAME,PPNAME2
      CHARACTER*4 VERSION
      REAL VELMAX,VELMIN

      LOGICAL VERBOS
      CHARACTER*128 OTAP,NTAP,NTAP2,INPUT
      INTEGER OUTTYPE

      INTEGER NTRMOD,KSAMPMOD,NTV
      REAL DZMOD,DTV

      DATA VERSION/' 4.2'/
      DATA PPNAME/'P2IV'/,PPNAME2/'PTIV'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ','P','I','C','K','S',
     2' ','T','O',' ','I','N','T','E','R','V','A','L',' ','V','E','L',
     3'O','C','I','T','Y',' ','C','O','N','V','E',
     3          'R','S','I','O','N',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/


      LTRM  = LER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     Process command line arguments
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL cmdlin(NTAP,NTAP2,OTAP,INPUT,IPIPI,IPIPO,LTRM,
     &  VERBOS,OUTTYPE)
      IF(IPIPI.EQ.0)THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN = 0
         LTRM = 2
      ENDIF
      IF(IPIPO.EQ.0)THEN
C        LUOUT IS AN INPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT=1
      ENDIF
      CALL LBOPEN(LUIN2,NTAP2,'r')

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN PRINTOUTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME2,JERR)
      IF(JERR.NE.0)STOP 200
      write(LPRT,*)'**************************************'
      write(LPRT,*) ppname,' Version: ',version,'  Modified... '
      write(LPRT,*) 
     1  'Thu Feb 16 08:57:35 CST 1995'
      write(LPRT,*)'**************************************'
      write(LPRT,*)' '
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)

      JERR = 0
      IF(INPUT.NE.' ')THEN
        OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
        IF(JERR.NE.0)THEN
           WRITE(LPRT,*)' ERROR OPENING INPUT CARD FILE'
           STOP 50
        ENDIF
      ELSE
        N=ICOPEN('-p2iv.crd',LCRD)
          IF(N.EQ.0)THEN
             WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
             STOP 50
          ENDIF
      ENDIF
     
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ VELOCITY PERTURBATION DATA
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOFH = 0
      CALL RTAPE(LUIN2,IHEAD,JEOFH)
      IF(JEOFH.EQ.0)GO TO 1000

      call saver(ihead,'NumSmp',ksampmod,linhed)
      call saver(ihead,'NumTrc',ntrmod,linhed)
      call saver(ihead,'Dx1000',idx,linhed)
      call saver(ihead,'Dz1000',idz,linhed)
      call saver(ihead,'MinVel',ivmin,linhed)
      call saver(ihead,'MaxVel',ivmax,linhed)
      deltax = (1.*idx)/1000.
      dzmod  = (1.*idz)/1000.
      velmin = ivmin
      velmax = ivmax

C     -------error checking----------------------------------
      IF(KSAMPMOD.GT.MXSAM)THEN
          WRITE(LPRT,*)
     &     'ERROR READING VELOCITY PERTURBATION DATA'
          WRITE(LPRT,*)' NUMBER OF SAMPLES = ',KSAMPMOD  
          WRITE(LPRT,*)' MAXIMUM NUMBER OF SAMPLES = ',MXSAM  
          STOP 101
      ENDIF

      IF(NTRMOD.GT.MXTRA)THEN
          WRITE(LPRT,*)
     &    'ERROR READING VELOCITY PERTURBATION DATA'
          WRITE(LPRT,*)' NUMBER OF TRACES = ',NTRMOD
          WRITE(LPRT,*)' MAXIMUM NUMBER OF TRACES = ',MXTRA
          STOP 102
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ VELOCITY PICKS      
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IEOFH = 0
      CALL RTAPE(LUIN,IHEAD,IEOFH)
      IF(IEOFH.EQ.0)GO TO 1000
      call saver(ihead,'NumSmp',ksamp,linhed)
      call saver(ihead,'NumTrc',ntr,linhed)
      call saver(ihead,'NumRec',nrec,linhed)
      call saver(ihead,'SmpInt',isi,linhed)
      call saver(ihead,'Format',iform,linhed)
      LEN = 4
C     CALL HLHPRT(IHEAD,IEOFH,PPNAME,LEN,LPRT)

C     -------error checking----------------------------------
      IF(KSAMP.GT.MXSAM)THEN
          WRITE(LPRT,*)
     &     'ERROR READING PICK DATA'
          WRITE(LPRT,*)' NUMBER OF SAMPLES = ',KSAMP
          WRITE(LPRT,*)' MAXIMUM NUMBER OF SAMPLES = ',MXSAM  
          STOP 103
      ENDIF
      IF(ntr.GT.mxtra)THEN
          WRITE(LPRT,*)
     &     'ERROR READING PICK DATA'
          WRITE(LPRT,*)' NUMBER OF TRACES = ',NTR
          WRITE(LPRT,*)' MAXIMUM NUMBER OF TRACES = ',MXTRA  
          STOP 103
      ENDIF
CCCCCCCCCCCCCCCCCC
C     Allocate space for vintz, a, velmod, time, lpvelmod
CCCCCCCCCCCCCCCCCC

      isize = max0(ksampmod,ksamp)*max0(ntrmod,ntr)
c     isize = max0((ksampmod*ntrmod),(ksamp*ntr))
      ierr = 0
      iabort = 0
      call galloc(pa,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      ierr = 0
      iabort = 0
      call galloc(pb,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      ierr = 0
      iabort = 0
      call galloc(pvintz,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      ierr = 0
      iabort = 0
      call galloc(pvelmod,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      ierr = 0
      iabort = 0
      call galloc(ptime,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      ierr = 0
      iabort = 0
      call galloc(plpvel,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif
      isize = max0(ksampmod,ksamp)
      ierr = 0
      iabort = 0
      call galloc(ptemp,isize*iszbyt,ierr,iabort)
      if(iabort.ne. 0 .or. ierr.ne.0)then
        write(lprt,*)' error allocating space'
        stop 100
      endif

      IV=1
      mr=1
      DO 200 L = 1,NTRMOD
          JEOF=0
          CALL RTAPE(LUIN2,RXX,JEOF)
          IF(JEOF.EQ.0)GO TO 1500
          CALL VMOV(DATA,1,VELMOD(IV),1,KSAMPMOD)
          IV = IV + KSAMPMOD
200   CONTINUE

      DT=.001*ISI
      CALL VCLR(DATA,1,MXSAM)
      LA=1
      DO 500 MR=1,NREC
         DO 100 L= 1,NTR
            IEOF=0
            CALL RTAPE(LUIN,RXX,IEOF)
            IF(IEOF.EQ.0)GO TO 1500
            CALL VMOV(IRX,1,THDR(1,L),1,ITRWRD)
            CALL VMOV(DATA,1,A(LA),1,KSAMP)
            LA = LA + KSAMP
  100    CONTINUE
500   CONTINUE

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ INPUT CARDS                                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

       CALL READCARD(LPRT,LCRD,DEPTHMAX,DZ,DELTAX,
     & EXPNT,
     & NTRSMOO,NZSMOO,
     & NTRSMOO2,NZSMOO2,CLIPPCNT)

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     CHECK PARAMETERS, SET DEFAULTS, WRITE TO USERS REPORT          C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      WRITE(LPRT,38)NTAP,NTAP2,OTAP
   38 FORMAT(' INPUT PICK DATASET = ',/,A128,/,
     & ' INPUT VELOCITY PERTURBATION DATASET = ',/,A128,/,
     & ' OUTPUT DATASET = '/,A128)
     
      nrrrec = nrec*ntr
      NZ = DEPTHMAX/DZ
      idx = DELTAX*1000.
      idz = DZ*1000.
      ivmin = VELMIN
      ivmax = VELMAX
      call savew(ihead,'NumRec',1,linhed)
      call savew(ihead,'NumTrc',nrrrec,linhed)
      call savew(ihead,'Dx1000',idx,linhed)
      call savew(ihead,'Dz1000',idz,linhed)
      call savew(ihead,'MinVel',ivmin,linhed)
      call savew(ihead,'MaxVel',ivmax,linhed)
      if(outtype.eq.0 .or. outtype.eq.2) then
         call savew(ihead,'NumSmp',nz,linhed)
      endif


      IF(IFORM.NE.3)THEN
         WRITE(LPRT,*)'  INPUT TAPE MUST BE FORMAT 3'
         STOP 100
      ENDIF

      IF(EXPNT.LE.0.0)EXPNT=1.

      WRITE(LPRT,22)KSAMP,NTR,NREC,ISI,IFORM
22    FORMAT(
     *34X,'NO. OF SAMPLES PER TRACE               ', 10x,'=', I10, /,
     *34X,'NO. OF TRACES PER RECORD               ', 10x,'=', I10, /,
     *34X,'NO. OF RECORDS                         ', 10x,'=', I10, /,
     *34X,'SAMPLE INTERVAL                        ', 10x,'=', I10, /,
     *34X,'FORMAT                                 ', 10x,'=', I10, /)

      IF(OUTTYPE.EQ.0) THEN
         WRITE(LPRT,*)'OUTPUT DATA TYPE = INTERVAL VELOCITY VS. DEPTH'
      ELSE IF(OUTTYPE.EQ.1) THEN
         WRITE(LPRT,*)'OUTPUT DATA TYPE = INTERVAL VELOCITY VS. TIME '
      ELSE IF(OUTTYPE.EQ.2) THEN
         WRITE(LPRT,*)'OUTPUT DATA TYPE = LP-NORM VELOCITY VS. DEPTH'
      ELSE IF(OUTTYPE.EQ.3) THEN
         WRITE(LPRT,*)'OUTPUT DATA TYPE = LP-NORM VELOCITY VS. TIME '
      ELSE IF(OUTTYPE.EQ.4) THEN
         WRITE(LPRT,*)'OUTPUT DATA TYPE = LP-NORM PERTURBATION ',
     & 'VELOCITY VS. TIME '
      ENDIF
      WRITE(LPRT,*)' '

      NP=NTRMOD
      WRITE(LPRT,271) DEPTHMAX,DZ,DELTAX,EXPNT,
     &NTRSMOO,NZSMOO,
     &NTRSMOO2,NZSMOO2,
     &VELMIN,VELMAX,NP
271   FORMAT(//,20X, 'INPUT PARAMETERS AFTER DEFAULTS:',
     &       //,13X, 'MAXIMUM DEPTH.................',1X,F8.2,
     &       //,13X, 'DEPTH INCREMENT...............',1X,F8.2,
     &       //,13X, 'TRACE INCREMENT...............',1X,F8.2,
     &       //,13X, 'EXPONENT (LP NORM)............',1X,F8.2,
     &       //,13X, 'PREFILTER:',
     &       //,13X, 'MAX TRACES TO SMOOTH..........',4X,I5,  
     &       //,13X, 'MAX SAMPLES TO SMOOTH.........',4X,I5,  
     &       //,13X, 'POSTFILTER:',
     &       //,13X, 'MAX TRACES TO SMOOTH..........',4X,I5,  
     &       //,13X, 'MAX SAMPLES TO SMOOTH.........',4X,I5,  
     &       //,13X, 'MINIMUM VELOCITY..............',1X,F8.2,
     &       //,13X, 'MAXIMUM VELOCITY..............',1X,F8.2,
     &       //,13X, 'NUMBER OF PERTURBATIONS.......',4X,I5)

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

C     ------kluge attempt to unintegerize integer picks--------
      LA = 1
      DO 550 MR=1,NREC
          DO 551 L=1,NTR
              CALL PSMOOTH(A(LA),KSAMP)
              LA = LA + KSAMP
551       CONTINUE 
550   CONTINUE

C     ------hardcoded filter weights for 3 point boxcar---------
      TRWATE = .33333
      ZWEIGHT = .33333
      TRWATE2=TRWATE
      ZWEIGHT2 = ZWEIGHT

      NTV=(KSAMPMOD*VELMAX)/VELMIN
      NTV=MIN(NTV,MXSAM)
      NTV=KSAMP
      DTV=DZMOD/VELMAX
      DTV=DT
      ix0=10
      DO 333 I=1,NTRMOD
         IP = (I-1)*KSAMPMOD +1
         IV = (I-1)*NTV +1
         CALL D2NLT(VELMOD(IP),KSAMPMOD,DZMOD,TIME(IP))

C        -------interpolate to a constant time interval-------
         CALL NL2L(VELMOD(IP),TIME(IP),KSAMPMOD,
     &       TEMPVEL,DTV,NTV)

C        -------convert to Lp-norm velocity-------------------
         CALL TINT2TLP(TEMPVEL,NTV,LPVELMOD(IV),EXPNT)
333   CONTINUE


      DO 455 I=1,NTV
         TIME(I)=I*DTV
455   CONTINUE



C        ------extract velocities from picks and invert velocities------
         CALL VELEXTR(LPVELMOD,TIME,NTV,NTRMOD,
     &   B,A,NTR*NREC,KSAMP,DT,NZ,DZ,VINTZ,
     &   TRWATE,NTRSMOO,ZWEIGHT,NZSMOO,OUTTYPE,EXPNT)

C>>>>>>>>>>>>>>>>>>>>>
C     ---------TRUNCATE VELOCITIES TO FAIRWAY LIMITS----------
      IF(OUTTYPE.EQ.0.AND.CLIPPCNT.NE.0.0)THEN
      DO 33324 IZ=1,NZ 
         IZMOD = IZ*(DZ/DZMOD)
         IF(IZMOD.LT.1)IZMOD=1
         IF(IZMOD.GT.KSAMPMOD)IZMOD=KSAMPMOD
         VMIN=VELMOD(IZMOD)*CLIPPCNT/100.0
         VMAX=VELMOD((NTRMOD-1)*KSAMPMOD+IZMOD)*
     &              (200.-CLIPPCNT)/100.
         DO 31234 ITR=1,NTR
            IV = (ITR-1)*NZ+IZ
            IF(VINTZ(IV).LT.VMIN) VINTZ(IV)=VMIN
            IF(VINTZ(IV).GT.VMAX) VINTZ(IV)=VMAX
31234    CONTINUE
33324 CONTINUE
      ENDIF
C<<<<<<<<<<<<<<<<<<<<
     

      NSAMP=NZ
      IF(OUTTYPE.EQ.1.OR.OUTTYPE.EQ.3)NSAMP=KSAMP
C     -----post inversion filtering------------------------
      LA = 1
      DO 570 MR=1,NREC
          DO 571 L=1,NTR
              CALL TSMOOTH(VINTZ(LA),NSAMP,ZWEIGHT2,NZSMOO2)
              LA = LA + NSAMP
571       CONTINUE 
570   CONTINUE

      CALL XSMOOTH(VINTZ,NTR,NSAMP,TRWATE2,NTRSMOO2)
     
C     ------output velocity perturbation data in Lp-norm velocities----
      IF(OUTTYPE.EQ.4)THEN
          NSAMP = NTV
          KSAMP=0
          NTR = NTRMOD
          NREC=1
          call savew(ihead,'NumSmp',nsamp,linhed)
          call savew(ihead,'NumTrc',ntr,linhed)
          call savew(ihead,'NumRec',1,linhed)
          LA=1
          DO 572  L=1,NTR
              CALL VMOV(LPVELMOD(LA),1,VINTZ(LA),1,NSAMP)
              LA = LA + NSAMP
572       CONTINUE
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C        OUTPUT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL WRTAPE(LUOUT,IHEAD,IEOFH)
      IEOF = IEOF + (NSAMP-KSAMP)*ISZBYT
      LA=1
      DO 600 MR=1,NREC
         DO 601 L= 1,NTR
            DO 489 I=1,NSAMP
                  J=I+LA-1
C                 IF(VINTZ(J).LT.VELMIN)VINTZ(J)=VELMIN
C                 IF(VINTZ(J).GT.VELMAX)VINTZ(J)=VELMAX
489         CONTINUE
            CALL VMOV(THDR(1,L),1,IRX,1,ITRWRD)
            CALL VMOV(VINTZ(LA),1,DATA,1,NSAMP)
            CALL WRTAPE(LUOUT,RXX,iEOF)
            LA = LA + NSAMP
  601    CONTINUE
600   CONTINUE 

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      ICODE = 100
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR ON RECORD',I5,' TRACE',I5)
      ICODE = 75
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUIN2)
      CALL LBCLOS(LUOUT)
      IF(ICODE.EQ.75)STOP 75
      IF(ICODE.EQ.100)STOP 100
      STOP
      END


C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO GET DATASET NAMES                                      *
C  ENTRY POINTS:                                                       *
C                cmdlin(NTAP,NTAP2,OTAP,INPUT,IPIPI,IPIPO,LTRM,        *
C                       VERBOS,OUTTYPE)
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,NTAP2,OTAP,INPUT
     &   ,IPIPI,IPIPO,LTRM,VERBOS,OUTTYPE)

      INTEGER ARGIS,OUTTYPE
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,NTAP2,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)
     & 'COMMAND LINE ARGUMENTS--PICKS TO INTERVAL VELOCITY'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap] ........ INPUT PICK DATASET NAME'
         WRITE(LTRM,*)
     &   '-N2[ntap2] ...... INPUT VELOCITY PERTURBATIONS'
         WRITE(LTRM,*)'-O[otap] ........ OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-C[input] ....... EXTERNAL CARD FILE'
         WRITE(LTRM,*)'-a[output type] . OUTPUT DATASET TYPE'
         WRITE(LTRM,*)
     &   '                  0 - interval vel vs depth (default)'
         WRITE(LTRM,*)'                  1 - interval vel vs time'
         WRITE(LTRM,*)'                  2 - Lp norm vel vs depth'
         WRITE(LTRM,*)'                  3 - Lp norm vel vs time '

         WRITE(LTRM,*)'-V .............. VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'p2iv -N[] -N2[] -O[] -C[] -a[]  '
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-N2',NTAP2,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGI4 ('-a',OUTTYPE,0,0)
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
