C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       PANLZ2T                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  TO CONVERT AN INPUT PANEL FROM DEPTH TO TIME              *
C  AUTHOR:   DAN WHITMORE     Version: 1.0      ORIGIN DATE: 93/04/02  *
C  REVISED:  Gary Murphy      Version: 1.1             DATE: 95/03/15  *
C            Fixed bug that made the process "unpipeable"
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      parameter (nxmax=2000,nzmax=10000,len_trace =itrwrd+nzmax)
      parameter (lcrd=25,lprt=26,llist=27,lumxc=62,lhead=6536)
      parameter (iord=1)

#ifdef HPUXSYSTEM
c     unit 7 should be pre-connected to stderr on HP systems
      parameter (LER=7)
#else
      parameter (LER=0)
#endif


C     DATA ARRAYS:
      integer     ihead(lhead)
      integer*2   irx(lntrhd)
      real        rxx(len_trace),data1(nzmax),data2(nzmax)
      equivalence (rxx(1),irx(1)),(rxx(ithwp1),data1(1))
      dimension trace(len_trace),rtrd(nzmax)
      integer*2 itrh(lntrhd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

C     character arrays:
      character*1  parr(66)
      character*4  version
      character*7  ppname
      character*128 ntap, otap, input, nvt1

c     pointers for velocity tapes
      real vel(1)
      pointer (pvel,vel)

      DATA VERSION/'1.1'/
      DATA PPNAME/'PANLZ2T'/
      DATA PARR/'C','O','N','V','E','R','T',' ',
     1          'D','E','P','T','H',' ','P','A','N','E',
     2          'L',' ','T','O',' ','T','I','M','E',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/


c     open printout file                         
      call openpr(llist,lprt,ppname,jerr)
      if(jerr.ne.0)stop 200
      nlin=1
      call gamoco(parr,nlin,lprt)
      ltrm = ler
      call cmdlin(ntap,otap,input,nvt1,ipipi,ipipo,ltrm,
     &nskip,np,dt,ntd)

      write(lprt,38)ntap,otap
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      write(lprt,39)nvt1
   39 FORMAT('VELOCITY VTAP = ',/,A128)


C
C     OPEN DATA FILES
C

      if(ipipi.eq.0) then
C        LU1 IS A INPUT DATASET
         call lbopen(lu1,ntap,'r')
      else
C        WE KNOW LU1 IS A PIPE
         lu1=0
         ltrm=2
      endif
      if(ipipo.eq.0) then
C        LU2 IS A OUTPUT DATASET
         call lbopen(lu2,otap,'w')
      else
C        WE KNOW LU2 IS A PIPE
         lu2=1
      endif

C     PROCESS INPUT LINE HEADER
      jeof = 0
      call rtape(lu1,ihead,jeof)
       if(jeof.eq.0) then
        WRITE(LPRT,*) 'ERROR IN READING INPUT LINE HEADER'
        CALL CCEXIT(100)
        stop
       endif

      len=4
      call hlhprt(ihead,jeof,ppname,len,lprt)
      call saver( ihead, 'NumSmp', nzd,  LINHED )
      call saver( ihead, 'NumRec', nrecd,   LINHED )
      call saver( ihead, 'NumTrc', ntrd,    LINHED )
      if(np.eq.0 .and .ntrd.gt.1) np = ntrd
      nxd = nrecd*ntrd/np
      
C     PROCESS OUTPUT LINE HEADER
      ms=dt*1000
      call savew( ihead, 'SmpInt', ms,  LINHED )
      call savew( ihead, 'NumSmp', ntd,  LINHED )
      call wrtape(lu2,ihead,jeof)
      jbytes = ntd*szsmpd + sztrhd

c     open and read in velocity datasets
      call lbopen(lvt1,nvt1,'r')
      jeof = 0
      call rtape(lvt1,ihead,jeof)
        if(jeof.le.0) then
           call lbclos(lu1)
           call lbclos(lu2)
           write(0,*)'error in reading input line header'
           stop 73
        endif

c     Bring in Input Line Header Values
      call saver(ihead, 'NumSmp', nz1, linhed)
      call saver(ihead, 'NumTrc', nx1, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)
      dx = float(idx_1000)/1000.
      dz = float(idz_1000)/1000.

c     check velocity dataset trace spacing
      nx_vels  = nx1
      nz_size  = nz1

      jerr = 0
      isize_veloc = nz_size*nx_vels     
      call galloc( pvel, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif

c        READ VELOCITIES FROM THE VELOCITY DATASET
         jxcol = -nz_size + 1 
         do jtrc=1,nx_vels
            jeof=0
            call rtape(lvt1,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(lu1)
                 call lbclos(lu2)
                 call lbclos(lvt1)
                 write(0,*)'error in reading velocity tape'
                 write(0,*)'trace=',jtrc
                 stop 74
              endif
 
c           load vel
              jxcol = jxcol + nz_size
              call vmov(rtrd,1,vel(jxcol),1,nz1) 
              if(nz1.lt.nz_size) then 
              jxn = jxcol + nz1
               call vfill(vel(jxn-1),vel(jxn),1,nz_size-nz1)  
              endif
         enddo


C     TRACE PROCESSING BEGINS

C      RECORD LOOP 100:
       do 100 jx = 1,nxd
        jxloc = jx
        if(jxloc.gt.nx_vels/nskip) jxloc = nx_vels/nskip

c       compute bias into velocity arrays
        jxz =(jxloc-1)*nskip*nz_size + 1

C       PANEL LOOP 200:
        init = 1
        do 200 jp=1,np
        jeofd=0
        call rtape(lu1,rxx,jeofd)
        if(jeof.eq.0) then
        write(lprt,*) 'error in input, record,trace=',nxd,np
        call ccexit(100)
        stop
        endif
        
c       DEPTH TO TIME CONVERSION:
        call traz2t(data1,data2,nzd,ntd,vel(jxz),dz,dt,iord,init)
        init = 0
        call vmov(data2,1,data1,1,ntd)

c       WRITE OUTPUT DATASET
        call wrtape(lu2,rxx,jbytes)

        if(jeof.eq.0) then
        WRITE(LPRT,*) 'ERROR IN OUTPUT, RECORD,TRACE=',nxd,np
        call ccexit(100)
        stop
        endif

C      END PANEL LOOP 200:
  200  continue

C     END RECORD LOOP 100:
  100 continue

      write(lprt,*) ' panlz2t complete'
      ICODE = 0
      call lbclos(lu1)
      call lbclos(lu2)
      call lbclos(lvt1)
      call ccexit(icode)
      stop
      end
c
      subroutine cmdlin(ntap,otap,input,ntv1,ipipi,ipipo,ltrm,
     &nskip,np,dt,ntd)
      integer argis
      logical help
      character*128  ntap,otap,input,ntv1
C     SET DEFAULTS TO NO PIPES
      ipipi=0
      ipipo=0
      help  = (argis( '-h' ).gt.0) .or. (argis( '-?').gt.0)
      if(help)then
         WRITE(LTRM,*)' MBS PANEL DEPTH TO TIME CORRECTION '
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[]       .. Input dataset name'
         WRITE(LTRM,*)'-O[]       .. Output dataset name'
         WRITE(LTRM,*)'-VT[]      .. Vel Tape Used in Migration'
         WRITE(LTRM,*)'-I[]       .. panel spacing of sort(skipped I)'
         WRITE(LTRM,*)'-np[]      .. # of traces per panel'
         WRITE(LTRM,*)'-dt[]      .. dt  (MS) of output (default=8)'
         WRITE(LTRM,*)'-t[]       .. tmax(MS) of output (default=5000)'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)
     &   'panlz2t -N[] -O[] -VT[] -I[] -np[] -dt[] -t[]'
         stop
      endif
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argstr('-VT',ntv1,' ',' ')
      call argi4  ('-I'  , nskip , 0, 0)
      call argi4  ('-np'  , np , 0, 0)
      call argr4  ('-dt'  , dtms , 8., 8.)
      call argr4  ('-t'  , tmax , 5000., 5000.)
      if(nskip.le.0) write(0,*) 'skipping inc must > 0'
      if(nskip.le.0) stop 999
      ntd = tmax/dtms
      dt = dtms/1000.
C     MAKE THE NTAP A PIPE
      if(ntap.eq.' ' ) ipipi=1
C     MAKE THE OTAP A PIPE
      if(otap.eq.' ' ) ipipo=1
      return
      end
