C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c Read a velocity field, read an obg field, read a trendline field
c      and determine pressures at every point in the field
c Output a pressure field in pounds/gallon (drilling mud)
c This is a simple program using Eaton's method only
c pp = obg-|(obg-nhg)|(V0/Vn)**3.0
c ppetn.F
c
c Mary Ann Thornton           v: 1.0         September 29, 1994
c
c Modifications:
c 7/11/96 .... by Martin Albertin to allow the user to specify the
c exponent on the command line
c
c************************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
      parameter   (convm = 3.280833, convg = .433, ppgal = 0.052)
      integer     lhed (SZLNHD)
      integer * 2 itr  (SZLNHD)
      real        head (SZLNHD)
      real        v0   (SZLNHD), vn (SZLNHD), pp(SZLNHD)
      real        obg  (SZLNHD)
      real        nhg, exp

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin, luin2, luin3, luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne

      character   ntap  * 100, otap * 100, name*5, version*4
      character   ntap2 * 100, ntap3 * 100
      logical     verbos, hlp, query, met, eng
      integer     argis
      equivalence (itr( 1), lhed (1), head(1))
      data lbytes/ 0 /, nbytes/ 0 /, name/'PPETN'/, version/' 1.1'/ 
 
c-----
c     read program parameters from command line card image file
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query .or. hlp )then
            call help()
            stop
      endif
c-----
c     open printout
#include <f77/open.h>
c-----
c     read command line arguments
      call gcmdln(ntap,ntap2,ntap3,otap,ns,ne,irs,ire,nhg,
     &            met,eng,exp,verbos)
c-----
c     open input and output files
      call getln(luin , ntap ,'r', 0)
      call getln(luin2, ntap2,'r', 0)
      call getln(luin3, ntap3,'r', 0)
      call getln(luout, otap ,'w', 1)
c-----
c     read line header from velocity trendline dataset
      call rtape(luin3, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'ppetn: no line header read from unit ',luin3
         write(LOT,*)' ( velocity trendline dataset )'
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c-----save values from trendline line header
      call saver(itr, 'NumSmp', nsampvt, LINHED)
      call saver(itr, 'SmpInt', nsivt  , LINHED)
      call saver(itr, 'NumTrc', ntrcvt , LINHED)
      call saver(itr, 'NumRec', nrecvt , LINHED)
      call saver(itr, 'Format', iformvt, LINHED)
      call saver(itr, 'Dx1000', idxvt,   LINHED)
      call saver(itr, 'Dz1000', idzvt,   LINHED)
      dxvt = idxvt/1000.
      dzvt = idzvt/1000.
c-----
c     read line header from overburden gradient file
      call rtape(luin2, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'ppetn: no line header read from unit ',luin2
         write(LOT,*)' ( overburden gradient dataset )'
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c     save values from obg line header
      call saver(itr, 'NumSmp', nsampd, LINHED)
      call saver(itr, 'SmpInt', nsid  , LINHED)
      call saver(itr, 'NumTrc', ntrcd , LINHED)
      call saver(itr, 'NumRec', nrecd , LINHED)
      call saver(itr, 'Format', iformd, LINHED)
      call saver(itr, 'Dx1000', idxd,   LINHED)
      call saver(itr, 'Dz1000', idzd,   LINHED)
      dxd = idxd/1000. 
      dzd = idzd/1000. 
      lbytes = 0
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'ppetn: no line header read from unit ',luin
         write(LOT,*)' ( velocity dataset )'
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c------
c     save values from velocity line header
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'Dx1000', idx,   LINHED)
      call saver(itr, 'Dz1000', idz,   LINHED)
      dx = idx/1000.
      dz = idz/1000.
c------
      if(nsamp.ne.nsampd .or. ntrcd.ne.ntrc .or. nrecd.ne.nrec)then
         write(LOT,*)'The obg dataset and the velocity dataset and'
         write(LOT,*)'the trendline dataset must be the same size.'
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
      if(nsamp.ne.nsampvt .or. ntrc.ne.ntrcvt .or. nrec.ne.nrecvt)then
         write(LOT,*)'The velocity trendline and the velocity dataset'
         write(LOT,*)'and the obg dataset must be the same size.'
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c------
c     print line header into printer listing
      call hlhprt(itr, lbytes, name, 5, LERR)
c-----
c     check validity of these arguments
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
c----------------------
c     determine obytes as the number of bytes in output trace
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
c     save command line arguments in the historical part of line header
      call savhlh(itr,lbytes,lbyout)
c----------------------
c     write the output line header
      call wrtape(luout, itr, lbyout )
 
c-----
      if( verbos ) then
         call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,ntap2,ntap3,otap,ns,ne,irs,ire,nhg,
     &               met,eng,exp,verbos)
      endif

c-----
c--------------------------------------------------
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------

c-----met=metric units
c-----eng=english units
c     convm=conversion factor for metric to english
c     convg=conversion factor for converting to grams/cubic_centimeter

c-----skip unwanted records
      call recskp(1,irs-1,luin ,ntrc,itr)
      call recskp(1,irs-1,luin2,ntrc,itr)
      call recskp(1,irs-1,luin3,ntrc,itr)

c-----LOOP ON RECORDS
      do 1000 jj = irs, ire
         call trcskp(jj,1,ns-1,luin ,ntrc,itr)
         call trcskp(jj,1,ns-1,luin2,ntrc,itr)
         call trcskp(jj,1,ns-1,luin3,ntrc,itr)

c--------LOOP ON TRACES
         do 1003  nn = ns, ne

c           read the velocity traces into itr then move to v0
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on velocity input:',luin
               write(LERR,*)'  rec= ',jj,'  trace= ',nn
               go to 999
            endif
            call vmov(lhed(ITHWP1),1,v0,1,nsamp)

c           read the obg traces into itr then move to obg
            nbytes = 0
            call rtape(luin2, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on ob-gradient input:',luin2
               write(LERR,*)'  rec= ',jj,'  trace= ',nn
               go to 999
            endif
            call vmov(lhed(ITHWP1),1,obg,1,nsamp)

c           read the vel.trendline traces into itr then move to vn
            nbytes = 0
            call rtape(luin3, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on trendline, unit:',luin3
               write(LERR,*)'  rec= 1, trace= 1'
               go to 999
            endif
            call vmov(lhed(ITHWP1),1,vn,1,nsamp)

c-----------LOOP ON SAMPLES
c----       compute pressure for ea. sample, convert to pounds/gallon
            do 1002 kk = 1,nsamp
               pp(kk) = obg(kk)-abs(obg(kk)-nhg)*((v0(kk)/vn(kk))**exp)
               if(pp(kk).lt.nhg)pp(kk) = nhg
               pp(kk) = pp(kk)/ppgal
 1002       continue
c----       
            call vmov (pp, 1, lhed(ITHWP1), 1, nsamp)
            call wrtape (luout, itr, obytes)
 1003    continue
c-----
c        skip to end of record
         call trcskp(jj,ne+1,ntrc,luin ,ntrc,itr)
         call trcskp(jj,ne+1,ntrc,luin2,ntrc,itr)
         call trcskp(jj,ne+1,ntrc,luin3,ntrc,itr)
 1000 continue

c--------------------------------------------------
c--------------------------------------------------
c-----
c     END PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------
 
  999 continue
 
c-----
c     close data files
      call lbclos(luin)
      call lbclos(luin2)
      call lbclos(luin3)
      call lbclos(luout)
c-----
      write(LERR,*)'end of ppetn, processed ',nrec,' record(s)',
     &               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
c...5....0....5....0....5....0....5....0....5....0....5....0....5....0..
      write(LER,*)'PPETN compute pressure gradient from velocity using '
      write(LER,*)'Eaton`s method. Inputs are observed velocity, normal'
      write(LER,*)'compaction velocity, and overburden (psi/ft).       '
      write(LER,*)'                                                    '
      write(LER,*)'Parameters[default values] required/optional:       '
      write(LER,*)' -VEL[]      req  input observed velocity dataset   '
      write(LER,*)' -OBG[]      req  input overburden gradient dataset '
      write(LER,*)' -VTR[]      req  input normal comp. trendline data '
      write(LER,*)' -PR[]       req  output pressure gradient dataset  '
      write(LER,*)' -ns[1]      opt  start trace number                '
      write(LER,*)' -ne[last]   opt  end trace number                  '
      write(LER,*)' -rs[1]      opt  start record number               '
      write(LER,*)' -re[last]   opt  end record number                 '
      write(LER,*)' -nhg[0.465] req  normal hydrostatic gradient       '
      write(LER,*)' -met        opt  metric velocity units             '
      write(LER,*)' -eng        opt  english velocity units            '
      write(LER,*)' -exp[3.0]   opt  Eaton exponent                    '
      write(LER,*)' -V          opt  verbose printout                  '
      write(LER,*)'                                                    '
      write(LER,*)'Usage:                                              '
      write(LER,*)'ppetn -VEL[] -OBG[] -VTR[] -PR[] -ns[] -ne[]  \     '
      write(LER,*)'   -rs[] -re[] -nhg[.465] -exp[3.0] [-met -V]       '
      write(LER,*)'                                                    '

      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,ntap2,ntap3,otap,ns,ne,irs,ire,nhg,
     &                    met,eng,exp,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name velocity
c     ntap2 - C*100    input file name density
c     ntap3 - C*100    input file name velocity trendline
c     otap  - C*100    output file name
c     ns    - int      starting trace index
c     ne    - int      ending trace index
c     irs   - int      starting record index
c     ire   - int      ending record index
c     nhg   - real     normal hydrostatic gradient
c                      default is for USA Gulf Coast area .465
c     met   - L        flag indicating metric units
c     eng   - L        flag indicating english units
c     exp   - real     Eaton exponent (default=3.0)
c     verbos  L        verbose output or not
c-----
      character   ntap*(*), otap*(*), ntap2*(*), ntap3*(*)
      integer     ns, ne, irs, ire
      logical     verbos, met, eng
      integer     argis
      real        nhg, exp
#include <f77/iounit.h>
 
c-------
            call argstr('-VTR', ntap3, ' ', ' ')
            call argstr('-OBG', ntap2, ' ', ' ')
            call argstr('-VEL', ntap , ' ', ' ')
            call argstr('-PR',  otap , ' ', ' ')
            call argr4 ('-exp', exp ,3.0 ,3.0)
            call argi4 ('-ns', ns ,   1   ,   1)
            call argi4 ('-ne', ne ,   0   ,   0)
            call argi4 ('-rs', irs ,  1   ,   1)
            call argi4 ('-re', ire ,  0   ,   0)
            call argr4 ('-nhg', nhg ,.465 ,.465)
            verbos =   (argis('-V') .gt. 0)
            met    =   (argis('-met') .gt. 0)
            eng    =   (argis('-eng') .gt. 0)
            if(ntap.eq.' ')then
               write(LOT,*)' The velocity field may not be a pipe.'
               write(LOT,*)' You must enter a filename for the velocity'
               write(LOT,*)' dataset.'
               write(LOT,*)' JOB TERMINATED ABNORMALLY'
               stop
            endif
            if(ntap3.eq.' ')then
               write(LOT,*)' The velocity trendline may not be a pipe.'
               write(LOT,*)' You must enter a filename for the velocity'
               write(LOT,*)' trendline dataset.'
               write(LOT,*)' JOB TERMINATED ABNORMALLY'
               stop
            endif
c-------
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,ntap2,ntap3,otap,ns,ne,irs,ire,nhg,
     &               met,eng,exp,verbos)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name velocity
c     ntap2 - C*100   input file name density
c     ntap3 - C*100   input file name velocity trendline
c     otap  - C*100   output file name
c     ns    - Int     starting record
c     ne    - Int     ending record
c     irs   - Int     starting trace
c     ire   - Int     ending trace
c     nhg   - real    normal hydrostatic gradient
c                     default is for USA Gulf Coast .465
c     met   - L       flag indicating metric units
c     eng   - L       flag indicating english units
c     exp   - real     Eaton exponent (default=3.0)
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,ns,ne,irs,ire
      real        nhg, exp
      logical     met,eng
      character   ntap*100, otap*100, ntap2*100, ntap3*100
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*)' # of samples/trace          =  ', nsamp
      write(LERR,*)' sample interval             =  ', nsi
      write(LERR,*)' traces per record           =  ', ntrc
      write(LERR,*)' records per line            =  ', nrec
      write(LERR,*)' format of data              =  ', iform
      write(LERR,*)' input velocity              =  ', ntap
      write(LERR,*)' input density               =  ', ntap2
      write(LERR,*)' input velocity trendline    =  ', ntap3
      write(LERR,*)' output pressure             =  ', otap
      write(LERR,*)' starting record             =  ', irs
      write(LERR,*)' ending record               =  ', ire
      write(LERR,*)' starting trace              =  ', ns
      write(LERR,*)' ending trace                =  ', ne
      write(LERR,*)' normal hydrostatic gradient =  ', nhg
      write(LERR,*)' Eaton exponent              =  ', exp
      if(met)then
         write(LERR,*)' velocity field in m/sec '
      else
         write(LERR,*)' velocity field in ft/sec '
      endif
      write(LERR,*)' '
 
      return
      end
