C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine prepsub(firstshot,dshot,firstoff,doff,soptnm,
     1                   xs,ys,zs,xr,yr,zr,recind,live,
     2                   xg,yg,zg,zw,nlive,ztopo,
     3                   lrecind,minrecind,maxrecind,
     4                   xdistmin,xdistmax,zdistmin,zdistmax,
     5                   dsta,zdatum,nshot,ntrace,
     6                   lugeom,cputim,waltim,
     7                   lutopo,luwater,rdtopo,rdwater,
     8                   zvo,dz,azim,stderr,lerr,undefined,
     9                   mintopo,maxtopo,minwater,maxwater,linv,
     a                   dtopo,dwater)
c
      implicit none
c
      integer mintopo,maxtopo,minwater,maxwater
      real    dtopo,dwater
      integer nshot,ntrace,minrecind,maxrecind
      integer luwater,lutopo,lugeom,lerr
      real    firstshot,dshot,firstoff,doff,dsta
      real    zdatum,zvo,dz,azim,undefined
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      logical live(ntrace,nshot)
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer soptnm(nshot)

      real    xdistmin(nshot),xdistmax(nshot)
      real    zdistmin(nshot),zdistmax(nshot)
      integer nlive(nshot)
c
      real    xg(minrecind:maxrecind)
      real    yg(minrecind:maxrecind)
      real    zg(minrecind:maxrecind)
      real    ztopo(minrecind:maxrecind)
      real    zw(minrecind:maxrecind)
      integer lrecind(minrecind:maxrecind)
c
      real    cputim(*),waltim(*)
c
      integer stderr
c
      logical rdtopo,rdwater,linv
c
      integer mingroup,maxgroup
      integer k,iseg,icolor,npicks,jtopo,itra
      real    zwater,topomin,topomax,xdatamin,xdatamax
      real    zdatamin,zdatamax,gdistmin,gdistmax
      integer itrace,ishot,ig,minshot,maxshot,ix,jshot,nrec,nsamp
      real    xh,zh,xsbackup,xtemp,smpunit,smpoff,recno,recunit,trcunit
      real    recoff,trcoff,v1,w1,v2,w2,xtemp2,ztemp
      integer minsearch,maxsearch,nsegments,maxpicks,iloop,icount
      logical vsp
      real    theta,xbegin,ybegin,xbeginprime
C__________________________________________________________________
c     initialize.                
C__________________________________________________________________
      icount=0
      xbegin=0.
      ybegin=0.
      xbeginprime=0.
      xdatamin=+1.e+32
      xdatamax=-1.e+32
      zdatamin=+1.e+32
      zdatamax=-1.e+32
      gdistmin=+1.e+32
      gdistmax=-1.e+32
      do 10000 k=minrecind,maxrecind
       lrecind(k)=0
       xg(k)=undefined
       ztopo(k)=undefined
       yg(k)=0.
       zg(k)=zdatum
       zw(k)=undefined
10000 continue
      zwater=0.
      nsegments=1
C__________________________________________________________________
c     read in appropriate header information.
C__________________________________________________________________
      call timstr(v1,w1)
      call rdheader(firstshot,dshot,firstoff,doff,
     1              minrecind,maxrecind,dsta,
     2              nshot,ntrace,nlive,xs,ys,zs, xr,yr,zr,xg,yg,zg,
     3              recind,lrecind,live,soptnm,stderr,lerr,
     4              mingroup,maxgroup)
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
      call timstr(v1,w1)
c
c
      if(.not.rdtopo) then
       topomin=mingroup*dsta-dsta
       topomax=maxgroup*dsta-dsta
       mintopo=mingroup
       maxtopo=maxgroup
      endif
c
c
C__________________________________________________________________
c     read in xsd format topography pick file.
C__________________________________________________________________
      if(rdtopo) then
201      format(10x,i5,6x,20x,10x,i5,9x,i5)
         read(lutopo,201)iseg,
     2                   icolor,        
     3                   npicks
         if (dsta.ge.dtopo) then
          do 90100 jtopo=mintopo,maxtopo-1
           read(lutopo,102) recno,xtemp,ztopo(jtopo) 
           do 100 iloop=1,int(dsta/dtopo)-1
            read(lutopo,102) recno,xtemp2,ztemp
100        continue
           if (abs(xtemp-xg(jtopo)).gt.dsta) then
            write(lerr,*) 'incompatible topography file'
            write(lerr,*) 'Should read topography of group location ',
     1                     xg(jtopo)
            write(lerr,*) 'read in fact topography of group location ',
     1                     xtemp
            icount = icount+1
           endif
           if (.not.linv) ztopo(jtopo)=-ztopo(jtopo)
102        format(f12.3,1x,f12.3,1x,f12.3)
90100     continue
         else
          do 90200 jtopo=mintopo,maxtopo,int(dtopo/dsta)
           read(lutopo,102) recno,xtemp,ztopo(jtopo)
           if (abs(xtemp-xg(jtopo)).gt.dsta) then
            write(lerr,*) 'incompatible topography file'
            write(lerr,*) 'Should read topography of group location ',
     1                     xg(jtopo)
            write(lerr,*) 'read in fact topography of group location ',
     1                     xtemp
            icount = icount+1
           endif
           if (.not.linv) ztopo(jtopo)=-ztopo(jtopo)
90200     continue
         endif

         call interph(ztopo(mingroup),mingroup,maxgroup,
     1                undefined,.true.,.true.)

         do 10 ishot=1,nshot
          itra = nint(xs(ishot)/dsta)+1
          zs(ishot) = ztopo(itra)
          do 20 itrace=1,ntrace
           zr(itrace,ishot) = ztopo(recind(itrace,ishot))
20        continue
10       continue 
   
         do 30 ig=mingroup,maxgroup
          zg(ig) = ztopo(ig)
30       continue

      else
         do 20000 ishot=1,nshot
          zs(ishot)=-zdatum
          do 15000 itrace=1,ntrace
           zr(itrace,ishot)=-zdatum
15000     continue
20000    continue
         do 21000 ig=mintopo,maxtopo
           ztopo(ig)=zdatum
21000    continue
         smpunit=-dz
         smpoff=zvo+dz
C__________________________________________________________________
c        write out topography info in xsd format.
C__________________________________________________________________
         npicks=(maxtopo-mintopo+1)
         write(lutopo,300,err=99993) 'Units ',
     1                 recunit,trcunit,smpunit,
     2                 nrec,ntrace,nsamp,
     3                ' Offset',recoff,trcoff,smpoff,
     4                ' Count  ',nsegments,npicks
300      format(a6,f12.3,1x,f12.3,1x,f12.3,1x,i5,1x,i5,1x,i5,
     1          a7,f12.3,1x,f12.3,1x,f12.3,a8,i5,1x,i5)
         iseg=1
         icolor=-44
301      format(a10,i5,a6,a20,a10,i5,a9,i5)
         recno=1.
         write(lutopo,301)'Segment = ',iseg,
     1                   ' Name ','topography',
     2                   ' color = ',icolor,
     3                   ' picks = ',npicks
         do 90400 jtopo=mintopo,maxtopo
          write(lutopo,302) recno,xg(jtopo),-ztopo(jtopo)
302       format(f12.3,1x,f12.3,1x,f12.3)
90400    continue
      endif

c__________________________________________________________________
c     determine min and max live shot.
c     these may be used to reproject the data onto a reference line.
c__________________________________________________________________
      minshot=nshot
      maxshot=1
      do 11000 ishot=1,nshot
       if(nlive(ishot) .gt. 0) then
          minshot=min(minshot,ishot)
          maxshot=max(maxshot,ishot)
       endif
11000 continue
c
C__________________________________________________________________
c     calculate inline min and max offsets.                   
C__________________________________________________________________
      do 50000 ishot=1,nshot
       xdistmin(ishot)=+1.e+30
       xdistmax(ishot)=-1.e+30
       zdistmin(ishot)=+1.e+30
       zdistmax(ishot)=-1.e+30
       if(nlive(ishot) .gt. 0) then
          do 48000 itrace=1,ntrace
           if(live(itrace,ishot)) then
              xh=xr(itrace,ishot)-xs(ishot)
              xdistmin(ishot)=min(xh,xdistmin(ishot))
              xdistmax(ishot)=max(xh,xdistmax(ishot))
              zh=(zr(itrace,ishot)-zs(ishot))
              zdistmin(ishot)=min(zh,zdistmin(ishot))
              zdistmax(ishot)=max(zh,zdistmax(ishot))
           endif
48000     continue
          zdatamin=min(zs(ishot),zs(ishot)+zdistmin(ishot),
     1                                  zdatamin)
          zdatamax=max(zs(ishot),zs(ishot)+zdistmax(ishot),
     1                                  zdatamax)
          xdatamin=min(xs(ishot),xs(ishot)+xdistmin(ishot),
     1                                  xdatamin)
          xdatamax=max(xs(ishot),xs(ishot)+xdistmax(ishot),
     1                                  xdatamax)
          gdistmin=min(xdistmin(ishot),gdistmin)
          gdistmax=max(xdistmax(ishot),gdistmax)
       else
          write(stderr,*) 'shot ',ishot,' is dead!'
       endif
50000 continue      
c__________________________________________________________________
c     calculate lowest and highest elevation of topographic surface.
c__________________________________________________________________
      do 64000 ix=mintopo,maxtopo
       topomin=min(ztopo(ix),topomin)
       topomax=max(ztopo(ix),topomax)
64000 continue
      do 52000 ishot=1,nshot
       if(nlive(ishot) .eq. 0) then
C__________________________________________________________________
c         intialize values for dead records.                        
C__________________________________________________________________
          xdistmin(ishot)=gdistmin
          xdistmax(ishot)=gdistmax
          xs(ishot)=0.
          ys(ishot)=0.
          zs(ishot)=0.
          call vclr(xr(1,ishot),1,ntrace)
          call vclr(yr(1,ishot),1,ntrace)
          call vclr(zr(1,ishot),1,ntrace)
       endif
52000 continue
C__________________________________________________________________
c     calculate the worst backup xdistance for any out of sequence
c     sources. sources that are not in ascending order will result
c     in increase memory requires to store travel time ray fans
c     and output crp gathers.
C__________________________________________________________________
      xsbackup=0.
      do 62000 ishot=1,nshot-1
       if(nlive(ishot) .gt. 0) then
          do 61000 jshot=ishot+1,nshot
           if(xs(jshot) .lt. xs(ishot) 
     1              .and. nlive(jshot) .gt. 0) then
             xsbackup=min(xsbackup,xs(jshot)-xs(ishot))
             write(stderr,*) 'shot ',jshot ,' is out of sequence!'
             write(stderr,'(a10,i10,f15.3)') 'jshot',jshot,xs(jshot),
     1                                       'ishot',ishot,xs(ishot)
           endif
61000     continue
       endif
62000 continue
c
      nrec=1
      nsamp=1000
      recunit=1.
      trcunit=dsta
      recoff=0.
      trcoff=xdatamin-dsta  
      minsearch=mingroup
      maxsearch=maxgroup
      if(rdwater) then
         read(luwater,201)iseg,
     1                    icolor,
     2                    npicks
         recno=1.
         if (dsta.ge.dwater) then
          do 92100 jtopo=minwater,maxwater-1
           read(luwater,102) recno,xtemp,zw(jtopo) 
           do 120 iloop=1,int(dsta/dwater)-1
            read(luwater,102) recno,xtemp2,ztemp
120        continue
           if (abs(xtemp-xg(jtopo)).gt.dsta) then
            write(lerr,*) 'incompatible waterbottom file'
            write(lerr,*) 'Should read waterbottom of group location ',
     1                     xg(jtopo)
            write(lerr,*) 'read in fact waterbottom of group location ',
     1                     xtemp
            icount = icount+1
           endif
           if (.not.linv) zw(jtopo)=-zw(jtopo)
92100     continue
         else
          do 92200 jtopo=minwater,maxwater,int(dwater/dsta)
           read(luwater,102) recno,xtemp,zw(jtopo)
           if (abs(xtemp-xg(jtopo)).gt.dsta) then
            write(lerr,*) 'incompatible waterbottom file'
            write(lerr,*) 'Should read waterbottom of group location ',
     1                     xg(jtopo)
            write(lerr,*) 'read in fact waterbottom of group location ',
     1                     xtemp
            icount = icount+1
           endif
           if (.not.linv) zw(jtopo)=-zw(jtopo)
92200     continue
         endif

         call interph(zw(mingroup),mingroup,maxgroup,
     1                undefined,.true.,.true.)
      else
C__________________________________________________________________
c        write out water bottom info in xsd format.
C__________________________________________________________________
         do 22000 ig=mingroup,maxgroup
          zw(ig)=zdatum
22000    continue

         npicks=ntrace
         smpunit=+dz
         smpoff=zvo-dz
         write(luwater,300,err=99993)'Units ',recunit,trcunit,smpunit,
     1                    nrec,ntrace,nsamp,
     2                    ' Offset',recoff,trcoff,smpoff,
     3                    ' Count  ',nsegments,npicks
         iseg=1
         icolor=-43
         write(luwater,301)'Segment = ',iseg,
     1                           ' Name ','topography',
     2                           ' color = ',icolor,
     3                           ' picks = ',npicks
         recno=1.
         do 90202 ig=mingroup,maxgroup
          write(luwater,302) recno,xg(ig),zw(ig)
90202    continue
      endif
c
      if (icount.gt.0) then
       write(lerr,*) 'program stopped'
       call exit(999)
      endif

      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
      call timstr(v1,w1)
C__________________________________________________________________
c     write out summary information that will be used FIRST by
c     the prestack migration codes.
C___________________________________________________________________
      vsp = .false.
      write(lugeom,'(7a12)') 'nshot','min RecInd','max RecInd',
     1              'min TopInd','max TopInd','dstation','vsp'
      write(lugeom,'(5i12,f12.6,l12)') nshot,mingroup,
     1                       maxgroup,mintopo,maxtopo,dsta,vsp
      write(lugeom,'(5a12)') 'xdatamin','xdatamax','gdistmin',
     1                       'gdistmax','xsbackup'         
      write(lugeom,'(5f12.1)') xdatamin,xdatamax,gdistmin,gdistmax,
     2                         xsbackup
      write(lugeom,'(7a12)') 'topomin','topomax','xbegin','ybegin',
     1                       'xbeginprime','azim','theta' 
      write(lugeom,'(5f12.1,2f12.6)') topomin,topomax,
     1                        xbegin,ybegin,xbeginprime,azim,theta
      if(vsp) then
         write(lugeom,'(6a12)') 'xs','ys','zs',
     1                  'zdistmin','zdistmax','nlive'
         write(lugeom,'(5f12.1,2i12)') (xs(ishot),ys(ishot),zs(ishot),
     1     zdistmin(ishot),zdistmax(ishot),nlive(ishot),soptnm(ishot),
     2     ishot=1,nshot)
      else
         write(lugeom,'(7a12)') 'xs','ys','zs',
     1                  'xdistmin','xdistmax','nlive','SoPtNm'
         write(lugeom,'(5f12.1,2i12)') (xs(ishot),ys(ishot),zs(ishot),
     1     xdistmin(ishot),xdistmax(ishot),nlive(ishot),soptnm(ishot),
     2                   ishot=1,nshot)
      endif
      write(lugeom,'(4a12)') 'ix','xtopo','ytopo','ztopo'
      write(lugeom,'(i12,3f12.1)')
     1               (ix,xg(ix),yg(ix),ztopo(ix), 
     2               ix=mintopo,maxtopo)   
      write(lugeom,'(6a12)') 'ig         ','xg','yg',
     1                       'zg (-GrpElv)','zw (-WDepDP)','RecInd'
      write(lugeom,'(i12,4f12.1,i12)')
     1               (ig,xg(ig),yg(ig),zg(ig),zw(ig),lrecind(ig),
     2               ig=mingroup,maxgroup)
C__________________________________________________________________
c      write out detailed information for each shot record.
C__________________________________________________________________
      do 80000 ishot=1,nshot
       write(lugeom,'(2a12,a12)') 'ishot','nlive'
       write(lugeom,'(2i12)') ishot,nlive(ishot)
       write(lugeom,'(2a12,3a12,a12)') 'trace','station',
     1             'xr','yr','zr','live'    
       do 70000 itrace=1,ntrace
        write(lugeom,'(2i12,3f12.1,l12)') 
     1       itrace,recind(itrace,ishot),      
     3       xr(itrace,ishot),yr(itrace,ishot),zr(itrace,ishot),
     4       live(itrace,ishot)
70000  continue
c
80000 continue
c
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
      return
c
99991 write(lerr,*) 'WARNING!'
      write(lerr,*) 'negative indices may have been caused'
     1             //' by indexing RecInd or SrcLoc > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' smaller value after -ming option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99991)
c
99992 write(lerr,*) 'WARNING!'
      write(lerr,*) 'bogus indices may have been caused'
     1             //' by indexing RecInd > 32667 !'
      write(lerr,*) 'examine your trace headers, and '
     1             //' if necessary, reindex your data'
      write(lerr,*) 'otherwise, resubmit job with '
     1             //' larger value after -maxg option'
      write(lerr,*) ' index encountered in ishot = ',ishot,
     1              ' itrace = ',itrace
      call exitfu(99992)
c
99993 write(lerr,*) 'ERROR in writing topographic pick file!'
      write(lerr,*) 'check for write permission'
      call exitfu(99993)
c
99994 write(lerr,*) 'ERROR in writing topographic pick file!'
      write(lerr,*) 'check for write permission'
      call exitfu(99994)
c
      end
