C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C NAME: PWMVZN  PWMVZN HEADER FILE              REV 7.1     NOV 90   *
C*********************************************************************
C
C  PURPOSE:
C     DEFINES THE COMMON AREA AND GLOBAL VARIABLES FOR PWMVZN.
C
C  HISTORY:
C	DEC 87		REV 1.0		R.D. COLEMAN, QTC
C
C	lots of missing history
C
C	APR 89		REV 5.2		M.A. THORNTON
C		Increased the number of input and output samples.
C
C	AUG 89		REV 5.3		M.A. THORNTON
C		Added stretch parameter.
C
C	more missing history
C
C	MAY 90		REV 7.0		R.D. COLEMAN
C		Added the array CXFTAB.
C
C	NOV 90		REV 7.1		R.D. COLEMAN
C		Added TT2WAY, decreased size of CXFTAB and changed
C               name of LUCRD2 to LUVEL.
C
C---------------------------------------------------------------------
C
C     MAXNT = TIME SAMPLES, MAXSMP = TIME SAMPLES, MAXNW=FREQUENCIES
C     MAXNX = TRACES      , MAXNK  = NO. K'S     , MAXNK1=NO. K'S + 1
C     MAXNZ = DEPTH # z's , MAXNZT = total # z's , MAXSEG=NO. Z-SEG'S
C     MAXREC= NO. RECORDS , MAXTAB = CXFTAB entries
C
      PARAMETER (LUCRD = 25, LUPRT = 26, LUSUR = 27, LUVEL = 28)
      PARAMETER (MAXNT  = 1024, MAXSMP = 1024, MAXNW  =  512,
     &           MAXNX  = 1024, MAXNK  = 1024, MAXNK1 = 1025,
     &           MAXNZ  = 1500, MAXNZT = 1500, MAXSEG = 1000,
     &           MAXREC =  200, NTRHDR =  128, MAXTAB =25001)
CMAT
      PARAMETER (NTRHD2 = 64)
C
      INTEGER LUINP, LUOUT, LUTRM,
     &        NREC, NTRC, NSMP, ITRC1, ITRC2,
     &        IREC1, IREC2, INCREC, NREC2, IDT0, IDT,
     &        NT, NW, NX, NK, NZ, NZSEG, NZT,
     &        IT1, IT2, NTOFF, NTPAD, IW1, IW2,
     &        IZSNZ(MAXSEG)
CMAT
      INTEGER * 2 HEADER(NTRHDR,MAXNX)
      LOGICAL VERBOS
      REAL    DT, DW, DX, DK, DZ, FMIN, FMAX, VELREF, BWIDTH, P, TT2WAY,
     &        OMEGA(MAXNW), FILTR(MAXNW), AK(MAXNK), THETA(MAXREC),
     &        ZSDZ(MAXSEG), ZSSLOI(MAXSEG), ZSSLOR(MAXSEG),
     &        RIMAGE(2*MAXNK1*MAXNZ), DEPTH(4*MAXNZ*MAXNK), STRCH,
     &        CXFTAB(2*MAXTAB+5)
      COMPLEX DATA(MAXNK*MAXNW)
C
      COMMON /PWCOMM/
     &        LUINP, LUOUT, LUTRM, NREC, NTRC, NSMP, ITRC1, ITRC2,
     &        IREC1, IREC2, INCREC, NREC2, IDT0, IDT,
     &        NT, NW, NX, NK, NZ, NZSEG, NZT, IT1, IT2, NTOFF, NTPAD,
     &        IW1, IW2, IZSNZ, HEADER, VERBOS,
     &        DT, DW, DX, DK, DZ, FMIN, FMAX, VELREF, BWIDTH, P, TT2WAY,
     &        OMEGA, FILTR, AK, THETA, ZSDZ, ZSSLOI, ZSSLOR,
     &        RIMAGE, DEPTH, CXFTAB, DATA, STRCH
C
