C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine diagonal(diag,gamma,ngamma,izmin,izmax,dz,ihmin,
     1                    ihmax,dh,ITRWRD)
c
      implicit none
c
      integer ITRWRD,ngamma,izmin,izmax,ihmin,ihmax
      real    diag(izmin:izmax,ngamma)
      real    gamma(ngamma)
      real    dz,dh
c
      integer ix,ih,iz,ixsi,igamma
      real    sqr,gamma2,xsi2,val
c
      val = 1.
c
      do 20000 igamma=1,ngamma
       do 20100 iz=izmin,izmax
        diag(iz,igamma) = 0.
20100  continue
20000 continue

      do 30000 igamma=1,ngamma
       gamma2 = ( gamma(igamma)**2 - 1. ) / 4.
       do 20 ixsi=izmin,izmax
        xsi2 = (ixsi*dz)**2
        do 30 ih=ihmin,ihmax
         sqr = xsi2 + gamma2*(ih*dh)**2
         if (sqr.gt.0.) then
          sqr = sqrt(sqr)
          iz = nint(sqr/dz)
          if ((iz.ge.izmin).and.(iz.le.izmax)) then
           diag(ixsi,igamma) = diag(ixsi,igamma) + val
          endif
         endif
30      continue
20     continue
30000 continue

      do 40000 igamma=1,ngamma
       do 40100 ixsi=izmin,izmax
        if (diag(ixsi,igamma).gt.0.)
     1     diag(ixsi,igamma)=1./sqrt(diag(ixsi,igamma))
40100  continue
40000 continue

      return
      end
