C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mainsub2(luin,luout,uin,uout,nx,nxbuf,gamma,ngamma,
     1                    izmin,izmax,dz,ihmin,ihmax,dh,lerr,ler,
     2                    ITRWRD,buffer,verbose,nodenumber,totalnodes,
     3                    ldiag,diag,lusemb,lfilesemb)

      implicit none

c-----------------------------------------------------------------------
c---->Type declaration for arguments
      logical verbose
      integer luin,luout,lerr,ler
      integer nx,nxbuf,ITRWRD,ngamma,izmin,izmax,ihmin,ihmax
      real    uout(nxbuf,izmin:izmax,ihmin:ihmax)
      real    buffer(-ITRWRD+izmin:izmax)
      real    uin(nxbuf,izmin:izmax,ngamma)
      real    gamma(ngamma)
      real    dz,dh
      integer nodenumber,totalnodes
      integer lusemb
      logical ldiag,lfilesemb
      real    diag(izmin:izmax,ngamma)
c
c---->Type declaration for local varialbles
      integer ix,ih,iz,ixsi,igamma
      real    sqr,gamma2,xsi2
      integer nbytes_in,nxpass,npass,ipass
c-----------------------------------------------------------------------


c---->We have nx crp to perform for this node and nxbuf crp fit in
c---->memory. There will thus be npass pass.
      npass = nx/nxbuf
      if (mod(nx,nxbuf).gt.0) npass=npass+1


c_______________________________________________________________________
c     loop over input data, record by record.
c_______________________________________________________________________
      do 50000 ipass=1,npass


c----->Define the number of crp for this pass (it is not allways nxbuf)
c-----------------------------------------------------------------------
       nxpass = min(nxbuf,nx-(ipass-1)*nxbuf)


c----->Read input arrays
c-----------------------------------------------------------------------
       do 40010 ix=1,nxpass
        do 40000 igamma=1,ngamma

c------->Read input (-N) file
         nbytes_in=0
         call rtape(luin,buffer(-ITRWRD+izmin),nbytes_in)
         if(nbytes_in .eq. 0) then
            write(lerr,*) 'end of file encountered in routine mainsub'
            write(lerr,*) 'input file, irec,itr:',ix,igamma
            call exit(1666)
         endif
         if (.not.ldiag) then
          do 40020 iz=izmin,izmax
           uin(ix,iz,igamma) = buffer(iz)
40020     continue

c-------->Read semblance file
          if (lfilesemb) then
           nbytes_in=0
           call rtape(lusemb,buffer(-ITRWRD+izmin),nbytes_in)
           if(nbytes_in .eq. 0) then
              write(lerr,*) 'end of file encountered in routine mainsub'
              write(lerr,*) 'input file, irec,itr:',ix,igamma
              call exit(1666)
           endif

c--------->Weight input radon domain by semblance term
           do 40021 iz=izmin,izmax
            uin(ix,iz,igamma) = uin(ix,iz,igamma)*buffer(iz)
40021      continue
          endif
         else

c-------->Weight input radon domain by hessian diagonal term
          do 40030 iz=izmin,izmax
           uin(ix,iz,igamma) = buffer(iz) * diag(iz,igamma)
40030     continue
         endif
40000   continue
40010  continue
 

c----->Clear output array
c-----------------------------------------------------------------------
       do 20000 ih=ihmin,ihmax
        do 20100 iz=izmin,izmax
         do 20200 ix=1,nxpass
          uout(ix,iz,ih) = 0.
20200    continue
20100   continue
20000  continue


c----->Loop over gamma
c-----------------------------------------------------------------------
       do 30000 igamma=1,ngamma

        gamma2 = ( gamma(igamma)**2 - 1. ) / 4.


c------>Loop over xsi
c-----------------------------------------------------------------------
        do 20 ixsi=izmin,izmax

         xsi2 = (ixsi*dz)**2

c------->We are now interested in the unique curve defined by igamma and
c------->ixsi and we do the summation of this curce along the data. Thus
c------->for each offset, we calculate the corresponding depth of this
c------->curve
         do 30 ih=ihmin,ihmax
          sqr = xsi2 + gamma2*(ih*dh)**2
          if (sqr.gt.0.) then
           sqr = sqrt(sqr)
           iz = nint(sqr/dz)
           if ((iz.ge.izmin).and.(iz.le.izmax)) then
            do 40 ix=1,nxpass
             uout(ix,iz,ih) = uout(ix,iz,ih) + uin(ix,ixsi,igamma)
40          continue
           endif
          endif
30       continue

20      continue


c------>Write verbose printout
c-----------------------------------------------------------------------
        if (verbose) write(ler,'(3(a,i6,a,i6,4x))') 'curve ',igamma,
     1           ' of ',ngamma,' pass ',ipass,
     2           ' of ',npass,' node ',nodenumber,' of ',totalnodes

30000  continue



c------>Write output result
c-----------------------------------------------------------------------
       do 10100 ix=1,nxpass
        do 10000 ih=ihmin,ihmax
         do 10200 iz=izmin,izmax
          buffer(iz) = uout(ix,iz,ih)
10200    continue
         call wrtape(luout,buffer(-ITRWRD+izmin),nbytes_in)
10000   continue
10100  continue

50000 continue


      return
      end
