C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C     Mike O'Brien         February 12, 1996

      subroutine rsamp_sub(rec,trc,smp,npicks,luout,name,icolor,jseg,
     :                     xmin,xmax,newx0,newdx,new_maxpik)
 
      integer luout, cnt, maxindx, jseg, icolor, npicks
      real    xmin, xmax, newx0, newdx
      real    slope, bias, xhere, zhere
      real    rec(npicks), trc(npicks), smp(npicks)
      character*20 name

102   format(f12.3,1x,f12.3,1x,f12.3)

c  get some useful values for resampling loop
c
      i = 1
      if (xmax .eq. 1.e+20) then

cpgg --> this logic only works in increasing X so must supply all 
c        pick related arrays to this routine sorted to increasing
c        X for every pick segment.
c

         do while (trc(i+1) .gt. trc(i))
            i = i+1
            if((i).ge.npicks)go to 1380
         enddo
 1380    xmax = trc(i)
         maxindx = i
      else
         maxindx = npicks
      endif

      if (xmin .eq. -1.e+20) then
         xmin = trc(1)
      endif

      nxout = nint((xmax - xmin )/newdx) + 1
      if(nxout.gt.new_maxpik)new_maxpik = nxout
      npicks = nxout
      
c  write the Segment card to the output file

      write(luout,60,err=350)jseg,name,icolor,nxout
 60   format('Segment = ',i5,' Name ',a20,'  color = ',i5,
     &          ' picks = ',i5)

c  resample in only the x direction and write new segment on the fly
c
      cnt = 1
      do i = 1, nxout
         xhere = xmin+newdx*(i-1)
         if (xhere .le. trc(1)) then
            write (luout,102)rec(1),xhere,smp(1)
         elseif(xhere .ge. trc(maxindx)) then
            write (luout,102)rec(maxindx),xhere,smp(maxindx)
         else
 400        if (xhere .gt. trc(cnt) .and.
     :           xhere .le. trc(cnt+1)) then
               slope = (smp(cnt+1)-smp(cnt))/(trc(cnt+1)-trc(cnt))
               bias  = smp(cnt) - trc(cnt)*slope
               zhere = slope*xhere + bias
               write (luout,102)rec(cnt),xhere,zhere
            else
               cnt = cnt+1
               goto 400
            endif
         endif
      enddo
      
      return

350   jerr = 100 
      return
      end

