C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RSIZ                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  RESIZE A DATASET IN X AND/OR T DIRECTION                  *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/12/09  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/05/25  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin           -  GET COMMAND LINE ARGUMENTS                   *
C      LBOPEN          -  OPEN TAPES                                   *
C      OPENPR          -  OPEN PRINTOUT FILES                          *
C      GAMOCO          -  PRINTS TORCH & OVAL                          *
C      ICOPEN  INTEGER -  OPEN INLINE CARD FILE                        *
C      RTAPE           -  READ TAPE                                    *
C      HLHPRT          -  DUMMY                                        *
C      VMOV            -  MATH ADVANTAGE MOVE CHARACTER STRING         *
C      LBCLOS          -  CLOSE TAPE                                   *
C      WRTAPE          -  WRITE TAPE                                   *
C      VCLR            -  MATH ADVANTAGE ZERO AN ARRAY                 *
C      RXPO            -  TRANSPOSE A MATRIX (CALLS RMTRAN-MATHADV.)   *
C      CCUINT          -  RESAMPLE ROUTINE                             *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      MAX     GENERIC -                                               *
C      IFIX    INTEGER -                                               *
C  FILES:                                                              *
C      GIASC  ( INPUT  INTERNAL   ) - INTERNAL READ OF DX FROM L.HEADER*
C      LCRD   ( INPUT  SEQUENTIAL ) - CARD FILE                        *
C      LPRT   ( OUTPUT SEQUENTIAL ) - PRINTOUT                         *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      200      ( 1) - OPEN PRINTOUT ERROR                             *
C      50       ( 3) - INPUT CARD ERROR                                *
C      100      ( 5) - USER ERROR                                      *
C      75       ( 1) - TAPE I/O ERROR                                  *
C      =BLANK=  ( 1) - NO ERROR                                        *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/01/26  *
C            -  ADD COF TAPEIO AND CALL TO GAMOCO                      *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/03/02  *
C            -  INCREASE MAX. NO. SAMPLES/TRACE TO 2048                *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/05/25  *
C            -  ADD HLHPRT, CHECK FOR OPEN CARD FILE ERRORS            *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/06/28  *
C            -  REPLACE XFSMP WITH FASTER CCUINT                       *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/11/15  *
C            -  CORRECT THE CALCULATION OF THE NEW GI IN OUTPUT HEADER *
C  REVISED BY:  DAN WHITMORE                  REVISION DATE: 89/01/31  *
C            -  CHANGED MAX # TRACES TO 4096                           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/02/06  *
C            -  MAKE DX AN OUTPUT TRACE SPACING RATHER THAN INPUT      *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/06/15  *
C            -  clear out the trace header, it was keeping the last tr.*
C            -  header for all new headers, and retaining 30000 in all *
C            -  the new headers when the last trace was dead           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/08/29  *
C            -  Move code to the sun to be maintain/distributed from sun
C  REVISED BY:  MARY ANN THORNTON  V: 2.1     REVISION DATE: 92/03/24  *
C            -  Call openpr with full program name for OS 6.1           
C            -  Remove all wordsize references for running on 32 Bit Mach.
C  REVISED BY:  MARY ANN THORNTON  V: 2.2     REVISION DATE: 92/05/12  *
C            -  Change topen to cmdlin, compile w/new sun compiler &
C            -  new libmbs.
C  REVISED BY:  MARY ANN THORNTON  V: 2.3     REVISION DATE: 93/07/08  *
C            -  Increase line header size, include hp.h so logical unit
C            -  ltrm will not be 0 on the HP
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
CCCCC
C     TAPE DATA AND HEADER ARRAYS
CCCCC
      PARAMETER (LLIST = 27, LPRT = 26, LCRD=25, ltmp = 28)
      DIMENSION IHEAD(SZLNHD)

      PARAMETER (NHEAD=11, MXTRA=4096, MXSAM=2048, MXX=2176)
      PARAMETER (MXTOT=MXTRA*MXSAM)

CCCCC SINCE DATASET CAN BE ENLARGED IN EITHER DIRECTION, M1 NEEDS TO
C      CORRESPOND TO THE MAX(MXTRA,MXSAM)
CCCCC PARAMETER (M1=MXTRA*2, M2=MXTRA*4)
      PARAMETER (M1=MXTRA*2, M2=MXTRA*4)
      DIMENSION IZ(M1),ZZ(M2)
      DIMENSION RXX(MXX),DATA(MXSAM),A(MXTOT),B(MXTOT)
      INTEGER*2 IRX(LNTRHD)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      CHARACTER*1  CARD(80)
      CHARACTER*1 PARR(66)
      CHARACTER*4  NAME,PPNAME,VERSION
      CHARACTER*4  GIASC
      CHARACTER*128 OTAP,NTAP,INPUT
      EQUIVALENCE (CARD(1),NAME)

      LOGICAL VERBOS
CCC   TABLE MUST BE DIMENSIONED (  MAX(MXTRA,MXSAM,LTR2,KSAMP2)  )
      DIMENSION TABLE(4096),TABL2(4096)

      DATA VERSION/' 2.3'/
      DATA PPNAME/'RSIZ'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ','R',
     2'E','S','I','Z','E',' ','S','E','I','S','M','I','C',' ','R','E',
     3'C','O','R','D','S','/','T','R','A','C','E','S',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/

      LTRM  = LER
      CALL cmdlin(NTAP,OTAP,INPUT,RX,RT,DX,IPIPI,IPIPO,LTRM,VERBOS)
      IF(IPIPI.EQ.0)THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN = 0
         LTRM = 2
      ENDIF
      IF(IPIPO.EQ.0)THEN
C        LUOUT IS AN INPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT=1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN PRINTOUT
C     OPEN CARD FILE OR 'BATCH'CARDFILE OR USE DEFAULTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      IF((RX.GE.999.) .OR. (RT.GE.999.))THEN
         JERR = 0
         IF(INPUT.NE.' ')THEN
            OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
            IF(JERR.NE.0)THEN
               WRITE(LPRT,*)'  ERROR OPENING EXTERNAL CARD FILE'
               STOP 50
            ENDIF
         ELSE
            N = ICOPEN('-rsiz.crd',LCRD)
            IF(N.EQ.0)THEN
               WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
               STOP 50
            ENDIF
         ENDIF
      ELSE
         GO TO 15
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ INPUT CARDS, SET UP JOB PARAMETERS, WRITE THEM OUT           C
C     RX  = INPUT RESAMPLE RATIO; RT  = OUTPUT RESAMPLE RATIO
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IREAD=1
    4 CONTINUE
      READ(LCRD,5,ERR=3000)CARD
    5 FORMAT(80A1)
      IF(NAME.NE.'RSIZ')GO TO 4
      READ(LCRD,16)RX,RT,DX
   16 FORMAT(3F10.0)
   15 CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN INPUT TAPE, GET PARAMETERS          WRITE THEM OUT           C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOF = 0
      CALL RTAPE(LUIN,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      LEN=4
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      CALL SAVER(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'Format', IFORM, LINHED)
      IF(IFORM.NE.3)THEN
         WRITE(LPRT,*)'  INPUT TAPE MUST BE FORMAT 3'
         STOP 100
      ENDIF
C
      IF(LTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         STOP 100
      ENDIF
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         STOP 100
      ENDIF
      IF(DX.GT.0.0)THEN
         IDX=IFIX(DX)
         WRITE(GIASC,22)IDX
   22    FORMAT(I4)
         CALL SAVEW(IHEAD, 'GrpInt', GIASC, LINHED)
         WRITE(LPRT,*)' OUTPUT TRACE SPACING ',IDX
      ENDIF
      IF(DX.LE.0.0)THEN
         CALL SAVER(IHEAD, 'GrpInt', GIASC, LINHED)
         READ(GIASC,23,IOSTAT=IERR)DX
   23    FORMAT(F8.0)
         IF(IERR .NE. 0) THEN
           WRITE(LPRT,*)'BAD READ ON GROUP INTERVAL FROM LINEHEADER'
           STOP 999
         ELSE
           WRITE(LPRT,*)'GROUP INTERVAL READ FROM LINEHEADER ', DX
         ENDIF
         IF(DX.LE.0.0)THEN
            WRITE(LPRT,*)'  GROUP INTERVAL IN HEADER .LE. ZERO'
            WRITE(LPRT,*)'  YOU MUST ENTER DX FOR OUTPUT TRACE SPACING'
            STOP 100
         ELSE
            WRITE(LPRT,*)' INPUT GROUP INTERVAL ',DX
            LDX=IFIX(DX/RX)
            WRITE(GIASC,22)LDX
            CALL SAVEW(IHEAD, 'GrpInt', GIASC, LINHED)
            WRITE(LPRT,*)' OUTPUT TRACE SPACING ',LDX
         ENDIF
      ENDIF
      KSAMP2 = KSAMP * RT
      LTR2   = LTR   * RX
      ISI2   = ISI / RT
      WRITE(LPRT,20)RX,RT
   20 FORMAT(
     *'  DATASET WILL BE RESIZED BY ',F7.3,' TO 1.0 RATIO IN X',/,
     *'                      AND BY ',F7.3,' TO 1.0 RATIO IN T')
      WRITE(LPRT,21)KSAMP2,LTR2,ISI2
   21 FORMAT('  OUTPUT SAMPLES='I5,' OUTPUT TRACES=',I5,/
     *       ' OUTPUT SAMPLE RATE=',I5)
      MXOUT=LTR2*KSAMP2
      IF(MXOUT.GT.MXTOT)THEN
         WRITE(LPRT,*)' OUTPUT DATASET EXCEEDS PROGRAM LIMITATIONS'
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
      IF(KSAMP2.GT.MXSAM)THEN
         WRITE(LPRT,*)' OUTPUT EXCEEDS PROGRAM LIMITATIONS IN T'
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
      CALL SAVEW(IHEAD, 'NumTrc', LTR2, LINHED)
      CALL SAVEW(IHEAD, 'SmpInt', ISI2, LINHED)
      CALL SAVEW(IHEAD, 'NumSmp', KSAMP2, LINHED)
      CALL WRTAPE(LUOUT,IHEAD,JEOF)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     SET UP OUTPUT RESAMPLE TABLE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      NTAB = MAX(LTR2,KSAMP2,LTR,KSAMP)
      DO 300 J=1,NTAB
         TABLE(J) = FLOAT(J-1)
  300 CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ RECORDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      DO 800 MR=1,NREC
         IF(VERBOS)WRITE(LPRT,*) 'PROCESSING RECORD ',MR
         LA = 1
         DO 500 L= 1,LTR
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            IF(IRX(125).EQ.30000)THEN
               CALL VCLR(A(LA),1,KSAMP)
               LA = LA + KSAMP
               GO TO 500
            ENDIF
            CALL VMOV(DATA,1,A(LA),1,KSAMP)
            LA=LA+KSAMP
  500    CONTINUE
C        ARRAY A CONTAINS ONE RECORD LTR TRACES, KSAMP SAMPLES EACH
C        TRANSPOSE A(KSAMP,LTR) INTO B(LTR,KSAMP)

         CALL VCLR(B,1,MXTOT)
         CALL RXPO(A,KSAMP,LTR,B)
         CALL VCLR(A,1,MXTOT)
         DO 575 J=1,NTAB
            TABL2(J) = FLOAT(J-1) * (1.0/RX)
  575    CONTINUE
C        RESIZE B INTO A ( IN X DIRECTION (TRACES) FIRST)
         INIT=1
         LA=1
         LB=1
         DO 600 K=1,KSAMP
            CALL CCUINT(TABLE,B(LB),LTR,TABL2,A(LA),LTR2,IZ,ZZ,INIT)
            INIT=0
            LA=LA+LTR2
            LB=LB+LTR
  600    CONTINUE
   19 FORMAT(7E18.6)

C        ARRAY A NOW CONTAINS 1 RECORD OF KSAMP COLUMNS, LTR2 POINTS EA.
C        TRANSPOSE A(LTR2,KSAMP) INTO B(KSAMP,LTR2)
C        RESIZE B INTO A ( IN T DIRECTION (SAMPLES) LAST)
C        RESULTING TRACES WILL BE KSAMP2*wordsize+hdrsize BYTES LONG
         DO 675 J=1,NTAB
            TABL2(J) = FLOAT(J-1) * (1.0/RT)
  675    CONTINUE
         CALL VCLR(B,1,MXTOT)
         CALL RXPO(A,LTR2,KSAMP,B)
         CALL VCLR(DATA,1,MXSAM)
         KBYTES = KSAMP2 * SZSMPD + SZTRHD
         INIT=1
         LA=1
         LB=1
         DO 700 L=1,LTR2
            CALL CCUINT(TABLE,B(LB),KSAMP,TABL2,DATA,KSAMP2,IZ,ZZ,INIT)
            INIT=0
            LB=LB+KSAMP
            IRX(106) = MR 
            IRX(107) = L 
            IRX(110) = MR 
            IRX(111) = L 
            IRX(125) = 0 
            CALL WRTAPE(LUOUT,RXX,KBYTES)
            IF(KBYTES.EQ.0)GO TO 1500
  700    CONTINUE
  800 CONTINUE
      WRITE(LPRT,801) NREC,LTR2,KSAMP2
  801 FORMAT(' JOB COMPLETE - OUTPUT=',I4,' RECORDS ',I4,' TRACES ',I4,
     1' SAMPLES')
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR ON RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          READ CARD ERRORS                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 3000 CONTINUE
      WRITE(LPRT,*)'  ERROR READING INPUT CARDS ON READ ',IREAD
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 50
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                    NORMAL END OF JOB                                 C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO GET DATASET NAMES                                      *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,INPUT,RX,RT,DX,IPIPI,IPIPO,LTRM,VERBOS)       *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*128  ??IOU* - INPUT TAPE                           *
C      OTAP    CHAR*128  ??IOU* - OUTPUT TAPE                          *
C      INPUT   CHAR*128  ??IOU* - CARD FILE                            *
C      RX      REAL      ??IOU* - X-DIRECTION RESAMPLE RATE            *
C      RT      REAL      ??IOU* - T-DIRECTION RESAMPLE RATE            *
C      DX      REAL      ??IOU* - OUTPUT TRACE SPACING                 *
C      IPIPI   INTEGER   ??IOU* - INPUT PIPE FLAG                      *
C      IPIPO   INTEGER   ??IOU* - OUTPUT PIPE FLAG                     *
C      LTRM    INTEGER   ??IOU* - TERMINAL LU                          *
C      VERBOS  LOGICAL   ??IOU* - AMOUNT OF PRINTOUT                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/07/27  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/05/25  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C      ARGR4           -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LTRM  ( OUTPUT SEQUENTIAL ) - TERMINAL                          *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,RX,RT,DX,IPIPI,IPIPO,LTRM,
     &                  VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--RESIZE IN X and/or T'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap] .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap] .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-RX[rx]  .. RATIO IN X-DIRECTION (default=2)'
         WRITE(LTRM,*)'-RT[rt]  .. RATIO IN T-DIRECTION (default=2)'
         WRITE(LTRM,*)'-DX[dx]  .. DELTA-X (OUTPUT trace spacing)'
      WRITE(LTRM,*)'         .. (default=input group interval*(1./RX) )'
         WRITE(LTRM,*)'-V       .. VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'rsiz -N[] -O[] -RX[] -RT[] -DX[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGR4 ('-RX',RX,2.0,999.)
      CALL ARGR4 ('-RT',RT,2.0,999.)
      CALL ARGR4 ('-DX',dx,0.0,0.0)
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RXPO                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TRANSPOSE A MATRIX                                        *
C  ENTRY POINTS:                                                       *
C      RXPO  (X,KROW,KCOL,Y)                                           *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (KROW,KCOL) - INPUT MATRIX             *
C      KROW    INTEGER  ??IOU*            - ROW DIMENSION              *
C      KCOL    INTEGER  ??IOU*            - COLUMN DIMENSION           *
C      Y       REAL     ??IOU*  (KCOL,KROW) - OUTPUT MATRIX            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/07/27  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/05/25  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RMTRAN - MATH ADVANTAGE LIBRARY                                 *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE RXPO(X,KROW,KCOL,Y)
      DIMENSION X(KROW,KCOL),Y(KCOL,KROW)
      CALL RMTRAN(X,KROW,Y,KCOL,KROW,KCOL)
      RETURN
      END
