C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C  NAME: SCOMB                                                         *
C***********************************************************************
C
C  PURPOSE:
C      CREATES A SEISMIC TAPE WHOSE TRACE DATA IS A LINEAR COMBINATION
C      OF THE TRACE DATA FROM TWO SEISMIC TAPES.
C
C  USAGE:
C      scomb -A[tapea] -B[tapeb] -O[otape] -a[] -b[] -DIV -e[] -V
C
C      -A is required and is used to specify the first input dataset.
C
C      -B is required and is used to specify the second input dataset.
C
C      -O is required and is used to specify the output dataset.
c
C      -a is the multiplier for input A
c
C      -b is the multiplier for input B
c
C      -e is an amount that will be added to input B before the Division
c
C      -DIV  is a flag to indicate division:        a*A/( b*(B+e) )
c
C      -MULT is a flag to indicate multiplication:  a*A * b*B
c
C      -SUM  is a flag to indicate addition:        a*A + b*B
c
C      -V for verbose printout
C
C  DESCRIPTION:
C      CREATES A SEISMIC TAPE WHOSE TRACE DATA IS A LINEAR COMBINATION
C      OF THE TRACE DATA FROM TWO SEISMIC TAPES; I.E.,
C
C         ODATA(i) = A * ADATA(i) + B * BDATA(i)
C
C      THE HEADERS IN THE OUTPUT TAPE ARE SET EQUAL TO THE HEADERS IN
C      THE FIRST INPUT TAPE.  HOWEVER, WORDS 11 TO 14 OF THE TWO INPUT
C      LINE HEADERS MUST MATCH.  THE COEFFICIENTS A AND B ARE READ (LIST
C      DIRECTED READ) FROM THE CARD FILE.
C      Revised:  Mary Ann Thornton     Version 2.0   8/l8/92
C                revived the code for distribution, made portable 
C      Revised:  Mary Ann Thornton     Version 3.0   1/l4/93
C                Changed the code to allow 2 new options:        
C                the options now are:
C                SUM = aA + bB
C                MULT = aA * bB
C                DIV  = aA / (b(B+eps))
C                a=multiplier for tape A
C                b=multiplier for tape B
C                eps=epsilon to add to tape B before division 
C      Revised:  Mary Ann Thornton     Version 3.1   6/l0/93
C                Added logical unit for the HP, checked for zero divide
C                Made sure (on division) that epsilon was added to B
C                after the multiplication took place on B, but before the
C                division was done.
C                Removed reference to the external card deck from the
C                program comments and pattern file
C-----------------------------------------------------------------------
C
      PROGRAM SCOMB
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C
      PARAMETER (LUCRD = 25, MAXSAM = 6000, MAXREC = 6000)
      PARAMETER (lprt = 26, LUSUR = 27)
      parameter (delim = -99999.)
C
      INTEGER ARGIS
      INTEGER LHEADA(SZLNHD), LHEADB(SZLNHD)
      INTEGER TRACEA(MAXSAM+ITRWRD), TRACEB(MAXSAM+ITRWRD)
      INTEGER*2 THEADA(LNTRHD), THEADB(LNTRHD)
      REAL    TDATAA(MAXSAM), TDATAB(MAXSAM)
      REAL    ASCALE(MAXREC), BSCALE(MAXREC)
      REAL    ESCALE(MAXREC)
      LOGICAL HELP,VERBOS
      LOGICAL DIV, MULT, SUM
      CHARACTER*1  CARD(80)
      CHARACTER*128 TAPEA, TAPEB, CARDS, OTAPE
      CHARACTER*1 PARR(66)
      CHARACTER*5 PPNAME
      CHARACTER*4 VERSION
C
      EQUIVALENCE (TRACEA(1), THEADA), (TRACEA(ITHWP1), TDATAA)
      EQUIVALENCE (TRACEB(1), THEADB), (TRACEB(ITHWP1), TDATAB)
      DATA PPNAME/'SCOMB'/
      DATA VERSION/' 3.1'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ','C','O','M','B','I','N','E',' ','T','W','O',' ',
     3'D','A','T','A','S','E','T','S',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C-----------------------------------------------------------------------
C
      lutrm = LER
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LUTRM,*)'COMMAND LINE ARGUMENTS--COMBINE 2 DATASETS'
         WRITE(LUTRM,*)' '
         WRITE(LUTRM,*)' INPUT '
         WRITE(LUTRM,*)'-A[ntap]   . FIRST INPUT DATASET NAME'
         WRITE(LUTRM,*)'-B[ntap]   . SECOND INPUT DATASET NAME'
         WRITE(LUTRM,*)'-O[otap]   . OUTPUT DATASET NAME'
         WRITE(LUTRM,*)'-a[Amult]  . SCALAR MULTIPLIER FOR DATASET A'
         WRITE(LUTRM,*)'           . Default is 1.0'
         WRITE(LUTRM,*)'-b[Bmult]  . SCALAR MULTIPLIER FOR DATASET B'
         WRITE(LUTRM,*)'           . Default is 1.0'
         WRITE(LUTRM,*)'-e[epsilon]. EPSILON FOR DATASET B FOR DIVISION'
         WRITE(LUTRM,*)'           . Default is 0.0'
         WRITE(LUTRM,*)'-SUM[flag] . FLAG FOR SUMMING'
         WRITE(LUTRM,*)'-DIV[flag] . FLAG FOR DIVISION'
         WRITE(LUTRM,*)'-MULT[flag]. FLAG FOR MULTIPLYING'
         WRITE(LUTRM,*)'-V         . VERBOSE PRINTOUT'
         WRITE(LUTRM,*)'USAGE:'
       WRITE(LUTRM,*)'scomb -A[] -B[] -O[] -a[] -b[] -DIV[] -e'
         WRITE(LUTRM,*)'               -OR-'
       WRITE(LUTRM,*)'scomb -A[] -B[] -O[] -a[] -b[] -MULT[]'
         WRITE(LUTRM,*)'               -OR-'
       WRITE(LUTRM,*)'scomb -A[] -B[] -O[] -a[] -b[] -SUM[]'
         STOP
      ENDIF
      CALL ARGSTR ('-A', TAPEA, ' ', ' ')
      CALL ARGSTR ('-B', TAPEB, ' ', ' ')
      CALL ARGSTR ('-O', OTAPE, ' ', ' ')
      CALL ARGSTR ('-C', CARDS, ' ', ' ')
      CALL ARGR4  ('-a', A    , 1.0, 1.0)
      CALL ARGR4  ('-b', B    , 1.0, 1.0)
      CALL ARGR4  ('-e', eps  , 0.0, 0.0)
      DIV    =   (ARGIS( '-DIV' ).GT.0)
      MULT    =  (ARGIS( '-MULT' ).GT.0)
      SUM    =   (ARGIS( '-SUM' ).GT.0)
C
      JERR = 0
      CALL OPENPR(LUSUR,lprt,PPNAME,JERR)
      IF(JERR.NE.0) STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,lprt)
      IF (TAPEA .EQ. ' ' .OR. TAPEB .EQ. ' ' .OR.
     &    OTAPE .EQ. ' '  ) THEN
         WRITE (lprt, *) ' FILE NAME IS MISSING'
         STOP
      ENDIF

      WRITE(lprt,38)TAPEA,TAPEB,OTAPE
   38 FORMAT(' INPUT DATASET 1 = ',/,A128,/
     1       ' INPUT DATASET 2 = ',/,A128,/
     2       ' OUTPUT DATASET  = ',/,A128)
      CALL LBOPEN (LUTAPA, TAPEA, 'r')
      CALL LBOPEN (LUTAPB, TAPEB, 'r')
      CALL LBOPEN (LUOTAP, OTAPE, 'w')
C
      JERR = 0
      N=0
      IF(CARDS.NE.' ')THEN
         OPEN (UNIT=LUCRD, FILE=CARDS, STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(lprt,*)'  ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
         WRITE(lprt,*)'  OPENED CARDS FOR READING'
         WRITE(lutrm,*)'  OPENED CARDS FOR READING'
         N=1
      ELSE
         N= ICOPEN('-scomb.crd',LUCRD)
         IF(N.NE.0)THEN
            WRITE(lprt,*)'  ERROR OPENING CARD FILE'
            STOP 50
         ENDIF
      ENDIF
      NBYTEA = 0
      CALL RTAPE (LUTAPA, LHEADA, NBYTEA)
      IF (NBYTEA .EQ. 0) THEN
         WRITE (lprt, *) ' ERROR READING TAPE A LINE HEADER'
         GO TO 800
      ENDIF
C
      NBYTEB = 0
      CALL RTAPE (LUTAPB, LHEADB, NBYTEB)
      IF (NBYTEB .EQ. 0) THEN
         WRITE (lprt, *) ' ERROR READING TAPE B LINE HEADER'
         GO TO 800
      ENDIF
C
      call saver(LHEADA,'NumRec',nrec,linhed)
      call saver(LHEADA,'NumTrc',ntra,linhed)
      call saver(LHEADA,'NumSmp',nsam,linhed)
      call saver(LHEADB,'NumRec',nrecb,linhed)
      call saver(LHEADB,'NumTrc',ntrab,linhed)
      call saver(LHEADB,'NumSmp',nsamb,linhed)
      if(nrec.ne.nrecb .or. ntra.ne.ntrab .or. nsam.ne.nsamb)then
            WRITE (lprt, *) ' TAPES ARE INCOMPATIBLE'
            GO TO 800
      ENDIF
      do irec=1,nrec
         ascale(irec)=a
         bscale(irec)=b
         escale(irec)=eps
      enddo
C
      LEN = 5
      CALL HLHPRT(LHEADA,NBYTEA,PPNAME,LEN,lprt)
      CALL WRTAPE (LUOTAP, LHEADA, NBYTEA)
C
C
      if(.not.sum .and. .not.div .and. .not.mult)then
         Write(lprt,*)
     & ' You must enter one of the following flags to indicate',
     & ' the operation to perform.  -SUM, -DIV, or -MULT'
         write(lprt,*)' Job terminated'
         Write(lutrm,*)
     & ' You must enter one of the following flags to indicate',
     & ' the operation to perform.  -SUM, -DIV, or -MULT'
         write(lutrm,*)' Job terminated'
         stop 100
      else
         if(sum)write(lprt,*) 'Datasets will be summed'
         if(div)write(lprt,*) 'Datasets will be divided'
         if(mult)write(lprt,*) 'Datasets will be multiplied'
      endif

      WRITE (lprt, 900) NREC, NTRA, NSAM
      if(nrec.gt.maxrec)then
         WRITE (lprt, *) ' NUMBER OF RECORDS EXCEEDS MAXIMUM'
         GO TO 800
      endif
C
      IF(N.NE.0)THEN

         do irec = 1, nrec
            ascale(irec)=delim
            bscale(irec)=delim
            escale(irec)=delim
         enddo

         READ  (LUCRD,77) CARD
   76    continue
         READ  (LUCRD,78,END=79) A, B, eps, I
         WRITE (lprt, 901) A, B, eps, i
         WRITE (lutrm, 901) A, B, eps, i
         if(i.gt.nrec)i=nrec
         ASCALE(I)=A
         BSCALE(I)=B
         ESCALE(I)=eps
         goto 76
   79    CONTINUE
         call INTRP ( ascale(1), nrec, delim, IERROR )
         call INTRP ( bscale(1), nrec, delim, IERROR )
         call INTRP ( escale(1), nrec, delim, IERROR )
      else
         WRITE (lprt, 901) A, B, eps
      ENDIF
   77    FORMAT(80A1)
   78    FORMAT(3F10.5,I10)


C
      IF (NSAM .GT. MAXSAM) THEN
         WRITE (lprt, *) ' NUMBER OF SAMPLES EXCEEDS MAXIMUM'
         GO TO 800
      ENDIF
C
      DO 230 IREC = 1, NREC
         write (lutrm,250)irec,ascale(irec),bscale(irec),escale(irec)
         write (lprt,250)irec,ascale(irec),bscale(irec),escale(irec)
  250 FORMAT (/' ', 'RECORD           =', I10,
     &         ' ', 'ASCALE =', E14.6,
     &         ' ', 'BSCALE =', E14.6,
     &         ' ', 'EPSILON =', E14.6)
         DO 220 ITRA = 1, NTRA
            NBYTEA = 0
            CALL RTAPE (LUTAPA, TRACEA, NBYTEA)
            IF (NBYTEA .EQ. 0) THEN
               WRITE (lprt, 902) IREC, ITRA
               GO TO 800
            ENDIF
C
            NBYTEB = 0
            CALL RTAPE (LUTAPB, TRACEB, NBYTEB)
            IF (NBYTEB .EQ. 0) THEN
               WRITE (lprt, 903) IREC, ITRA
               GO TO 800
            ENDIF
C
         if(sum)then
            DO 210 I = 1, NSAM
               TDATAA(I)=ascale(irec)*TDATAA(I)+bscale(irec)*TDATAB(I)
  210       CONTINUE
         endif

         if(mult)then
            DO 310 I = 1, NSAM
               TDATAA(I)=ascale(irec)*TDATAA(I)*bscale(irec)*TDATAB(I)
  310       CONTINUE
         endif
C
         if(div)then
            DO 410 I = 1, NSAM
               DIVIS = ((bscale(irec)*TDATAB(I)) + escale(irec))
                 if(divis .eq. 0.0) then
                   write(lprt,*)' The divisor is zero at sample',i, 
     &                      ' trace ',itra,'-- output sample will be',
     &                      ' zero, also'
                   write(lutrm,*)' The divisor is zero at sample',i, 
     &                      ' trace ',itra,'-- output sample will be',
     &                      ' zero, also'
                   tdataa(i) = 0.0
                   go to 410
                 endif
               TDATAA(I) = (ascale(irec) * TDATAA(I)) / DIVIS
  410       CONTINUE
         endif
C
            CALL WRTAPE (LUOTAP, TRACEA, NBYTEA)
            IF (NBYTEA .EQ. 0) THEN
               WRITE (lprt, 904) IREC, ITRA
               GO TO 800
            ENDIF
C
  220    CONTINUE
  230 CONTINUE
C
  800 CONTINUE
      WRITE (lprt, 905)
C
      CALL LBCLOS (LUTAPA)
      CALL LBCLOS (LUTAPB)
      CALL LBCLOS (LUOTAP)
      STOP
C
  900 FORMAT (/' ', 'NUMBER OF RECORDS           =', I5/
     &         ' ', 'NUMBER OF TRACES PER RECORD =', I5/
     &         ' ', 'NUMBER OF SAMPLES PER TRACE =', I5)
  901 FORMAT (/' ', 'A       =', E14.6/
     &         ' ', 'B       =', E14.6/
     &         ' ', 'epsilon =', E14.6/
     &         ' ', 'record  =', I10)
  902 FORMAT (/' ', 'ERROR READING INPUT TAPE A - REC', I4, ', TRACE',
     &               I4)
  903 FORMAT (/' ', 'ERROR READING INPUT TAPE B - REC', I4, ', TRACE',
     &               I4)
  904 FORMAT (/' ', 'ERROR WRITING OUTPUT TAPE - REC', I4, ', TRACE',
     &               I4)
  905 FORMAT (/' ', 'SCOMB COMPLETE')
      END
