C***********************************************************************
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C ESSL VERSION OF SLNT                                                 *
C***********************************************************************
C  ROUTINE:       SLNT                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  PRODUCE A TAU/P SECTION                                   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   N.D.WHITMORE,JR.                   ORIGIN DATE: 86/09/12  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 86/09/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GAMOCO -                                                        *
C      LBOPEN -                                                        *
C      RTAPE  -                                                        *
C      HLH    -                                                        *
C      RDCRD  -                                                        *
C      WRTAPE -                                                        *
C      SKIPT  -                                                        *
C      MOVE   -                                                        *
C      VMOV   -                                                        *
C      VCLR   -                                                        *
C      RFFT   -                                                        *
C      CVMUL  -                                                        *
C      CDOTPR -                                                        *
C      LBCLOS -                                                        *
C      SLNTSTK -
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      COS     GENERIC -                                               *
C      CMPLX   COMPLEX -                                               *
C      SIN     GENERIC -                                               *
C  FILES:                                                              *
C      6  ( OUTPUT SEQUENTIAL ) -                                      *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      999      ( 2) -                                                 *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C      MOVE   -                                                        *
C  REVISED BY:  L. YOUNG                      REVISION DATE: 87/02/02  *
C               90 DEGREE PHASE SHIFT AND MUTE OPTION ADDED            *
C  REVISED BY:  LAJUANTA YOUNG                REVISION DATE: 88/03/14  *
C               REVISED TO RUN ON CRAY 2                               *
C  REVISED BY:  L. YOUNG                      REVISION DATE: 87/02/02  *
C               90 DEGREE PHASE SHIFT AND MUTE OPTION ADDED            *
C  REVISED BY:  R.D. COLEMAN, CETech          REVISION DATE: 91/09/16  *
C               OPTIMIZATION FOR CRAY 2
C  REVISED BY:  M.A. THORNTON                 REVISION DATE: 91/09/19  *
C               Move code to Sun for maintenance/distribution
C  REVISED BY:  M.A. THORNTON   V: 2.1        REVISION DATE: 92/03/24  *
C               Remove word size references to run on 32 bit machine   *
C               However, slnt needs libmbs routines unavailable now
C               Use VMOV and VCLR when moving data/zeroes              *
C               Call openpr w/full program name for OS 6.1
C  REVISED BY:  M.A. THORNTON   V: 2.2        REVISION DATE: 92/05/21  *
C               Change topen to cmdlin for new sun compiler,           *
C               Code now runs on a 32 bit machine                      *
C  REVISED BY:  M.A. THORNTON   V: 2.3        REVISION DATE: 92/11/18  *
C               Put dxrec*1000 in the dx1000 line header slot          *
C  REVISED BY:  M.A. THORNTON   V: 2.4        REVISION DATE: 93/07/08  *
C               Increased line header buffer size; included hp.h so the*
C               logical unit LTRM will not be 0 on the HP              *
C  REVISED BY:  M.A. THORNTON   V: 2.5        REVISION DATE: 93/10/21  *
C               Added new command line argument for input group interval
C               Changed pattern file to show 1.0 for default for exponent
C               Changed man page to show 1.0 for default for exponent
C               and to include the new command line argument (-G)    
C  REVISED BY:  M.A. THORNTON   V: 2.6        REVISION DATE: 94/03/15  *
C               Added a check to make sure dx was not zero             *
C  REVISED BY:  M.A. THORNTON   V: 2.7        REVISION DATE: 94/03/18  *
C               Code failed when farmp and zermp were zero, and vmute
C               was GT zero (the tramp variable was undefined, and new
C               OS could not handle this).  Code was changed to use farmp
C               rather tramp when farmp and zermp were equal.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C ****
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

C   ADD 'SCALE ' TO ALLOW FOR MORE THAN 0 AND =90 DEGREE PHASE SHIFT
C
      PARAMETER ( NWMAX = 1024, NXMAX = 1100, NPMAX = 181, NSMAX = 4096)
      PARAMETER ( LPRT = 26, LCRD = 25, LLIST = 27 )
C
      COMPLEX DATA2D(NWMAX*NXMAX+NXMAX), DATAC(NSMAX/2),
     &        DSLNT(NXMAX), SLNT2D(NWMAX*NXMAX+NXMAX), SCALE
C
      REAL    TRACE(NSMAX+ITRWRD), DATA(NSMAX), WEIGHT(NXMAX), P(NPMAX),
     &        XOFF(NXMAX), ZRAMP(NSMAX), ANGKEP(NPMAX), XRAMP(NSMAX)
C
      INTEGER ICOPEN
      INTEGER*2 ITRH(LNTRHD)
      INTEGER   THEAD(1500), IHEAD(SZLNHD)
C
      LOGICAL VERBOS
      CHARACTER*4  IARR, PARR(2) * 33
      CHARACTER*1  CARD(80)
C
      EQUIVALENCE ( ITRH(1), TRACE(1) ), ( IHEAD(1), THEAD(1) )
      EQUIVALENCE ( TRACE(ITHWP1), DATA(1) ), ( DATAC(1), DATA(1) )
C
C     NTAP INPUT TAPE NAME
C     OTAP OUTPUT TAPE NAME
C     INPUT CARD FILE DATASET NAME
C
C   CHARACTER VARIABLE TO READ ASCII GROUP INTERVAL VALUE FROM LINEHEADER
C
      CHARACTER*4   GIASC
      CHARACTER*8   VREFK, NPK, PSTRTK, PINCK
      CHARACTER*4   PPNAME
      CHARACTER*4   VERSION
      CHARACTER*128 NTAP, OTAP, INPUT
      CHARACTER*1   HLHWRT(35)
      CHARACTER*1   HLHWRT2(35)
      CHARACTER*35  HLHWRT3, HLHWRT4
      EQUIVALENCE ( VREFK, IVREF ), ( NPK, NP ), ( PSTRTK, IPSTRT ),
     &            ( IPINC, PINCK )
C
      DATA XRAMP   / NSMAX * 0.0 /
      DATA HLHWRT  / '-', 'N', 33*' ' /
      DATA HLHWRT2 / '-', 'O', 33*' ' /
      DATA HLHWRT3 / 'vref =          #angs              ' /
      DATA HLHWRT4 / 'ang-strt          ang-inc          ' /
      DATA VERSION / ' 2.7' /
      DATA PPNAME  / 'SLNT' /
      DATA IARR    / 'SLNT' /
      DATA PARR(1) / '        SLANT STAK               ' /
      DATA PARR(2) / '      TAU-P TRANSFORM            ' /
C
C-----------------------------------------------------------------------
C
  901 FORMAT ( 80A1 )
  902 FORMAT ( F10.0, 2I10, 2F10.0, 3I10 )
  903 FORMAT ( 6F10.0 )
  904 FORMAT ( I10, 2F10.0 )
  905 FORMAT ( 1X, 'BAD READ ON INPUT LINEHEADER' )
  906 FORMAT ( ' -INPUT TAPE IS NOT SIS FORMAT 3 ' / ,
     &   ' -EXECUTION TERMINATED ' )
  907 FORMAT ( F8.0 )
  908 FORMAT ( /////, 22X, 'SLANT STAK PARAMETERS', //,
     &' REFERENCE VELOCITY                                ', F10.2, //,
     &' STARTING RECORD                                      ', I7, //,
     &' ENDING RECORD                                        ', I7, //,
     &' SPATIAL RECORD INCREMENT                          ', F10.2, //,
     &' MAXIMUM FREQUENCY                                 ', F10.2, //,
     &' NUMBER OF ZEROS TO PAD                               ', I7, //,
     &' OUTSIDE SPATIAL TAPER (IN TRACES)                    ', I7, //,
     &' INSIDE  SPATIAL TAPER (IN TRACES)                    ', I7, // )
  909 FORMAT ( /////, 22X, 'VELOCITY AND PHASE PARAMETERS', //,
     &' FIRST BREAK MUTING VELOCITY                       ', F10.2, //,
     &' TIME 0 FOR MUTING VELOCITY                        ', F10.2, //,
     &' FAR OFFSET RAMP(MS)                               ', F10.2, //,
     &' ZERO OFFSET RAMP(MS)                              ', F10.2, //,
     &' 90 DEGREE PHASE SHIFT (0 = NO,90 = YES)           ', F10.2, //,
     &' FREQUENCY EXPONENT                                ', F10.2, ///)
  910 FORMAT ( I5 )
  911 FORMAT ( 1X, ' R.I. ', I5, ' PROCESSED' )
  912 FORMAT ( 1X, /, '   EXECUTION COMPLETE   ' )
C
C-----------------------------------------------------------------------
C
C     (LTRM) TERMINAL=0, EXCEPT WHEN USING PIPES, THEN TERMINAL=2
C     cmdlin PICKS UP ALL THE COMMAND LINE ARGUMENTS AND LETS YOU
C     KNPW IF PIPES ARE BEING USED
C
      LTRM = LER
      CALL cmdlin(NTAP, OTAP, INPUT, grpint, 
     &            SCAL, IPIPI, IPIPO, LTRM, VERBOS )
      IF( IPIPI .EQ. 0 ) THEN
C
C        LUIN IS AN INPUT DATASET
C
         CALL LBOPEN( LUIN, NTAP, 'r' )
      ELSE
C
C        WE KNOW LUIN IS A PIPE
C
         LUIN = 0
         LTRM = 2
      ENDIF
C
      IF( IPIPO .EQ. 0 ) THEN
C
C        LUOUT IS AN OUTPUT DATASET
C
         CALL LBOPEN( LUOUT, OTAP, 'w' )
      ELSE
C
C        WE KNOW LUOUT IS A PIPE
C
         LUOUT = 1
      ENDIF
C
C     LLIST IA A FREE LOGICAL UNIT NUMBER FOR USE IN OPENPR
C     LPRT IS THE L0GICAL UNIT NUMBER FOR A PRINTOUT
C     PPNAME IS THE PROGRAM NAME
C     OPEN PRINTOUT
C
      CALL OPENPR( LLIST, LPRT, PPNAME, JERR )
      IF( JERR .NE. 0 ) STOP 200
#include <mbsdate.h>
      NLIN = 1
      CALL GAMOCO( PARR, NLIN, LPRT )
C
C     OPEN THE INPUT CARD FILE IF IT EXISTS AS A SEPARATE FILE OR USE THE
C     ICOPEN FUNCTION TO USE THE BATCH JOB STREAM AS THE INPUT CARD FILE
C     IF THE BATCH JOB STREAM IS USED AS A CARD FILE, 'N' WILL BE .GT. 0
C     IT THERE ARE NO CARDS, IT IS ASSUMED THE PARAMETER VALUE CAME IN
C     ON THE COMMAND LINE (OR DEFAULT VALUE WILL BE USED).
C
      IF( INPUT .NE. ' ' ) THEN
         OPEN( UNIT=LCRD, FILE=INPUT, STATUS='OLD' )
         N = 1
      ELSE
         N = ICOPEN( '-slnt.crd', LCRD )
      ENDIF
C
      IF( N .NE. 0 ) THEN
         READ( LCRD, 901 ) CARD
         READ( LCRD, 902 ) VREF, NSTRT, NEND, DXREC, FMAX, NPAD,
     &                     NWT1, NWT2
         READ( LCRD, 901 ) CARD
         READ( LCRD, 903 ) VMUTE, T0, FARMP, ZERMP, HILB, EXPON
         IVMUTE = VMUTE
C
C        READ ANGLE CARDS
C
         READ( LCRD, 901 ) CARD
         NP = 0
  140    CONTINUE
            READ( LCRD, 904, END=160 ) NP1, PSTRT, PINC
            IF( NP1 .LE. 0 ) GO TO 160
            P(NP+1)  = PSTRT
            WRITE( LPRT, * ) 'ANGLE(',NP + 1,')=', P(NP+1)
            IF( NP1 .GT. 1 ) THEN
               DO 150 I = NP + 2, NP + NP1
                  P(I) = P(I-1) + PINC
                  WRITE( LPRT, * ) 'ANGLE(',I,')=', P(I)
  150          CONTINUE
               CALL VMOV( P, 1, ANGKEP, 1, NPMAX )
            ENDIF
            NP = NP + NP1
            GO TO 140
  160    CONTINUE
      ENDIF
C
C     GET INPUT PARAMETERS
C     NP = NUMBER OF ANGLES (P'S)
C     NPAD = EXTRA ZEROES TO PAD
C     NW = NUMBER OF FREQUENCIES
C     WEIGHT(.) = WEIGHT ARRAY
C     DOMEGA = DELTA OMEGA
C     DXREC =  SHOT INCREMENT
C     NSTRT = STARTING RECORD
C
      IEOF = 0
      CALL RTAPE( LUIN, IHEAD, IEOF )
      IF( IEOF .EQ. 0 ) THEN
         WRITE( LPRT, 905 )
         GO TO 999
      ENDIF
C
C     PROCESS LINE HEADER
C  
      call saver(ihead, 'NumTrc', ntr, linhed) 
      call saver(ihead, 'NumRec', nrec, linhed) 
      call saver(ihead, 'SmpInt', isi, linhed) 
      call saver(ihead, 'NumSmp', nsamp, linhed) 
      call saver(ihead, 'Format', ifmt, linhed) 

c
c     convert from microseconds
c
      dtmsec=isi
      if(dtmsec .gt. 16) then
         dtmsec=.001*dtmsec
      endif
      dt=dtmsec*.001
      isi=nint(dtmsec)

C
C   CHECK TO MAKE SURE FORMAT 3 DATA
C
      IF( IFMT .NE. 3 ) THEN
         WRITE( LPRT, 906 )
         CALL CCEXIT( 906 )
      ENDIF
C
C     READ GROUP INTERVAL FROM LINEHEADER
C
      if(grpint.gt.0.0)then
         dx = grpint
         write(lprt,*)' GROUP INTERVAL READ FROM COMMAND LINE ', DX
      else
         CALL SAVER(IHEAD, 'GrpInt', GIASC, LINHED)
         READ( GIASC, 907, IOSTAT=IERR ) DX
         IF( IERR .NE. 0 ) THEN
            WRITE(LPRT,*)'BAD READ ON GROUP INTERVAL FROM LINEHEADER '
            WRITE(LPRT,*)'SUGGESTION: Use the -G flag to enter the ',
     &                   'input group interval on the command line. '
            GO TO 999
         ELSE
            WRITE( LPRT, * ) ' GROUP INTERVAL READ FROM LINEHEADER ', DX
         ENDIF
      endif
cmat  Check for dx le 0.0 and stop
      if(dx.le.0.0)then
        write(lprt,*)' The group interval is less than or equal to ',
     &               'zero in the line header. You must enter the ',
     &               'group interval on the command line with the ',
     &               'flag -G '
        write(ler,*) ' The group interval is less than or equal to ',
     &               'zero in the line header. You must enter the ',
     &               'group interval on the command line with the ',
     &               'flag -G '
        stop 100
      endif
C
C     WRITE PARAMETERS TO PRINTOUT
C
      WRITE( LPRT, 908 ) VREF, NSTRT, NEND, DXREC, FMAX, NPAD,
     &                   NWT1, NWT2
C
C     SET DEFAULTS FOR PHASE AND FREQUENCY SCALER
C
      IF( HILB  .EQ. 0.0 ) HILB  = 45.0
      IF( EXPON .EQ. 0.0 ) EXPON =  1.0
C
      WRITE( LPRT, 909 ) VMUTE, T0, FARMP, ZERMP, HILB, EXPON
C
C     CONVERT ANGLES TO RAY PARAMETERS
C
      PI     = 4.0 * ATAN( 1.0 )
      TWOPI  = 2.0 * PI
      RADIAN = PI / 180.0
      DO 170 I = 1, NP
         P(I) = SIN( P(I) * RADIAN ) / VREF
  170 CONTINUE
C
C     DETERMINE FREQUENCY SAMPLING
C
      CALL PWROF2( NSAMP + NPAD, IPWR2 )
      NSPAD = 2 ** IPWR2
C
      IF( NSPAD .GT. NSMAX ) THEN
         WRITE( LPRT, * ) 'NUMBER OF SAMPLES (TO NEXT POWER OF 2) GT',
     &                NSMAX
         WRITE( LPRT, * ) 'JOB TERMINATED'
         GO TO 999
      ENDIF
C
      T      = FLOAT( NSPAD ) * FLOAT( ISI ) / 1000.0
      DOMEGA = TWOPI / T
      TNYQ   = 1.0 / ( 2.0 * FLOAT( ISI ) / 1000.0)
      IF( FMAX .GT. TNYQ ) THEN
         WRITE( LPRT, * ) '  MAXIMUM FREQUENCY REDUCED TO NYQUIST'
         FMAX = TNYQ
      ENDIF
C
      NW = ( TWOPI * FMAX ) / DOMEGA
      LW = NW
      IF( MOD( NW, 2 ) .EQ. 0 ) LW = NW + 1
C
      IF( NW * NTR .GT. NWMAX * NXMAX ) THEN
         WRITE( LPRT, * )
     &        'NUMBER OF TRACES * NUMBER OF TRACES IS TOO LARGE'
         GO TO 999
      ENDIF
C
C     SET RECORD CONTROL DEFAULTS
C
      IF( NSTRT .LE. 0 )    NSTRT = 1
      IF( NEND  .LE. 0 )    NEND  = NREC
      IF( NEND  .GT. NREC ) NEND  = NREC
C
C     COMPUTE WEIGHT ARRAY
C
      IF( NWT1 .GT. NTR / 2 ) THEN
         WRITE( LPRT, * )
     &        'ERROR IN INPUT SPATIAL TAPERS, NO TAPERING APPLIED'
         NWT1 = 0
         NWT2 = 0
      ENDIF
C
      IF( NWT2 .GT. NTR ) THEN
         WRITE( LPRT, * )
     &        'ERROR IN INPUT SPATIAL TAPERS, NO TAPERING APPLIED'
         NWT1 = 0
         NWT2 = 0
      ENDIF
C
      IF( ( NWT1 + NWT2 / 2 ) .GT. NTR / 2 ) THEN
         WRITE( LPRT, * )
     &        'ERROR IN INPUT SPATIAL TAPERS, NO TAPERING APPLIED'
         NWT1 = 0
         NWT2 = 0
      ENDIF
C
      IF( NWT1 .LT. 0) NWT1 = 0
      IF( NWT2 .LT. 0) NWT2 = 0
C
      DO 180 N = 1, NTR
         WEIGHT(N) = 1.0
  180 CONTINUE
C
      IF( NWT1 .GT. 0 ) THEN
         DO 190 N = 1, NWT1
            WEIGHT(N)       = FLOAT( N ) / FLOAT( NWT1+1 )
            WEIGHT(NTR - N+1) = WEIGHT(N)
  190    CONTINUE
      ENDIF
C
      IF( NWT2 .GT. 1 ) THEN
         DO 200 N = 1, NWT2 / 2
            WTEMP = FLOAT( N ) / ( FLOAT( NWT2 ) / 2.0 + 1 )
            WEIGHT(NTR/2-N+1)    = WTEMP
            WEIGHT((NTR+1 )/2+N) = WTEMP
  200    CONTINUE
         IF( ( NTR / 2 * 2 ) .NE. NTR) WEIGHT(NTR/2+1) = 0.0
      ENDIF
C
      LEN = 4
      CALL HLHPRT( IHEAD, IEOF, PPNAME, LEN, LPRT )
C
      CALL MOVE( 1, HLHWRT(3), NTAP, 33 )
      LEN = 35
      CALL HLHPRT( IHEAD, IEOF, HLHWRT, LEN, LPRT )
C
      LEN = 35
      CALL MOVE( 1, HLHWRT2(3), OTAP, 33 )
      CALL HLHPRT( IHEAD, IEOF, HLHWRT2, LEN, LPRT )
C
      MBYTES = ( NSAMP + NPAD ) * SZSMPD + SZTRHD
      IRECNM = NEND - NSTRT + 1
      ISMPNM = NSAMP + NPAD
      IVREF  = VREF
      IPSTRT = ANGKEP(1)
      IPINC  = ABS( ABS( ANGKEP(2) ) - ABS( ANGKEP(1) ) )
      WRITE( UNIT=HLHWRT3( 8:15 ), FMT=910 )  IVREF
      WRITE( UNIT=HLHWRT3( 23:30 ), FMT=910 ) NP
      LEN = 35
      CALL HLHPRT( IHEAD, IEOF, HLHWRT3, LEN, LPRT )
C
      WRITE( UNIT=HLHWRT4( 10:17 ), FMT=910 ) IPSTRT
      WRITE( UNIT=HLHWRT4( 27:34 ), FMT=910 ) IPINC
      LEN = 35
      CALL HLHPRT( IHEAD, IEOF, HLHWRT4, LEN, LPRT )
C
      CALL SAVEW( IHEAD, 'CDPFld', NP, LINHED )
      CALL SAVEW( IHEAD, 'Format', IFMT, LINHED )
      CALL SAVEW( IHEAD, 'NumRec', IRECNM, LINHED )
      CALL SAVEW( IHEAD, 'NumTrc', NP, LINHED )
      CALL SAVEW( IHEAD, 'NumSmp', ISMPNM, LINHED )
      CALL SAVEW( IHEAD, 'MutVel', VMUTE, LINHED )
      CALL SAVEW( IHEAD, 'WatVel', IVREF,LINHED )
      CALL SAVEW( IHEAD, 'RATTrc', IPSTRT, LINHED )
      CALL SAVEW( IHEAD, 'RATFld', IPINC, LINHED )
      idxrec = dxrec * 1000. 
      CALL SAVEW( IHEAD, 'Dx1000', idxrec, LINHED )
C
      CALL WRTAPE( LUOUT, IHEAD, IEOF )
C
C     SKIP OVER  (NSTRT - 1) * NTR   TRACES
C
      NSKIP = ( NSTRT - 1 ) * NTR
      IF( NSTRT .GT. 1) CALL SKIPT( LUIN, NSKIP, NSAMP * 4+256 )
C
C        SET VALUE FOR VELOCITY MUTE IN MILLISECONDS AND INVERSE FOR MULTI-
C        PLICATIONS INSIDE DO LOOPS LATER       ....................L YOUNG
C        ALSO SET RAMP VALUE IN SAMPLES FOR LATER     ..............L YOUNG
C        IF VMUTE IS 0 SKIP MUTE OPTION
C
      IF( VMUTE .EQ. 0.0) GO TO 240
C
      VX   = VMUTE / 1000.0
      VXI  = 1.0 / VX
      XISI = 1.0 / ISI
      RNTR = NTR
      RNTR = RNTR / 2.0 + 1.0
      MNTR = RNTR
C
C     FILL RAMP ARRAY FOR LINEAR TYPE RAMP
C
      IF( FARMP .GT. ZERMP ) THEN
         TRAMP = ( FARMP - ZERMP + 1 ) / RNTR
         DO 210 IR = 1, MNTR
            XRAMP(IR) = ( MNTR - IR ) * TRAMP
            XRAMP(IR) = ( XRAMP(IR) / ISI ) + 0.5
            IF( XRAMP(IR) .EQ. 0) XRAMP(IR) = 1.0
  210    CONTINUE
      ENDIF
C
      IF( FARMP .EQ. ZERMP ) THEN
         DO 220 IR = 1, MNTR
            XRAMP(IR) = ( farmp / ISI ) + 0.5
            IF( XRAMP(IR) .EQ. 0) XRAMP(IR) = 1.0
  220    CONTINUE
      ENDIF
C
      IF( ZERMP .GT. FARMP ) THEN
         TRAMP = ( ZERMP - FARMP + 1 ) / RNTR
         DO 230 IR = 1, MNTR
            XRAMP(IR) = IR * TRAMP
            XRAMP(IR) = ( XRAMP(IR) / ISI ) + 0.5
            IF( XRAMP(IR) .EQ. 0) XRAMP(IR) = 1.0
  230    CONTINUE
      ENDIF
C
  240 CONTINUE
C
      ITRH127 = 0
      DO 390 NR = 1, NEND - NSTRT + 1
         ITRH127 = 0
C
C        READ, FFT AND XPOSE DATA
C
         DO 350 NX = 1, NTR
            NBYTES = 0
            CALL RTAPE( LUIN, TRACE, NBYTES )
C
            IF( NBYTES .EQ. 0 ) THEN
               WRITE( LPRT, * ) 'ERROR READING TRACE ',NX,' ON REC',
     &                        NR + NSTRT - 1
               GO TO 999
            ENDIF
C
            CALL SAVER(ITRH, 'StaCor', I125, TRCHED)
            IF( I125 .EQ. 30000 ) THEN
               CALL VCLR(DATA, 1, NSPAD)
            ENDIF
C
C           FETCH OFFSET FROM HEADER
C
            CALL SAVER(ITRH, 'DstSgn', I119, TRCHED)
            XOFF(NX) = I119
C
            CALL SAVER(ITRH, 'SoPtNm', I127, TRCHED)
            IF( I127 .NE. 0 .AND. I125 .NE. 30000 ) THEN
               ITRH127 = I127
            ENDIF
C
            IF( IFMT .EQ. 1 ) THEN
               WRITE( LPRT, * )'INPUT DATA IS FORMAT 1 DOES NOT COMPUTE'
               GO TO 999
            ENDIF
C
C    IF MUTE VELOCITY IS 0 SKIP MUTE OPTION
C
            IF( VMUTE .EQ. 0.0) GO TO 330
C
C           COMPUTE LINES FOR FIRST BREAK MUTING AND RAMP .........L YOUNG
C
            ZEROT  = ( ABS( XOFF(NX) ) * VXI ) + T0
            X0SAMP = ( ZEROT * XISI ) + 0.5
            N0SAMP = X0SAMP
            NRAMP  = XRAMP(NX)
            IF( NRAMP .GT. N0SAMP) NRAMP = N0SAMP
C
            DO 310 IX = 1, NRAMP
               FRAMP     = NRAMP
               XX        = IX
               ZRAMP(IX) = XX / ( FRAMP + 1.0 )
  310       CONTINUE
C
            IF( N0SAMP .GT. NRAMP) NDIF = N0SAMP - NRAMP
            IF( N0SAMP .EQ. NRAMP) NDIF = 0
            IF( NDIF   .GT. 0) CALL VCLR( DATA(1), 1, NDIF )
C
            DO 320 IX = 1, NRAMP
               IXX       = IX + NDIF
               DATA(IXX) = DATA(IXX) * ZRAMP(IX)
  320       CONTINUE
C
C           END OF MUTE AND RAMP COMPUTATIONS ...................L YOUNG
C

  330       CONTINUE
C
C           CLEAR DATA TO NEXT POWER OF 2
C
            IF( NSPAD .GT. NSAMP ) THEN
               CALL VCLR( DATA(NSAMP + 1), 1, ( NSPAD - NSAMP ) )
            ENDIF
C
C           FFT DATA (REAL -> COMPLEX)
C
            CALL RFFT( DATA, NSPAD, 1 )
C
C           TRANSPOSE INTO DATA2D AND ROTATE PHASE
C
            THETA = HILB * RADIAN
            SCALE = WEIGHT(NX) * CMPLX( COS( THETA ), SIN( THETA ) )
            JWX   = (NX - 1) * LW
C
            DO 340 JW = 1, NW
               DATA2D(JWX+JW) = DATAC(JW) * SCALE * FLOAT( JW )**EXPON
  340       CONTINUE
  350    CONTINUE
C
         DO 380 JP = 1, NP
C
C           INITIALIZE SLANT ARRAYS FOR THIS 'P'
C
            DO 360 NX = 1, NTR
               ARG       = -DOMEGA * P(JP) * XOFF(NX)
               DSLNT(NX) = CMPLX( COS( ARG ), SIN( ARG ) )
  360       CONTINUE
C
C           COMPUTE SLANT STACK FOR ALL OMEGA'S FOR THIS 'P'
C
            FPTEMP = FMAX
            PKNT   = P(JP)
C
            IF( ABS( PKNT ) .GT. 0.00000001 ) THEN
               FPTEMP = 1.0 * ( 1.0 / ABS( PKNT ) ) / ( 2.0 * DX )
            ENDIF
C
            FPMAX  = AMIN1( FPTEMP, FMAX )
            NWPMAX = ( FPMAX * 2.0 * PI ) / DOMEGA
C
            JXW = 1
            CALL SLNTSTK( LW, NWPMAX, NTR, NSPAD, DSLNT, DATA2D, SLNT2D,
     &                    DATAC )
C
C           INVERSE FFT
C
            CALL RFFT( DATA, NSPAD, -1 )
C
C           BUILD OUTPUT TRACE HEADERS
C
            I119 = ANGKEP(JP)
            CALL SAVEW(ITRH, 'RecNum', NR, TRCHED)
            CALL SAVEW(ITRH, 'TrcNum', JP, TRCHED)
            CALL SAVEW(ITRH, 'DstSgn', I119, TRCHED)
C
C           UPDATE FOR SLOWNESS,REFERENCE VEL. IN THE TRACE HEADER
C
C           For the time being the slowness will not be put into the
C           trace header - other programs are not using it for now, keep
C           the line here for later use ??
CCCCCCCCCC  ITRH(41)  = 10000.0 * SIN( ANGKEP(JP) * RADIAN ) / VREF
            I117 = VREF
            I127 = ITRH127
            I108 = ITRH127
            CALL SAVEW(ITRH, 'DstUsg', I117, TRCHED)
            CALL SAVEW(ITRH, 'SoPtNm', I127, TRCHED)
            CALL SAVEW(ITRH, 'SrcPnt', I108, TRCHED)
C
            IF( P(NP) .GE. 0.0) THEN
               I125 = 1000.0 * DXREC * ( NR - 1 ) * P(JP)
            ELSE
               I125 = 1000.0 * DXREC * (NEND - NSTRT - NR) * P(JP)
            ENDIF
            CALL SAVEW(ITRH, 'StaCor', I125, TRCHED)
C
            CALL WRTAPE( LUOUT, TRACE, MBYTES )
  380    CONTINUE
         NWRIT = NR + ( NSTRT - 1 )
         WRITE( LPRT, 911 ) NWRIT
  390 CONTINUE
C
  999 CONTINUE
      CALL LBCLOS( LUIN )
      CALL LBCLOS( LUOUT )
      WRITE( LPRT, 912 )
      STOP
      END
C
C=======================================================================
C
      SUBROUTINE cmdlin( NTAP, OTAP, INPUT, grpint, SCALE, IPIPI, IPIPO,
     &                 LTRM, VERBOS )
C
      INTEGER ARGIS
      LOGICAL HELP, VERBOS
      CHARACTER * 128 NTAP, OTAP, INPUT
C
C     SET DEFAULTS TO NO PIPES
C
      IPIPI  = 0
      IPIPO  = 0
      VERBOS = .FALSE.
      HELP   = ( ARGIS( '-H' ) .GT. 0) .OR. ( ARGIS( '-?' ) .GT. 0)
C
      IF(  HELP ) THEN
         WRITE( LTRM, * ) 'COMMAND LINE ARGUMENTS-----SLANT STAK    '
         WRITE( LTRM, * ) ' '
         WRITE( LTRM, * ) ' INPUT '
         WRITE( LTRM, * ) '-N(NTAP)    . INPUT DATASET'
         WRITE( LTRM, * ) '-O(OTAP)    . OUTPUT DATASET NAME'
         WRITE( LTRM, * ) '-G(grpint)  . INPUT GROUP INTERVAL'
         WRITE( LTRM, * ) '-C(INPUT)   . OPTIONAL CARD FILE'
         WRITE( LTRM, * ) '-V          . VERBOSE PRINTOUT'
         WRITE( LTRM, * ) 'USAGE:'
         WRITE( LTRM, * ) 'SLNT -N() -O() -G() -V'
         WRITE( LTRM, * ) '          OR'
         WRITE( LTRM, * ) 'SLNT -N() -O() -G() -C() -V'
         STOP
      ENDIF
C
      CALL ARGSTR( '-N', NTAP,  ' ', ' ')
      CALL ARGSTR( '-O', OTAP,  ' ', ' ')
      CALL ARGSTR( '-C', INPUT, ' ', ' ')
      CALL ARGR4 ( '-G', grpint,0.0,0.0 )

      VERBOS = ( ARGIS( '-V' ) .GT. 0 )
C
C     MAKE THE NTAP A PIPE
C
      IF( NTAP .EQ. ' ') IPIPI = 1
C
C     MAKE THE OTAP A PIPE
C
      IF( OTAP .EQ. ' ') IPIPO = 1
      RETURN
      END
