C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
      parameter   (NAMELEN=7)
#include "prog.h"
 
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhdr, bigar4
      real        bigar1, bigar2, bigar3, vel, slow, tempar
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkadr3, bigar3(1))
      pointer     (wkadr4, bigar4(1))
      pointer     (pvel,   vel(1))
      pointer     (pslow,  slow(1))
      pointer     (ptemp,  tempar(1))

      parameter   (NPAD=4)

      data name/'SLOW2VEL'/, version /' 1.0'/ 

      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query )then
            call help()
            stop 0
      endif
      if ( hlp ) then
           call help()
           stop 0
      endif

#include <f77/mbsopen.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             vmin,vmax,verbos,rev)
 
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call getln(luin , ntap,'r', 0)
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write (lerr,*)'no header read from unit',luin
         stop 100
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)

      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)

      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, NAMELEN, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
      heap3 = .true.
      heap4 = .true.
      heaps = .true.
      heapv = .true.
      heapt = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      itemi = ntrc * ITRWRD * SZSMPD
      item1 = ntrc * nsamp  * SZSMPD
      item2 = ntrc * nsamp  * SZSMPD
      item3 = ntrc * NPAD * SZSMPD
      item4 = ntrc * SZSMPD
      items = ntrc * SZSMPD
      itemv = ntrc * SZSMPD
      itemt = ntrc * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadri, itemi, errcdi, aborti)
      call galloc (wkadr1, item1, errcd1, abort1)
      call galloc (wkadr2, item2, errcd2, abort2)
      call galloc (wkadr3, item3, errcd3, abort3)
      call galloc (wkadr4, item4, errcd4, abort4)
      call galloc (pslow, items, errcds, aborts)
      call galloc (pvel, itemv, errcdv, abortv)
      call galloc (ptemp, itemt, errcdt, abortt)
 
      if (errcdi .ne. 0.) heapi = .false.
      if (errcd1 .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
      if (errcd3 .ne. 0.) heap3 = .false.
      if (errcd4 .ne. 0.) heap4 = .false.
      if (errcds .ne. 0.) heaps = .false.
      if (errcdv .ne. 0.) heapv = .false.
      if (errcdt .ne. 0.) heapt = .false.
 
      if (.not.heap1 .or. .not.heap2 .or. .not.heap3.or.
     &    .not.heapv .or. .not.heapt .or.
     &    .not.heapi .or. .not.heap4 .or. .not.heaps) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*) item4,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) itemv,'  bytes'
         write(LERR,*) itemt,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item3,'  bytes'
         write(LERR,*) item4,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) itemv,'  bytes'
         write(LERR,*) itemt,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call getln(luout, otap,'w', 1)
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vmin,vmax,ntap,otap)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            ic = 0
            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
 
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc , TRACEHEADER)
                  call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

       if (verbos)
     1 write(LERR,*)'recnum,trcnum,srcloc,recind,dphind,dstsgn,stacor= '
     2,recnum,trcnum,srcloc,recind,dphind,dstsgn,stacor

c------

               IF (.not. rev) THEN
c------
c  for the forward test we store large floats in the
c  predefined areas of the header

                  real1 = 1000.   * float( srcloc )
                  real2 = 100000. * float( trcnum )

                  call putfp2(lhed,ifmt_TVPT20,l_TVPT20, ln_TVPT20,
     1                        real1  , TRACEHEADER)
                  call putfp2(lhed,ifmt_TVPT21,l_TVPT21, ln_TVPT21,
     1                        real2  , TRACEHEADER)

               ELSE
c------
c  for the reverse test we get 2 large floats

                  call getfp2(lhed,ifmt_TVPT20,l_TVPT20, ln_TVPT20,
     1                        real1  , TRACEHEADER)
                  call getfp2(lhed,ifmt_TVPT21,l_TVPT21, ln_TVPT21,
     1                        real2  , TRACEHEADER)
                  write(LERR,*)'Real 1/2= ',real1,real2

               ENDIF


                  if (stacor .eq. 30000) then
                     call vclr (tri,1,nsamp)
                  endif
 
c----------------------
c  pack data into array
                  ic = ic + 1
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * ITRWRD
                  call vmov (tri,1, bigar1(istrc+1),1, nsamp)
                  call vmov (lhed,1, itrhdr(ishdr+1),1,ITRWRD)
 
1001        continue
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
c-----------------------
c  here's the meat...
c  do something to data
 
            call subs (jtr, nsamp, bigar1, bigar2, bigar3, bigar4,
     &                 NPAD, vmin, vmax,
     &                 vel, slow, tempar)
 
c  (USER: insert your subroutine above)
c-----------------------
 
c---------------------
c  extract traces from
c  output array and
c  write output data
            do 1002 kk = 1, jtr
 
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (bigar1(istrc+1),1,lhed(ITHWP1),1, nsamp)
                  call vmov (itrhdr(ishdr+1),1,lhed,1,ITRWRD)
                  call wrtape (luout, itr, obytes)
 
 
 1002             continue
 
 
 1000       continue
 
  999 continue
 
c-----
c     close data files
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of slow2vel, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'slow2vel transforms slowness spectra to velocity spectra:'
        write(LER,*)
     :'see manual pages by typing man slow2vel (or mman, tman, '
        write(LER,*)' uman slow2vel)'
        write(LER,*)
     :'see more cryptic online help by typing slow2vel '
        write(LER,*)' -h or slow2vel "-?" '
        write(LER,*)
     :'see pattern file by typing catpat slow2vel'
        write(LER,*)
     :'build an executable script by typing '
        write(LER,*) ' catpat slow2vel > slow2vel.job'
        write(LER,*)
     :'execute slow2vel by typing slow2vel and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -vmin[vmin] (no default) :  minimum velocity (ft,m/s)'
        write(LER,*) ' '
        write(LER,*)
     :' -vmax[vmax] (no default) :  maximum velocity (ft,m/s)'
        write(LER,*) ' '
        write(LER,*)
     :' -R  include on command line to reverse operation'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   slow2vel -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] -v[vel] [-R -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  vmin,vmax,verbos,rev)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vmin- R*4      minimum velocity
c     vmax- R*4      maximum velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire
      real        vmin, vmax
      logical     verbos, rev
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program slow2vel might be invoked in the following way:
 
c     slow2vel  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into slow2vel and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4 ( '-vmin', vmin, 999999., 999999. )
            call argr4 ( '-vmax', vmax, 999999., 999999. )
            rev    =   (argis('-R') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vmin,vmax,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vmin- R*4     design velocity
c     vmax- R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' minimum velocity =  ', vmin
            write(LERR,*) ' maximum velocity =  ', vmax
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
