C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  SNS sums all angles at a station and scales it,       
C      It also sorts by station and secondarily each angle
C      for ASS plot displays.
C
C          Rick Cook      1-15-90
C
C      REVISED:  MARY ANN THORNTON    SEPTEMBER 9, 1991
C      Moved code to the Sun for maintenance/distribution there
C
C      REVISED:  DAVID NELSON         DECEMBER 27, 1991
C      1. Added mixing option -MIX as per Marty Albertin
C      2. Limit to 4096 samples per trace in or out
C      3. Max records and traces are dynamic
C
C      REVISED:  MARY ANN THORNTON    V: 2.2   March 24, 1992
C      Call openpr with ppname and recompile for OS 6.1        
C      Remove savew inside trace loops
C      Remove all references to word size to run on 32 bit machine
C
C      REVISED:  GARY MURPHY          V: 2.3   April 7, 1992
C      Add a new command line argument which will allow user
C      to specify how to number the output records - they can
C      be one record with many traces as in the past, or they
C      can be many records with one trace each
C      Changed calls to hpalloc to galloc
C
C      Revised:  Gary Murphy         V:2.4     August 25, 1992
C      Add option to renumber the stack seperately from the
C      sort panels.
C
C      Revised:  Gary Murphy         V:2.5     November 11, 1992
C      Made on-line help match pattern file.
C
C      Revised:  Gary Murphy         V:2.6     January 22, 1993
C      Changed maximum number of output samples and fixed mix/
C      renumbering bug.
C
C      Revised:  Gary Murphy         V:2.7     June 22, 1993
C      Fixed bug in rs option.
C      Added the include file for the HP logical unit  / M.A.Thornton
C      Revised:  Dan Whitmore        V:2.8     November 1, 1993
C      changed wrtape call to write the correct number of bytes
C
C      Revised:  Mary Ann Thornton   V:2.9     January 11, 1996
C      changed the default from "number of records" to 1, No Skipping
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

       parameter (lprt=26, llist=27)
       parameter (MAXSMP=4096)
       parameter (LENTRC=MAXSMP+ITRWRD)

       real stak(1), buffer(1)
       pointer (pstak, stak), (pbuffer, buffer)

       real trc(LENTRC), trcd(MAXSMP), xmult, alpha, expnt
       real scal(MAXSMP), acon, temp
       integer i, j, k, m, n, nrec, ntrc, nsamp, skip, msamp
       integer nnrec, nntrc, nmsamp
       integer lnhd(3000), nbytes, ltem
       integer*2 trchd(LNTRHD)
       integer left, si, jerr, mix, verbos, argis, dalu
       integer stdout, solu, stlu, luin, len, nlin
       integer lid, offset(2)
       character*128 ntap, sotap, sttap
       character*1 parr(66), name(35)
       character*4 version
       character*3 ppname
       logical help


       equivalence( trc(1), trchd(1) )
       equivalence( trc(ITHWP1), trcd(1) )

       data parr/6*' ','S','N','S',' ',
     1' ','S','U','M','M','E','R',' ','A','N','D',' ',
     2'S','O','R','T','E','R',' ',37*' '/

       data name/'S','N','S',' ','(','S','C','A','L','A','R','S',' ',
     1'=',20*' ',')'/

       data version/' 2.9'/
       data ppname/'SNS'/
       data jabort/0/

       stdout = LER
       dalu = 13
       n = 1
       m = 0
       verbos = -1
       mix = -1

C Print help if asked to

       help  = (argis( '-h' ).gt.0) .or. (argis( '-?').gt.0)
       if (help) then
           write(stdout,*)'COMMAND LINE ARGUMENTS FOR SNS'
           write(stdout,*)' '
           write(stdout,*)'INPUT'
           write(stdout,*)'-N[ntap]          .. INPUT DATASET NAME'
           write(stdout,*)'-SORT[sotap]      .. SORTED OUTPUT '
           write(stdout,*)'-STAK[sttap]      .. STACKED AND SCALED'
           write(stdout,*)'                     OUTPUT '
           write(stdout,*)'-MAXSAMP[maxsamp] .. WILL OVERRIDE THE' 
           write(stdout,*)'                     NUMBER OF SAMPLES'
           write(stdout,*)'                     IN THE INPUT DATA'
           write(stdout,*)'                     AND PAD OUTPUTS TO'
           write(stdout,*)'                     THIS NUMBER'
           write(stdout,*)'                     (optional)'
           write(stdout,*)'-I[skip]          .. TRACE SKIPPING'
           write(stdout,*)'                     INCREMENT'
           write(stdout,*)'                       (default is 1)'
           write(stdout,*)'-MIX[mix]         .. MIX [mix] SORTED'
           write(stdout,*)'                     TRACES'          
           write(stdout,*)'                     MUST BE LESS THAN'
           write(stdout,*)'                     OR EQUAL TO -I[skip]'
           write(stdout,*)'                     AFTER ITS ROUNDED UP TO'
           write(stdout,*)'                     NEAREST ODD INTEGER'
           write(stdout,*)'-A[alpha]         .. TIME EXPONENT'
           write(stdout,*)'                       (default is .5)'
           write(stdout,*)'-X[XMULT]         .. CONSTANT MULTIPLIER'
           write(stdout,*)'                       (default is 1.)'
           write(stdout,*)'-E[expnt]         .. EXPONENT FOR POWER'
           write(stdout,*)'                     OF 10'
           write(stdout,*)'                       (default is 0)'
           write(stdout,*)'-R                .. RENUMBERING'
           write(stdout,*)'                       (0 : one record)'
           write(stdout,*)'                       (1 : rec = in trc)'
           write(stdout,*)'                       (default is 0)'
           write(stdout,*)'-rs               .. RENUMBER STACK'
           write(stdout,*)'                       (0 : one record)'
           write(stdout,*)'                       (1 : rec = in trc)'
           write(stdout,*)'                       (default is -R)'
           write(stdout,*)'[-V]              .. VERBOS PRINTOUT'
           write(stdout,*)' '
           write(stdout,*)'USAGE:'
           write(stdout,*)'sns -N[] -SORT[] -STAK[] -MAXSAMP[] -I[] ',
     &                        '-MIX[] -A[] -X[] -E[] -R[] -rs[] [-V]'
           write(stdout,*)' '
           write(stdout,*)' '
           write(stdout,*)' '
           stop
        endif

C Get command line arguments

       call argstr('-N', ntap, ' ', ' ')
       call argstr('-SORT', sotap, ' ', ' ')
       call argstr('-STAK', sttap, ' ', ' ')
       call argi4 ('-MAXSAMP', msamp, -1, 0)
       call argi4 ('-I', skip, 1, 1)
       call argi4 ('-MIX', mix, 0, 0)
       call argr4 ('-A', alpha, 0.5, 0.5)
       call argr4 ('-X', xmult, 1.0, 1.0)
       call argr4 ('-E', expnt, 0.0, 0.0)
       call argi4 ('-R', number, 0, 0)
       call argi4 ('-rs', numbst, 0, -1)
       verbos = argis( '-V' )
       if (numbst .eq. -1) numbst = number

C Check to see if mix is less than skip, round up to odd integer

       if (skip.gt.0 .and. mix.gt.0 .and. skip.lt.mix) then
           write(stdout,*)'-I[skip] < -MIX[mix]'
           stop
       endif

       if (mix.gt.1) then
            mix=mix/2*2+1
            ihmix=mix/2
       endif

C Check to see if input is piped

       if (ntap.eq.' ') then
           luin = 0                   
       else
           call lbopen(luin, ntap, 'r')
       endif

C Check to see if the -MAXSAMP flag was present

       if (msamp.eq.-1) then
           write(stdout,*)'MAXSAMP was not given a value'
           call lbclos(luin)
           stop
       endif

C Check to see if output files were specified

       if (sotap.eq.' ') then
           write(stdout,*)'no sorted output file specified, exiting.'
           call lbclos(luin)
           stop
       elseif (sttap.eq.' ') then
           write(stdout,*)'no summed output file specified, exiting.'
           call lbclos(luin)
           stop
       else
           call lbopen(solu, sotap, 'w')
           call lbopen(stlu, sttap, 'w')
       endif

C Open the printout file

       call openpr(llist, lprt, ppname, jerr)
       if (jerr.ne.0) then
           write(stdout, *) 'Error opening printout'
           write(lprt, *) 'Error opening printout'
           stop 200
       endif
#include <mbsdate.h>
       nlin = 1
       call gamoco(parr, nlin, lprt)
       write(lprt,5) ntap
    5  format('  INPUT DATA = ',/,a128,/)
       write(lprt,6) sotap
    6  format('  SORTED OUTPUT =',/,a128,/)
       write(lprt, 9) sttap
    9  format('  SUMMED OUTPUT = ',/,a128,/)
c
c Find an available unit number for the variable lid.
c Stop if no available unit number can be found.
c
      lid = 0
      i   = 98
 17   if ( i .le. 7 ) then
         write(stdout,*)'Too many open files, stop program.'
         stop
      endif
      inquire( unit=i, opened=help )
      if ( .not. help ) then
         lid = i
	 goto 18
      endif
      i = i - 1
      goto 17
 18   continue

C Read in line header and get important values

       nbytes = 0
       call rtape(luin, lnhd, nbytes)
       if (nbytes.eq.0) then
           write(stdout,*)'could not read input line header, exiting.'
           write(lprt,7)
   7       format(1x,'BAD READ ON INPUT LINEHEADER',/,1x,'  END OF JOB')
           goto 1000
       endif
       call saver(lnhd, 'NumRec', nrec, LINHED)
       call saver(lnhd, 'NumTrc', ntrc, LINHED)
       call saver(lnhd, 'NumSmp', nsamp, LINHED)
       call saver(lnhd, 'SmpInt', si, LINHED)

C Check to make sure msamp is >= nsamp 
C if msamp was given of command line

       if (msamp.gt.0) then
           if (nsamp.gt.msamp) then
               write(stdout,*)'sns error: number of samples on ',
     :                        'input greater ',
     :                        'than number of requested output samples.'
               call lbclos(luin)
               call lbclos(solu)
               call lbclos(stlu)
               stop
           endif
       endif
       len = 35
       call hlhprt(lnhd, nbytes, name, len, lprt)

C Change line header to show changes for the summed output

       if (numbst .eq. 0) then
          call savew(lnhd, 'NumRec', 1, LINHED)
       else
          call savew(lnhd, 'NumRec', ntrc, LINHED)
          call savew(lnhd, 'NumTrc', 1, LINHED)
       endif
       if (msamp.gt.0) then
           call savew(lnhd, 'NumSmp', msamp, LINHED)
       endif
       call wrtape(stlu, lnhd, nbytes)
       if (verbos.gt.0) then
           write(lprt,*)'summed output data'
           if (numbst .eq. 0) then
              write(lprt,*)'# rec = ', 1
              write(lprt,*)'# trc = ', ntrc
           else
              write(lprt,*)'# rec = ', ntrc
              write(lprt,*)'# trc = ', 1
           endif
           if (msamp.gt.0) then
               write(lprt,*)'# samp = ', msamp
           else
               write(lprt,*)'# samp = ', nsamp
           endif
           write(lprt,*)'samp interval = ', si
           write(lprt,*)'    '
           write(lprt,*)'renumbering option = ', number
           write(lprt,*)'renumbering stack option = ', numbst
       endif

C Change line header to show changes for the sorted output
C   If no skipping increment was given, default is 1 (no skipping)
C   use the input number of records so the output sort and stack are the
C   same size.

       ltem = ntrc + skip - 1
       nnrec = ltem/skip

C Changed NumRec to 1 because Dan wanted it that way on 1-24-90
C Changed NumTrc to nnrec*nntrc instead of to nntrc, 2-7-90
C Allow record/trace numbering as user requests    4/92     

       left = iabs((nnrec*skip) - ltem)
       nntrc = nrec
       if (number .eq. 0) then
          call savew(lnhd, 'NumRec', 1, LINHED)
          call savew(lnhd, 'NumTrc', nnrec*nntrc, LINHED)
       else
          call savew(lnhd, 'NumRec', nnrec, LINHED)
          call savew(lnhd, 'NumTrc', nntrc, LINHED)
       endif


       if (msamp.gt.0) then
           call savew(lnhd, 'NumSmp', msamp, LINHED)
       endif
       call wrtape(solu, lnhd, nbytes)
       if (verbos.gt.0) then
           write(lprt,*)'sorted output data'
           if (number .eq. 0) then
              write(lprt,*)'# rec = ', 1   
              write(lprt,*)'# trc = ', nnrec*nntrc   
           else
              write(lprt,*)'# rec = ', nnrec
              write(lprt,*)'# trc = ', nntrc
           endif
           if (msamp.gt.0) then
               write(lprt,*)'# samp = ', msamp
           else
               write(lprt,*)'# samp = ', nsamp
           endif
           write(lprt,*)'samp interval = ', si
           write(lprt,*)'trc ignored at end of each input rec = ',left
           write(lprt,*)'mixing ',mix,' traces'
           write(lprt,*)'    '
       endif

C Build vector for scaling

c      dt = float(si)/1000.0
c      acon = xmult * dt ** (-alpha)
       acon = xmult ** (-alpha)
       do 20 k = 1,nsamp,1
c          temp = acon*((k * dt) ** alpha) 
           temp = acon*(k ** alpha) 
           scal(k) = temp * (10.0 ** expnt)
   20  continue   

C
C  The maximum amount of memory needed is computed.  The variable nmsamp
C  is set to an odd number to prevent memory bank conflicts.
C
       nmsamp = max0( nsamp, msamp ) + ITRWRD
       nmsamp = nmsamp + mod( nmsamp+1, 2 )

       call galloc( pstak, nmsamp*ntrc*iszbyt, jerr, jabort )
       if ( jerr .ne. 0 ) then
            write(stdout,*)'Stak buffer problem'
            write(stdout,*)'Error allocating memory: ', jerr
 	    stop
       endif

C Clear the vector that will contain the summed section
C    I didn't think that I would have to do this as I
C    expected that fortran arrays were cleared upon
C    execution of the program but I found that this
C    was not the case.

       do 30 i=1,ntrc,1
           call vclr( stak( (i-1)*nmsamp+1 ), 1, nmsamp )
  30   continue

C Start looping to read in input data and process it as we go

       do 100 i=1,nrec,1
           m = 0
           do 80 j=1,ntrc,1

C Read in trace

               nbytes = 0
               call rtape(luin, trc, nbytes)
               if (nbytes.eq.0) then
                   write(stdout,*)'error reading trc ',j
                   write(stdout,*)'   of rec ',i,'   exiting'
                   goto 1000
               endif

               if (i.eq.1.and.j.eq.1) then
		  inbuf  = nbytes/ISZBYT + mod( (nbytes/ISZBYT)+1, 2 )
                  if (mix.gt.1) then
c                     add extra in case center of last mix not
c                     included in the output number of records
		      lbuffer= (nnrec+1)*nntrc*inbuf
                  else
		      lbuffer= nnrec*nntrc*inbuf
                  endif
		  call galloc( pbuffer, lbuffer*iszbyt, jerr, jabort )
                  if ( jerr .ne. 0 ) then
                       write(stdout,*)'Sort buffer problem'
                       write(stdout,*)'Error allocating memory: ', jerr
               	       stop
                  endif
               endif

C Stak the data if it's not a dead trace
                 
CCCCCCCCCC     call saver(trchd, 'StaCor',istat, TRCHED)
               if (trchd(125).ne.30000) then
		  index = (j-1)*nmsamp + ITHWP1
 		  call vadd(trcd,1,stak(index),1,stak(index),1,nsamp)
               endif

C Use last input trace headers for the summed output

               if (i.eq.nrec) then
CCCCCCCCC          call savew(trchd, 'RecNum', 1, TRCHED)
                   if (numbst .eq. 0) then
                      trchd(106) = 1
                   else
                      trchd(106) = trchd(107)
                      trchd(107) = 1
                   endif
                   call vmov(trchd,1,stak((j-1)*nmsamp+1),1,ITRWRD)
               endif

C I changed the TrcNum and RecNum for reasons mentioned above

               if (mix.gt.1) then
                   ifirst=m*skip-ihmix+1
                   if (j.eq.1) ifirst=1
                   ilast=m*skip+ihmix+1
                   if (ilast.gt.ntrc) ilast=ntrc
                   if (j.eq.ifirst) then
c                      first trace in the mix
                       imixdiv=0
                       itrhd=0
                       offset(1) = i + (m*nntrc)
                       index = (offset(1) - 1)*inbuf + 1
c                      either move thead+trace to mix buffer or clear
                       if (trchd(125).ne.30000) then
                           ione=1
                           call vmov(trc,ione,buffer(index),ione,
     &                               nbytes/ISZBYT)
                           itrhd=1
                           imixdiv=imixdiv+1
                       else
                           call vclr(buffer(index),1,nbytes/ISZBYT)
                       endif
                   else if (j.eq.ilast) then
c                      last trace in the mix
                       offset(1) = i + (m*nntrc)
                       index = (offset(1) - 1)*inbuf + ITHWP1
                       if (trchd(125).ne.30000) then
         	           call vadd(trcd,1,buffer(index),1,
     &                                      buffer(index),1,nsamp)
                           imixdiv=imixdiv+1
                       endif
c                      apply mix divisor
                       if (imixdiv.gt.0) then
                           call vsdiv(buffer(index),1,float(imixdiv),
     &                               buffer(index),1,nsamp)
                       endif
                       m = m+1
                   else if (j.gt.ifirst. and. j.lt.ilast. and.
     &                                        trchd(125).ne.30000) then
c                      middle of mix so vertically stak trace 
                       offset(1) = i + (m*nntrc)
                       index = (offset(1) - 1)*inbuf + ITHWP1
         	       call vadd(trcd,1,buffer(index),1,
     &                                  buffer(index),1,nsamp)
                       imixdiv=imixdiv+1
c                      move first live trace header to mix buffer
c                      for case where first trace in mix was dead
                       if (itrhd.eq.0) then
                           call vmov(trchd,1,
     &                               buffer(index-ITRWRD),1,ITRWRD)
                           itrhd=1
                       endif
                   endif
               else if (MOD(j-1, skip).eq.0) then
                   offset(1) = i + (m*nntrc)
                   index = (offset(1) - 1)*inbuf + 1
                   call vmov( trc, 1, buffer(index), 1, nbytes/ISZBYT)
                   m = m+1
               endif
   80      continue
  100  continue


C Now scale the summed output data and write it out

       do 120 i=1,ntrc,1
	   index = (i-1)*nmsamp+ITHWP1
           call vmul( stak(index), 1, scal, 1, stak(index), 1, nsamp)
           index = index - ITRWRD
           if (msamp.gt.0) then
cdan10/29/93   call wrtape( stlu, stak(index), ISZBYT*nmsamp )
               call wrtape( stlu, stak(index), ISZBYT*(msamp+ITRWRD) )
           else
               call wrtape( stlu, stak(index), nbytes)
           endif
  120  continue

C     write it out with wrtape to a sorted sis file

 
       mixh = mix/2
       do 160 i=1,nnrec,1
           do 140 j=1,nntrc,1
               offset(1) = j + (nntrc*(i-1))
               index = (offset(1) - 1)*inbuf + 1
	       call vmov( buffer(index), 1, trc, 1, nbytes/ISZBYT )
               if (number .eq. 0) then
                  trchd(107) = j + nntrc*(i-1)
                  trchd(106) = 1
CCCCCCCC          call savew(trchd, 'TrcNum', j + nntrc*(i-1), TRCHED)
CCCCCCCC          call savew(trchd, 'RecNum', 1, TRCHED)
               else
                  if (j .ne. nntrc) then
                     trchd(106) = trchd(107)
                     if (i .ne. 1) trchd(106) = trchd(106) + mixh
                     lastrc = trchd(106)
                  else
                     trchd(106) = lastrc
                  endif
                  trchd(107) = j
               endif
               if (msamp.gt.0) then
		   do 130 k=ITHWP1+nsamp, msamp, 1
			trc(k) = 0.0
  130		   continue
                   call wrtape(solu, trc, ISZBYT*(ITRWRD+msamp))
               else
                   call wrtape(solu, trc, nbytes)
               endif
  140      continue
  160  continue

               
C Close files and exit

 1000  write(lprt, 1010)
 1010  format(1x,'  END OF JOB')
       call lbclos(luin)
       call lbclos(solu)
       call lbclos(stlu)
       goto 5000

 1500  write(stdout, 1510)
 1510  format(1x, 'could not open DA file')
       goto 1000

 2000  write(stdout, 2010)
 2010  format(1x,'  could not reopen DA file')
       goto 1000

 5000  end
