C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stoltmg (rdata,nt,nx,onea,vdtodx,ntr,nsamp,
     1		          cdata,kx,work,first,
     2                    tabl1, tabl2, zz, iz, isflg)
************************************************************************
*
*	stlmigsbs -- simple Stolt migration (2-d fft version, no cosine)
*
*	PURPOSE -- same
*
*	TECHNICAL REF -- Jon Claerbout 
*			 Imaging the Earth's Interior, pp.30-33
*
*	NOTE: Const. velocity only
*
*
*   Definition of Variables - Complex
*
*	CDATA(,) =  complex input data
*      RESULT(,) =  complex result
*
*   Definition of Variables - Real
*
*      RDATA(,)	=   real part of input data
*	DK	=   wavenumber increment
*	DT	=   time sample rate of input data 
*	DTAU	=   'time' sample rate of output data 
*	DW	=   frequency increment
*	DX	=   trace spacing 
*      IDATA(,) =   imaginary part of input data (zero)
*	KTAU	=   modified kz wavenumber
*	KX()	=   wavenumber array
*	ONE	=   1.0
*	PI	=   pi 
*	TWO	=   2.0
*	TWOPI	=   2.0*pi
*	V	=   seismic velocity (constant)
*	VKX	=   v*kx
*	VKXOW	=   v*kx/w         [w=freq]
*	VKXOW2	=   vkxow*vkxow
*	W()	=   frequency array
*	ZERO	=   0.0
*
*   Definition of Variables - Integer 
*
*	IKX	=   wavenumber counter
*	ITAU	=   tau counter 
*	IW	=   frequency counter
*	IX	=   trace counter
*	NT	=   time samples on input data
*	NTAU	=   'time' samples on output data
*	NTNYQ	=   nyquist freq index
*	NX	=   traces on input data
*	NXNYQ	=   nyquist wavenumber index
*
************************************************************************
#include <f77/lhdrsz.h>

      	integer	ikx,	it,    iktau,	iom,
     : 		nxnyq,	nt,	nth,	ntnyq, iz(*)

      	real 	dk,	wh,	vkx2,	wl,
     :		     	kx(nx), one,	
     :		pi,	rdata(nsamp,ntr),	two,	twopi,
     :		vkx,	zero, tabl1(*), tabl2(*), zz(*)

      	complex	cdata(nt,nx)
        complex work(nt+1)
        real    tmp(SZLNHD)
        logical first
      	parameter (pi=3.14159265)

c 	.. constants

      	zero = 0.0
      	one = 1.0
      	two = 2.0
      	twopi = 2*pi
        pionth = twopi/float(nt)
        ntt = nt
        nth = ntt/2
        nx2 = nx/2
        czero = cmplx(0.,0.)
        fnt = ntt
        fnx = nx
      	ntnyq = ntt/2
      	nxnyq = nx/2
        rntnx = 1./float(ntt*nx)

c  	.. Fourier transform:  (t,x) --> (w,k)

         do  1  j = 1, ntr
            do  2  i = 1, nsamp

                cdata(i,j) = cmplx( rdata(i,j), 0.0 )

2           continue
1       continue

#ifdef CRAYSYSTEM
        call ft2d(ntt,nx,cdata,1.,-1.,sqrt(1./fnt),sqrt(1./fnx),work)
#else
        call cfft2d ( cdata, ntt, nx, 1)
#endif


        do  10  j = 1, nx

                call cvsmul (cdata(1,j), 2, rntnx, cdata(1,j), 2, ntt)

10      continue

c-------------------------------------------------------
      IF (first) THEN

          isflg = 1
      ELSE
          isflg = 0

      ENDIF

c 	.. Initialize wavenumber, kx, array
c	.. Positive/Negative wavenumbers

          dk= (vdtodx*twopi)/float(nx)
          do 11 ikx = 1, nx
              vkx = float(ikx-1)*dk
              if (ikx .gt. nx/2) vkx = twopi*vdtodx - vkx
              kx(ikx) = vkx * vkx
 11       continue

c-------------------------------------------------------
c  	.. Transformation:  (w,k) --> (Kz,k)
c  	.. Stolt interpolation from w-axis to Kz-axis

      DO  21  ikx = 1, nx

          vkx2 = kx(ikx)

          work(1) = czero
          work(ntt+1) = czero

          do  22  iom = 1, ntt
                  work(iom) = cdata(iom,ikx)
22        continue

          cdata(1,ikx) = czero

          do  23  iktau = 2, nth+1

              aktau = .5 * pionth * (float(iktau) - onea)
              om = sqrt(aktau*aktau + vkx2)
              iom = 1 + om/pionth

              if (iom .lt. nth .or. ikx .lt. nx2) then
                 wl = float(iom) - om/pionth
                 wh = 1. - wl
                 cdata(iktau,ikx) = wl*work(iom) + wh*work(iom+1)
                 cdata(ntt-iktau+2,ikx) = wl*work(ntt-iom+2) + 
     1                                   wh*work(ntt-iom+1)
              else
                 cdata(iktau,ikx) = czero
              endif

23       continue

21    CONTINUE

c  	.. Fourier tranform:  (Kz,k) --> (tau,x)

#ifdef CRAYSYSTEM
        call ft2d(ntt,nx,cdata,-1.,1.,sqrt(1./fnt),sqrt(1./fnx),work)
#else
        do  ix = 1, nx
            do  it = nt/2+1, nt
c               cdata (it,ix) = 0.0
            enddo
        enddo

        call cfft2d ( cdata, ntt, nx,-1)
#endif

c  	.. migrated data is real part of complex result 


        do 30 ix=1,ntr
                do 40 it=1,nth
                      tmp(it) = real(cdata(it,ix))
c                     rdata(it,ix) = real(cdata(it,ix))
 40              continue
                call fcuint (tabl1, tmp, nth, tabl2, rdata(1,ix),
     1                       nsamp, iz, zz, isflg)
 30     continue

        isflg = 0

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
