C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SWATH                                                *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:       PROGRAM SWATH BUILDS A PSUEDO V(X,Z) MIGRATED        *
C                 DATASET FROM SEVERAL V(Z) MIGRATED SECTIONS.         *
C                 EACH SECTION IS CONVERTED TO TIME AND SPLICED        *
C                 TOGETHER.                                            *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:    GARY MURPHY                     ORIGIN DATE:  90/03/01   *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/01  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin          -                                               *
C      LBOPEN          -                                               *
C      OPENPR          -                                               *
C      GAMOCO          -                                               *
C      ICOPEN  INTEGER -                                               *
C      RTAPE           -                                               *
C      HLHPRT          -                                               *
C      WRTAPE          -                                               *
C      VCLR            -                                               *
C      VMOV            -                                               *
C      VMUL            -                                               *
C      LBCLOS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:                                                              *
C      LCRD  ( INPUT  SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      200      ( 1) -  OPEN PRINT FILE ERROR                          *
C      =BLANK=  ( 1) -  NO ERRORS                                      *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  GARY MURPHY                   REVISION DATE: 90/03/01  *
C            - INITIAL RELEASE                                         *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/09/05  *
C            - Move code to sun for distribution/maintenance           *
C  REVISED BY: DAVID W.NELSON    V2.2         DATE: 92/01/07           *
C            - Changed NVMAX from 375 to 1000 to match pwmvzn          *
C            - Use NINT in computation of LTR and NSI                  *
C            - Changed CCUINT to FCUINT                                *
C  REVISED BY:  MARY ANN THORNTON    V: 2.3   REVISION DATE: 92/03/04  *
C            - Added change by Gary Murphy - when ivel not  .gt. 1     *
C            -                               check for zero depths     *
C  REVISED BY:  MARY ANN THORNTON   V: 2.4    REVISION DATE: 92/03/04  *
C            - Call openpr with full program name for OS 6.1           *
C  REVISED BY:  MARY ANN THORNTON   V: 2.5    REVISION DATE: 92/03/04  *
C            - Change topen to cmdlin for new sun compiler             *
c  revised by: gary murphy v2.6               date: 92/06/29           *
c            - fully implement verbos option                           *
c            - check for duplicate velocity functions                  *
c            - remove the include for mbsdate-stamp                    *
c  revised by: gary murphy v2.7               date: 92/08/20           *
c            - reference velocity to top of layer                      *
c  revised by: gary murphy v2.8               date: 92/09/08           *
c            - change maximum number of samples per trace from 2048 to *
c              8000                                                    *
c  revised by: gary murphy v2.9               data: 92/09/20           *
c            - allow total width to be off by one trace width          *
c            - removed include of HeaderSize.h  /Mary Ann Thornton     *
c  revised by: gary murphy v3.0               date: 92/10/04
c            - made swath tie vttd/vlmx for flat layer model.
c  revised by: gary murphy v3.1               date: 92/11/10
c            - fixed bug that reversed polarity of the trace located
c              at the first velocity function when there were more
c              than one velocity function.
c            - made help match pattern file and man page.
c  revised by: gary murphy v3.2               date: 93/06/07
c            - added dynamic memory
c  revised by: mary ann thronton v3.3         date: 93/06/07
c            - added logical unit for HP, then let ltrm = LER  /mat
c            - changed hpalloc to galloc and changed a format  /mat
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

      PARAMETER (LPRT=26, LCRD=25, LLIST=27)
      PARAMETER (MAXSMP=8000, MAXTRC=4000)
      PARAMETER (ITIM=1, ISUM=2)
      PARAMETER (NFMAX=75, NVMAX=1000)

      PARAMETER (MXWORD=MAXSMP+ITRWRD)
      PARAMETER (MAXBIN=MAXTRC*MAXSMP*ISUM)

      POINTER (PTR, BIN(1))
      POINTER (JPTR, JBIN(1))
 
c     DIMENSION BIN(MAXBIN)
c     DIMENSION JBIN(MAXBIN)

      DIMENSION TRACE(MAXSMP), X1(MAXSMP), X2(MAXSMP)
      dimension ihead(mxword)
      integer*2 jhead(LNTRHD)
      DIMENSION IHEADS(ITRWRD, MAXTRC)
      DIMENSION NV(NFMAX), IX(NFMAX), IBEGTR(NFMAX), IENDTR(NFMAX)
      DIMENSION VIN(NVMAX,NFMAX), DEP(NVMAX,NFMAX)
      DIMENSION IZ(MAXSMP), ZZ(MAXSMP*4)
      DIMENSION DIVSOR(MAXTRC)

      CHARACTER*128 NTAPA(NFMAX),NTAP,OTAP,INPUT,VCARD
      CHARACTER*66 CTITLE
      CHARACTER*35 CHLH
      CHARACTER*80 CARD
      CHARACTER*4 VERSION
      CHARACTER*5 PPNAME

      LOGICAL VERBOS

      EQUIVALENCE (IHEAD(ITHWP1), TRACE(1))
      equivalence (ihead(1), jhead(1))
c     EQUIVALENCE (BIN(1), JBIN(1))

      DATA CTITLE/'    CREATE PSUEDO V(X,Z) FROM SEVERAL V(Z) SWATHES
     &             '/
      DATA ICC, N /2*0/, LVCRD /28/
      DATA VERSION/' 3.3'/
      DATA PPNAME/'SWATH'/
C
C *** GET COMMAND LINE ARGUMENTS
C
      ltrm = LER
      CALL cmdlin(NTAP, OTAP, INPUT, IPIPI, IPIPO, LTRM, 
     &           VERBOS, VCARD, ENDTIM, PADTIM, BEGTIM, DTMS, DZ, 
     &           TDEPTH, DX, TWIDTH, NFUNC)
C
C *** LUIN IS AN INPUT DATASET
C
      IF(IPIPI.EQ.0)THEN
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE 
C
C *** WE KNOW LUIN IS A PIPE
C
         LUIN = 0
         LTRM = 2
      END IF
C
C *** LUOUT IS A OUTPUT DATASET
C
      IF(IPIPO.EQ.0)THEN
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE 
C
C *** LUOUT IS A PIPE
C
         LUOUT = 1
      ENDIF
C
C *** OPEN PRINT FILE
C
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF (JERR .NE. 0) THEN
         WRITE (LER, 10)
   10    FORMAT(/, 1X, '** M0010 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'UNABLE TO OPEN PRINT FILE'               ,/,
     &            45X, 'REMOVE ANY FILES NAMED SWATH IN YOUR '   ,/,
     &            45X, 'WORKING DIRECTORY, OR, MAKE MORE ROOM '  ,/,
     &            45X, 'ON YOUR DISK.'                           ,/)
         ICC = 100
      END IF
C include <mbsdate.h>
C
C *** MAKE TORCH AND OVAL
C
      NLIN = 1
      CALL GAMOCO (CTITLE, NLIN, LPRT)
C
C *** PRINT INPUT/OUTPUT DATASET INFO AFTER TORCH AND OVAL
C
      if (verbos)
     &WRITE (LPRT, 20) NTAP, OTAP
   20 FORMAT(' INPUT DATASET  = ',/,A128,/,
     &       ' OUTPUT DATASET = ',/,A128,/)
C
C *** READ INPUT SIS LINE HEADER
C
      IEOF = 0
      CALL RTAPE (LUIN, IHEAD, IEOF)
      IF (IEOF .EQ. 0) THEN
         WRITE (LPRT, 30)
   30    FORMAT(/, 1X, '** M0030 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'UNABLE TO OPEN SIS DATA SET.'            ,/,
     &            45X, 'MAKE SURE THAT YOU INPUT THE DATA '      ,/,
     &            45X, 'SET NAME CORRECTLY AND CHECK CASE.'      ,/)
         ICC = 100
      END IF
      CALL SAVER(IHEAD, 'NumTrc', NTRCS, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', NSAMPS, LINHED)
      CALL SAVER(IHEAD, 'Format', IFMT, LINHED)
C
C *** READ CARD DECK
C
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE (LPRT, 33) 
   33       FORMAT(/, 1X, '** M0033 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'UNABLE TO OPEN PARAMETER CARD'           ,/)
            ICC = 100
         ELSE
            N = 1
         ENDIF
      ELSE
         N = ICOPEN('-swath.crd',LCRD)
      ENDIF
      IF (N .NE. 0) THEN

         READ (LCRD, 34, END=8000) CARD
   34    FORMAT (A80)
         if (verbos)
     &   WRITE (LPRT, 35) CARD
   35    FORMAT (5X, A80)
         IF (CARD(1:4) .NE. 'TIME') THEN
            WRITE (LPRT, 36) CARD(1:4)
   36       FORMAT(/, 1X, '** M0036 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'EXPECTED TO READ A TIME CARD'            ,/,
     &               45X, 'FOUND A ', A4, ' INSTEAD.'               ,/)
            ICC = 100
         END IF

         READ (LCRD, 34, END=8000) CARD
         READ (CARD, 40) TENDTM, TPADTM, TBEGTM, TDTMS
   40    FORMAT (10X, 4F10.0)

         READ (LCRD, 34, END=8000) CARD
         if (verbos)
     &   WRITE (LPRT, 35) CARD
         IF (CARD(1:4) .NE. 'SIZE') THEN
            WRITE (LPRT, 55) CARD(1:4)
   55       FORMAT(/, 1X, '** M0055 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'EXPECTED TO READ A SIZE CARD'            ,/,
     &               45X, 'FOUND A ', A4, ' INSTEAD.'               ,/)
            ICC = 100
         END IF

         READ (LCRD, 34, END=8000) CARD
         READ (CARD, 60) TDZ, TDPTH, TDX, TWDTH, NFNC
   60    FORMAT (4F10.0, I7)
C
C *** NON-ZERO COMMAND LINE PARAMETERS OVERRIDE CARD PARAMETERS
C
         IF (BEGTIM .EQ.0.) BEGTIM = TBEGTM
         IF (ENDTIM .EQ.0.) ENDTIM = TENDTM 
         IF (PADTIM .EQ.0.) PADTIM = TPADTM 
         IF (DTMS   .EQ.0.) DTMS   = TDTMS   
         IF (DZ     .EQ.0.) DZ     = TDZ
         IF (TDEPTH .EQ.0.) TDEPTH = TDPTH
         IF (DX     .EQ.0.) DX     = TDX
         IF (TWIDTH .EQ.0.) TWIDTH = TWDTH
         IF (NFUNC  .EQ. 0) NFUNC  = NFNC

      END IF
C
C *** COMPUTE DEFAULT NUMBER OF OUTPUT SAMPLES
C
      IF (DTMS .LE. 0.) DTMS = ISI
C
C *** CHECK DEPTH SPACING
C
      IF (DZ .LE. 0.) THEN
         WRITE (LPRT, 220)  
  220    FORMAT(/, 1X, '** M0220 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'DELTA-Z PARAMETER '                        ,
     &                 'INVALID'                                 ,/,
     &            45X, 'CHECK CC  5-10 OF THE SIZE CARD.'        ,/)
         ICC = 100
      END IF
C 
C *** CHECK TOTAL DEPTH
C 
      IF (TDEPTH .LE. DZ) THEN
         WRITE (LPRT, 230)   
  230    FORMAT(/, 1X, '** M0230 ** ERROR DETECTED BY PROGRAM SWATH', 
     &             2X, 'TOTAL DEPTH MUST BE GREATER THAN '         , 
     &                 'DEPTH INTERVAL'                          ,/, 
     &            45X, 'CHECK CC 11-20 OF THE SIZE CARD.'        ,/) 
         ICC = 100 
      END IF 
C 
C *** CHECK TRACE SPACING 
C 
      IF (DX .LE. 0.) THEN
         WRITE (LPRT, 240)   
  240    FORMAT(/, 1X, '** M0240 ** ERROR DETECTED BY PROGRAM SWATH', 
     &             2X, 'DELTA-X PARAMETER '                        , 
     &                 'INVALID'                                 ,/, 
     &            45X, 'CHECK CC 21-30 OF THE SIZE CARD.'        ,/) 
         ICC = 100 
      END IF 
C  
C *** CHECK TOTAL WIDTH
C  
      IF (TWIDTH .LE. DX) THEN 
         WRITE (LPRT, 250)    
  250    FORMAT(/, 1X, '** M0250 ** ERROR DETECTED BY PROGRAM SWATH',  
     &             2X, 'TOTAL WIDTH MUST BE GREATER THAN '         ,  
     &                 'TRACE INTERVAL'                          ,/, 
     &            45X, 'CHECK CC 31-40 OF THE SIZE CARD.'        ,/) 
         ICC = 100  
      END IF
C   
C *** CHECK TOTAL NUMBER OF SAMPLES AND TRACES
C
      LTR = NINT(TWIDTH / DX)   
      NSI = NINT(TDEPTH / DZ)
      IF (LTR*NSI .GT. MAXTRC*MAXSMP) THEN
         WRITE (LPRT, 255)
  255    FORMAT(/, 1X, '** M0255 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'TOTAL WIDTH AND DEPTH EXCEEDS '            ,
     &                 'PROGRAM LIMITS.'                         ,/)
         ICC = 100
      END IF
      IF (LTR .LT. 3) THEN
         WRITE (LPRT, 257) 
  257    FORMAT(/, 1X, '** M0257 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'TOTAL NUMBER OF TRACES MUST EXCEED 2'   ,/)
         ICC = 100
      END IF
      IF (NSI .LT. 3 .OR. NSI .GT. MAXSMP) THEN
         WRITE (LPRT, 259) MAXSMP
  259    FORMAT(/, 1X, '** M0259 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'TOTAL NUMBER OF SAMPLES MUST EXCEED 2'   ,/,
     &            45X, 'AND BE LESS THAN', I9                    ,/)
         ICC = 100
      END IF
C   
C *** CHECK NUMBER OF FUNCTIONS 
C
      IF ((NFUNC .LE. 0) .OR. (NFUNC .GT. NFMAX)) THEN  
         WRITE (LPRT, 260)     
  260    FORMAT(/, 1X, '** M0260 ** ERROR DETECTED BY PROGRAM SWATH',   
     &             2X, 'THE NUMBER OF VELOCITY FUNCTIONS '         ,   
     &                 'IS INVALID '                             ,/,  
     &            45X, 'CHECK CC 41-47 OF THE SIZE CARD.'        ,/)  
         ICC = 100   
      END IF
C     
C *** WRITE PARAMETERS TO USER REPORT
C     
      if (verbos)
     &WRITE (LPRT, 270) ENDTIM, PADTIM, BEGTIM, DTMS,
     &                  DZ, TDEPTH, DX, TWIDTH, LTR, NSAMPS, NFUNC
  270 FORMAT (//, 30X, 'INPUT PARAMETERS AFTER DEFAULTS:'         ,
     &        //, 23X, '  END TIME (MS) . . . . . . . . .',2X,F7.2,
     &        //, 23X, '  PAD TIME (MS) . . . . . . . . .',   F9.2,
     &        //, 23X, '  START TIME (MS) . . . . . . . .',2X,F7.2,
     &        //, 23X, '  SAMPLE INTERVAL (MS). . . . . .',   F9.2,
     &        //, 23X, '  DELTA-Z . . . . . . . . . . . .',2X,F7.2,
     &        //, 23X, '  TOTAL DEPTH . . . . . . . . . .',   F9.2,
     &        //, 23X, '  DELTA-X . . . . . . . . . . . .',2X,F7.2,
     &        //, 23X, '  TOTAL WIDTH . . . . . . . . . .',   F9.2,
     &        //, 23X, '  TOTAL NUMBER OF OUTPUT TRACES .',     I9,
     &        //, 23X, '  TOTAL NUMBER OF INPUT SAMPLES .',     I9,
     &        //, 23X, '  NUMBER OF VELOCITY FUNCTIONS. .',4X,  I5)
C
C *** SWATH CARD AND INPUT DATASET NAMES AND STARTING TRACE NUMBERS
C
      DO 279 IFUNC = 1, NFUNC
         READ (LCRD, 34, END=8000) CARD
         if (verbos)
     &   WRITE (LPRT, 35) CARD
         IF (CARD(1:5) .NE. 'SWATH') THEN
            WRITE (LPRT, 273) CARD(1:5)
  273       FORMAT(/, 1X, '** M0273 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'EXPECTED TO READ A SWATH CARD'           ,/,
     &               45X, 'FOUND A ', A5, ' INSTEAD.'               ,/)
            ICC = 100
         ENDIF
         READ (CARD, 275) IBEGTR(IFUNC), IENDTR(IFUNC), 
     &                    NTAPA(IFUNC)(1:128)
  275    FORMAT (5X, I5, I10, 1X, A128)
         IF (IBEGTR(IFUNC) .GT. LTR) THEN
            WRITE (LPRT, 276) IBEGTR(IFUNC)
  276       FORMAT(/, 1X, '** M0276 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'BEGINNING TRACE NUMBER ON SWATH CARD'    ,/,
     &               45X, I9, 'EXCEEDS TOTAL WIDTH.'     ,/)
            ICC = 100
         END IF
         if (iendtr(ifunc) .eq. ltr+1) then
            ltr = iendtr(ifunc)
            twidth = dx * ltr
            write (lprt, 277) twidth, ltr
  277       format (/, 1x, '** m0277 ** warning from program swath',
     &                 2x, 'total width parameter reset to ',f9.2,
     &                45x, 'number of output traces reset to ', i9,/)
         endif
         IF (IENDTR(IFUNC) .GT. LTR) THEN
            WRITE (LPRT, 278) IENDTR(IFUNC)
  278       FORMAT(/, 1X, '** M0278 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'ENDING TRACE NUMBER ON SWATH CARD'       ,/,
     &               45X, I9, 'EXCEEDS TOTAL WIDTH.'               ,/)
            ICC = 100
         END IF
  279 CONTINUE
C
C *** OPEN VELOCITY DECK
C
      IF (VCARD .NE. ' ') THEN
         OPEN (UNIT=LVCRD, FILE=VCARD, STATUS='OLD', IOSTAT=JERR)
         IF (JERR .NE. 0) THEN
            WRITE (LPRT, 280)
  280       FORMAT(/, 1X, '** M0280 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'UNABLE TO OPEN VELOCITY CARD DECK.'      ,/,
     &               45X, 'MAKE SURE THAT YOU INPUT THE DATA '      ,/,
     &               45X, 'SET NAME CORRECTLY AND CHECK CASE.'      ,/)
            ICC = 100
         END IF
      ELSE
         LVCRD=LCRD
      END IF
C
C *** READ ALL VELOCITIES, EXPAND, AND PUT IN BIN
C
      VMIN = 100000.
      VMAX = 0.0
      ifunco = 1
      DO 370 IFUNC = 1, NFUNC
C
C *** MODEL CARD AND NUMBER OF VELOCITIES AND TRACE POSITION
C
         READ (LVCRD, 34, END=8000) CARD
         if (verbos)
     &   WRITE (LPRT, 35) CARD
         IF (CARD(1:5) .NE. 'MODEL') THEN
            WRITE (LPRT, 300) CARD(1:5)
  300       FORMAT(/, 1X, '** M0300 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'EXPECTED TO READ A MODEL CARD'           ,/,
     &               45X, 'FOUND A ', A5, ' INSTEAD.'               ,/)
            ICC = 100
         ENDIF
         READ (CARD, 310) nvs, ixs
  310    FORMAT (10X, I10, 20X, I10)
c
c *** eliminate redundant entries
c
         if (ifunc .gt. 1) then
            if (ixs .eq. ix(ifunco)) then
               if (verbos)
     &            write (lprt, *) 
     &                  'warning - duplicate entries at function ',
     &                   ix(ifunco)
            else
               ifunco = ifunco + 1
            endif
         endif
         ix(ifunco) = ixs
         nv(ifunco) = nvs
         IF (IX(ifunco) .GT. LTR) THEN
            WRITE (LPRT, 320) IX(ifunco)
  320       FORMAT(/, 1X, '** M0320 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'TRACE NUMBER INPUT ON MODEL CARD'        ,/,
     &               45X, I9, 'EXCEEDS TOTAL WIDTH.'         ,/)
            ICC = 100
         END IF
C
C *** READ IN VELOCITY FUNCTION
C
         READ (LVCRD, 34, END=8000) CARD
         if (verbos)
     &   WRITE (LPRT, 35) CARD
         DO 360 IVEL = 1, NV(ifunco)
            READ (LVCRD, 34, END=8000) CARD
            if (verbos)
     &      WRITE (LPRT, 35) CARD
            READ (CARD, 330) INVEL, VIN(IVEL,ifunco), DEP(IVEL,ifunco)
  330       FORMAT (I10, F10.0, 10X, F10.0)
            IF (INVEL .NE. IVEL) THEN
               WRITE (LPRT, 340)
  340          FORMAT
     &            (/,1X,'** M0340 ** ERROR DETECTED BY PROGRAM SWATH',
     &               2X,'THE VELOCITY NUMBER MUST START AT '      ,/,
     &              45X,'1 AND INCREMENT BY 1.'                   ,/)
               ICC = 100
            ENDIF
            IF (IVEL .GT. 1) THEN
               IF (DEP(IVEL,ifunco) .LE. DEP(IVEL-1,ifunco))THEN
                  WRITE (LPRT, 350) 
  350             FORMAT
     &            (/,1X, '** M0350 ** ERROR DETECTED BY PROGRAM SWATH',
     &               2X, 'DEPTHS MUST INCREASE.'                   ,/)
                  ICC = 100
               ENDIF
             ELSE
               IF (DEP(IVEL,ifunco) .LE. 0.0) DEP(IVEL,ifunco)=1.0
            END IF
            IF(VIN(IVEL,ifunco).GT.VMAX)VMAX=VIN(IVEL,ifunco)
            IF(VIN(IVEL,ifunco).LT.VMIN)VMIN=VIN(IVEL,ifunco)
  360    CONTINUE
  370 CONTINUE
      if (ifunco .ne. nfunc) then
         nfunc = ifunco
         if (verbos)
     &      write (lprt, *) 'number of functions reset to ', ifunco
      endif
C
C *** COME HERE ON CARD READ ERROR                        
C  
      GOTO 1000
 8000 CONTINUE
         WRITE (LPRT, 8010)
 8010    FORMAT(/, 1X, '** M8010 ** ERROR DETECTED BY PROGRAM SWATH',
     &             2X, 'END OF CARD DECK DETECTED.'              ,/)
         ICC = 100
 1000 CONTINUE
      IF (ICC .NE. 0) GOTO 9000
c     CALL VCLR (BIN, 1, MAXBIN)
C
C *** CONVERT DEPTH-INTERVAL VELOCITIES TO TIME-AVERAGE VELOCITIES
C
      SR_SEC = DTMS * .001
      NSO = 0
      DO 410 IFUNC = 1, NFUNC
         T = DEP (1,IFUNC) / VIN(1,IFUNC)
         DO 400 IVEL = 2, NV(IFUNC)
            T = T + ((DEP(IVEL,IFUNC) - DEP(IVEL-1,IFUNC))
     &        / VIN (IVEL,IFUNC))
  400    CONTINUE
         NTS = T * 2. / SR_SEC
         IF (NTS .GT. NSO) NSO = NTS
  410 CONTINUE
      if (verbos)
     &WRITE (LPRT, 411) NSO
  411 FORMAT (/, 23X, '  NUMBER OF OUTPUT SAMPLES. . . .',   I9)
C
C *** CLEAR BIG ARRAY
C
      MAXDYN = MAX (NSAMPS, NSO) * LTR * ISUM
      call galloc (ptr, maxdyn*ISZBYT, ierr, 'iabort')
      JPTR = PTR
      CALL VCLR (BIN, 1, MAXDYN)
C
C *** UPDATE PROCESSING HISTORY AND WRITE OUT LINE HEADER
C
      IF (ICC .NE. 0) GOTO 9000
      WRITE (CHLH, 500) 'SWATH (CREATE PSUEDO V(X,Z))'
  500 FORMAT (A35)
      CALL HLHPRT (IHEAD, IEOF, CHLH, LEN(CHLH), LPRT)
      IDTMS = DTMS + 0.5
      CALL SAVEW(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVEW(IHEAD, 'NumRec', 1, LINHED)
      CALL SAVEW(IHEAD, 'SmpInt', IDTMS, LINHED)
      CALL SAVEW(IHEAD, 'NumSmp', NSO, LINHED)
      CALL WRTAPE (LUOUT, IHEAD, IEOF )
C
C *** CREATE X1 ARRAY FOR CUBIC INTERPOLATION ROUTINE
C
      ifunc = 1
  423 continue
      DO 420 I = 1, NSAMPS
         X1 (I) = (I-1) * DZ
         if (verbos) write (lprt,*) 'x1(',i,') = ', x1(i)
  420 CONTINUE
C
C *** INTERPOLATE AVERAGE VELOCITIES TO ONE PER TIME SAMPLE
C
      ivel = 1
      depth = - .5 * sr_sec * vin(ivel, ifunc)
      do i = 1, nso
         if (depth .gt. dep(ivel, ifunc)) then
           ivel = ivel + 1
           if (ivel .gt. nv(ifunc)) ivel = nv(ifunc)
         endif
         depth = depth + .5 * sr_sec * vin(ivel, ifunc)
         x2(i) = depth
         if (verbos) write (lprt,*) 'x2(',i,') = ', x2(i)
      enddo
C
C *** READ DATA INTO BIG ARRAY
C
      INIT = 1
      DO 700 IT = 1, NTRCS
         ITRC = IT+IBEGTR(IFUNC)-1
         IBIN1 = (NSO*LTR)*(ITIM-1) + NSO*(ITRC-1)
         IBIN2 = (NSO*LTR)*(ISUM-1) + NSO*(ITRC-1)
         IEOF = 0
         CALL RTAPE (LUIN, IHEAD, IEOF)
         IF (IEOF .EQ. 0) THEN
            WRITE (LPRT, 605) IT
  605       FORMAT(/, 1X, '** M0605 ** WARNING FROM PROGRAM SWATH',
     &                2X, 'END OF TAPE ENCOUNTERED PREMATURELY'  ,/,
     &               45X, 'MAXIMUM TRACE NUMBER RESET TO', I9    ,/)
            GOTO 710
         END IF
         CALL SAVER(IHEAD, 'StaCor', ISTAT, TRCHED)
         IF (ISTAT .EQ. 30000) GO TO 700
         CALL VMOV (IHEAD(1), 1, IHEADS(1, ITRC), 1, ITRWRD)
         TRACE(1)=ITRC
         CALL CCUINT (X1(1), TRACE(1), NSAMPS, X2(1), BIN(IBIN1+1), NSO,
     &                IZ(1), ZZ(1), INIT)
         INIT = 0
         CALL MAXMGV (BIN(IBIN1+1), 1, ABSMAX, LOC, NSO)
         if (nfunc .eq. 1) then
            weight = 1.
         else IF (IFUNC .EQ. 1 .AND. ITRC .LT. IX(IFUNC)) THEN
               WEIGHT = 1. - FLOAT (IX(IFUNC) - ITRC)
     &                / FLOAT (IX(IFUNC))
         ELSE IF (IFUNC .EQ. NFUNC .AND. ITRC .GT. IX(NFUNC)) THEN
               WEIGHT = 1. - FLOAT (ITRC - IX(IFUNC)) 
     &                / FLOAT (LTR - IX(IFUNC) + 1)
         else if (itrc .eq. ix(ifunc)) then
            weight = 1.
         ELSE IF (ITRC .GT. IX(IFUNC)) THEN
            IF (ITRC .GE. IX(IFUNC+1)) THEN
               WEIGHT = 1. - FLOAT (IX(IFUNC+1) - IX(IFUNC) - 1) 
     &                / FLOAT (IX(IFUNC+1) - IX(IFUNC))
            ELSE
               WEIGHT = 1. - FLOAT (ITRC - IX(IFUNC)) 
     &                / FLOAT (IX(IFUNC+1) - IX(IFUNC))
            END IF
         ELSE
            IF (ITRC .LE. IX(IFUNC-1)) THEN
               WEIGHT = 1. - (IX(IFUNC) - IX(IFUNC-1) -1) 
     &                / FLOAT (IX(IFUNC) - IX(IFUNC-1))
            ELSE
               WEIGHT = 1. - (IX(IFUNC) - ITRC) 
     &                / FLOAT (IX(IFUNC) - IX(IFUNC-1))
            END IF
         END IF
         CALL VSMA (BIN(IBIN1+1), 1, WEIGHT/ABSMAX, BIN(IBIN2+1), 1, 
     &              BIN(IBIN2+1), 1, NSO)
         DIVSOR(ITRC) = DIVSOR(ITRC) + WEIGHT/ABSMAX
         if (verbos)
     &   WRITE (LPRT,*)' INPUT TRACE = ',IT,' PROCESSED weight = ',
     &   weight,' maximum amplitude = ', absmax, 
     &   ' ratio = ',weight/absmax
  700 CONTINUE
      GOTO 720
  710 CONTINUE
      IENDTR(IFUNC) = IT+IBEGTR(IFUNC)-1
  720 CONTINUE
      IF (IFUNC .LT. NFUNC) THEN
         CALL LBCLOS (LUIN)
         IFUNC = IFUNC + 1
         NTAP = NTAPA(IFUNC)(1:128)
         if (verbos)
     &   WRITE (LPRT, 850) NTAP
  850    FORMAT (1X, 'INPUT DATASET ', A128)
         CALL LBOPEN (LUIN,NTAP,'r')
         IEOF = 0
         CALL RTAPE (LUIN, IHEAD, IEOF)
         IF (IEOF .EQ. 0) THEN
            WRITE (LPRT, 800)
  800       FORMAT(/, 1X, '** M0800 ** ERROR DETECTED BY PROGRAM SWATH',
     &                2X, 'UNABLE TO OPEN SIS DATA SET.'             ,/,
     &               45X, 'MAKE SURE THAT YOU INPUT THE DATA '       ,/,
     &               45X, 'SET NAME CORRECTLY AND CHECK CASE.'       ,/)
            ICC = 100
            GOTO 9000
         ELSE
            CALL SAVER(IHEAD, 'NumTrc', NTRCS, LINHED)
            CALL SAVER(IHEAD, 'NumSmp', NSAMPS, LINHED)
            GOTO 423
         END IF
      END IF
C
C *** OUTPUT VELOCITY TAPE
C
      NBYTES = (NSO+ITRWRD)*SZSMPD
      DO 950 IT = 1, LTR
         IBIN1 = (NSO*LTR)*(ISUM-1) + NSO*(IT-1)
         CALL VMOV (IHEADS(1,IT),  1, IHEAD(1), 1, ITRWRD)
         IF (DIVSOR(IT) .EQ. 0.) THEN
            CALL SAVEW(IHEAD, 'StaCor', 30000, TRCHED)
            CALL VCLR (TRACE(1), 1, NSO)
         ELSE
            CALL VSDIV (BIN(IBIN1+1), 1, DIVSOR(IT), TRACE(1), 1, NSO)
         END IF
         IEOF = NBYTES
         jhead (106) = 1
         jhead (107) = it
         CALL WRTAPE(LUOUT, IHEAD, IEOF)
         if (verbos)
     &   WRITE (LPRT, 940) IT
  940    FORMAT(5X,'OUTPUT TRACE ',I9,' PROCESSED ')
  950 CONTINUE
 9000 CONTINUE
      WRITE (LPRT, 9045)
 9045 FORMAT (1X, '  END OF JOB ')
      CALL LBCLOS (LUIN)
      CALL LBCLOS (LUOUT)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C       cmdlin (OTAP, INPUT, IPIPO, LTRM, VERBOS, VCARD,                *
C             DZ, TDEPTH, DX, TWIDTH, NFUNC)                           *
C  ARGUMENTS:                                                          * 
C                                                                      *
C      OTAP    CHAR*(NIHEAD)  ??IOU* -                                 *
C      INPUT   CHAR*(NIHEAD)  ??IOU* -                                 *
C      IPIPO   INTEGER   ??IOU* -                                      *
C      LTRM    INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      VCARD   CHAR*128  ??IOU* -                                      *
C      DZ      REAL      ??IOU* -                                      *
C      TDEPTH  REAL      ??IOU* -                                      *
C      DX      REAL      ??IOU* -                                      *
C      TWIDTH  REAL      ??IOU* -                                      *
C      NFUNC   INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 88/05/05  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/12/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C      ARGR4           -                                               *
C      ARGI4           -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdlin (NTAP, OTAP, INPUT, IPIPI, IPIPO, LTRM, 
     &                  VERBOS, VCARD,
     &                  ENDTIM, PADTIM, BEGTIM, DTMS,
     &                  DZ, TDEPTH, DX, TWIDTH, NFUNC)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*(*) NTAP,OTAP,INPUT,VCARD
C
C *** SET DEFAULTS TO NO PIPES
C
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--CREATE PSUEDO V(X,Z)'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[input]      . INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[output]     . OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-C[swath.crd]  . INPUT CARDS'
         WRITE(LTRM,*)'-I[vfunctions] . INPUT VELOCITY CARDS'
         WRITE(LTRM,*)'-ET[endtimems] . END TIME IN MS'
         WRITE(LTRM,*)'-PT[padtimems] . PAD TIME IN MS'
         WRITE(LTRM,*)'-BT[begtimems] . BEG TIME IN MS'
         WRITE(LTRM,*)'-DT[dtms]      . SAMPLE INTERVAL IN MS'
         WRITE(LTRM,*)'-DZ[dz]        . DELTA-Z'
         WRITE(LTRM,*)'-Z[tdepth]     . TOTAL DEPTH'
         WRITE(LTRM,*)'-DX[dx]        . DELTA-X'
         WRITE(LTRM,*)'-X[twidth]     . TOTAL WIDTH'
         WRITE(LTRM,*)'-NF[functions] . NO. VELOCITY FUNCTIONS TO READ'
         WRITE(LTRM,*)'-V             . VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'swath -O[] -C[] -I[]'
         WRITE(LTRM,*)'          OR'
         WRITE(LTRM,*)'swath -O[] -I[] -DZ[] -Z[] -DX[] -X[] -NF[]'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP ,' ',' ')
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGSTR('-I',VCARD,' ',' ')
      CALL ARGR4 ('-ET',BEGTIM    ,0.0,0.0)
      CALL ARGR4 ('-PT',ENDTIM    ,0.0,0.0)
      CALL ARGR4 ('-BT',PADTIM    ,0.0,0.0)
      CALL ARGR4 ('-DT',DTMS      ,0.0,0.0)
      CALL ARGR4 ('-DZ',DZ    ,0.0,0.0)
      CALL ARGR4 ( '-Z',TDEPTH,0.0,0.0)
      CALL ARGR4 ('-DX',DX    ,0.0,0.0)
      CALL ARGR4 ( '-X',TWIDTH,0.0,0.0)
      CALL ARGI4 ( '-NF',NFUNC ,0  ,0  )
      VERBOS =   (ARGIS( '-V' ).GT.0)
C
C *** MAKE THE OTAP A PIPE
C
      IF(NTAP.EQ.' ' ) IPIPI=1
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
