C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: mkndx - Routine to create vlist (list of velocities) and an
C               Index matrix of the velocities (transposed - V(x,z) )
C                                               Version 1.0 August, 1993
C***********************************************************************
C  Purpose: mkndx accepts an array (one whole record) of a velocity
C           field, and scans the array making a list of each unique
C           velocity (binned by a figure of 4.0), transposes the 
C           array, then creates an integer*2 array of the indices for
C           the velocity field
C  Language:  Fortran 77
C
C  History:   Mary Ann Thornton     Version 1.0     August 1993
C
C  Parameters:
C    velist Input character array containing velocity list filename
C    vlist  Input real array to hold the list of velocities
C    vel    Input real array containing the velocity field
C    veltr  Input real workspace to hold the transposed velocity field
C    ind    Input integer*2 array to contain the velocity indices
C    nx     Input integer scalar - number of traces in x-direction
C    nz     Input integer scalar - number of samples in z-direction
C    jj     Input integer scalar - record number
C***********************************************************************
      subroutine mkndx(velist,vlist,vel,veltr,ind,nx,nz,jj)
#include <f77/iounit.h>
      real vlist(*)
      real vel(nz,nx),veltr(nx,nz)
      integer nx, nz, jj
      integer*2 ind(nx,nz)
      character velist*(*)
      logical around
c-------------------------------------------
c     open the velist file for output
c-------------------------------------------
      jerr = 0
      if(velist.ne.' ')then
        inquire(file=velist, exist=around)
        if(.not.around)then
           open(unit=LUCARD,file=velist,status='new',iostat=jerr)
        else
           open(unit=LUCARD,file=velist,status='old',iostat=jerr)
        endif
        if(jerr.ne.0)then
          write(LERR,*)' Error opening list of velocities'
          ierr =  50
          return
        endif
      endif
c-------------------------------------------
c     transpose the velocity matrix
      call rmtran(vel(1,1),nz,veltr(1,1),nx,nz,nx)
c-------------------------------------------
      dv = 4.0
      iv = 1
      vlist(1) = ifix( (dv/2.0 + veltr(1,1))/dv )*dv
      ind(1,1) = iv
      do 100 iz = 1,nz
         do 50 ix = 1,nx
            vtmp = ifix( (dv/2.0 + veltr(ix,iz))/dv )*dv 
            ivtmp = iv
            do 25 ivv = 1,ivtmp 
               if(abs(vtmp-vlist(ivv)) .lt. dv)then
                 ind(ix,iz) = ivv
                 go to 50
               endif
   25       continue
            iv = iv + 1
            vlist(iv) = vtmp
            ind(ix,iz) = iv
   50    continue
  100 continue
cc    do 110 iz = 1,nz,25
cc       write(LER,127)(ind(iii,iz),iii=1,nx,25)
cc110 continue
      write(LERR,  *)' velocity list contains ',iv,' velocities'
      write(LUCARD,128)iv
      write(LUCARD,*)'VELOCITIES REFLECTED'
      do 125 ivv = 1,iv
         write(LERR,  126)ivv,vlist(ivv)
         write(LUCARD,126)ivv,vlist(ivv)
  125 continue
  126 format(i10,f10.0)
  127 format(25i2)
  128 format('MODEL',5x,i10)
      return
      end
