C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: ZKRDDS
c PURPOSE: READ DDS DICTIONARY FILE
c***********************************************************************
c
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c
c***********************************************************************
c
      subroutine zkrdds( ntap, ztap, nsmp0, ntrc0, nrec0, nz, nkx, nky
     &                 , kx0, ky0, dkx, dky, zmax, tmax, dz, dt
     &                 , verbos )
c
      implicit none
c
c parameters:
c
      integer   jcardmax        ! maxinum number of cards in DDS file
      parameter( jcardmax = 28 )
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c
c input parameters:
c
      logical   verbos          ! verbose output flag
c
c output parameters:
c
      real      dkx             ! delta kx
      real      dky             ! delta ky
      real      dt              ! delta t
      real      dz              ! delta z
      character ntap*(*)        ! name of input data file
      character ztap*(*)        ! name of input zeta file
      real      kx0             ! kx origin
      real      ky0             ! ky origin
      integer   nkx             ! number of x wave numbers
      integer   nky             ! number of y wave numbers
      integer   nrec0           ! number of records, orig. data
      integer   nsmp0           ! number of samples per trace, orig. data
      integer   ntrc0           ! number of traces per record, orig. data
      integer   nz              ! number of z_s
      real      tmax            ! maximum t (msecs)
      real      zmax            ! maximum z
c
c local variables:
c
C     character card*132        ! record on dds file
      integer   jcard           ! input line index
      integer   nstr            ! number of tokens in text line less one
      character str(0:3)*100    ! tokens from data dictionary lines
c
c functions:
c
      integer   str2int         ! string to integer
      real      str2real        ! string to real
c
c***********************************************************************
c
c  CONTENTS OF THE INPUT DDS FILE SHOULD LOOK LIKE:
c
c  zeta=   <full_zeta_file_path_name>
c  data=   <full_data_file_path_name>
c  format= usp
c  data_type=  complex*8
c  axis=   zbar kx ky
c  size=   <nzbar> <nkx> <nky>
c  delta=  -1 <dkx> <dky>
c  origin= -1 <kx0> <ky0>
c  txy_size= <nsmp_in> <ntrc_in> <nrec_in>
c
c***********************************************************************
      do jcard = 1, jcardmax
c
         call getline( LUSI, str, nstr )
         if( nstr .lt. 0 ) go to 200
c
         if     ( str(0) .eq. 'zeta=' ) then
            ztap = str(1)
c
         elseif( str(0) .eq. 'data=' ) then
            ntap = str(1)
c
         elseif( str(0) .eq. 'format=' ) then
            if( str(1) .ne. 'usp' ) then
               write( LER, * ) '***** ERROR: format must be usp *****'
               call exitfu(1)
            endif
c
         elseif( str(0) .eq. 'data_type=' ) then
            if( str(1) .ne. 'complex*8' ) then
               write( LER, * ) '***** ERROR: data_type must be ',
     &                         'complex*8 *****'
               call exitfu(1)
            endif
c
         elseif( str(0) .eq. 'axis='      ) then
            if( ( str(1) .ne. 'zbar' ) .or. ( str(2) .ne. 'kx' ) .or.
     &                                      ( str(3) .ne. 'ky' ) ) then
               write( LER, * ) '***** ERROR: invalid axis *****'
               call exitfu(1)
            endif
c
         elseif( str(0) .eq. 'size=' ) then
            if( nstr .ne. 3 ) then
               write( LER, * ) '***** ERROR: invalid size rank *****'
               call exitfu(1)
            endif
            nz  = str2int( str(1) )
            nkx = str2int( str(2) )
            nky = str2int( str(3) )
c
         elseif( str(0) .eq. 'delta=' ) then
            if( nstr .ne. 3 ) then
               write( LER, * ) '***** ERROR: invalid delta rank *****'
               call exitfu(1)
            endif
            dkx = str2real( str(2) )
            dky = str2real( str(3) )
c
         elseif( str(0) .eq. 'origin=' ) then
            if( nstr .ne. 3 ) then
               write( LER, * ) '***** ERROR: invalid origin rank *****'
               call exitfu(1)
            endif
            kx0 = str2real( str(2) )
            ky0 = str2real( str(3) )
c
         elseif( str(0) .eq. 'txy_size=' ) then
            if( nstr .ne. 3 ) then
               write( LER, * )'***** ERROR: invalid txy_size rank *****'
               call exitfu(1)
            endif
            nsmp0  = str2int( str(1) )
            ntrc0  = str2int( str(2) )
            nrec0  = str2int( str(3) )
c
         elseif( str(0) .eq. 'zmax=' ) then
            zmax = str2real( str(2) )
c
         elseif( str(0) .eq. 'tmax=' ) then
            tmax = str2real( str(2) )
c
         elseif( str(0) .eq. 'dt=' ) then
            dt = str2real( str(2) )
c
         elseif( str(0) .eq. 'dz=' ) then
            dz = str2real( str(2) )
c
         endif
      enddo
c
      write( LER, * )' ***** ERROR: should not have reached ', jcardmax
     &             , ' input cards, stopping *****'
      call exitfu(1)
c
c***********************************************************************
  200 continue
c
c      if ( verbos ) then
c         write( LUPRT, * ) ' CONTENTS OF INPUT DDS FILE: '
c         rewind( LUCARD )
c         do jcard = 1, 8
c            read( LUCARD, '(a)', end=300 ) card
c            write( LUPRT, '(a)' ) card
c         enddo
c      endif
c
  300 continue
c
c      close( LUCARD )
c***********************************************************************
      return
      end
