C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: ZKRZETA
c PURPOSE: read zeta file
c***********************************************************************
c
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c
c***********************************************************************
      subroutine zkrzeta( ztap, nzin, zin, timein, ierr )
c***********************************************************************
c***********************************************************************
      implicit none
c
#include <f77/iounit.h>
c
c input variables:
c
      character ztap*(*)        ! name of input zeta file
      integer   nzin            ! number of z_s from input dds file
c
c output variables:
c
      integer   ierr            ! error flag
      real      timein(0:nzin)  ! irregular time grid from zeta file
      real      zin(0:nzin)     ! irregular depth grid from zeta file
c
c local variables:
c
      character cdum*1          ! dummy used to skip input line
      integer   jdum            ! scratch integer
      integer   jz              ! z index
      integer   nz              ! number of z_s from zeta file
      real      zmin            ! minimum z value
      real      zmax            ! maximum z value
c
c***********************************************************************
c
      open( unit=LUDISK, file=ztap, status='old' )
c
c===  read zeta file
c
c===  skip 3 header lines
      read( LUDISK, '(a)' ) cdum
      read( LUDISK, '(a)' ) cdum
      read( LUDISK, '(a)' ) cdum
c
c===  read zmin, zmax, nz
      read( LUDISK, * ) zmin, zmax, nz
      if( nz .ne. nzin ) then
         write( LER, * )' ***** ERROR reading zeta file , discrepancy '
     &          ,' in nz and nzin *****'
         ierr = 1
         go to 800
      endif
c
c===  skip header line
      read( LUDISK, '(a)' ) cdum
c
c===  read data lines
      do jz = 0, nz
         read( LUDISK, * ) jdum, zin(jz), timein(jz)
         if( jdum .ne. jz ) then
            write( LER, * )' ***** ERROR reading zeta file *****'
     &     , ' jdum .ne. jz ***'
            ierr = 1
            go to 800
         endif
      enddo
c
c===  check for errors (go ahead but print a warning to stderr)
c
      if( (zin(0) .lt. zmin-.005) .or. (zin(nz) .gt. zmax+.005) ) then
         write( LER, * )' ***** WARNING reading zeta file, zmin zmax '
     &           ,' in zeta file do not bracket z values *****'
         write( LER, *)' zin(0)  = ', zin(0), '  zmin = ', zmin
         write( LER, *)' zin(nz) = ', zin(nz), '  zmax = ', zmax
c         ierr = 1
         go to 800
      endif
c
c***********************************************************************
  800 continue
c
      close( LUDISK )
c
      return
      end
c***********************************************************************
