C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: ZKWDDS 
c PURPOSE: WRITE OUTPUT DDS DICTIONARY FILE
c***********************************************************************
c
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c
c***********************************************************************
c   If dz is specified, then the data dictionary will contain the
c            following:
c   data=   <full_data_file_path_name>
c   format= usp
c   data_type=  real*4
c   axis=   z x y
c   size=   <nz> <nx> <ny>
c   delta=  <dz> <dx> <dy>
c   origin= <z0> <x0> <y0>
c   txy_size= <nsmp_in> <ntrc_in> <nrec_in>
c***********************************************************************
c   If dtms is specified, then the data dictionary will contain the
c              following:
c   data=   <full_data_file_path_name>
c   format= usp
c   data_type=  real*4
c   axis=   t x y
c   size=   <nt> <nx> <ny>
c   delta=  <dt> <dx> <dy>
c   origin= <t0> <x0> <y0>
c   txy_size= <nsmp_in> <ntrc_in> <nrec_in>
c***********************************************************************
c***********************************************************************
      subroutine zkwdds( outfil, otap, nz, nt, nx, ny, t0, z0, x0, y0
     &                 , dz, dt, dx, dy, nsmp0, ntrc0, nrec0, verbos )
c***********************************************************************
      implicit none
c***********************************************************************
c
#include <f77/iounit.h>
c
c input parameters
c
      real      dt              ! delta t
      real      dx              ! delta x
      real      dy              ! delta y
      real      dz              ! delta z
      real      t0              ! first t
      real      x0              ! first x
      real      y0              ! first y
      real      z0              ! first z
      integer   nrec0           ! number of records, orig. data
      integer   nsmp0           ! number of samples per trace, orig. data
      integer   ntrc0           ! number of traces per record, orig. data
      integer   nt              ! number of t_s
      integer   nx              ! number of x_s
      integer   ny              ! number of y_s
      integer   nz              ! number of z_s
      character otap*(*)        ! full name of DDS file
      character outfil*(*)      ! output data dictionary
      logical   verbos          ! verbose output flag
c
c local variables
c
      character card*132        ! record on dds file
      integer jcard             ! record index on dds file
c***********************************************************************
c
      open( unit=LUCARD, file=outfil, status='unknown' )
c
      write( LUCARD, '(''data= '',(a))' ) otap
      write( LUCARD, '(''format= usp'')' )
      write( LUCARD, '(''data_type=  real*4'')' )
c
c===  depth case
c
      if( dz .gt. 0.0 ) then
         write( LUCARD, '(''axis=   z x y'')'      )
         write( LUCARD, '(''size=     '',3i20)'    ) nz, nx, ny
         write( LUCARD, '(''delta=    '',3g20.10)' ) dz, dx, dy
         write( LUCARD, '(''origin=   '',3g20.10)' ) z0, x0, y0
         write( LUCARD, '(''txy_size= '',3i20)'    ) nsmp0, ntrc0, nrec0
         go to 900
      endif
c
c=== time case
c
      if( dt .gt. 0.0 ) then
         write( LUCARD, '(''axis=   t x y'')'      )
         write( LUCARD, '(''size=     '',3i20)'    ) nt, nx, ny
         write( LUCARD, '(''delta=    '',3g20.10)' ) dt, dx, dy
         write( LUCARD, '(''origin=   '',3g20.10)' ) t0, x0, y0
         write( LUCARD, '(''txy_size= '',3i20)'    ) nsmp0, ntrc0, nrec0
         go to 900
      endif
c***********************************************************************
900   continue
c
      if ( verbos ) then
         write( LUPRT, * ) ' CONTENTS OF OUTPUT DDS FILE: '
         rewind( LUCARD )
         do jcard = 1, 8
            read( LUCARD, '(a)' ) card
            write( LUPRT, '(a)' ) card
         enddo
      endif
c
      close( LUCARD )
      return
      end
c***********************************************************************
