C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine InterpAngle ( Angles, Records, Nangles, RecNum, 
     :     RotationAngle )

#include <f77/lhdrsz.h>

      integer Records ( SZLNHD ), Nangles, RecNum

      real    Angles ( SZLNHD ), RotationAngle

c handle record less than first record in function

      if ( RecNum .le. Records(1) ) then
         RotationAngle = Angles(1)
         return
      endif

c handle record numbers greater than last entry in file

      if ( RecNum .ge. Records(Nangles) ) then
         RotationAngle = Angles(Nangles)
         return
      endif

c interpolate angle

      do i = 2, Nangles

         if ( RecNum .lt. Records(i) ) then
            RotationAngle = Angles(i-1) + ( Angles(i) - Angles(i-1) ) / 
     :           abs ( float ( Records(i) - Records(i-1) ) ) * 
     :           abs ( float ( RecNum - Records(i-1) ) )
            return
         endif

      enddo

c something bad has happenend

      write(LERR,*)'GROT: Cannot find record ',RecNum,' in flatfile'
      write(LERR,*)'      Will use Rotation Angle of ',RotationAngle
      write(LERR,*)'WARNING'
      return
      end

         
