C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine eigen2(quad,eig,mv)
      dimension quad(*),eig(*)
      real lmda1,lmda2
c
c   quad - original matrix (symmetric), destroyed in computation.
c          Resultant eigenvalues are placed in diagonal of matrix
c          in descending order.

c          a    b
c          c    d

c    eig - resultant matrix of eigenvectros (stored columnwise, in
c          same order as eigenvalues.
c     mv - input code:  0 = compute eigenvalues & eigenvectors
c                       1 = compute eigenvalues only
c
c  section for 2-component data
c       quad(1)=sum11
c       quad(2)=sum12
c       quad(3)=sum12
c       quad(4)=sum22

        a=quad(1)
        c=quad(2)
        b=quad(3)
        d=quad(4)

      if(abs(c) .ne. 0.) then
           bb=(a+d)
           cc=a*d-c*b
           sq=sqrt(bb*bb-4.*cc)
           lmda1=(bb + sq)/2.
           lmda2=(bb - sq)/2.
           if(lmda1 .lt. 1.e-30) then
              lmda1=0.
              lmda2=0.
           endif
           quad(1)=lmda1
           quad(3)=lmda2
      else
           quad(1) = amax1(a,b)
           quad(3) = amin1(a,b)
           eig(1) = 0.
           eig(2) = 0.
           return
      endif
c
c  section 2 compute eigenvector
      if(mv .eq. 0) then
           if (b .ne. 0.0 .AND. c .ne. 0.0) then
              e1=(lmda1-a)/b
              ee = sqrt (e1*e1 + 1.0)
              eig(1) = 1.0 / ee
              eig(3) = e1 / ee
              e1=(lmda2-a)/b
              ee = sqrt (e1*e1 + 1.0)
              eig(2) = 1.0 / ee
              eig(4) = e1 / ee

           else
              eig(1) = 1.0
              eig(3) = 0.0
           endif
      endif
c
c  adjust eigenvalues for scale factor and put into quad
      return
      end

