C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine polfil2(n,x1,x2,vtrin,rtrin,iwin,th,nrect,im,rl,rlsm)
c
c  subroutine to compute & apply ground roll filter to 3 components
c
c  input:
c        n -- number of input data points
c     x1,2 -- 2 input channels, vert, radl, trans
c      thr -- threshold, determines zeroing of rect function
c      ist -- sample at which to start processing
c     iwin -- sliding window length
c    nrect -- power to raise rect function
c
c  output:
c   vtrin  -- vertical filtered output (ditto for rtrin)
c
#include <localsys.h>
#include <f77/lhdrsz.h>
      dimension   x1(*),x2(*),vtrin(*),rtrin(*)
      real        rl(*),rlsm(*)
      real        q11(SZLNHD),q12(SZLNHD),q22(SZLNHD)
      real        eig(4), quad(4), lmda(2), work(4)
      real        lmda1,lmda2,sum11,sum12,sum22
      real        pi, radeg
      pi = 3.14159265
      radeg = 180./pi
 
      iwin2 = iwin/2
      ist0  = im


c   don't start pocessing unless we're at least 1/2 window length into trace
      if (iwin2 .gt. ist0) then
          ist0 = iwin2 - im
          ist1 = ist0 + 1
      else
          ist1 = im
      endif
      if (ist1 .eq. 0) ist1 = 1

c   stop processing when we're within 1/2 window length of end of trace
      nw   = n - iwin2
c
c   Loop to calculate 0-lag cross correlation coefficients of  V, R, T
c
c   q11 = V * V; q22 = R * R 
c   q12 = V * R
c
       call vmul (x1,1,x1,1,q11,1,n)
       call vmul (x1,1,x2,1,q12,1,n)
       call vmul (x2,1,x2,1,q22,1,n)


c     do i=1,n
c     write(10,*)i,q11(i)
c     enddo
c
c   Main DO LOOP for calculating filter

      rlmin = 9999999.
      rlmax = 0.
      nump  = 0

      DO 100 i=ist1,nw

             nump = nump + 1

c    start & end of current window position
             if (iwin2 .eq. 0) then
                istart=i
                iend  =i
             else
                istart=i-iwin2
                iend  =i+iwin2
             endif

c    for first window position we need to compute complete correlation...
             if(i .eq. ist1) then
                  sum11=0.
                  sum12=0.
                  sum22=0.
c     ... i.e. sum over all values in window
                  do 10 j=istart,iend
                        sum11=sum11+q11(j)
                        sum12=sum12+q12(j)
                        sum22=sum22+q22(j)
   10             continue

c    BUT for all remaining window positions on trace NEW correlation value is
c    found by subtracting first value of previous position and adding last value
c    of new window position, since these are the only values to change for a 
c    shift of one sample
             else
                     sum11=sum11-q11(istart-1)+q11(iend)
                     sum12=sum12-q12(istart-1)+q12(iend)
                     sum22=sum22-q22(istart-1)+q22(iend)
             endif
c    fill up 4-entry EIGEN matrix
             quad(1)=sum11
             quad(2)=sum12
             quad(3)=sum12
             quad(4)=sum22

c            call rseaa (2, 2, quad, lmda, eig, work, ierr)
c            lmda1 = amax1 (lmda(1),lmda(2))
c            lmda2 = amin1 (lmda(1),lmda(2))
             call eigen2 (quad,eig,0)
             lmda1=quad(1)
             lmda2=quad(3)
c   test for degenerate case, and fill up filter vector
             if(abs(lmda1) .gt. 1.e-30 .AND. abs(lmda2) .gt. 1.e-30) 
     1       then
                    rli = abs (lmda2/lmda1)
                    if (rli .gt. 1) rli = 0.
c                   rri = abs ( alog(rli) )
                    if (rri .ge. rlmax) rlmax = rli
                    if (rri .le. rlmin) rlmin = rli
c                   rl (nump) = (1 - rli) ** nrect
                    rl (nump) = rli
c     if(i.ge.80.and.i.le.100)write(0,*)i,rli,radeg*atan2(eig(1),eig(3))
c     if(i.ge.80.and.i.le.100)write(0,*)i,rli,eig(1),eig(3)
             else
c                   rl (nump) = 0.
             endif
  100 CONTINUE

c     call vsmul  (rl, 1, 1/rlmin, rl, 1, nump)
c     do  i = 1, nump
c         rli = rl (i)
c         if (rli .eq. 0.) rl(i) = 1.0
c     enddo
c     call SmoothFit(rl,nump,iwin)

c     do i = 1, nump
c     write(10,*)4*i,rl(i)
c     enddo
c     write(10,777)
c777   format()
c     do i = 1, nump
c     write(10,*)4*i,rlsm(i)
c     enddo
c     write(10,777)

c     ii = 0
c     DO  i = ist1, nw
c         ii = ii + 1
c         rli = rlsm (ii)
c         vtrin (i) = x1 (i) / rli
c         rtrin (i) = x2 (i) / rli
c         
c     ENDDO

      do  i = 1, im-1
          vtrin(i) = 0.
          rtrin(i) = 0.
      enddo

c   End of Main DO LOOP

      return
      end
