C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine RedFlag(lhed,Horizon,Datum,N,nsi,fmax,AliasFlag)

#include <save_defs.h>
#include <f77/iounit.h>

      integer N,nsi,i,lhed(*),RecNum,TrcNum,l_RecNum,l_TrcNum

      real Horizon(*),Datum(*),fmax,nsiPsdm,SqueezeNyquist
      real nsampPsdm

      logical AliasFlag

      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_RecNum,length,RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call saver2(lhed,ifmt,l_TrcNum,length,TrcNum,TRACEHEADER)

c
c ----- determine if temporal sample theorem is being violated for -----
c       given fmax.
c

      nsampPsdm = Datum(1)/float(nsi)
      nsiPsdm = Horizon(1)/nsampPsdm
      SqueezeNyquist = 1./(2.*nsiPsdm*1.e-3)

      if(SqueezeNyquist .lt. fmax ) then
         AliasFlag = .true.
      write(LERR,*)' WARNING: Aliasing at Record ', RecNum, ' Trace ',
     :     TrcNum
      write(LERR,*)'          Squeeze Nyquist of ',SqueezeNyquist
      write(LERR,*)'          occurs when event at ',Horizon(1),' ms'
      write(LERR,*)'          is moved to datum at ',Datum(1),' ms'
      write(LERR,*)' '
      endif

      do i=2,N
    
         nsampPsdm = (Datum(i) - Datum(i-1))/float(nsi)
         nsiPsdm = (Horizon(i) - Horizon(i-1))/nsampPsdm
         SqueezeNyquist = 1./(2.*nsiPsdm*1.e-3)

         if(SqueezeNyquist.lt.fmax)then
            AliasFlag = .true.
      write(LERR,*)' WARNING: Aliasing at Record ', RecNum, ' Trace ',
     :     TrcNum
      write(LERR,*)'          Squeeze Nyquist of ',SqueezeNyquist
      write(LERR,*)'          occurs when event at ',Horizon(i),' ms'
      write(LERR,*)'          is moved to datum at ',Datum(i),' ms'
      write(LERR,*)'  '
        endif
         
      enddo
      
      return
      end
