C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c     program module postsort  -  multicomponent post sort
c
c**********************************************************************c
c
c     postsort reads a set of seosmic traces (an ntuple) then
c     orders and selects the desired components an writes the results
c     to th e output.  postsort expects it's input from compsort.
c
c subroutine calls: rtape, hlh, wrtape, save, dagc, odd
c
c**********************************************************************c
c
c     declare variables
c
      parameter (MAXC=9)
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer     itr(SZLNHD)
      integer     lhed( SZLNHD )
      integer     itrh
      pointer     (wkadri, itrh(1))
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, novrd, ndis
#include <f77/pid.h>
      integer     trc,rec,ntuple,otuple,pair(9)
      character   name * 8,   ntap * 256, otap * 256, comp*18
      character   TrWrdr * 6, TrWrds * 6
      logical verbos, query, dist, heapi
      integer argis

      equivalence ( itr(  1), lhed(1) )
      data name     /'POSTSORT'/
      data lbytes / 0 /, nbytes / 0 /, verbos/.false./, dist/.false./

c-----
c     get help if necessary
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout file
c-----
#include <f77/open.h>

c-----
c     read program parameters from command line card image file
c-----
      call gcmdln(ntap,otap,comp,pair,otuple,novrd,dist,verbos,
     1            TrWrdr,TrWrds)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     guarantee that we can work with the files
c-----
      write(LERR,*)'LER=  ',LER,'  LERR=  ',LERR
      write(LERR,*)'luin=  ',luin,'  luout=  ',luout

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes                  )
      write(LERR,*)'lbyte, lbytes= ',lbyte,lbytes
      if(lbytes .eq. 0) then
             write(LOT,*)'gsort: no header read from unit ',luin
             write(LOT,*)'FATAL'
             stop
      endif

      call hlhprt ( itr , lbytes, name, 8, LERR        )

#include <f77/saveh.h>

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
      call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
 
      call savelu( TrWrdr ,ifmt,l_TrWrdr,length,TRACEHEADER)
      call savelu( TrWrds ,ifmt,l_TrWrds,length,TRACEHEADER)

      if(novrd .eq. 0) then
         call saver( itr, 'RATTrc',  ntuple , LINHED)
      else
         ntuple = novrd
      endif
         call savew( itr, 'RATTrc',  otuple , LINHED)
c--------------------------------------
c   put in right flag for multiplex
c--------------------------------------
      if(dist) then
         call savew( itr, 'RATFld',   0     , LINHED)
      else
c--------------------------------------
c   or not
c--------------------------------------
         call savew( itr, 'RATFld',   2     , LINHED)
      endif
      jtr = (ntrc/ntuple)*otuple
      nrecc = nrec
      ndis = ntrc/ntuple
c-----
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr  , LINHED)

c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.

      nitems = ITRWRD + nsamp
      itemi = ntrc * nitems * SZSMPD
      call galloc (wkadri, itemi, errcdi, aborti)
      if (errcdi .ne. 0.) heapi = .false.

      if (.not. heapi) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform, ntuple,
     1           ntap,otap,comp,pair,dist,ndis,otuple,
     2           l_TrWrdr,l_TrWrds)
c     end if
      call savhlh( itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )
c-----
c     BEGIN PROCESSING
c     process desired trace records
c-----
c     read ntuple, sort, then output desired sequence
c
C**********************************************************************C
c
      DO 100 JJ = 1, NREC
              DO 98 LL = 1, NTRC
                 nbytes=0
                 istrc = (LL-1) * nitems
                 call rtape(luin,itr,nbytes)
                 if(nbytes .eq. 0) then
                   write(LERR,*)'end of file at rec ',jj,' trc ',ll,
     1                           ' ntuple ',ntuple
                   go to 999
                 endif
                 call vmov (lhed, 1, itrh(istrc+1), 1, nitems)

   98         CONTINUE
c-------------------------------------------------------
c  traces organized by distance first, then component
c-------------------------------------------------------
           IF(.not.dist) THEN

              DO 97 MM = 1, otuple
                 do 96 LL = 1, ntrc

                     istrc = (LL-1) * nitems
                     call vmov (itrh(istrc+1), 1, lhed, 1, nitems)

                     i15 = itr ( l_TrWrdr)
                     i16 = itr ( l_TrWrds)
                     rec = itr ( l_RecNum)
                     trc = itr ( l_TrcNum)

                     call encode(i15,i16,i1516)
                     if(i1516 .eq. pair(MM)) then
                        if(verbos)
     1                  write(LERR,*)'writing rec ',rec,' trc ',trc,
     2                              ' ntuple ',i1516
                        call wrtape(luout,itr,nbytes)
                    endif
   96            continue
   97         CONTINUE
c-------------------------------------------------------
c  traces organized by component first, then distance
c-------------------------------------------------------
           ELSE

              DO 99 ID = 1, ndis

                 DO 95 MM = 1, otuple

                      do 94 L  = 1, ntuple

                          LL = L + (ID-1)*ntuple

                          istrc = (LL-1) * nitems
                          call vmov (itrh(istrc+1), 1, lhed, 1, nitems)

                          i15 = itr ( l_TrWrdr)
                          i16 = itr ( l_TrWrds)
                          rec = itr ( l_RecNum)
                          trc = itr ( l_TrcNum)

                          call encode(i15,i16,i1516)
                          if(i1516 .eq. pair(MM)) then
                             if(verbos)
     1                          write(LERR,*)'writing rec ',rec,' trc ',
     2                                   trc,' ntuple ',i1516
                             call wrtape(luout,itr,nbytes)
                         endif
   94                 continue
   95            CONTINUE
   99         CONTINUE

           ENDIF

  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

      subroutine sort(ix,key,no)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'execute gsort by typing postsort and  list of program parameters'
      write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
        write(LER,*)
     1' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout ): output data file name'
        write(LER,*)' '
        write(LER,*)
     1' -C [comp] enter receiver-source pairs (no blanks)'
        write(LER,*)
     1' eg:   -C111213'
        write(LER,*)
     1' for 3 traces: receiver comp=H1, source comp=H1,H2,V'
        write(LER,*)
     1' -Hwr [TrWrdr](default = ToStUn ) : rcvr component header word'
        write(LER,*)
     1' -Hws [TrWrds](default = ToTmAU ) : src component header word'
        write(LER,*)' '
        write(LER,*)
     1' -D  flag: if present traces output by components for each dist'
        write(LER,*)
     1'     otherwise traces output by distances for each component'
        write(LER,*)
     1' -V  flag: if present verbose printout'
       write(LER,*)' '
       write(LER,*)
     1'usage:   postsort -N[ntap] -O[otap] -C[comps] -Hwr[] -Hws[]'
       write(LER,*)
     1'         [-D -V]'
         write(LER,*)
     1'***************************************************************'
      return
      end
      subroutine gcmdln(ntap,otap,comp,pair,leni,novrd,dist,verbos,
     1            TrWrdr,TrWrds)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     comp  - C*18      string of component indices
c     pair  - I*9       vector of component pairs
c     pair  - I         number of pairs
c    novrd  - I         override the value of ntuple found in line header
c     verbos- L   verbose output or not
c     dist  - L   organize output components for constant distance
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), comp*18, string*1
      character TrWrdr * 6, TrWrds * 6
      logical   verbos, dist
      integer   argis,leni,imod,pair(9)

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-C', comp, ' ', ' ' )
            call argi4 ( '-n', novrd, 0, 0 )
            call argstr( '-Hwr', TrWrdr, 'ToStUn', 'ToStUn' )
            call argstr( '-Hws', TrWrds, 'ToTmAU', 'ToTmAU' )
            if(comp(1:1) .eq. ' ') then
              write(LERR,*)'No component sequence given'
              write(LERR,*)'check documentation & rerun'
              stop
            endif
            leni = 0
            do 1 i=1,18
               if(comp(i:i) .ne. ' ') leni = i
    1       continue
            imod = mod(leni,2)
            if(imod .ne. 0) then
              write(LERR,*)'One of the components is missing'
              write(LERR,*)'present comp=  ',comp
              write(LERR,*)'check command line too see that the -C'
              write(LERR,*)'is followed by pairs of components'
              call help()
              stop
            endif
            verbos = ( argis( '-V' ) .gt. 0 )
            dist   = ( argis( '-D' ) .gt. 0 )
            j=0
            do 2  i=1,leni,2
               j = j+1
               string = comp(i:i)
               call stoint(string,i1)
               string = comp(i+1:i+1)
               call stoint(string,i2)
               call encode(i1,i2,pair(j))
    2       continue
            leni = leni/2
c-----
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, ntuple,
     1        ntap,otap,comp,pair,dist,ndis,otuple,
     2           l_TrWrdr,l_TrWrds)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntuple- I*4 input rec/src pairs
c     npair - I*4 output rec/src pairs
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     comp  - C*18    string describing receiver/source pairs
c     pair  - I*4(9)  2-digit numbers derived from pairs of comp string charac
c     dist  - L   organize components for constant distance
c     ndis  - I*4  number distances
c-----
#include <f77/iounit.h>
      integer   nsamp, nsi, ntrc, nrec, iform, pair(9),ndis
      integer   otuple
      character ntap*(*), otap*(*), comp*18
      logical   dist

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' input comp pairs    =  ',ntuple
            write(LERR,*) ' output comp pairs   =  ',otuple
            write(LERR,*) ' output components   =  ',pair
            write(LERR,*) ' output pairs        =  ',comp
            write(LERR,*) ' receiver component word   =  ',l_TrWrdr
            write(LERR,*) ' source component word     =  ',l_TrWrds
         if(dist) then
            write(LERR,*) ' Output components for constant distance'
         endif
            write(LERR,*) ' number distaces     =  ',ndis
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
