C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPicks(lupick,Record,StartTime,EndTime,irs,
     :     ire,PickOverride,numpicks,verbos)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer lupick,nelem,index(4,1),nsegs,item,irs,ire
      integer errcd1,errcd2,abort,j,i, numpicks

      real StartTime(numpicks),Record(numpicks),EndTime(numpicks)
      real rec_units,trc_units
      real samp_units,PickOverride

      real TempRec,TempTime,slope

      pointer (wkadr12, TempRec(2000000))
      pointer (wkadr13, TempTime(2000000))


      character junk*1

      logical verbos

c
c ----- initialize variables -----
c
 
      nelem = 0
      nsegs = 1
      abort = 0

c
c ----- allocate additional memory -----
c

      item = ((ire-irs)+10)*SZSMPD

      call galloc(wkadr12,item,errcd1,abort)
      call galloc(wkadr13,item,errcd2,abort)

      if (errcd1 .ne. 0 .or. errcd2 .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'FATAL:Unable to allocate Pickfile workspace:'
         write(LERR,*) item*2,'  bytes'
         write(LERR,*)' '
         stop
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating Pickfile workspace:'
         write(LERR,*) item*2,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- rewind file -----
c

      rewind lupick

c
c ----- read past file header -----
c

      read(lupick,'(a1,4x,3f13.7)')junk,rec_units,trc_units,samp_units

c 
c ----- read past segment header -----
c

      read(lupick,'(a1)')junk

c
c ----- read first segment -----
c

 1    read(lupick,'(a1)',end=20)junk

      if(junk.ne.'S') then

         nelem = nelem + 1
         goto 1

      else

         index(nsegs,1) = nelem

         write(LERR,*) ' segment number : ', nsegs 
         write(LERR,*) ' number of elements : ', nelem 

c
c -----	advance segment register and reset element counter -----
c

         nsegs = nsegs + 1

         if(nsegs.gt.2)then

            write(LERR,*)' FATAL: more that 2 segments in pickfile'
            write(LERR,*)'        There must be one segment for window'
            write(LERR,*)'        start and one for window end.  Any '
            write(LERR,*)'        other pickfile configuration is '
            write(LERR,*)'        not accepted.'
            write(LERR,*)' '
            stop

         endif
  
         nelem = 0

c
c ----- start next segment -----
c

         goto 1

      endif

c
c ----- have reached end of pick file -----
c	assign number of elements for last segment
c

 20   index(nsegs,1) = nelem
      
      write(LERR,*) ' segment number : ', nsegs 
      write(LERR,*) ' number of elements : ', nelem 

      if(nsegs.ne.2)then

         write(LERR,*)'FATAL: there must be two segments in the pick'
         write(LERR,*)'       file corresponding to the start time and'
         write(LERR,*)'       end time of the window of interest.  you'
         write(LERR,*)'       have ',nsegs,' segments.'
         write(LERR,*)' '
         stop

      endif

c
c -----	now know total number of segments -----
c       and number of elements in each
c
	
      rewind lupick

c	
c ----- read past header -----
c	

      read(lupick,'(a1)') junk

c		
c ----- read past segment header -----
c

      read(lupick,'(a1)') junk

c
c ----- read StartTime() -----
c

      do j = 1,index(1,1)

         read(lupick,10)TempRec(j),TempTime(j)
 10      format(f12.0,14x,f12.0)

c
c ----- multiply picks by pick sample interval override if required -----
c

         if(PickOverride.gt.1)then
               
            TempTime(j) = TempTime(j)*PickOverride
               
         endif

      enddo

c
c ----- interpolate a StartTime for every record -----
c

      DO 100 i=irs,ire


         do j=1,index(1,1)

            if(float(i).le.TempRec(j))then

               if(j.eq.1)then

                  Record(i) = float(i)
                  StartTime(i) = TempTime(j)
                  goto 100

               else

                  Record(i) = float(i)
                  slope = (TempTime(j) - TempTime(j-1))/(TempRec(j) - 
     :                 TempRec(j-1))
                  StartTime(i) = slope * (Record(i) - TempRec(j-1)) + 
     :                 TempTime(j-1)
                  goto 100

               endif

            endif

         enddo
               
 100   CONTINUE

c
c ----- read EndTime() -----
c

c		
c ----- read past segment header -----
c

      read(lupick,'(a1)') junk

      do j = 1,index(2,1)

         read(lupick,10)TempRec(j),TempTime(j)

c
c ----- multiply picks by pick sample interval override if required -----
c

         if(PickOverride.gt.1)then
               
            TempTime(j) = TempTime(j)*PickOverride
               
         endif

      enddo

c
c ----- interpolate a EndTime for every record -----
c

      DO 200 i=irs,ire


         do j=1,index(2,1)

            if(float(i).le.TempRec(j))then

               if(j.eq.1)then

                  EndTime(i) = TempTime(j)
                  goto 200

               else

                  Record(i) = float(i)
                  slope = (TempTime(j) - TempTime(j-1))/(TempRec(j) - 
     :                 TempRec(j-1))
                  EndTime(i) = slope * (Record(i) - TempRec(j-1)) + 
     :                 TempTime(j-1)
                  goto 200

               endif

            endif

         enddo
               
 200  CONTINUE

c
c ----- verbose output of window data -----
c

      if(verbos)then

         write(LERR,*)' '
         write(LERR,*)' Window Parameters as interpolated from Pickfile'
         write(LERR,*)' '
         write(LERR,*)'   Record    StartTime    EndTime '

         do j=irs,ire

            write(LERR,*)record(j),StartTime(j),EndTime(j)

         enddo

      endif
            
c
c ----- free up memory no longer required -----
c

c      call gfree(wkadr12)
c      call gfree(wkadr13)

      return
      end
 
