C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,ttap,otap,ptap,le1,irs,ire,isrc,
     :     isrc2,pick,flat,PickOverride,AngleToAdd,AngleConstant,
     :     angopt,ixs,ixe,ixd,verbos,analy, IKP)

#include <f77/iounit.h>

      integer    argis,irs,ire,le1,ixs,ixe,ixd
      integer    isrc, angopt,isrc2

      real       PickOverride,AngleToAdd,AngleConstant
     
      character  ntap*(*), otap*(*), ptap*(*), ttap*(*)

      logical    pick,flat,verbos,analy, IKP

      le1 = 0

c
c ----input and output files----
c
      call argstr('-N',ntap,' ',' ') 
      call argstr('-T',ttap,' ',' ') 
      call argstr('-O',otap,'out','out')
      call argstr('-P',ptap,' ',' ')

      le1 = lenth(ptap)

c
c ----constant rotation angle----
c

      call argr4('-rot',AngleToAdd,0.0,0.0)
      call argr4('-ROT',AngleConstant,0.0,0.0)

c
c ----start and end record----
c

      call argi4('-rs',irs,1,1)
      call argi4('-re',ire,0,0)

c
c ----xgraph output start and end record, record increment----
c

      call argi4('-xs',ixs,1,1)
      call argi4('-xe',ixe,0,0)
      call argi4('-xd',ixd,1,1)

c
c ----source type----
c

      call argi4('-s',isrc,1,1)

c
c ----type of optional second source----
c

      call argi4('-m',isrc2,0,0)

      call argr4('-dt',PickOverride,1.0,1.0)

      pick = (argis('-pick') .gt. 0)
      flat = (argis('-flat') .gt. 0)

      if(le1.eq.0.and.AngleConstant.lt.1.e-20)then

         write(LERR,*)'FATAL: This routine requires input of a time'
         write(LERR,*)'       window over which to operate.  You may'
         write(LERR,*)'       supply this information in a pick file'
         write(LERR,*)'       derived by picking the fairway in xsd '
         write(LERR,*)'       or through a flat file.  A -P or -ROT '
         write(LERR,*)'       option is required.'
         write(LERR,*)'  '
         stop

      endif

      if(.not.pick.and..not.flat.and.AngleConstant.lt.1.e-20)then
         
         write(LERR,*)'FATAL: You must enter -pick or -flat to indicate'
         write(LERR,*)'       format of your input window information'
         write(LERR,*)'       or use -ROT option. '
         stop

      endif

c
c ----angle output range, 0 for 0-360 degree----
c 			  1 for -180-180
c

      call argi4('-a',angopt,0,0)

c
c ----option to generate relation between angle and window length----
c

      analy = (argis('-L') .gt. 0)

      verbos = (argis('-V') .gt. 0)

      IKP = ( argis('-ikp') .gt. 0 )

      return
      end
