C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lestsq(x,y,size,is,ie,slope,binter,sslp)
c     this subroutine finds the slope and b-intercept of 2 input 1-D
c     arrays using the least squares approximation
c     calling this routine will not change the values of x and y
c     
c     ==============================================================
c     x, y: sample arrays
c     size: size of x and y arrays
c     is, ie: start and end indices of arrays for least square fit
c     slope, binter: y=slope*x+binter least square fit
c     sslp: standard deviation of slope
c     ==============================================================

c     nopts: number of points
c     mx, my: sample mean
c     sx, sy: standard deviation
c     sse: sum of squared deviations
c     mse: error mean square

      integer nopts, i, size, is, ie
      real x(size),y(size)
      real slope, binter, mx, my, sx, sy, sslp,sse,mse
      real c1, c2, c3, c4, c5, c6

c     calculating the coefficients
      c1=0.
      c2=0.
      c3=0.
      c4=0.
      c5=0.
      nopts = ie - is + 1
      c6=float(nopts)

      do i=is,ie
        c1=x(i)+c1
        c2=y(i)+c2
        c3=x(i)**2+c3
        c4=y(i)**2+c4
        c5=x(i)*y(i)+c5
      enddo

      if (nopts.gt.2) then
        sse=(c4-c2**2/c6)-(c5-c1*c2/c6)**2/(c3-c1**2/c6)
        mse=sse/(c6-2.)
        sslp=sqrt(mse/(c3-c1**2/c6))
      else
        sslp=5.e10
      endif

      mx=c1/c6
      my=c2/c6
      sx=sqrt(c3/c6-mx**2)
      sy=sqrt(c4/c6-my**2)

      slope=(c5/c6-mx*my)/(sx**2)
      binter=my-slope*mx

      return
      end

