C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rotorls2(TraceHeaders1,TraceHeaders2,
     :     TraceHeaders3,TraceHeaders4,TraceHeaders5,TraceHeaders6,
     :     ntrc,nsampo,nsi,x,y,z,x2,y2,z2,StartTime,
     :     EndTime,JJ,AngleToAdd,AngleConstant,angopt,isrc,isrc2,
     :     ixs,ixe,ixd,verbos,analy,luang,luxgr,
     :     xorig,yorig,xorig2,yorig2,xtmp,ytmp,xtmp2,ytmp2)

#include <f77/iounit.h>

c
c ---- this subroutine is similar to subroutine rotorls
c      but work for multi (two) source case
c      the only difference is that it calls lestsq2
c      and write out two hodograms into each xgraph files
c

c
c ----- variable declaration -----
c
      integer ntrc,nsampo,nsi,JJ, iteration
      integer TraceHeaders1(*), TraceHeaders2(*), TraceHeaders3(*)
      integer TraceHeaders4(*), TraceHeaders5(*), TraceHeaders6(*)
      integer nopts, angopt, isrc, isrc2
      integer luxgr, ixs, ixe, ixd,luang

      real x(nsampo),y(nsampo),z(nsampo),AngleToAdd,AngleConstant
      real x2(nsampo),y2(nsampo),z2(nsampo)
      real xorig(nsampo),yorig(nsampo),xtmp(nsampo),ytmp(nsampo)
      real xorig2(nsampo),yorig2(nsampo),xtmp2(nsampo),ytmp2(nsampo)
      real EndTime(*),StartTime(*),dTime
      real slope, yinter, zinter, sslp, sDegreePhi
      real slopeAnal,yinterAnal,sslpAnal
      real DegAnal(9),sDegAnal(9), windAnal(9)
      real dx,xmin,xmax,xcoord,x2y2max,x2y2max2,x2y2,x2y22,factor

      logical verbos,analy

      integer i,index1,index2,index3,Start,End,EndAnal,ii

      real rad2deg,pi
      real RadianPhi,DegreePhi,CosPhi,SinPhi,xtemp,ytemp
      real RadPhiAnal,CosAnal,SinAnal

      character c_Record*7, c_Src*4, c_Angle*13, c_Time*5
      character c_minus*1, c_Hodogram*9, c_LinearRegression*18
      character c_LinearRegressionSD*22, c_LinearRegression_SD*22
      character c_plus*1, c_weightedLinearRegression*27


c
c ----- initialize variables -----
c

      pi = 3.1415926
      rad2deg = 57.29578
      index1 = 1
      index2 = nsampo+1
      index3 = 2*nsampo+1
      c_Record = '"Record'
      c_Src = ' src'
      c_Angle = ' const angle'
      c_Time = ' Time'
      c_minus = '-'
      c_plus = '+'
      c_hodogram = ' hodogram'
      c_LinearRegression = ' linear regression'
      c_LinearRegressionSD = ' linear regression +sd'
      c_LinearRegression_SD = ' linear regression -sd'
      c_weightedLinearRegression = ' weighted linear regression'
c
c ----- watch out for dead traces -----
c

      IF (       TraceHeaders1(1).eq.30000
     :     .and. TraceHeaders2(1).eq.30000
     :     .and. TraceHeaders3(1).eq.30000
     :     .or.  TraceHeaders4(1).eq.30000
     :     .and. TraceHeaders5(1).eq.30000
     :     .and. TraceHeaders6(1).eq.30000 ) then

         write(LERR,*)' WARNING :All components for record ',JJ,' dead.'
         write(LERR,*)'          Processing of this record is bypassed.'
         write(LERR,*)' '

      ELSEIF(AngleConstant.lt.1.e-30)then
         
c
c ----- do well rotation -----
c

c
c ----- get start and end window in samples for this record -----
c

       Start = nint(StartTime(JJ)/float(nsi))
       End = nint(EndTime(JJ)/float(nsi))

       if(Start.lt.1)Start = 1
       if(End.gt.nsampo)End = nsampo

c
c ---- save original data before rotation ----
c

       if(analy)then
         windAnal(3)=EndTime(JJ)-StartTime(JJ)
         do i=1,nsampo
           xorig(i)=x(i)
           yorig(i)=y(i)
           xorig2(i)=x2(i)
           yorig2(i)=y2(i)
         enddo
       endif

c
c ---- output two hodograms ----
c

        if (JJ.ge.ixs .and. JJ.le.ixe
     :    .and. mod(JJ-ixs,ixd).eq.0) then
          write(luxgr,10) c_Record, JJ, c_Src, isrc, c_Time, 
     :          StartTime(JJ), c_minus, EndTime(JJ),c_Hodogram
 10       format(a7,1x,i10,1x,a4,1x,a10,1x,a5,1x,f13.3,1x,a1,1x,f13.3,
     :         1x,a9)
          do i=Start,End
            write(luxgr,*)x(i),y(i)
          enddo
          write(luxgr,*)' '

          write(luxgr,10) c_Record, JJ, c_Src, isrc2, c_Time, 
     :          StartTime(JJ), c_minus, EndTime(JJ),c_Hodogram
          do i=Start,End
            write(luxgr,*)x2(i),y2(i)
          enddo

c
c ---- x range for plotting least sq fit line
c

          xmax=0.
          xmin=0.
          x2y2max=0.
          x2y2max2=0.
          do i=Start,End
            if(x(i).gt.xmax) xmax = x(i)
            if(x2(i).gt.xmax) xmax = x2(i)
            if(x(i).lt.xmin) xmin = x(i)
            if(x2(i).lt.xmin) xmin = x2(i)

            x2y2=x(i)**2+y(i)**2
            x2y22=x2(i)**2+y2(i)**2
            if(x2y2.gt.x2y2max)x2y2max=x2y2
            if(x2y22.gt.x2y2max2)x2y2max2=x2y22
          enddo

c
c---- normalize the second data sets so that each data set ----
c     will play the same important role in least sq fit
c

          factor=sqrt(x2y2max/x2y2max2)
          do i=Start,End
            x2(i)=x2(i)*factor
            y2(i)=y2(i)*factor
          enddo

          dx=(xmax-xmin)/10.

        endif


c
c ----- rotate twice by least square rotation angle -----
c 
       
       nopts = End - Start + 1 
       DegreePhi = 0.
       do iteration = 1,2
         call lestsq2(x,y,x2,y2,nsampo,Start,End,slope,yinter,sslp)
         RadianPhi = atan(slope)
         if (iteration .eq. 2) then
           RadianPhi = atan(slope) + AngleToAdd/rad2deg
         endif
         DegreePhi = RadianPhi*rad2deg + DegreePhi

c
c ---- the total intercept is not calculated here because ----
c      one set of data is normalized, and there is no
c      absolute scale any more
c

c
c ----- rotate x and y ----
c

         CosPhi = cos(RadianPhi)
         SinPhi = sin(RadianPhi)

         do i = 1,nsampo
           xTemp = x(i)
           yTemp = y(i)
           x(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
           y(i) = (yTemp*CosPhi)-(xTemp*SinPhi)
           xTemp = x2(i)
           yTemp = y2(i)
           x2(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
           y2(i) = (yTemp*CosPhi)-(xTemp*SinPhi)
         enddo
       enddo

c
c ----- standard deviation of rotation angle ----
c

       sDegreePhi=sslp/(1.+slope**2)*rad2deg
       if (sslp.gt.1.e10) sDegreePhi=180.

c
c ---- compute angle, align for x along positive lobe for src 1 ----
c      src 2 should have the same tool orientation
c

       call lestsq(x,z,nsampo,Start,End,slope,zinter,sslp)
       if (slope.lt.0.) then
         DegreePhi = DegreePhi + 180.
         do i = 1,nsampo
           x(i) = 0. - x(i)
           y(i) = 0. - y(i)
           x2(i) = 0. - x2(i)
           y2(i) = 0. - y2(i)
         enddo
       endif

c
c ----- angle range: 0-360 or -180-180 according to angopt ----
c

       if (angopt .eq. 0) then
         if (DegreePhi.le.0.) then
           DegreePhi = DegreePhi + 360.
         elseif (DegreePhi.gt.360.) then
           DegreePhi = DegreePhi - 360.
         endif
       else
         if (DegreePhi.le.-180.) then
           DegreePhi = DegreePhi + 360.
         elseif (DegreePhi.gt.180.) then
            DegreePhi = DegreePhi - 360.
         endif
       endif

c
c ---- window length vs. rot angle analysis               ----
c      calculate the rotation angle and it standard deviation
c      as a function of window length and record number
c      output an ascii file
c      the window length being analyzed are
c      len0/3*i where i=1,2,...,9 where len0 is the original
c      window length
c

       if(analy)then

c
c ---- the window length and corresponding rot angle that ----
c      has been calculated above

         DegAnal(3)=DegreePhi
         sDegAnal(3)=sDegreePhi

         dTime=(EndTime(JJ)-StartTime(JJ))/3.

c
c ---- for each window length, copy back original data before ----
c      rotation, calculate the rotation angle and std deviation
c

         do ii=1,9
           EndAnal = Start+nint(dTime*float(ii)/float(nsi)) 
           if(EndAnal.gt.nsampo)EndAnal=nsampo
           if(EndAnal.lt.1)EndAnal=1

           if(ii.ne.3)then
             windAnal(ii)=(EndAnal-Start)*float(nsi)

             do i=Start,EndAnal
               xtmp(i)=xorig(i)
               ytmp(i)=yorig(i)
               xtmp2(i)=xorig2(i)
               ytmp2(i)=yorig2(i)
             enddo

c
c ---- the angle calculation method is the same as above ----
c      except that the rotation is not needed for the 2nd run
c

             DegAnal(ii)=0.
             do iteration=1,2
               call lestsq2(xtmp,ytmp,xtmp2,ytmp2,nsampo,Start,
     :                 EndAnal,slopeAnal,yinterAnal,sslpAnal)
               RadPhiAnal=atan(slopeAnal)
               if (iteration .eq. 2) then
                 RadPhiAnal = atan(slopeAnal) + AngleToAdd/rad2deg
               endif
               DegAnal(ii) = RadPhiAnal*rad2deg + DegAnal(ii)

               if(iteration.eq.1)then
                 CosAnal=cos(RadPhiAnal)
                 SinAnal=sin(RadPhiAnal)
                 do i=Start,EndAnal
                   xTemp=xtmp(i)
                   yTemp=ytmp(i)
                   xtmp(i)=(xTemp*CosAnal)+(yTemp*SinAnal)
                   ytmp(i)=(yTemp*CosAnal)-(xTemp*SinAnal)
                   xTemp=xtmp2(i)
                   yTemp=ytmp2(i)
                   xtmp2(i)=(xTemp*CosAnal)+(yTemp*SinAnal)
                   ytmp2(i)=(yTemp*CosAnal)-(xTemp*SinAnal)
                 enddo
               endif
             enddo


c
c ----- standard deviation of rotation angle sDegAnal array ----
c       caculated from std deviation of the slope sslpAnal
c

             sDegAnal(ii)=sslpAnal/(1.+slopeAnal**2)*rad2deg
             if(sslpAnal.gt.1.e10) sDegAnal(ii)=180.

c
c ----- compute angle and align for x along positive lobe -----
c
           
             call lestsq(xtmp,z,nsampo,Start,EndAnal,
     :           slopeAnal,zinter,sslpAnal)
             if (slopeAnal.lt.0.) then
               DegAnal(ii) = DegAnal(ii) + 180.
             endif

c
c ----- angle range: 0-360 or -180-180 according to angopt ----
c

             if (angopt .eq. 0) then
               if (DegAnal(ii).le.0.) then
                 DegAnal(ii) = DegAnal(ii) + 360.
               elseif (DegAnal(ii).gt.360.) then
                 DegAnal(ii) = DegAnal(ii) - 360.
               endif
             else
               if (DegAnal(ii).le.-180.) then
                 DegAnal(ii) = DegAnal(ii) + 360.
               elseif (DegAnal(ii).gt.180.) then
                  DegAnal(ii) = DegAnal(ii) - 360.
               endif
             endif

           endif

c
c ---- write window length vs. angle pairs to the ascii file ----
c
    
           write(luang,*)JJ,windAnal(ii),DegAnal(ii),sDegAnal(ii)
         enddo
       endif

c
c ---- output linear regression line to the xgraph files that ----  
c      contain the hodogram
c

        if (JJ.ge.ixs .and. JJ.le.ixe
     :    .and. mod(JJ-ixs,ixd).eq.0) then
          write(luxgr,*)' '
          write(luxgr,20) c_Record, JJ, c_Src, isrc, c_plus, isrc2, 
     :         c_weightedLinearRegression
 20       format(a7,1x,i10,1x,a4,1x,i10,1x,a1,1x,i10,1x,a27)

          do i=0,10
           xcoord=xmin+real(i)*dx
           write(luxgr,*)xcoord,
     :       tan(DegreePhi/rad2deg)*xcoord
          enddo

c 
c ---- output the linear regression fit plus the std deviation ----
c

          write(luxgr,*)' '
          write(luxgr,30) c_Record, JJ, c_Src, isrc, 
     :         c_LinearRegressionSD
 30       format(a7,1x,i10,1x,a4,1x,i10,1x,a22)

          do i=0,10
           xcoord=xmin+real(i)*dx
           write(luxgr,*)xcoord,
     :       tan((DegreePhi+sDegreePhi)/rad2deg)*xcoord
          enddo

          write(luxgr,*)' '
          write(luxgr,30)c_Record, JJ, c_Src, isrc, 
     :         c_LinearRegression_SD

c 
c ---- output the linear regression fit minus the std deviation ----
c

          do i=0,10
           xcoord=xmin+real(i)*dx
           write(luxgr,*)xcoord,
     :       tan((DegreePhi-sDegreePhi)/rad2deg)*xcoord 
          enddo
        endif

c
c---- remove the normalization factor -----
c

       do i=Start,End
         x2(i)=x2(i)/factor
         y2(i)=y2(i)/factor
       enddo

c
c ---- if verbos, output the record, rotangle, 		----
c      and rotangle std deviation pairs
c

       if(verbos.and.AngleConstant.lt.1.e-20)then
         write(LERR,40)JJ,DegreePhi,sDegreePhi
       endif
 40    format(i5,3x,f6.1,3x,f6.1)


      ELSE


c
c ----- constant rotation of AngleConstant input by user -----
c       required only.  No calculation of angle based
c       on input data is desired
c


c
c ---- write out hodogram to xgraph files
c

        if (JJ.ge.ixs .and. JJ.le.ixe
     :    .and. mod(JJ-ixs,ixd).eq.0) then
          write(luxgr,10)c_Record, JJ, c_Src, isrc, c_Time,
     :          StartTime(JJ), c_minus, EndTime(JJ),c_Hodogram
          do i=Start,End 
            write(luxgr,*)x(i),y(i) 
          enddo 

          write(luxgr,*)' '
          write(luxgr,10)c_Record, JJ, c_Src, isrc2, c_Time,
     :          StartTime(JJ), c_minus, EndTime(JJ),c_Hodogram
          do i=Start,End 
            write(luxgr,*)x2(i),y2(i) 
          enddo 

c
c ---- x range for plotting the rotation direction ----
c

          xmin=0.
          xmax=0.
          do i=Start,End
            if(x(i).gt.xmax) xmax = x(i)
            if(x2(i).gt.xmax) xmax = x2(i)
            if(x(i).lt.xmin) xmin = x(i)
            if(x2(i).lt.xmin) xmin = x2(i)
          enddo
          dx=(xmax-xmin)/10.

         endif

         DegreePhi = AngleConstant
         RadianPhi = AngleConstant/rad2deg

c
c ----- rotate x and y -----
c

         CosPhi = cos(RadianPhi)
         SinPhi = sin(RadianPhi)

         do i = 1,nsampo

            xTemp = x(i)
            yTemp = y(i)
            x(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
            y(i) = (xTemp*SinPhi)+(yTemp*CosPhi)
            xTemp = x2(i)
            yTemp = y2(i)
            x2(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
            y2(i) = (xTemp*SinPhi)+(yTemp*CosPhi)

         enddo

c
c ---- write the rotation direction line into the xgraph files ----
c

        if (JJ.ge.ixs .and. JJ.le.ixe
     :    .and. mod(JJ-ixs,ixd).eq.0) then
          write(luxgr,*)' '
          write(luxgr,100) c_Record, JJ, c_Src, isrc, c_plus, isrc2, 
     :         c_Angle, DegreePhi
 100      format(a7,1x,i10,1x,a4,1x,i10,1x,a1,1x,i10,1x,a13,1x,f13.3)

          do i=0,10
           xcoord=xmin+real(i)*dx
           write(luxgr,*)xcoord,tan(RadianPhi)*xcoord
          enddo
        endif

      ENDIF

      return
      end


