C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************
c
c usp_aqp  reads data from usp line headers and trace headers, and
c          writes aqplot plotfiles.
c
c**********************************************************************
c
c USP system includes
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#ifdef SUNSYSTEM
      implicit   none
#endif

      character name*100
      character infile*100
c
c    USP dataset dimensions, variables
c
      integer numsmp, numtrc, numrec, ns, irs
      integer ifmt_NumCmp, l_NumCmp, ln_NumCmp, numcmp
      integer ifmt_MCList, l_MCList, ln_MCList

      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc, srcloc
      integer ifmt_LinInd, l_LinInd, ln_LinInd, linind
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, srptxc
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, srptyc
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, rcptxc
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, rcptyc
      integer ifmt_SrXAzm, l_SrXAzm, ln_SrXAzm, srxazm
      integer ifmt_RcXAzm, l_RcXAzm, ln_RcXAzm, rcxazm
*      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm, soptnm
      integer ifmt_RecInd, l_RecInd, ln_RecInd, recind
      integer ifmt_MCLE(16), l_MCLE(16), ln_MCLE(16)

      real dt
c
c    Space for a line header
c
      integer lheader(SZLNHD)
      integer lhedlength, trlength, trdataoff
      integer itrace
c
c    Function subroutines
c
      integer argis, nblen, usprtrace, uspclose
c      integer uspseek
      character   getname * 100

      integer ierr, iabort
c
      integer jerr
c
c    Data trace (plus header)
c
      real        trace
      pointer     (ptrace, trace(2))
c
c    uspio argument declarations
c
      character mode*100
      character clparam*100
      character wclparam*100
      integer   ierror, maxfile, maxcomp
      integer   pt
      integer   dptw
      integer   ikpsock
      integer   seekalot, seekstat
      integer   incon

*     usp_aqp declarations 

      character*6    mcmnem
      character*255  srcaqp, rcvaqp

      integer        lusrc, lurcv, length
      integer        icmp
      integer        srccmp, rcvcmp
      integer        mcle(16), nsrcc, srcclst(3), nrcvc, rcvclst(3)
      integer        srclist(10000), rcvlist(10000), nsrc, nrcv

      logical        verbos

      real           sazmth, razmth, azmth0
      real           sxmin, sxmax, symin, symax
      real           rxmin, rxmax, rymin, rymax

      data           srxazm, rcxazm, mcle, azmth0/ 
     &                900  ,  900  , 16*0, 90.0/
**********************************************************************
#include <f77/open.h>

      name = getname()
c*********************************************************************
c
c    Self-doc

      if ( argis ( '-?' ) .gt. 0 .or. 
     &     argis ( '-h' ) .gt. 0 .or.
     1     argis ( '-H' ) .gt. 0     ) call help

*********************************************************************
*     get command line arguments

      call cmdln(verbos)

*********************************************************************
c
c    uspioinit initializes the "uspinfo" structure used by the uspio
c    library. To allocate enough space, uspioinit needs to know the
c    maximum number of seismic files and the maximum number of
c    components to allow for. For scalar I/O, maxcomp is 1.

      maxfile = 1
      maxcomp = 1
      call uspioinit(name, maxfile, maxcomp)
      write(LERR,*) 'uspio initialized'

c**********************************************************************
c
c    uspsinput: "USP Scalar Input"
c
c**********************************************************************
c
c    Description of INPUT arguments to uspsinput
c
c**********************************************************************
c
c mode (read / write mode):
c 'r'   open an already existing file for reading only
c 'rw'  open an already existing file for reading and writing
c 'ra'  open an already existing file for reading, writing, and
c       appending. Output will start at the end of the file
c       (although nothing will prevent you from seeking back to the
c       beginning and overwriting the original traces if you wish!).

      mode = 'r'

c clparam ("Input file name command line parameter"): this string
c is appended to '-N' and looked for on the command line to find
c an input file name for this input. If clparam is whitespace,
c then uspinput will look for '-N' (as is usual practice for scalar
c USP programs that only need a single input). If instead clparam
c were, say, '1', then uspinput would look for '-N1' on the command
c line.
c
c If an input file name is specified, then uspinput will attempt
c to open that file for input.
c
c If no input file name is specified on the command line, the place
c uspinput next looks depends on whether the program is running
c under IKP or not. If not in IKP, the only possible fallback is to
c standard input. If in IKP, the fallback is to the "IKP single input"
c socket number specified by the argument "ikpsock" (this is quite
c likely 0, meaning standard input, but doesn't have to be).
c
c If you specify the same "clparam" for different inputs, uspinput
c will check the command line for repeated occurrences of the same
c argument. (For example, "-N file1 -N file2 -N file3".) Note this is
c very different from the behavior for "wclparam" (see below).

      clparam = ' '

c wclparam ("Windowing command line parameter"): This string is appended
c to '-ns', '-ne', '-rs', '-re', '-wi', and '-pt' and the result looked
c for on the command line to determine how to "window" the data. If
c wclparam is entirely whitespace you'll get the usual USP defaults.
c
c '-ns' and '-ne' are the standard start-trace, end-trace in a gather
c parameters; '-rs' and '-re' are the standard start-gather, end-gather
c in a line parameters.
c
c '-pt', if present, specifies that traces outside the window should
c be passed through; '-wi', if present, specifies that traces outside
c the window should be discarded.
c
c If you specify the same wclparam for multiple input files, uspinput
c will only look for the associated windowing parameters on the command
c line ONCE. After that it will re-use whatever values it found before.
c (The idea is that if you specify one '-rs', say, you'll want it to
c apply to ALL the associated '-N' input files, no matter how many
c there happen to have been.)

      wclparam = ' '

c dptw ("default pass through or window"): In the absence of anything
c to the contrary on the command line, 0 means DON'T pass through
c unused data, 1 means DO pass it through unchanged.
c '-wi(wclparam suffix)' on the command line overrides, and means
c to truncate anyway. '-pt(wclparam suffix)' overrides, and means
c to pass through anyway. If dptw is -1, that means don't even LOOK
c on the command line for any windowing parameters; the user program
c wants to handle ALL windowing / pass-through etc details for this
c file for itself.

      dptw = 0

c ikpsock is the ikp socket number to look for a single input on.
c Usually ikpsock will be 0, meaning standard input. (You are asked
c to specify ikpsock because you might want to have multiple inputs
c in ikpsock; at most one of those could be from standard input.)

      ikpsock = 0

c seekalot guides uspinput in deciding how to buffer the data.
c A value of 0 means "this program will mostly plod through the data
c reading in order (alternated perhaps with passes through the data
c writing in order)". A value of 1 means "this program will jump around
c within a gather a lot, but not often between different gathers". If
c the program is going to furiously alternate reading and writing
c nearby traces (for example, read a trace, write it back out, read
c the next trace, write it back out, etc) that also counts as 1.
c If the program will jump at random all over the data, even between
c different gathers and lines, then seekalot should be 2.

      seekalot = 0

      ierror = 0

      call uspsinput(mode, clparam, wclparam, 
     1      dptw, ikpsock, seekalot, seekstat,
     1      numsmp, numtrc, numrec, dt, ns, irs, pt,
     1      lheader, lhedlength, trlength, trdataoff, infile,
     1      incon, ierror)

*     open, check aqp output files
 80   format(1a80)
      srcaqp = infile
      length = nblen(infile)
      srcaqp(length+1:length+5)='.saqp'
      call alloclun(lusrc)
      open (lusrc, file=srcaqp(1:length+5),status='new',err=910)
      if (verbos) write(LER ,82)  srcaqp
      write(LERR,82)  srcaqp
 82   format(/' Source aqp output: ',a80)
      rewind(lusrc)

      rcvaqp = infile
      rcvaqp(length+1:length+5)='.raqp'
      call alloclun(lurcv)
      open (lurcv, file=rcvaqp(1:length+5),status='new',err=920)
      if (verbos) write(LER ,86)  rcvaqp
      write(LERR,86)  rcvaqp
 86   format(/' Receiver aqp output: ',a80)
      rewind(lurcv)

c**********************************************************************
c
c    Description of OUTPUT arguments of uspsinput
c
c**********************************************************************
c
c numsmp, numtrc, numrec, dt specify the dimensions of the dataset:
c
c  numsmp = number of samples in a trace (NumSmp),
c  numtrc = number of traces in a gather (NumTrc)
c  numrec = number of gathers in a line  (NumRec)
c
c  dt = sampling rate, in FLOATING-POINT SECONDS.
c       (uspinput / uspouput handle the conversion between
c       the sample rate stored as an integer in the usp line header
c       keyword 'SmpInt', and the floating-point number that most
c       programs that actually USE the sample rate as a physically
c       meaningful unit demand.)
c

c
c ns and irs return the trace number and gather number, respectively,
c of the first trace the user program sees. (These are not from any
c header; they are simply counted from the beginning of the file,
c starting with 1, 2, 3, etc.) Your program may need this information
c to modify values from the line header specifying things like initial
c trace offsets, etc. (They may no longer be what you expect after
c windowing.)
c
c
c pt tells your program whether the output will be windowed (0) or
c passed through (1). The user program may need to know this for
c modifying values in an outgoing line header. (The standard
c USP dimensional line-header keywords "NumTrc" and "NumRec" will
c automatically be set appropriately by "uspoutput".)
c
c
c lheader is the line header for this input.
c
c
c lhedlength is the length in bytes of this line header.
c
c
c trlength is the length in full words (floats) of a single trace,
c including the trace header. You'll need to allocate
c trlength * SZSMPD bytes to store a trace.
c
      iabort = 1
      call galloc (ptrace, trlength * SZSMPD,
     1                    ierr, iabort)
c
c trdataoff is the offset in full words (floats) from the start of
c the trace to the start of the trace data. (In other words, it's
c the trace header length.)
c
c For now this will always be ITRWRD, but if you write your code
c to use trdataoff then it will not have to be changed if we switch
c to variable-length trace headers later on, which is quite likely.
c
c
c incon is the "connection number", the number you'll have to use
c to refer to this connection later on. (It's like a sisio logical
c unit number, but not the same. It starts at 1 for the first
c connection, and counts up.)
c
c
c ierror will be incremented once for each error that was found.
c Unless ierror is zero this input cannot be used, and attempting
c to do so will result in an error.
c
**********************************************************************

*     interpret MCList
      icmp = 0
      nsrcc = 0
      nrcvc = 0
1100  icmp = icmp + 1
      if (icmp .le. 9) then
         mcmnem(1:5) = 'MCLE0'
         write(mcmnem(6:6),'(i1)') icmp
      else
         if (icmp .gt. 16) then
            numcmp = 16
            go to 1150
         endif
         mcmnem(1:5) = 'MCLE'
         write(mcmnem(6:6),'(i2)') icmp
      endif
      call savelu(mcmnem,ifmt_MCLE(icmp),l_MCLE(icmp),
     &            ln_MCLE(icmp),LINEHEADER)
      call saver2(lheader, ifmt_MCLE(icmp), l_MCLE(icmp),
     &            ln_MCLE(icmp), mcle(icmp), LINEHEADER)
      if (mcle(icmp) .eq. 0) then
         if (icmp .eq. 1) then
            write (LER,1105)
            write (LERR,1105)
 1105       format(' MCList is empty.  I assume vertical components.')
            mcle(1) = 33
            numcmp = 1
            srcclst(1) = 3
            nsrcc = 1
            rcvclst(1) = 3
            nrcvc = 1
            go to 1150
         endif
         numcmp = icmp -1
         go to 1150
      endif

      rcvcmp = mod(mcle(icmp),10)
      srccmp = (mcle(icmp)-rcvcmp)/10
      call chkpt(srcclst, nsrcc, srccmp, *1120)
 1120 call chkpt(rcvclst, nrcvc, rcvcmp, *1100)
      go to 1100

 1150 write(LERR,1155) (mcle(icmp), icmp = 1, numcmp)
 1155 format(' MCList elements:',16I3)
      write(LERR,1165) (srcclst(icmp), icmp = 1, nsrcc)
 1165 format(' source elements:',3I3)
      write(LERR,1175) (rcvclst(icmp), icmp = 1, nrcvc)
 1175 format(' recever elements:',3I3)

**********************************************************************
*     get line header offsets
*     args:       mnemonic, type,      offset,   count,    buffer
      call savelu('NumCmp',ifmt_NumCmp,l_NumCmp,ln_NumCmp,LINEHEADER)
      call savelu('MCList',ifmt_MCList,l_MCList,ln_MCList,LINEHEADER)

**********************************************************************
*  get trace header offsets
*     args:       mnemonic, type,      offset,   count,    buffer

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      call savelu('SrXAzm',ifmt_SrXAzm,l_SrXAzm,ln_SrXAzm,TRACEHEADER)
      call savelu('RcXAzm',ifmt_RcXAzm,l_RcXAzm,ln_RcXAzm,TRACEHEADER)

*      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)

***********************************************************************
*     prepare to write src, rcv tapes
      rewind (lusrc)
      rewind (lurcv)
      nsrc = 0
      nrcv = 0
      sxmin = 1.0e27
      sxmax = -sxmin
      rxmin = sxmin
      rxmax = sxmax
      symin = 1.0e27
      symax = -symin
      rymin = symin
      rymax = symax
      write(lusrc, 4005)  sxmin, sxmax, symin, symax, azmth0
      write(lurcv, 4005)  sxmin, sxmax, symin, symax, azmth0
**********************************************************************
*     do for every trace

 3000 do 3099 itrace = 1, numtrc * numrec
* 3000 do 3099 itrace = 1, 5

c     Arguments to usprtrace:
c
c**********************************************************************
c
c     The first argument is the integer connection number that you
c     got back from either uspinput or uspoutput.
c
c     The second argument is the trace array for it to read from or
c     write to.
c
c     The third argument is the DIMENSIONED length of the trace.
c     If the trace it reads is too long to fit, you will get an error
c     message instead of a memory overrun and possibly a core dump.
c     In this example, since we allocated the trace to be just long
c     enough, the length is just trlength.
c
c     The return value is:
c
c     0: everything OK
c    -1: something very bad
c     1: you just went off the end of the data
c

         if (usprtrace(incon, trace, trlength) .ne. 0) then
            write (LER , *) 'Could not read trace ', itrace
            go to 3099
         endif
***********************************************************************
*         call saver2(trace,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
*     1               soptnm , TRACEHEADER)
         call saver2(trace,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1               srcloc , TRACEHEADER)

*        if this source point has already been written, skip it
         call chkpt(srclist, nsrc, srcloc, *3050)
         write(LERR,*) ' S ',nsrc, srcloc,(srclist(icmp), icmp=1,nsrc)
         call saver2(trace,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               srptxc , TRACEHEADER)
         call saver2(trace,ifmt_SrPtYc,l_SrPtYc, ln_SrPtYc,
     1               srptyc , TRACEHEADER)

         if (srptxc .gt. sxmax) sxmax = srptxc
         if (srptxc .lt. sxmin) sxmin = srptxc
         if (srptyc .gt. symax) symax = srptyc
         if (srptyc .lt. symin) symin = srptyc

*        assume that all listed components are present at every point
         call saver2(trace,ifmt_SrXAzm,l_SrXAzm, ln_SrXAzm,
     1               srxazm , TRACEHEADER)
         sazmth = srxazm / 10.0
         do icmp = 1, nsrcc
            srccmp = srcclst(icmp)
            if (srccmp .eq. 1) then
*              remember that aqplot assumes eastings, southings!
               write(lusrc,3025) 'S', srcloc, srptxc, -srptyc, sazmth, 
     &                           1, 0, sazmth
 3025          format(1a1, i9, 2i10, f10.1, 3x,
     &                2i6,f10.1)
            elseif (srccmp .eq. 2) then
               write(lusrc,3025) 'S', srcloc,srptxc, -srptyc,sazmth+90, 
     &                           1, 0, sazmth
            elseif (srccmp .eq. 3) then
               write(lusrc,3027) 'S', srcloc, srptxc, -srptyc,
     &                           1, 0, sazmth
 3027          format(1a1, i9, 2i10, '     Z    ',3x,
     &                2i6,f10.1)
            endif
         enddo

***********************************************************************
 3050    call saver2(trace,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               recind , TRACEHEADER)

*        if this receiver point has already been written, skip it
         call chkpt(rcvlist, nrcv, recind, *3099)

         call saver2(trace,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               linind, TRACEHEADER)
          call saver2(trace,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                rcptxc , TRACEHEADER)
          call saver2(trace,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                rcptyc , TRACEHEADER)

         if (rcptxc .gt. rxmax) rxmax = rcptxc
         if (rcptxc .lt. rxmin) rxmin = rcptxc
         if (rcptyc .gt. rymax) rymax = rcptyc
         if (rcptyc .lt. rymin) rymin = rcptyc

*     assume that all listed components are present at every point
          call saver2(trace,ifmt_RcXAzm,l_RcXAzm, ln_RcXAzm,
     1                rcxazm , TRACEHEADER)
         razmth = rcxazm / 10.0
         do icmp = 1, nrcvc
            rcvcmp = rcvclst(icmp)
            if (rcvcmp .eq. 1) then
*              remember that aqplot assumes eastings, southings!
               write(lurcv,3025) 'R', recind, rcptxc, -rcptyc, razmth, 
     &                           1, 0, razmth
            elseif (rcvcmp .eq. 2) then
               write(lurcv,3025) 'R', recind,rcptxc, -rcptyc,razmth+90, 
     &                           1, 0, razmth
            elseif (rcvcmp .eq. 3) then
               write(lurcv,3027) 'R', recind, rcptxc, -rcptyc,
     &                           1, 0, razmth
            endif
         enddo

 3099 enddo
*     end of trace loop

 4000 continue
      endfile(lusrc)
      rewind (lusrc)
*              remember that aqplot assumes eastings, southings!
      write(LERR, 4005)  sxmin, sxmax, -symax, -symin, azmth0
 4005 format('INIT', 5f10.1)
      write(lusrc,4005)  sxmin, sxmax, -symax, -symin, azmth0
      call skip(lusrc, nsrc*nsrcc)
      endfile(lusrc)

      endfile(lurcv)
      rewind (lurcv)
      write(LERR, 4005)  rxmin, rxmax, -rymax, -rymin, azmth0
      write(lurcv,4005)  rxmin, rxmax, -rymax, -rymin, azmth0
      call skip(lurcv, nrcv*nrcvc)
      endfile(lurcv)

c    Finally, make SURE to call uspclose to close your connections
c    before exiting. Some of your data may end up missing if you forget
c    to do this.
c

      if (uspclose(incon)) then
          write (LER , *) 'Trouble closing input.'
      endif

      write( LERR, * ) ' '
      write( LERR, * ) ' Normal end of usp_aqp.'
      write( LERR, * ) ' Processed ', nsrc,' shots locations, and'
      write( LERR, * )   nrcv, ' groups, with ', numcmp,
     &                   ' components each.'
      write( LERR, * ) ' '
      write( LER, * ) ' '
      write( LERR, * ) ' Normal Termination'
      write( LER, * ) ' Normal Termination'

      stop     

***********************************************************************
*     tape errors

 910  write(LER,915) srcaqp
      write(LERR,915) srcaqp
 915  format(/' APS_USP: Error opening aqp source file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
 920  write(LER,925) rcvaqp
      write(LERR,925) rcvaqp
 925  format(/' APS_USP: Error opening aqp receiver file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
      end
*********************************************************************
**********************************************************************
***********************************************************************
***********************************************************************
      subroutine chkpt(list, nlist, number,*)

*     assembles list of points already treated

      integer        list(*), nlist, number, ilist

      if (nlist .eq. 0) then
         list(1) = number
         nlist = 1
      else
         do ilist = 1, nlist
            if (list(ilist) .eq. number) return 1
         enddo
*        ilist is now nlist + 1
         nlist = ilist
         list(nlist) = number

         return
      endif

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine skip (lu, nskip)
*     skips records

 100  do 109 i=1,nskip
         read(lu,*)
 109  enddo

      return
      end


