C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine velsmp (nsamp,ntrc,nvel,pi,po,dhold,shold,dt,
     1                   vmin,vinc,V0, zz, iz, icinit)

#include <f77/lhdrsz.h>

      real    dhold (nsamp, ntrc)
      real    shold (nsamp, nvel)
      real    pi (ntrc)
      real    po (nvel)
      real    zz (*)
      integer iz (*)
      real    work1 (SZLNHD)
      real    work2 (SZLNHD)

      v02 = V0 * V0

      DO  i = 1, nsamp

          ti = float(i) * dt

          do  j = 1, ntrc

              work1 (j) = dhold (i,j)
          enddo

          do  k = 1, nvel

              vk  = vmin + float(k-1)*vinc
              vk2 = vk * vk
              po (k) = ti * vk2 / v02
          enddo

          call vclr (work2, 1, nvel)
          call fcuint (pi, work1, ntrc, po, work2, nvel,
     1                 iz, zz, icinit)
          icinit = 1

          do  j = 1, nvel

              shold (i,j) = work2 (j)
          enddo

      ENDDO

      return
      end
