C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine semb_clean(x,lx,lt,cossq,lcos)
      real x(lt,lx),cossq(lcos)
      real work(4000)

      ndo=lt/4
      do i=1,ndo
       x(i,lx)=0.001
      end do
      do j=1,lx
       do i=1,ndo
        if(x(i,j).eq.1.0.and.x(i+1,j).eq.1.0)then
         x(i,j)=0.0
        endif
        if(x(i,j).eq.1.0.and.x(i+1,j).ne.1.0)then
         x(i,j)=0.001
        endif
       end do
      end do
      lcos2=lcos/2
      do i=1,lx
       do j=1,lcos2
        work(j)=0.
       end do
       call vmov(x(1,i),1,work(lcos2),1,lt)
       call conv(work,1,cossq(lcos),-1,x(1,i),1,lt,lcos,1)
      end do
      xmax = 0.
      do j=1,lx
       do i=1,lt
        if(x(i,j).gt.xmax)xmax = x(i,j)
       end do
      end do
      if(xmax.ne.0.0)then
       scal = .95/xmax
      do j=1,lx
       do i=1,lt
         x(i,j)=x(i,j)*scal
       end do
      end do
      end if
      return
      end
