C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  Program to demultiplex the output of program opstf, which writes  |
C |  its scan and semblances traces in the order of scan, sembl, etc.  |
C |                                                                    |
C |   CODED BY R. CRIDER  1/92  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      integer maxsmp
      parameter (maxsmp = 3000)
      CHARACTER PARR*26
      CHARACTER NAME*5,TITLE(66)*1
C
      INTEGER   ITR(6128)
      INTEGER   argis
      integer   trhdi2(1)
      integer   trhdi4(1),pipe
C
      character ntap*256, otap*256, stap*256
C
      logical open, there,IKP,sopen
C
      EQUIVALENCE (itr,trhdi2,trhdi4)
C
      DATA NAME/'OPSTD'/,OPEN/.FALSE./,pipe/3/
      DATA PARR/'OPTICAL STACK RE-MULTIPLEX'/
      DATA TITLE/66*' '/

      ipr = LERR
      wrknt = 0
C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         call ccexit(0)
      endif
      J=20
      DO I=1,26
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
       ntap = ' '
       otap = ' '
       stap = ' '
      call gcmdln(ntap,otap,stap,IKP)

C
      if(ntap.ne.' ')then
      there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LERR,*)'Requested scan data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      sopen = .true.
      if(stap.ne.' ')then
       there=.false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LERR,*)'Requested semblance data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      if(.not.IKP .and. (ntap.eq.' '.or.stap.eq.' '))then
        write(LERR,*)'Scan and Semblance data sets are required'
        stop
      endif
      CALL GAMOCO(TITLE,1,IPR)
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
      CALL openr2(lusemb,itr,lbytes,nsamps,nsrs,ntrcs,nrcds,
     :stap,LERR,pipe,IKP)
      if(lusemb.lt.0)then
       write(LERR,*)'Semblance data set is required. Fatal error.'
       stop 100
      endif
      CALL openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :LERR,ithree,unitsc)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      sr=FLOAT(NSR)/1000.
      mbytes = (nsamp + itrwrd)*ISZBYT
      nrecc = nrcd
      call savew(itr,'NumRec',nrecc,LINHED)
      ntro = ntrc*2
      nn = ntro
      call savew(itr,'NumTrc',ntro, LINHED)
C      +----------------------+
*      |   WRITE LINE HEADER  |
C      +----------------------+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
      CALL openw(LUOUT,ITR,LBYTES,NRECC,nn,OPEN,otap,LERR,ithree)
      call prparm(ntap,otap,stap,LERR)
C +-------------------------------------------+
C | FIND AND READ FIRST TRACE OF FIRST RECORD |
C +-------------------------------------------+
      IREAD=0
      mbytes = (nsamp+ITRWRD)*ISZBYT
  306 CONTINUE
      iout=0
      irec = 0
      DO 101 NX = 1,ntrc
        nbytes = 0
        CALL RTAPE(LUIN,ITR,nbytes)
        IF(nbytes .EQ. 0) THEN
         GO TO 999
        ENDIF
        iout=iout+1
c       trhdi2(l_TrcNum)=iout
        call savew2(trhdi2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              iout , TRACEHEADER)
        call wrtape(luout,itr,mbytes)
        call rtape(lusemb,itr,nbytes)
        if(nbytes.eq.0)then
          write(LERR,*)'Found EOF on semblance file after record ',irec
          go to 999
        end if
        iout=iout+1
c       trhdi2(l_TrcNum)=iout
        call savew2(trhdi2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              iout , TRACEHEADER)
        call wrtape(luout,itr,mbytes)
  101 CONTINUE
      go to 306
  999 CONTINUE
      CALL LBCLOS( LUIN)
      CALL LBCLOS(LUOUT)
      CALL LBCLOS(lusemb)
      stop
      END

      subroutine openw(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,otap,ipr,ithree)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  LINE HEADER BUFFER                                *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    MODE  - I*4  -  MODE OF PROCESSING                                *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TP'S PER ANALYSIS. NUMBER OF TRACES     *
*                    PER RECORD OUTPUT IF ANALYSIS MODE.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *
      INTEGER   ITR(*)
      character otap*256
      LOGICAL OPEN

      LINHED = 0
      if(otap.ne.' ')then
       call lbopen(luout,otap, 'w')
      else
       luout = 1
      endif
      lby = 0
      OPEN=.TRUE.
      call savew(itr,'Format',3,LINHED)
      call savew(itr, 'NumTrc', NP,   LINHED)
      call savew(itr,'NumRec',nrecc,linhed)
      call savew(itr,'MnLnIn',ithree,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END

      subroutine gcmdln(ntap,otap,stap,IKP)
C
      integer argis
      logical IKP
C
      character ntap*256, otap*256,stap*256

	  ntap = ' '
      call argstr ('-N1',ntap,' ',' ')          
      stap= ' '
      call argstr ('-N2',stap,' ',' ')
      otap = ' '
      call argstr ('-O',otap,' ',' ')            
      IKP = (argis('-IKP').gt.0)
      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'****************************************************************'
      write(LER,*)'Program OPSTDI............Optical Stack Re-Multiplex'
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N1 [ntap]   (Default = stdin)   : Input Scan data'   
      write(LER,*)                                           
     :' -N2 [stap]   (No default)        : Input Semblance data'
      write(LER,*)                                               
     :' -O [otap]    (Default = stdout)  : Output scan data'
      write(LER,*)                                        
     :'Usage:  ',                                         
     :' opstdi -N1[ntap] -N2[stap] -O[otap]'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            

      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :IPR,ithree,unitsc)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
*  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
*  ONLY.                                                               *
*  INPUT:                                                              *
*    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*  OUTPUT:                                                             *
*   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
*    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
*    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
*    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
*    V0    - R*4  -  Velocity of the medium                            *
*    NP    - I*4  -  Number of Tp's                                    *
*    PMIN  - R*4  -  Minimum Tp                                        *
*    PMAX  - R*4  -  MAXIMUM Tp                                        *
*                                                                      *
* ******************************************************************** *
      integer maxsmp
      parameter (maxsmp = 3000)
      INTEGER   ITR(*)
      CHARACTER NAME*5, ntap*256

      if(ntap.ne.' ')then
        call lbopen(luin, ntap, 'r')
      else
        luin = 0
      endif
      LINHED=0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=5
      call hlhprt(itr,lbytes,name,ifour,IPR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', ntrc,   LINHED)
      call saver(itr, 'MnLnIn', ithree, LINHED)
      if(iabs(ithree).ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to use it.'
        call ccexit(100)
      endif
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
C
      RETURN
      END
      subroutine openr2(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,
     :ntap,IPR,pipe,IKP)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
*  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
*  ONLY.                                                               *
*  INPUT:                                                              *
*    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*  OUTPUT:                                                             *
*   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
*    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
*    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
*    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
*                                                                      *
* ******************************************************************** *
      integer maxsmp
      parameter (maxsmp = 3000)
      INTEGER   itr(*),pipe
      logical IKP
      CHARACTER ntap*256

      if(ntap(1:1).ne.' '.and..not.IKP)then
        call lbopen(luin, ntap, 'r')
      elseif(ntap(1:1).eq.' '.and. IKP)then
       call sisfdfit(luin,pipe)
      else
        luin = -1
      endif
      LINHED=0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumTrc', ntrc,  LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'MnLnIn', ithree, LINHED)
      if(iabs(ithree).ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to use it.'
        call ccexit(100)
      endif
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
C
      RETURN
      END

      SUBROUTINE prparm(ntap,otap,stap,LERR)
C
      character ntap*256, otap*256, stap*256
      character pipe*50
C
      pipe = 'pipe'
      WRITE(LERR,'(10X,A     )')' '
      WRITE(LERR,'(10X,A     )')'  Input Parameters After Defaults'
      if(ntap.ne.' ')then
      WRITE(LERR,'(10X,2A    )')'Input Scan data...........',
     :ntap(1:50)
      else
      WRITE(LERR,'(10X,2A    )')'Input Scan data...........',pipe
      endif
      WRITE(LERR,'(10X,2A    )')'Input Semblance data.....',
     :stap(1:50)
      if(otap.ne.' ')then
      WRITE(LERR,'(10X,2A    )')'Output Multiplexed data....',
     :otap(1:50)
      else
      WRITE(LERR,'(10X,2A    )')'Output Multiplexed data...',pipe
      endif
      RETURN
      END
