C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  MODULE TO PERFORM ANALYSIS AND/OR VELOCITY PICKING FOR TP         |
C |  STACK PROCEDURE AS DESCRIBE BY DEBAZELAIRE IN FEB 1988 GEOPHYSICS.|
C |                                                                    |
C |   CODED BY R. CRIDER  2/90  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer maxsmp,nerrflg
      parameter (maxsmp = SZLNHD)
      parameter (nerrflg = 9)
      character PARR*21
	
      character NAME*5,TITLE(66)*1
      real          temp(2*SZLNHD)
      real          P(SZSMPM), XOFF(SZSMPM), xoffv2(SZSMPM)
      real          p2(SZSMPM)
      real          Ritr(SZLNHD)
      real          hold(1),Dhold(1),shold(1),scan(1)
      real          Live(1),hs(1),sqrbuf(1),shfts(1)
      integer       itrhd(1)
      integer       itr(SZLNHD)
      integer       TH,LH

      integer       argis
      integer       rs, re, static(SZSMPM),zero_min
C
      pointer       (phold, hold), (pdhold, dhold)
      pointer       (plive, Live),(psqr,sqrbuf)
      pointer       (psh, shold),(pth,itrhd),(pscn,scan)
      pointer       (phs, hs),(pshf,shfts)
C
      character ntap*256, otap*256
C
      logical OPEN, there,swght,sta,errflg(nerrflg),live_opt
      logical log_opt
C
      equivalence (itr(1),Ritr(1))
C
      data NAME/'OPSTF'/,OPEN/.FALSE./
      data PARR/'OPTICAL STACK FORWARD'/
      data TITLE/66*' '/

      ipr = LERR
      wrknt = 0
      iout = 0
      TH = TRACEHEADER
      LH = LINEHEADER
C +=========================+
c | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         call ccexit(0)
      endif
      J=23
      DO I=1,21
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
C +============================================+
c | Note that parameters and code for handling |
c | sliding window (lsw, pcnt, method) left in |
c | in anticipation of later investigating     |
c | desirability of that option.               |
C +============================================+
      sta = .false.
      live_opt = .false.
      log_opt = .false.

      ntap = ' '
      otap = ' '
      call gcmdln(ntap,otap, rs, re, np,pmin,pmax,v0,
     :swght,stexp,sta,live_opt,log_opt,idmin,idmax)
      dmin = idmin
      dmax = idmax
      if(dmax.le.0)dmax = 99999.
      if(dmin.lt.0)dmin = 0.
C
      if(v0.eq.0.0)then
         write(LER,*)' Initial Velocity V0 must be supplied. Fatal!'
         call ccexit(100)
      endif

      v2 = v0*v0
      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LERR,*)'Requested input data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      CALL GAMOCO(TITLE,1,IPR)
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
      CALL openr(LUIN,itr,LBYTES, nsamp,nsr,ntrc,nrcd,name,ntap,LERR,
     1           np,unitsc)

      if(rs.eq.0)rs=1
      if(re.eq.0)re=32767

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TH)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TH)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TH)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TH)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TH)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TH)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TH)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TH)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TH)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TH)


      inv = 0
      if(log_opt.and.(pmin.eq.0.0.or.pmax.eq.0.0))then
          write(LERR,*)' For the log-linear option, neither pmin ',
     :' nor pmax can be zero'
        stop 100
       endif

      call get_tp(pmin,pmax,np,log_opt,pinc,p,inv,ierr)
      if(ierr.ne.0)then
        call lbclos(luin)
        stop 100
      endif

      do i=1,np
       p2(i)=p(i)*p(i)
      end do

      sr=FLOAT(NSR) * unitsc
      fsr = nsr
C +=====================================================+
c | GET PROGRAM PARAMETERS, SAVE VALUES IN LINE HEADER, |
c | WRITE LINE HEADER                                   |
C +=====================================================+
C
      V2=V0*V0
C
      mbytes = (nsamp + ITRWRD)*ISZBYT
      nrecc = nrcd
      if(re.ne.32767.and.rs.gt.0)NRECC = re - rs + 1
C      +----------------------+
c      |   WRITE LINE HEADER  |
C      +----------------------+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
      noutr = np + np

      CALL openw(LUOUT,itr,LBYTES,NRECC,noutr,OPEN,otap,
     :pmin, pmax,pinc,v0,log_opt,ntrc)

      if(.not.open)then
         write(LERR,*)'Error opening output data set'
         call ccexit(100)
      endif
C +============================+
c | ALLOCATE SPACE FOR STORAGE |
C +============================+
      do i=1,nerrflg
       errflg(i)=.false.
      end do

      jabort = 0
      ierror =0
      ner=0
      iget = nsamp*ISZBYT
      call galloc(phs,iget,ierror,jabort)
      ner = ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(phold, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(psqr,  iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(plive,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=ntrc*nsamp*ISZBYT
      call galloc(pdhold,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=ntrc*ITRWRD*ISZBYT
      call galloc(pth,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget = np*nsamp*ISZBYT
      call galloc(psh, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pscn,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=ntrc*ISZBYT
      call galloc(pshf,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      do i=1,nerrflg
      if(errflg(i))then 
          write(ipr,*)' Unable to allocate memory.  Reduce data set',
     *       ' size and try again.'
          call ccexit(100)
      endif
      end do
      if(inv.gt.0)then
        inv1 = inv+1
        nm = np - inv1 + 1
        do i = 1,nm
         hold(i)=p(inv+i)
        end do
        do i=1,inv
          hold(np-i+1)=p(inv-i+1)
        end do
        do i=1,np
         p(i)=hold(i)
        end do
        do i = 1,nm
         hold(i)=p2(inv+i)
        end do
        do i=1,inv
          hold(np-i+1)=p2(inv-i+1)
        end do
        do i=1,np
         p2(i)=hold(i)
        end do
      endif
C +-------------------------------------------+
C | FIND AND READ FIRST TRACE OF FIRST RECORD |
C +-------------------------------------------+
      do i=1,SZSMPM
       xoff(i)=0.
      end do
  306 CONTINUE

      if(rs.gt.1)then
       do i=1,rs-1
        do j=1,ntrc
         nbytes=0
         call rtape(luin,itr,nbytes)
         if(nbytes.eq.0)then
          write(LERR,*)'Premature EOF on inut.  Check start record'
          write(LER ,*)'Premature EOF on inut.  Check start record'
          call lbclos(luin)
          call lbclos(luout)
          stop
         endif
        end do
       end do
      endif

      do while(rs.le.re)
       rlive   = 0
       statsum = 0.
       rlive   = 0.
       zero_min=nsamp+10
       DO nx = 1,ntrc
        nbytes = 0
        call rtape(LUIN,itr,NBYTES)
         if(nbytes.eq.0)then    
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
        call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,ioff,TH)
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,istat,TH)
C +========================================+
C | Get the static and compute running sum |
C +========================================+
        static(nx)=istat
        if(istat.lt.30000)then
         statsum = statsum+static(nx)
         rlive = rlive+1
        endif
        if(istat.ge.30000)ioff = 0
        xoff(nx)   = iabs(ioff)
        xoffv2(nx) = xoff(nx)/v0
        xoffv2(nx) = xoffv2(nx)*xoffv2(nx)
C +-----------------------+
C | save the trace header |
C +-----------------------+
        ndx = (nx-1)*ITRWRD+1
        call vmov(itr,1,itrhd(ndx),1,ITRWRD)
C       +------------------+
C       |   SAVE THE DATA  |
C       +------------------+
        j=1
        k=ithwp1-1
        do while(Ritr(k+j).eq.0.0.and.j.lt.nsamp)
         j=j+1
        end do
        if(j.lt.zero_min)zero_min=j
        ndx = (nx-1)*nsamp
        if(istat.ge.30000)then
         do i=1,nsamp
          dhold(ndx+i)=0.
         end do
        else
         k=ITHWP1-1
         do i=1,nsamp
          dhold(ndx+i)=Ritr(k+i)
         end do
        endif
       END DO   
C +=========================================+
C | Get the average static and the residual |
C +=========================================+
       if(rlive.eq.0) rlive = 1
       avstat = statsum/rlive
       do i=1,ntrc
        if(static(i).lt.30000)static(i)=static(i)-avstat
       end do
       call vclr(temp,1,nsamp+nsamp)
       do jp = 1,np
        isloc=(jp-1)*nsamp
        tp  = p(jp)
        itp = tp*1000.
        tp2 = p2(jp)
        do i=1,nsamp
          sqrbuf(i) = 0.0
          shold(isloc+i)   = 0.0
          hold(i)   = 0.0
          Live(i)   = 0.0
          hs(i)     = 0.0
        end do
C +==================================+
c |  Compute and apply current shift |
C +==================================+
        do nx = 1,ntrc
         if(tp.ge.0)then
          shfts(nx)=sqrt(tp2+xoffv2(nx)) - tp
         else
          pt = -tp
          shfts(nx)=sqrt(tp2+xoffv2(nx)) - pt
          shfts(nx) = -shfts(nx)
         endif
         shfts(nx)= shfts(nx)/SR
        end do
        do nx = 1,ntrc
         ld = (nx-1) * NSAMP
C +--------------------------------------------+
C |   For each trace compute the shift and sum |
C |   the shifted trace into the sum buffer.   |
C |   First see if need to apply header static |
C +--------------------------------------------+
         if(sta)then
          statv = float(static(nx))/fsr
          call statapp(Dhold(ld),nsamp,temp,statv)
         else
          do ny = 1,nsamp
           temp(ny)=dhold(ny+ld)
          end do
         endif
         if(abs(shfts(nx)).le.nsamp.and.
     :   xoff(nx).ge.dmin.and.xoff(nx).le.dmax)then
          call statapp(temp,nsamp,hs,shfts(nx))
          do j=zero_min,nsamp
           rz        = sqrbuf(j)
           ry        = hold(j)
           rx        = hs(j)
           hold(j)   = ry  + rx
           sqrbuf(j) = rz + rx*rx
          end do
          if(.not.live_opt)then
           do j=1,nsamp
            rx = Live(j)
            ry = hs(j)
            if(ry.ne.0.0)Live(j)=rx+1.0
           end do
          endif
         endif
        end do
        if(live_opt)then
         do i=1,nsamp
          Live(i) = rlive
         end do
        endif
C   +===========================================+
C   | Compute the semblance from the sum (hold) |
C   | and sum of squares (sqrbuf) buffers       |
C   +===========================================+
        do i=1,nsamp
           if(sqrbuf(i).ne.0.0.and.Live(i).ne.0.0)then
             h=hold(i)/sqrbuf(i)
             shold(isloc+i)=h*hold(i)/Live(i)
           endif
        end do
        if(sta)then
           statv = avstat/fsr + 1.
           call statapp(hold(1),nsamp,temp,statv)
           do j=1,nsamp
             hold(j)=temp(j)
           end do
           call statapp(shold(isloc+1),nsamp,temp,statv)
           do j=1,nsamp
            shold(isloc+j)=temp(j)
           end do
        endif
C   +===============================+
C   | Normalize the stack for the   |
C   | number of live samples summed |
C   +===============================+
        if(stexp.ne.0.0.and.stexp.ne.1.0)then
            do i=1,nsamp
              if(Live(i).ne.0.0)then
                Live(i)= exp(log(Live(i))*stexp)
              endif
            end do
        endif
        do i=1,nsamp
          if(Live(i).eq.0.0)then
             scan(isloc+i)=0.0
          else
             scan(isloc+i)=hold(i)/Live(i)
          end if
        end do
       end do   
C +=================+
C | Output the data |
C +=================+
C   +----------------------------------------------+
C   | First, find a good trace header.  There must |
C   | be at least one.  If not, use the first one. |
C   +----------------------------------------------+
       do i=1,ITRWRD
        itr(i)=itrhd(i)
       end do
       call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,ist_ndx,TH)
       itrc=1
       do while (ist_ndx.ge.30000.and.itrc.le.ntrc)
        itrc=itrc+1
        ndx = (itrc-1)*ITRWRD
        do i=1,ITRWRD
         itr(i)=itrhd(ndx+i)
        end do
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,ist_ndx,TH)
       end do
       if(itrc.gt.ntrc)itrc=ntrc
       iout = 0
       DO jp=1,np
        isloc=(jp-1)*nsamp
        ndx = (itrc-1)*ITRWRD+1
        call vmov(itrhd(ndx),1,itr,1,ITRWRD)
        iout = iout + 1
        call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,iout,TH)
        call savew2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,itp,TH)
        idx              = p(jp)*1000.
        call savew2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,idx,TH)
        if(idx.lt.0)idx  = -idx
        call savew2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,idx,TH)
        call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,0,TH)
        if(jp.le.ntrc)then
         ival = xoff (jp)
         call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,ival,TH)
        else
         call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,0,TH)
        endif

        if(swght)then
         do i=1,nsamp
          Ritr(ITRWRD+i)=scan(isloc+i)*shold(isloc+i)
         end do
        else
         do i=1,nsamp
          Ritr(ITRWRD+i)=scan(isloc+i)
         end do
        endif
        call wrtape(luout,itr,mbytes)
        iout = iout + 1
        call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,iout,TH)
        do i=1,nsamp
         Ritr(ITRWRD+i)=shold(isloc+i)
        end do
        call wrtape(luout,itr,mbytes)
       end DO
 
       rs=rs+1
      END DO

      call lbclos(luin)
      call lbclos(luout)
      call ccexit(0)
      END
C***********************************************************************

      SUBROUTINE prparm(NP,re,rs,V0,pmax,pmin,delp,ntap,otap,swght,
     1stexp,sta,p,LERR)
C
      integer     rs,re
      real p(*)
C
      character ntap*256, otap*256
C
      logical swght,sta
C
      WRITE(LERR,'(10X,A     )')' '
      WRITE(LERR,'(10X,A     )')'  INPUT PARAMETERS AFTER DEFAULTS'
      WRITE(LERR,'(10X,2A)')    'Input data set............',
     :ntap(1:25)
      if(otap.ne.' ')then
      WRITE(LERR,'(10X,2a)')    'Output data...............',
     :otap(1:25)
      else
      write(LERR,'(10x,3a)')    'Output data...............',
     :'pipe'
      endif
      WRITE(LERR,'(10X,A,I6  )')'Start Record .............',rs
      WRITE(LERR,'(10X,A,I6  )')'End Record ...............',re
      WRITE(LERR,'(10X,A,f6.1)')'Velocity of medium........',v0
      WRITE(LERR,'(10X,A,e12.5)')'Minimum Tp................',pmin
      WRITE(LERR,'(10X,A,e12.5)')'Maximum Tp................',pmax
      WRITE(LERR,'(10X,A,I6  )')'Number of TPs ............',NP
      WRITE(LERR,'(10X,A,f6.1)')'Stack Divisor Exponent....',stexp
      if(swght)
     :write(LERR,'(10x,a     )')'Semblance weighting requested'
      if(sta)
     :write(LERR,'(10x,a     )')'Statics applied '
      write(LERR,*)' Tp values used'
       call writer(p,np,1,LERR)
      RETURN
      END
C

      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     &IPR,np,unitsc)
c ******************************************************************** *
c                                                                      *
c  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
c  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
c  ONLY.                                                               *
c  INPUT:                                                              *
c    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
c    ITR   - I*4  -  INPUT BUFFER                                      *
c  OUTPUT:                                                             *
c   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
c    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
c    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
c    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
c    V0    - R*4  -  Velocity of the medium                            *
c    NP    - I*4  -  Number of Tp's                                    *
c    PMIN  - R*4  -  Minimum Tp                                        *
c    PMAX  - R*4  -  MAXIMUM Tp                                        *
c                                                                      *
c ******************************************************************** *
      integer maxsmp
      parameter (maxsmp = 3000)
      integer   itr(*)
      character NAME*5, ntap*256

      if(ntap.ne.' ')then
        call lbopen(luin, ntap, 'r')
      else
        luin = 0
      endif
      LINHED = 0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL rtape(LUIN, itr, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=5
      call hlhprt(itr,lbytes,name,ifour,IPR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', ntrc,   LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif

      if (np .eq. 0) np = ntrc

      RETURN
      END

      SUBROUTINE openw(LUOUT,itr,LBYTES,NRECC,NP,OPEN,otap,
     :pmin, pmax,delp,v0,log_opt,ntrc)
c ******************************************************************** *
c                                                                      *
c  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
c  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
c  INPUT:                                                              *
c   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
c    ITR   - I*4  -  INPUT BUFFER                                      *
c   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
c    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
c    NP    - I*4  -  NUMBER OF TRACES PER RECORD OUTPUT.               *
c  OUTPUT:                                                             *
c    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
c                                                                      *
c ******************************************************************** *
      integer   itr(*)
      character otap*256
      logical OPEN,log_opt

      LINHED = 0
      if(otap.ne.' ')then
        call lbopen(luout,otap, 'w')
      else
        luout = 1
      endif
      if(luout.gt.0)open=.true.
      lby = 0
      ithree = 2
      if(log_opt)ithree = -2
      call savew(itr, 'NumTrc', np, linhed)
      call savew(itr,'NumRec',nrecc,linhed)
      call savew(itr, 'OrNTRC', ntrc , LINHED)
      call savew(itr, 'MutVel', V0,   LINHED)
      call savew(itr, 'MnLnIn', ithree, LINHED)
      p=pmin*1000.
      call savew(itr, 'ILClIn', p, LINHED)
      p=pmax*1000.
      call savew(itr, 'CLClIn', p, LINHED)
      call savew(itr, 'NmSpMi', delp, LINHED)
      call savew(itr, 'Format', 3, LINHED)
      lby = lbytes
      CALL wrtape(LUOUT, itr, LBY)
      RETURN
      END

      subroutine gcmdln(ntap,otap, rs, re, np,pmin,pmax,v0,
     :swght,stexp,sta,live_opt,log_opt,dmin,dmax)
c                                     
c     Modified by R. L. Crider 4-27-90
c                                     
c     this routine processes the command line arguments.
c                                                               
      integer rs, re, argis,dmin,dmax

      character ntap*256, otap*256

      logical swght,sta,live_opt,log_opt

	  ntap = ' '
      otap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argi4('-rs',rs,0,0)
      call argi4('-re',re,0,0)
      call argr4('-pm',pmin,0.,0.)
      call argr4('-px',pmax,0.,0.)
      call argi4('-np',np,0,0)
      call argr4('-v0',v0,0.0,0.0)
      call argr4('-st',stexp,0.0,0.0)
      call argi4('-dmin',dmin,0,0)
      call argi4('-dmax',dmax,0,0)
      if(stexp.eq.0)stexp=0.7
      swght = (argis('-W').gt.0)
      sta = (argis('-S').gt.0)
      live_opt = (argis('-live').gt.0)
      log_opt  = (argis('-L').gt.0)
      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'PROGRAM OPTSF............Optical Stack (Forward)'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N [ntap]      (may be pipe)     : Input data file name'   
         write(LER,*)                                             
     :' -O [otap]      (may be pipe)     : Output data file name'
         write(LER,*)                                        
     :' -rs [rs]   (default = first)     : First record to process'
         write(LER,*)                                             
     :' -re [re]   (default = last)      : Last record to process'
         write(LER,*)                                           
     :' -pm [pmin]   (default = 0)       : First Tp'
         write(LER,*)                                           
     :' -px [pmax]   (no default)        : Last Tp'
         write(LER,*)                                           
     :' -np [np]    (no default)         : Number of Tps'
         write(LER,*)                                           
     :' -v0 [v0]    (no default)         : Velocity of medium'
         write(LER,*)
     :' -st[stexp] (default = 1.0)       : Stack Divisor Exponent'
         write(LER,*)                                           
     :' -dmin [dmin](default = near)     : Minimum distance in scan',
     :'                                    and semblance computations'
         write(LER,*)                                           
     :' -dmax [dmax](default = far )     : Maximum distance in scan',
     :'                                    and semblance computations'
         write(LER,*)
     :' -W        (default = NO)         : If present, weight stack'
         write(LER,*)
     :'                                    with semblance'
         write(LER,*)
     :' -S        (default = NO)         : If present, apply statics'
         write(LER,*)
     :' -live     (default = NO)         : If present, normalize stack'
         write(LER,*)
     :'                                    by number of live traces'
         write(LER,*)
     :'                                    instead of number non-zero'
         write(LER,*)
     :'                                    samples.'
         write(LER,*)
     :' -L        (default = NO)         : If present, make the change'
         write(LER,*)
     :'                                    in Tp linear in LOG(TP)'
         write(LER,*)
     :'                                    instead of linear in Tp'
         write(LER,*)
     :'                                    to enhance data at early'
         write(LER,*)
     :'                                    times.'
         write(LER,*)  
     :'***************************************************************'
       write(LER,*)                                        
     :'Usage: ',                                         
     :'opstf -N[ntap] -O[otap] -rs[first record] -re[last record]',
     :' -pm[pmin] -px[pmax] -np[num tp] -v0[v0] -st[stexp] -W -S -N -L'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            

      subroutine expw(live,nsamp,stexp)
      Real live(*),stexp
      call vlogz(Live,1,0.0,Live,1,nsamp)
      call vsmul(Live,1,stexp,Live,1,nsamp)
      call vexp(Live,1,Live,1,nsamp)
      return
      end
      subroutine vclr(x,ix,n)
      real x(*)
      integer ix,n,i,k
      k=1
      do i=1,n
       x(k)=0.
       k=k+ix
      end do
      return
      end
      subroutine vmov(x,ix,y,iy,n)
      real x(*),y(*)
      integer ix,iy,n,i,k,m
      k=1
      m=1
      do i=1,n
       y(m)=x(k)
       k=k+ix
       m=m+iy
      end do
      return
      end
