C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  Module to extract stack and velocity field from OPSTF output.     |
C |                                                                    |
C |   CODED BY R. CRIDER  2/92  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations of ntap, otap, etc. to be char*256 in subroutines
c as well as main.    jev  - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer maxsmp
      parameter (maxsmp = SZLNHD)
      CHARACTER PARR*24
      CHARACTER NAME*5,TITLE(66)*1
      REAL          velout(SZLNHD),stkout(SZLNHD),P(SZLNHD)
      REAL          cmute(SZLNHD),sembndx(SZLNHD), HEAD(SZLNHD)
      REAL          hold(1),maxcrv(1), shold(1),mutes(1),pick(1)
      integer       trhd(1)
      POINTER       (phold, hold), (pmaxcrv, maxcrv)
      POINTER       (pshold, shold),(ppk,pick)
      POINTER       (pm,mutes),(pth,trhd)

C
      INTEGER   ITR (SZLNHD)
      INTEGER   itr2(SZLNHD)
      
      INTEGER       thstat,jr(70),argis,pipe,kndex(SZLNHD)
      integer       rs, re,sto,nst
      integer       jndex(SZLNHD)
C
C   
      character ntap*256, otap*256, vtap*256, pkfile*256,mutef*256
C
      LOGICAL OPEN, VOPEN, VOUT, there,log_opt,IKP
      logical mute, swght,pik

      common / trhdr /
     1     ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     2     ifmt_RecNum,l_RecNum,ln_RecNum,
     3     ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     4     ifmt_RecInd,l_RecInd,ln_RecInd,
     5     ifmt_DphInd,l_DphInd,ln_DphInd,
     6     ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7     ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     8     ifmt_StaCor,l_StaCor,ln_StaCor,
     9     ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,
     a     ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC

C
      EQUIVALENCE (ITR(1), ITR2(1), HEAD(1))

      DATA NAME/'OPSTK'/,OPEN/.FALSE./,VOPEN/.FALSE./,VOUT/.FALSE./
      DATA PARR/'OPTICAL STACK EXTRACTION'/
      DATA LUIN/7/,LUOUT/8/,LUOUTV/9/,lusemb/25/,luan/26/
      data lupik/24/,lum/27/
      DATA TITLE/66*' '/, pipe/3/

      ipr = LERR
      wrknt = 0
C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         stop
      endif
      J=21
      DO I=1,24
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
       ntap = ' '
       otap = ' '
       vtap = ' '
       pkfile = ' '
       mutef = ' '
      call gcmdln(ntap,otap,vtap,vout,pkfile,mutef,
     :rs,re,thresh,sto,nst,vmin,vmax,swght,IKP,lcos,lmed)
C
      if(pkfile.ne.' ')then
        pik = .true.
        inquire(file = pkfile, exist = there)
        if(there) then
          open(unit=LUPIK, file=pkfile, status='old')
          close(unit=LUPIK, status = 'DELETE') 
          open(unit=LUPIK, file=pkfile, status='new',
     :         form='formatted',access='sequential')
        else
          open(unit=LUPIK, file=pkfile, status='new',
     :         form='formatted',access='sequential')
        endif
      endif
      if(mutef.eq.' ')then
        lum = 0
        mute=.false.
      else
        mute=.true.
        inquire(file = mutef, exist = there)
        if(there) then
          open(unit=LUM, file=mutef)
c    :         form='formatted',access='sequential')
        else
          write(LERR,*)' Requested mute file ', mutef,
     :' not found.  Job aborted.'
        stop
        endif
      endif

      if(rs.eq.0)rs = 1
      if(re.eq.0)re = 32767

      if(ntap.ne.' ')then

       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LERR,*)'Requested input data set does not exist.',
     &'  Try again.'
        stop
       endif
      endif
      vout = .false.
      CALL GAMOCO(TITLE,1,IPR)
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
      CALL openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :   np,pmin,pmax,v0,LERR,ierror,log_opt,unitsc)
      if(ierror.ne.0)then
       call lbclos(luin)
       stop
      endif

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      pmin = pmin/1000.
      pmax = pmax/1000.

      call get_tp(pmin,pmax,np,log_opt,pinc,p,inv,ierr)

      if(ierr.ne.0)then
         write(LERR,*)' For the log-linear option, neither pmin ',
     :' nor pmax can be zero'
         call lbclos(luin)
         stop 100
      endif

      delp = pinc
      if(inv.ne.0.and.sto.ne.0)then
        write(LERR,*)' Stacking option 1 not recommended with ',
     :'negative Tp values.  Results unpredictable'
      endif
      ns4 = nsamp*ISZBYT
      SR=FLOAT(NSR) * unitsc
C +=====================================================+
c | GET PROGRAM PARAMETERS, SAVE VALUES IN LINE HEADER, |
c | WRITE LINE HEADER                                   |
C +=====================================================+
      CALL prparm(ntap,otap,vtap,pkfile,mutef,NP,re,rs,
     : V0,THRESH,vmin,vmax,sto,nst,pmax,pmin,delp,LERR)

      np4 = np*ISZBYT
      nn = np
      do i=1,np
        jndex(i)=i
        kndex(i)=i
      end do
C
C
      MBYTES = (nsamp + itrwrd)*ISZBYT
      nrecc = nrcd
      if(re.ne.32767.and.rs.ge.1)NRECC = re - rs + 1
C +==============================+
c | Open the requested data sets |
c | and write the line header    |
C +==============================+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
      mm = 1
      CALL openw(LUOUT,ITR,LBYTES,NRECC,mm,OPEN,otap,LERR)

      CALL open2(LUOUTV,ITR,LBYTES,NRECC,mm,VOPEN,vtap,LERR,pipe,
     :IKP,ierror)
      vout = VOPEN

C +============================+
* | ALLOCATE SPACE FOR STORAGE |
C +============================+
      ierror = 0
      iabort = 0
      iget = np*nsamp*ISZBYT
      call galloc(phold,iget,ierror,iabort)
      call galloc(pshold,iget,ierror,iabort)
      iget = nsamp*ISZBYT
      call galloc(pmaxcrv,iget,ierror,iabort)
      iget = 4 * nsamp * ISZBYT + ISZBYT
      call galloc(ppk,iget,ierror,iabort)
      iget = 70 * nsamp * ISZBYT
      call galloc(pm,iget,ierror,iabort)
      iget=ITRWRD*ISZBYT
      call galloc(pth,iget,ierror,iabort)
      if(ierror.ne.0)then 
          write(ipr,*)' Unable to allocate memory.  Reduce data set',
     *       ' size and try again.'
          call lbclos(luin)
          stop
      endif
      if(inv.ne.0)then
        inv1 = inv+1
        nm = np - inv1 + 1
        call vmov(p(inv1),1,hold,1,nm)
        call vmov(p(inv),-1,hold(np),-1,inv)
        call vmov(hold,1,p,1,np)
      endif
C +--------------------------------+
C | READ THE MUTE FILE IF SUPPLIED |
C +--------------------------------+
      if(mute)then
         call rdmute(mutef,lum, nsamp,  mutes, jr, nsets,ierror)
         call sortmute(mutes,jr,nsamp,nsets,ierror)
      endif
C +-------------------------------------------+
C | FIND AND READ FIRST TRACE OF FIRST RECORD |
C +-------------------------------------------+
      jin = 0
      kin = 0
      kout = 0
      klin=0
      klear=nsamp*nn
      jbias=nsamp*nn
      kbias=ITRWRD*nn

      IREAD=0
  306 CONTINUE
      iscnknt = 0
      isemknt = 0
      NBYTES = 0
      CALL RTAPE(LUIN,ITR,NBYTES)
      IF(NBYTES.EQ.0)then
        write(LERR, *)'EOF on input data set.  OPST ending'
        call lbclos(luin)
        call lbclos(luout)
        if(vopen)call lbclos(luoutv)
        stop
      endif
c     irec = itr2(l_RecNum)
      call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
      IF(irec.ge.rs) THEN
       iscnknt = iscnknt + 1
       index = (iscnknt-1)*nsamp + 1
       ntx   = (iscnknt-1)*ITRWRD + 1
c      thstat = itr2(l_StaCor)
       call saver2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             ival , TRACEHEADER)
       thstat = ival
       if(thstat.GE.30000)THEN
        do i=0,nsamp-1
         hold(index+i)=0.
        end do
        itr2(l_StaCor) = 0
        call savew2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              0    , TRACEHEADER)
       else
        call vmov(itr(ITHWP1),1,hold(index),1,nsamp)
       endif
      ELSE
        GO TO 306
      ENDIF
      do k=1,ITRWRD
       trhd(k)=itr(k)
      end do
C +-------------------------------------------------+
C | Get the current mute function if mute requested |
C +-------------------------------------------------+
      if(mute)then
        call getmute(irec, JR, mutes, nsets, nsamp, cmute)
      endif
      DO 101 NX = 2,ntrc
       CALL RTAPE(LUIN,ITR,NBYTES)
       IF(NBYTES .EQ. 0) THEN
        WRITE(IPR,'(5X,A)')'END OF FILE ON INPUT:'
        WRITE(IPR,'(5X,A,1X,I4,A,1X,I4)')'  REC= ',IREC,'TRACE= ',NX
        call lbclos(luin)
        call lbclos(luout)
        stop
       ENDIF
c      thstat = itr2(l_StaCor)
c      irec   = itr2(l_RecNum)
       call saver2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             ival , TRACEHEADER)
       thstat = ival
      call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
C +-------------------------------+
C |   Save trace headers and data |
C +-------------------------------+
       if((nx/2*2).ne.nx)then
        iscnknt = iscnknt + 1
        index = (iscnknt-1)*nsamp + 1
        ntx   = (iscnknt-1)*ITRWRD + 1
        IF(thstat.GE.30000)THEN
         do i=0,nsamp-1
          hold(index+i)=0.
         end do
c        itr2(l_StaCor) = 0
         call savew2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               0    , TRACEHEADER)
        ELSE
         call vmov(itr(ITHWP1),1,hold(index),1,nsamp)
        ENDIF
       else
        isemknt = isemknt+1
        mndex = (isemknt-1)*nsamp + 1
        IF(thstat.GE.30000)THEN
         do i=0,nsamp-1
          shold(mndex+i)=0.
         end do
        ELSE
         call vmov(itr(ITHWP1),1,shold(mndex),1,nsamp)
         if(swght)then
          do i=0,nsamp-1
           hold(index+i)=hold(index+i)*shold(mndex+i)
          end do
         endif
        ENDIF
       endif
  101 continue
c     irec = itr2(l_RecNum)
      call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)
      call process(hold,shold,nsamp,sr,np,vmin,vmax,delp,nrecc,
     :  cmute,mute,nsr,maxcrv,sembndx,pik,p,v0,pmin,pmax,pick,
     :  jndex,kndex,stkout,velout,trhd(1),lupik,luout,luoutv,sto,itr,
     :  itr2,nst,mbytes,irec,thresh,vout,inv,lcos,lmed,ierror)

        rs=rs+1
        if(rs.le.re)go to 306
  999 CONTINUE
      CALL LBCLOS( LUIN)
      CALL LBCLOS(LUOUT)
      IF(VOPEN)CALL LBCLOS(LUOUTV)
      WRITE(IPR,'(1X,/,A)')'   EXECUTION COMPLETE   '
      stop
      END
C***********************************************************************

      SUBROUTINE prparm(ntap,otap,vtap,pkfile,mutef,NP,re,rs,
     :V0,THRESH,vmin,vmax,sto,nst,pmax,pmin,delp,IPR)
C
      INTEGER     rs,re,sto
C
      character ntap*256, otap*256, vtap*256,pkfile*256,mutef*256
      character pipe*50
C
      pipe = 'pipe'
      IF(rs.EQ.0)rs=1
      WRITE(IPR,'(10X,A     )')' '
      WRITE(IPR,'(10X,A     )')'  Input Parameters After Defaults'
      if(ntap.ne.' ')then
      WRITE(IPR,'(10X,2A    )')'Input Scan/Semblance data.',
     :ntap(1:50)
      else
      WRITE(IPR,'(10X,2A    )')'Input Scan/Semblance data.',pipe
      endif
      if(mutef.ne.' ')
     :WRITE(IPR,'(10X,2A    )')'Input Mute File...........',
     :mutef(1:50)
      if(otap.ne.' ')then
      WRITE(IPR,'(10X,2A    )')'Output Stacked data.......',
     :otap(1:50)
      else
      WRITE(IPR,'(10X,2A    )')'Output Stacked data.......',pipe
      endif
      if(vtap.ne.' ')
     :WRITE(IPR,'(10X,2A    )')'Output Velocity data......',
     :vtap(1:50)
      if(pkfile.ne.' ')
     :WRITE(IPR,'(10X,2A    )')'Output Pick file..........',
     :pkfile(1:50)
      WRITE(IPR,'(10X,A,I6  )')'Start Record .............',rs
      WRITE(IPR,'(10X,A,I6  )')'End Record ...............',re
      WRITE(IPR,'(10X,A,I6  )')'Stacking Mode.............',sto 
      WRITE(IPR,'(10X,A     )')'0 = Isotime sum of N largest' 
      WRITE(IPR,'(10X,A     )')'    TP scan values (N is    ' 
      WRITE(IPR,'(10X,A     )')'    next parameter)         ' 
      WRITE(IPR,'(10X,A     )')'1 = Stack picked from TP scan max' 
      WRITE(IPR,'(10X,A,F6.0)')'Minimum Velocity .........',VMIN
      WRITE(IPR,'(10X,A,F6.0)')'Maximum Velocity .........',VMAX
      WRITE(IPR,'(10X,A,I6  )')'Number Elements to Sum....',nst
      WRITE(IPR,'(10X,A,F6.0)') 'Velocity of medium........',V0
      WRITE(IPR,'(10X,A,e12.5)')'Minimum Tp................',pmin
      WRITE(IPR,'(10X,A,e12.5)')'Maximum Tp................',pmax
      WRITE(IPR,'(10X,A,I6  )') 'Number of TPs ............',NP
      WRITE(IPR,'(10X,A     )')' '
      WRITE(IPR,'(10X,A,e12.5)')'Tp Increment..............',delp
      RETURN
      END
C
      SUBROUTINE openw(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,
     &otap,IPR)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  LINE HEADER BUFFER                                *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    MODE  - I*4  -  MODE OF PROCESSING                                *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TP'S PER ANALYSIS. NUMBER OF TRACES     *
*                    PER RECORD OUTPUT IF ANALYSIS MODE.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *
      INTEGER   ITR(*)
      character otap*256
      LOGICAL OPEN

      if(otap.ne.' ')then
      call lbopen(luout,otap, 'w')
      else
       luout = 1
      endif
      LINHED=0
      lby = 0
      OPEN=.TRUE.
c
c changed from saver to savew - jev - 4/9/97
c 
      call savew(itr,'Format',3,LINHED)
      call savew(itr, 'NumTrc', NP,   LINHED)
      call savew(itr,'NumRec',nrecc,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END
      SUBROUTINE open2(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,
     &otap,IPR,pipe,IKP,ierror)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  LINE HEADER BUFFER                                *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    MODE  - I*4  -  MODE OF PROCESSING                                *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TP'S PER ANALYSIS. NUMBER OF TRACES     *
*                    PER RECORD OUTPUT IF ANALYSIS MODE.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *


      INTEGER   ITR(*)
      character otap*256
      LOGICAL OPEN, IKP
      integer pipcnt
      lerr = ipr

      OPEN = .false.
      write(LERR,*)'ikp = ',IKP
      if(otap(1:1) .ne.' ' .and. .not.IKP)then
       call lbopen(luout,otap, 'w')
       write(LERR,*)'Opening velocity output disk file named ',otap
      elseif (otap(1:1)  .eq. ' ' .and. IKP) then
       if (pipcnt(pipe,1) .ne. 0) then
        call sisfdfit (luout, pipe)
        write(LERR,*)'Opening velocity output pipe',luout
       else
        luout = -1
       endif
      else
        luout = -1
      endif
      write(LERR,*)'Opening velocity tape unit= ',luout

      if (luout .le. 0) then
         write(LERR,*)'Cannot open output data set.'
         luout = -1
         open = .false.
         return
      endif

      LINHED=0
      lby = 0
      OPEN=.TRUE.
      call savew(itr,'Format',3,LINHED)
      call savew(itr, 'NumTrc', NP,   LINHED)
      call savew(itr,'NumRec',nrecc,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END

      subroutine locinc(iroot,incr,iloc1,iloc2,iloc3,iloc4)
      integer iroot,incr,iloc1,iloc2,iloc3,iloc4

      iloc1 = iroot
      iloc2 = iloc1 + incr
      iloc3 = iloc2 + incr
      iloc4 = iloc3 + incr
      return
      end

      subroutine gcmdln ( ntap,otap,vtap,vflag,pkfile,
     :mutef,rs,re,thresh,sto,nst,vmin,vmax,swght,IKP,lcos,lmed)
c                                     
c     this routine processes the command line arguments for use in
c     program STKOP.
c                                                               
      real thresh
      integer rs, re, ri
      integer sto,nst,argis

      character ntap*256, otap*256, vtap*256,mutef*256
      character pkfile*256

      logical   vflag, IKP
      logical swght

      vflag = .false.                            
      IKP   = .false.                            
      vtap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O2',vtap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argstr ('-pk',pkfile,' ',' ')
      call argstr('-mf',mutef,' ',' ')
      call argi4('-rs',rs,0,0)
      call argi4('-re',re,0,0)
      call argi4('-ri',ri,0,0)
      if(ri.eq.0)ri = 1
      call argr4('-th',thresh,0.,0.)
      if(thresh.eq.0.0)thresh = 0.35
      call argi4('-sto',sto,0,0)
      call argi4('-nst',nst,0,0)
      if(sto.gt.1)sto = 0
      if(sto.eq.0.and.nst.eq.0)nst=3
      call argr4('-vm',vmin,0.0,0.0)
      call argr4('-vx',vmax,0.0,0.0)
      swght = (argis('-W').gt.0)
      IKP   = (argis('-IKP').gt.0)
      call argi4('-nsm',lcos,0,0)
      call argi4('-nm',lmed,0,0)
      return                                                  
      end

*     SUBROUTINE CCEXIT (ICODE)                                      
*     if(icode.ne.0)WRITE (6,1000) ICODE
*1000 FORMAT(' PROGRAM TERMINATION:  EXIT CODE = ',I6)
*     STOP                                                       
*     END                                                       

c
c commented out getfle subroutine - 4/8/97 - jev
c subroutine is no longer used
c
c     subroutine getfle(ofile,luorec)
c
c#include <f77/iounit.h>
c
c  ****************************************************************** 
c  *      Subprogram to check the existence of input and output     *
c  *      files                                                     *
c  ******************************************************************
c     character ofile*100, openstat*3
c     logical there,ok
c
c     inquire(file=ofile,exist=there)
c     last=lenth(ofile)
c     if(there)then
c	    openstat = 'old'
c	  else
c	    openstat = 'new'
c     endif
c     if(ofile(1:1).ne.' ')then
c        open(unit=luorec,file=ofile,status=openstat)
c        inquire(unit=luorec,opened=ok)
c        if(.not.ok)then
c         write(LERR,'(5x,a,a,a)')'Unable to open ',ofile(1:last),
c    *    ' for output.'
c         write(LERR,'(a)')'  ***** Job abended ********'
c         stop
c        endif
c     endif
c     return
c     end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'Program OPSTK...........Optical Stack Extraction'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N [ntap]      (May be pipe)     : Input scan data file name'   
         write(LER,*)                                               
     :' -O [otap]      (May be pipe)     : Output stacked data file'
         write(LER,*)                                           
     :' -O2 [vtap]     (optional)        : Output velocity data file'
         write(LER,*)                                           
     :' -pk [pkfile]   (optional)        : Output Pick file name'
         write(LER,*)                                           
     :' -mf [mutefile] (optional)        : Input Mute file'
         write(LER,*)                                               
     :' -rs [rs]       (default=first)   : First record to process'
         write(LER,*)                                             
     :' -re [re]       (default=last)    : Last record to process'
         write(LER,*)                                           
     :' -sto[sto]      (default=0)       : Stack Option'
         write(LER,*)
     :'                                    0 = Isotime sum of nst'
         write(LER,*)
     :'                                        Tp scan values.'
         write(LER,*)
     :'                                    1 = Picked stack'
         write(LER,*)                                           
     :' -nst[nst]      (default = 3)     : Number tp values to sum'
         write(LER,*)
     :'                                    for sto = 0 '
         write(LER,*)                                           
     :' -th [thresh]   (default = .35    : Semblance Picking threshold'
         write(LER,*)                                           
     :' -vm [vmin]     (optional)        : Minimum Velocity in scans'
         write(LER,*)                                               
     :' -vx [vmax]     (optional)        : Maximum Velocity in scans'
         write(LER,*)                                           
     :' -nsm[nsm] (default = no smooth)  : Number points in smoothing'
         write(LER,*)
     :'                                    operator for semblance'
         write(LER,*)                                           
     :' -nm[lmed]      (default = No)    : Length of median filter'
         write(LER,*)
     :'                                    applied to output velocity'
         write(LER,*)        
     :' -W        (default = No)         : If present, weight stack'
         write(LER,*)        
     :'                                    with semblance'
       write(LER,*)                                        
     :'Usage:  ',                                         
     :' opstk -N[ntap] -O[otap] -O2[vtap] -pk[pkfile] -mf[mutefile]',
     :' -rs[first record] -re[last record] -sto[sto] -nst[nst]',
     :' -th[thresh] -vm[vmin] -vx[vmax] -nsm[nsm] -nm[lmed] -W'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            

      subroutine getmax(vsc,nx,nvel,maxcrv,refs)
C ******************************************************************** C
C * Subprogram: getmax                              Entry: getmax    * C
C * Author: R.L. Crider                                              * C
C * Date: May, 1991                                                  * C
C * Subroutine to select the maximum semblance curve.  This curve is * C
C * later scanned (in pikmax) to get the actual picks.               * C
C *                                                                  * C
C * Usage:                                                           * C
C *  Call getmax(vsc, nx,nvel,maxcrv,refs)                           * C
C *  Input:                                                          * C
C *      vsc  - R*4 - matrix of semblance values dimensioned         * C
C *                   nx X nvel.                                     * C
C *       nx  - I*4 - length of a column in vsc (trace length)       * C
C *     nvel  - I*4 - length of a row in vsc (number velocity scans) * C
C *  Output:                                                         * C
C *    maxcrv - R*4 - Vector containing the max semblance "curve"    * C
C *      refs - R*4 - Vector containing the column (trace) location  * C
C *                   of each maximum.                               * C
C ******************************************************************** C
      real vsc(*),maxcrv(*),refs(*)

C +------------------------------------------+
C | Find the maxima and save their positions |
C +------------------------------------------+
      do 100 i=1,nx
        call maxv(vsc(i),nx,vsmax,iref,nvel)
        if(vsmax.gt.1.0.or.vsmax.lt.0.0)then
         refs(i)=1.
         maxcrv(i)=0.
        else
         refs(i)=iref
         maxcrv(i)=vsmax
        endif
  100 continue
      return
      end

      subroutine pikmax(vsc,maxcrv,refs,ns,dt,np,p,v0,
     :thresh,vmin,vmax,pmin,pmax,delp,pick,npicks,lpick,vpick)
C ******************************************************************** C
C *                                                                  * C
C * Subprogram: pikmax                              Entry: pikmax    * C
C * Author: R.L. Crider                                              * C
C * Date: May, 1991                                                  * C
C * Subroutine to pick the maximum semblance curve returned by       * C
C * GETMAX().                                                        * C
C *                                                                  * C
C * Usage:                                                           * C
C *   call pikmax(vsc,maxcrv,refs,ns,dt,np,p,v0,                     * C
C *     thresh,vmin,vmax,pick,npicks.lpick)                          * C
C *                                                                  * C
C *  Input:                                                          * C
C *      vsc  - R*4 - matrix of semblance values                     * C
C *    maxcrv - R*4 - Vector containing the max semblance "curve"    * C
C *                   from GETMAX subroutine.                        * C
C *      refs - R*4 - Vector containing the column location of       * C
C *                   each maximum (from getmax).                    * C
C *       ns  - I*4 - length of a column in vsc (trace length)       * C
C *       dt  - R*4 - Sample interval, in seconds.                   * C
C *       np  - I*4 - length of a row in vsc (number velocity scans) * C
C *        p  - R*4 - Vector of P values, one for each column.       * C
C *       v0  - I*4 - Initial velocity                               * C
C *   thresh  - R*4 - Semblance picking threshold (0<threshold<1)    * C
C *     vmin  - R*4 - Minimum velocity                               * C
C *     vmax  - R*4 - Maximum velocity                               * C
C *     pmin  - R*4 - Minimum P value.                               * C
C *     pmax  - R*4 - Maximum P value.                               * C
C *     delp  - R*4 - Change in P value.                             * C
C *                                                                  * C
C *  Output:                                                         * C
C *     pick  - R*4 - Matrix containing the picked values.           * C
C *                   Column 1: time of pick                         * C
C *                   Column 2: velocity of pick                     * C
C *                   Column 3: semblance at pick                    * C
C *                   Column 4: column location of pick              * C
C *   npicks  - I*4 - Number of picks                                * C
C *   lpick   - I*4 - Temporal index of picks                        * C
C *   vpick   - R*4 - Vector of picked velocities                    * C
C *                                                                  * C
C ******************************************************************** C
      real vsc(*),maxcrv(*),pick(ns,4),thresh,refs(*),p(*),vpick(*)
      real dt,v0
      integer ns, np,lpick(*)

      nsr = dt * 1000.
      np2 = np
      vslope = (vmax-vmin)/(float(ns-1))
      npicks = 0
      ist = 1
  100 continue
C +--------------------------------------------------+
C | Search until find sembl value ge threshold, then |
C | find the encompassing "glob"                     |
C +--------------------------------------------------+
      IF(maxcrv(ist).ge.thresh)then
         big = maxcrv(ist)
         Lbig = ist
         do 110 i=ist+1,ns
           if(maxcrv(i).gt.big)then
             big = maxcrv(i)
             Lbig = i
           endif
           if(maxcrv(i).lt.thresh)then
              iend = i
              go to 120
           endif
  110    continue
         iend = ns
  120  continue
C +-----------------------------+
C | Increment the pick counter  |
C +-----------------------------+
        npicks = npicks + 1
        L = Lbig
        lpick(npicks) = L
C +---------------------------+
C | Save the time of the pick |
C +---------------------------+
        pick(L,1)= (L-1) * nsr
        iref = refs(L)
        iloc=(iref -1)*ns + L
C +---------------------------+
C | Save the semblance value  |
C +---------------------------+
        pick(L,3)=vsc(iloc)
C +------------------------------+
C | Save the semblance location, |
C | the velocity, and the time.  |
C +------------------------------+
        pick(L,4) = iref
C +---------------------------+
C | Compute the velocity here |
C +---------------------------+
        ppp = p(iref)
        if(ppp.eq.0.0)ppp = float(nsr)/1000.
        pt=pick(L,1)
        if(pt.eq.0.0)pt=dt
        v = compvel(pt,ppp,v0)
        pick(L,2)=v
        jdx = pick(L,1)/nsr + 1
        vpick(jdx)=v
        if(iref.gt.np2)pick(L,2)=-pick(L,2)
C +--------------------------------+
C | Compute the interval velocity  |
C | to see if this is a valid pick |
C +--------------------------------+
        idrop=0
        if(npicks.gt.1)then
          v2 = v
          j1 = lpick(npicks-1)
          v1 = pick(j1,2)
          t2 = (L -1)*dt
          t1 = pick(j1,1)/1000.
        endif
        ist = iend + 1
        if(ist.lt.ns)go to 100
      else
        ist = ist + 1
        if(ist.lt.ns)go to 100
      ENDIF
      return
      end

      real function compvel(t0,tp,v0)
      real t0, tp, v0
      
      tpp = tp
      if(tpp.lt.0)tpp=-tpp
      v = v0 * sqrt(tpp/t0)
      compvel = v

      return
      end

      subroutine pikstk(x,pick,npicks,refs,lpick,ns,nsr,
     :v0,pmax,pmin,delp,p,np,vp,pp)
C ******************************************************************** C
C *                                                                  * C
C * Subprogram: pikstk                              Entry: pikstk    * C
C * Author: R.L. Crider                                              * C
C * Date: May, 1991                                                  * C
C * Subroutine to pick the stack from the tp scan matrix using       * C
C * results of pikmax.                                               * C
C *                                                                  * C
C * Usage:                                                           * C
C *   call pikstk(x,pick,npicks,refs,lpick,ns,nsr,                   * C
C *     v0,pmax,pmin,delp,p,np,vp,pp)                                * C
C *  Input:                                                          * C
C *        x  - R*4 - TP scan matrix                                 * C
C *     pick  - R*4 - Pick matrix from pikmax.                       * C
C *   npicks  - I*4 - number of picks                                * C
C *     refs  - R*4 - TP index of picks                              * C
C *    lpick  - I*4 - Temporal index of picks                        * C
C *       ns  - I*4 - Number samples per trace                       * C
C *      nsr  - I*4 - Sample interval, in msec                       * C
C *       v0  - R*4 - Initial velocity                               * C
C *     pmin  - R*4 - Minimum P value, in sec                        * C
C *     pmax  - R*4 - Maximum P value, in sec                        * C
C *     delp  - R*4 - Increment between P values, in sec             * C
C *        p  - R*4 - Vector of P values                             * C
C *       np  - I*4 - Number of P values (total = + & -)             * C
C *                                                                  * C
C *  Output:                                                         * C
C *       vp  - R*4 - Stacked data trace                             * C
C *       pp  - R*4 - Velocity trace (stacking velocity)             * C
C *                                                                  * C
C ******************************************************************** C
      real x(*), pick(ns,4),vp(*),pp(*),refs(*),p(*)
      real pmax,pmin,delp
      integer lpick(*),np,ns,nsr,npicks
      
      np2 = np
      v02 = v0*v0
      do i=1,ns
        pp(i)=0.
        vp(i)=0.
      end do
      k1 = 0
      pp(1)=v0
      do 100 i=1,npicks
       k = lpick(i)
       m = refs(k)
       iloc = (m-1)*ns + k
       if(i.eq.1)then
         if(k.gt.1)then
          v = pick(k,2)
          sep = k - 1
          vp(1)=x(1)
          vvL=v
          if(vvL.lt.0)vvL=-vvL
          delv = (vvL-v0)/sep
          xn = 0
          do 10 n=2,k
           xn = xn + 1
           vl = v0 + xn * delv
           t=(n-1)*nsr
           lt = n -1
           tpp = vl*vl*t/v02
           if(tpp.gt.pmax)tpp=pmax
           if(delp.ne.0)then
              loc = (tpp-pmin)/delp + 1
           else
              call findloc(loc,p,np,tpp)
           endif
           iloc=(loc-1)*ns + lt
           vp(n)=x(iloc)
           pp(n)=v
   10     continue
         else
          pp(k) = pick(k,2)
          if(pp(k).eq.0.0)pp(k)=v0
          ist = (m -1 )*ns+ 1
          vp(k) = x(ist)
         endif
         k1= k
       else
         slen = k-k1
         s1 = pick(k1,1)/float(nsr)+1
         s2 = pick(k,1)/float(nsr)+1
         xm1 = refs(k1)
         xm2 = refs(k)
C +-----------------------------+
C | Get change in sample number |
C +-----------------------------+
         dels = s2 - s1
C +----------------------------+
C | Get change in trace number |
C +----------------------------+
         delx = xm2 - xm1
         slopes = dels/slen
         slopex = delx/slen
         do 50 j=k1,k
           xj = j-k1
           kk = s1  + xj*slopes
           mm = xm1 + xj*slopex
           iloc = (mm - 1)*ns + kk
           vp(j) = x(iloc)
           ctime = (kk -1)*nsr
           ttp = p(mm)
           if(ttp.eq.0.0)ttp = float(nsr)/1000.
           if(ttp.eq.0.0)then
              cv = v0
           else
              if(ctime.eq.0.0)ctime=float(nsr)/1000.
              cv = compvel(ctime,ttp,v0)
           endif
           pp(j) = cv
           if(p(mm).lt.0)pp(j)=-pp(j)
   50    continue
         k1 = k
       endif
  100 continue
      lbig = ns*np
      k = lpick(npicks)
      v = pick(k,2)
      m = refs(npicks)
      velc = v * v
      if(k.lt.ns)then
           n = (m-1)*ns
        do 200 i=k,ns
          ctime = (i-1)*nsr
          ttp = ctime * velc/v02
          if(ttp.gt.pmax)ttp=pmax
          if(ttp.lt.0)ttp = pmin
          if(delp.ne.0)then
            loc=(ttp-pmin)/delp+1
          else
            call findloc(loc,p,np,ttp)
          endif
          ist = (loc - 1)*ns + i
          if(ist.gt.lbig.or.ist.lt.1)ist=m
          vp(i) = x(ist)
          pp(i) = v
  200   continue
      endif
      return
      end

      subroutine findloc(loc,p,np,tp)
      real p(*)
      diff = 999999.
      do 10 i=1,np
       der = abs(p(i)-tp)
       if(der.lt.diff)then
         diff = der
         loc = i
       endif
   10 continue
      return
      end

      subroutine expw(live,nsamp,stexp)
      Real live(*),stexp
      call vlogz(Live,1,0.0,Live,1,nsamp)
      call vsmul(Live,1,stexp,Live,1,nsamp)
      call vexp(Live,1,Live,1,nsamp)
      return
      end

      subroutine rdmute(mutef,lum, nsamp, mutes, jr, nsets,ierror)
#include <f77/iounit.h>
      REAL mutes(*)
      INTEGER lum, nsamp, jr(*), nsets,osamp,base
      character card*80,mutef*256,id*5

C +--------------------------+
C |   Read the Units record  |
C +--------------------------+
   80 format(a80)
   81 format(a40)
      read(lum,34)id,card
      if(id.ne.'Units')then
        write(LERR,*)'Mute file format incorrect. Job aborted'
        ierror = 1
        return
      endif
      read(card(1:80),35)recu, trcu, timeu,nrecs,np,ns
   34 format(t1,a5,t1,a80)
   35 format(t10,f9.0,t23,f9.0,t36,f9.0,t50,i4,t56,i5,t64,i4)
   36 format(t1,f12.0,1x,f12.0,1x,f12.0)
C +----------------------------------------------------+
C |   Read the data, using "Segment" card as separator |
C +----------------------------------------------------+
      nsets = 0
      irec = 1
  100 continue
      card = ' '
      read(unit=lum,fmt=34,end=500)id,card
      if(id.eq.'Segme')then
        if(nsets.ge.1.and.osamp.lt.nsamp)then
         loc = (nsets-1)*nsamp + osamp + 1
         lfill = nsamp - osamp
         call vfill(mutes(loc-1),mutes(loc),1,lfill)
        endif
        nsets = nsets + 1
        if(nsets.gt.70)then
          write(LERR,*)'The number of mute functions supplied',
     :    ' exceeds the maximum (70).  Job aborted.'
          ierror = 1
          return
        endif
        k=0
        go to 100
      endif
      read(card(1:40),36)rec, trc, time
      k = k + 1
      jr(nsets)= rec
      isamp = time/timeu + 1
      loc = (nsets-1)*nsamp + isamp
      mutes(loc)=trc
      if(k.eq.1)then
       base = (nsets-1)*nsamp
       loc = base + 1
       lclr = isamp-1
       if(lclr.gt.0)then
        call vclr(mutes(loc),1,lclr)
       endif
       osamp = isamp
       otrc = trc
      else
       jend = isamp -1
       jlen = jend-osamp
       if(jlen.eq.0)then
         jlen = 1
       endif
       slope = (trc - otrc)/float(jlen)
       base = (nsets-1)*nsamp
       x = 0
       do 210 i=osamp, jend
        loc = base + i
        mutes(loc)=otrc + slope * x
        x = x + 1.
  210  continue
       otrc = trc
       osamp = isamp
      endif
      go to 100
  500 continue
      if(osamp.lt.nsamp.and.nsets.ge.1)then
       loc = (nsets-1)*nsamp + osamp + 1
       lfill = nsamp - osamp
       call vfill(mutes(loc-1),mutes(loc),1,lfill)
      endif
      return
      end

      SUBROUTINE getmute(IRI, JR, mutes, nsets, ns, cmute)
C ******************************************************************** C
C *   Subroutine to find the mute function for the current ri.       * C
C *                                                                  * C
C *   INPUT:                                                         * C
C *                                                                  * C
C *     IRI    - I*4   -  Current RI #                               * C
C *      JR    - I*4() -  Vector of RI #'s for mute functions        * C
C *   MUTES    - R*4() -  Matrix of mutes.                           * C
C *   NSETS    - I*4   -  Number of mute functions supplied.         * C
C *      ns    - I*4   -  Trace length.                              * C
C *                                                                  * C
C *   OUTPUT :                                                       * C
C *                                                                  * C
C *   CMUTE    - R*4() -  Current mute vector                        * C
C *                                                                  * C
C ******************************************************************** C
      REAL mutes(*), cmute(*)
      INTEGER  JR(*), nsets
C
      IF(nsets.gt.1)then
       if(iri.le.jr(1))then
        do i=1,ns
          cmute(i)=mutes(i)
        end do
        return
       endif
       DO 210 I = 2,nsets
        IF(JR(I).GE.IRI.or.I.eq.nsets)THEN
          if(jr(i).eq.iri)then
           loc = (i-1)*ns
           do j=1,ns
             cmute(j)=mutes(loc+j)
           end do
           return
          endif
          if(i.eq.nsets.and.iri.gt.jr(i))then
           loc = (i-1)*ns
           do j=1,ns
             cmute(j)=mutes(loc+j)
           end do
           return
          endif
          k = i
          k1 = i-1
          loc1=(k1-1)*ns + 1
          loc2=(k-1)*ns + 1
          slope = float(iri-jr(k1))/float(jr(k)-jr(k1))
          loc1 = loc1 - 1
          loc2 = loc2 - 1
          do 100 L = 1,ns
           loc1 = loc1 + 1
           loc2 = loc2 + 1
           cmute(L)= mutes(loc1) + 
     :           (mutes(loc2)-mutes(loc1))*slope
  100     continue
         return
        ENDIF
  210  CONTINUE
      ELSE
       do i=1,ns
         cmute(i)=mutes(i)
       end do
       return
      ENDIF
      END

      subroutine appmute(semb,nsamp,np,cmute)
      REAL semb(*), cmute(*)
      INTEGER nsamp, np

      do 100 i=1,nsamp
      imutst = cmute(i)
      if(imutst.gt.np)imutst=np
      if(imutst.gt.0)call vclr(semb(i), nsamp, imutst)
  100 continue
      return
      end

      subroutine sortmute(mutes,jr,ns,nsets,ierror)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
      real mutes(*),temp(1),recs(70)
      integer ns, nsets,jr(*),ir(70)
      integer kndx(70)
      POINTER (pt,temp)

      iget = ns * nsets*ISZBYT
      iabort = 0
      ierror=0
      call galloc(pt,iget,ierror,iabort)
      if(ierror.ne.0)then
        write(LERR,*)' Error in pt memory allocation'
        return
      endif
      do 100 i=1,nsets
       kndx(i)=i
       recs(i)=jr(i)
  100 continue
      call hsorti(nsets,recs,kndx)
      do 200 i=1,nsets
        loc1 = kndx(i)
        ir(i)=jr(loc1)
        loc1 = (loc1-1)*ns + 1
        loc2 = (i-1)*ns + 1
        do k=0,ns-1
         temp(loc2+k)=mutes(loc1+k)
        end do
  200 continue
      lmove = nsets * ns
      do k=1,lmove
       mutes(k)=temp(k)
      end do
      do k=1,nsets
       jr(k)=ir(k)
      end do
      call gfree(pt)
      return
      end
      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :np,pmin,pmax,v0,IPR,ierror,log_opt,unitsc)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
*  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
*  ONLY.                                                               *
*  INPUT:                                                              *
*    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*  OUTPUT:                                                             *
*   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
*    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
*    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
*    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
*    V0    - R*4  -  Velocity of the medium                            *
*    NP    - I*4  -  Number of Tp's                                    *
*    PMIN  - R*4  -  Minimum Tp                                        *
*    PMAX  - R*4  -  MAXIMUM Tp                                        *
*                                                                      *
* ******************************************************************** *
      integer maxsmp
      parameter (maxsmp = 3000)
      INTEGER   ITR(*)
      CHARACTER NAME*5, ntap*256
      logical   log_opt

      if(ntap.ne.' ')then
        call lbopen(luin, ntap, 'r')
      else
        luin = 0
      endif
      LINHED=0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=5
      call hlhprt(itr,lbytes,name,ifour,IPR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', NP,   LINHED)
      call saver(itr, 'MutVel', V0,   LINHED)
      call saver(itr, 'MnLnIn', ithree, LINHED)
      call saver(itr, 'ILClIn', pmin, LINHED)
      call saver(itr, 'CLClIn', pmax, LINHED)
      call saver(itr, 'NmSpMi', delp, LINHED)
      call saver(itr, 'Format', ifmt, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      v = abs(v0)
      if(ithree.lt.0)then
         v0 = -v
      endif
      ntrc = np
      np = np/2
c     ithree = iabs(ithree)
      if(iabs(ithree).ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to use it.'
        ierror = 1
        return
      endif
      log_opt = .false.
      if (ithree .eq. -2) log_opt = .true.
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
        ierror = 1
        return
      endif
C
      RETURN
      END
