C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  Subroutine to extract stach and velocity field from OPSTF outut.  |
C |                                                                    |
C |   CODED BY R. CRIDER  2/92  HDC                                    |
C |   call process(hold,shold,nsamp,sr,np,vmin,vmax,delp,              |
C |     cmute,mute,nsr,maxcrv,sembndx,pik,p,v0,pmin,pmax,pick,         |
C |     jndex,kndex,stkout,velout,trhd,lupik,luout,luoutv,sto,itr,     |
C |     nst,mbytes,irec,thresh,vout,inv)                               |
C |                                                                    |
C ******************************************************************** C
      subroutine process(hold,shold,nsamp,sr,np,vmin,vmax,delp,nrecc,
     :cmute,mute,nsr,maxcrv,sembndx,pkfile,p,v0,pmin,pmax,pick,
     :jndex,kndex,stkout,velout,trhd,lupik,luout,luoutv,sto,itr,
     :itr2,nst,mbytes,irec,thresh,vout,inv,lcos,lmed,ierror)
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real hold(*),shold(*),cmute(*),maxcrv(*),sembndx(*)
      real p(*),pick(*),vpick(3000),Live(3000),stkout(*),velout(*)
      real work1(3000),work2(3000),vloc(3000),tloc(3000),vels(3000)
      real cossq(51)
      real pneg(1), holdn(1),sholdn(1)
      real envlp(1),envlpn(1)
      integer pndex1(1),pndex2(1)
      POINTER (p1,pndex1),(p2,pndex2)
      POINTER (ph,holdn),(ps,sholdn),(ppn,pneg)
      POINTER (pen,envlp),(penn,envlpn)

C
      logical mute,vout,pkfile
C
      integer lpick(6000),jndex(*),kndex(*)
      integer trhd(*),itr(*),wrknt
      integer   itr2(*)
      integer posp,negp
C
      character segline*20

      common / trhdr /
     1     ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     2     ifmt_RecNum,l_RecNum,ln_RecNum,
     3     ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     4     ifmt_RecInd,l_RecInd,ln_RecInd,
     5     ifmt_DphInd,l_DphInd,ln_DphInd,
     6     ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7     ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     8     ifmt_StaCor,l_StaCor,ln_StaCor,
     9     ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,
     a     ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC

C
      data wrknt/0/
      SAVE wrknt

      if (lcos.gt.0)then
       lcos2 = lcos/2+1
       piby2 = 2.*atan(1.0)
       j=lcos2
       do i=1,lcos2
        arg = (i-1)*piby2/lcos2
        cossq(j) = cos(arg)
        cossq(j)=cossq(j)*cossq(j)
        j=j-1
       end do
       j=lcos2-1
       do i=lcos2+1,lcos
        cossq(i)=cossq(j)
        j=j-1
       end do
       call semb_clean(shold,hold,np,nsamp,cossq,lcos)
      end if
      zero = 0.0
      nsr = sr*1000.+.1
      posp = np
      negp = 0
      pp1 = p(1)
      ierror = 0
      iabort = 0
      iget=np*ISZBYT
      call galloc(p1,iget,ierror,iabort)
      if(ierror.ne.0)then
         write(LERR,*)' Unable to allocate memory'
         return
      endif
      iget = nsamp*np*ISZBYT
      call galloc(pen,iget,ierror,iabort)
      if(ierror.ne.0)then
         write(LERR,*)' Unable to allocate memory'
         return
      endif
      do i=1,np
        pndex1(i)=i
      end do
      if(inv.ne.0)then
        do i=1,np
          if(p(i).lt.0)then
            posp=i-1
            negp = np-posp
            go to 50
          endif
        end do
   50   continue
        if(negp.eq.np)then
          write(LERR,*)' Found no positive Tp values.  Fatal Error'
          return
        endif
        negp=negp+1
        igetp=posp*ISZBYT
        igetn=negp*ISZBYT
        call grealloc(p1,igetp,ierror,iabort)
        call galloc(p2,igetn,ierror,iabort)
        call galloc(ppn,igetn,ierror,iabort)
        iget=igetn*nsamp
        call galloc(ph,iget,ierror,iabort)
        call galloc(ps,iget,ierror,iabort)
        call galloc(penn,iget,ierror,iabort)
        if(ierror.ne.0)then
           write(LERR,*)' Unable to allocate memory'
           return
        endif
        do i=1,posp
          pndex1(i)=i
        end do
        do i=1,negp
          pndex2(i)=i
        end do
        call vmov(p(np),-1,pneg,1,negp-1)
        pneg(1)=p(1)
        j=np+1
        do i=2,negp
          j=j-1
          ndx=(j-1)*nsamp+1
          jdx=(i-1)*nsamp+1
          call vmov(hold(ndx),1,holdn(jdx),1,nsamp)
          call vmov(shold(ndx),1,sholdn(jdx),1,nsamp)
        end do
        call vmov(hold,1,holdn,1,nsamp)
        call vmov(shold,1,sholdn,1,nsamp)
      endif
      if(vmin.gt.0.0.or.vmax.gt.0.0)then
        call velmute(hold,nsamp,posp,vmin,vmax,v0,sr,p,pp1)
        call velmute(shold,nsamp,posp,vmin,vmax,v0,sr,p,pp1)
        if(inv.ne.0)then
          call velmute(holdn,nsamp,negp,vmin,vmax,v0,sr,p,pp1)
          call velmute(sholdn,nsamp,negp,vmin,vmax,v0,sr,p,pp1)
        endif
      endif
C +=========================================+
C | If mute requested, apply to semblance   |
C | and scan data before picking and output |
C +=========================================+
      if(mute)then
        call appmute(shold,nsamp,posp,cmute)
        call appmute(hold,nsamp,posp,cmute)
        if(inv.ne.0)then
         call appmute(sholdn,nsamp,negp,cmute)
         call appmute(sholdn,nsamp,negp,cmute)
        endif
      endif
C +===============+
C | Pick the data |
C +===============+
      do i=1,np
        ndx = (i-1)*nsamp
        call hilbertx(hold(ndx+1),nsamp,work1,ierr)
        do j=1,nsamp
         envlp(ndx+j)=sqrt(hold(ndx+j)*hold(ndx+j) +
     :                     work1(j)*work1(j))
        end do
      end do
      if(inv.ne.0)then
       do i=1,negp
        ndx = (i-1)*nsamp
        call hilbertx(holdn(ndx+1),nsamp,work1,ierr)
        do j=1,nsamp
         envlp(ndx+j)=sqrt(holdn(ndx+j)*holdn(ndx+j) +
     :                     work1(j)*work1(j))
        end do
       end do
      endif
      recu = 1
      trcu = 1
      timeu = nsr
      nrecs = 1
      ntrcp = np
      call vclr(maxcrv,1,nsamp)
      call vclr(sembndx,1,nsamp)
      call getmax(shold,nsamp,np,maxcrv,sembndx)
      call pikmax(shold,maxcrv,sembndx,nsamp,sr,np,p,v0,
     :  thresh,vmin,vmax,pmin,pmax,delp,pick,npicks,lpick,
     :  vpick)
      wrknt = wrknt + 1
      if(wrknt.eq.1.and.pkfile)then
        write(lupik,35)'Units',recu,trcu,timeu,nrecs,np,nsamp
      endif
      write(segline,'(a)')'Segment = 1'
      if(pkfile)write(lupik,'(a)')segline
      one = irec
      do kk=1,npicks
        kki = lpick(kk)
        call locinc(kki,nsamp,iloc1,iloc2,iloc3,iloc4)
        itime = pick(iloc1)
        ti = itime
        tloc(kk)=ti
        idex = pick(iloc4)
        ctp = P(idex)
        atp = abs(ctp)
        if(atp.eq.0.0)atp = sr
        ctime = ti/1000.
        if(ctime.eq.0.0)ctime=sr
        cv=compvel(ctime,atp,v0)
        cv = abs (cv)
        vloc(kk) = cv
        if(pkfile)write(lupik,36)one,cv,ti
c     write(0,*)'kk= ',kk,' piks ',pick(iloc2),pick(iloc4),ti,atp,ctp,cv
      end do
   35 format(a,t10,f9.6,t23,f9.6,t36,f9.6,t50,i4,t56,i5,t64,i4)
c  36 format(f12.6,1x,f12.6,1x,f12.6)
c  35 format(a5,3f13.6,3i6,1x,a6,3f13.6)
   36 format(f12.6,1x,f12.6,1x,f12.6,1x,f12.6)

C   +===========================================+
C   | Output the stacked data and (optionally)  |
C   | the velocity information.                 |
C   +===========================================+
      call vel (tloc, vloc, nsamp, 1000.*sr, npicks, vels)
C +========================================+
C | IF stack option sto = 1, pick the data |
C +========================================+
      ijk = 1
      if(sto.eq.1)then
         call pikstk(hold,pick,npicks,sembndx,lpick,nsamp,
     :    nsr,v0,pmax,pmin,delp,p,np,stkout,velout)
       elsE
         do i=1,nsamp
           Live(i)=0.
           stkout(i)=0.
           velout(i)=vmin
         end do
         DO 85 i=1,nsamp
c         call vabs(hold(i),nsamp,work1,1,posp)
          call vmov(envlp(i),nsamp,work1,1,posp)
          call vmov(pndex1,1,jndex,1,posp)
          call hsorti(posp,work1,jndex)
          if(inv.ne.0)then
c           call vabs(holdn(i),nsamp,work2,1,negp)
            call vmov(envlpn(i),nsamp,work2,1,negp)
            call vmov(pndex2,1,kndex,1,negp)
            call hsorti(negp,work2,kndex)
          endif
          ctime=(i-1)*sr
          if(ctime.eq.0.0)ctime = sr
          kmp = posp
          kmn = negp
          sumvp = 0.
          sumvn =0.
          mm = 0
          mmn=0
          livep=0
          liven=0
          stakp=0
          stakn=0
          do 82 L=1,nst
           LL = L
   80      continue
           ist = kmp - LL + 1
           m = (jndex(ist) -1)*nsamp + i
           if(shold(m).lt.thresh)then
              LL = LL + 1
              if(LL.gt.nst)then
                 ist = posp-mm
                 mm = mm+1
                 if(mm.gt.nst)mm=mm-1
                 m=(jndex(ist)-1)*nsamp + i
                 go to 81
              endif
              go to 80
           endif
   81      continue
           stakp=stakp+hold(m)
           if(hold(m).ne.0.0)livep=livep+1
           ctp = p(jndex(ist))
           atp = abs(ctp)
           if(atp.eq.0.0)atp = sr
           cvp=compvel(ctime,atp,v0)
           cvp = abs (cvp)
           if(mute)then
             iik = cmute(i) + 1
             yyk = iik
             xxk = kk
             if(mute.and.(xxk.eq.yyk))cvp = 0.
           endif
           sumvp=sumvp+cvp
   82     continue
          if(inv.ne.0)then
          ndo = nst
          if(ndo.gt.negp)ndo=negp
          do 182 L=1,ndo
           LL = L
  180      continue
           ist = kmn - LL + 1
           m = (kndex(ist) -1)*nsamp + i
           if(sholdn(m).lt.thresh)then
              LL = LL + 1
              if(LL.gt.ndo)then
                 ist = negp-mmn
                 mmn = mmn+1
                 if(mmn.gt.ndo)mm=mm-1
                 m=(kndex(ist)-1)*nsamp + i
                 go to 181
              endif
              go to 180
           endif
  181      continue
           stakn=stakn+holdn(m)
           if(holdn(m).ne.0.0)liven=liven+1
           ctp = pneg(kndex(ist))
           atp = abs(ctp)
           if(atp.eq.0.0)atp = sr
           cvn=compvel(ctime,atp,v0)
           cvn = abs (cvn)
           if(mute)then
             iik = cmute(i) + 1
             yyk = iik
             xxk = kk
             if(mute.and.(xxk.eq.yyk))cvn = 0.
           endif
           sumvn=sumvn+cvn
  182     continue
          endif
          if(abs(stakp).ge.abs(stakn))then
            Live(i)=livep
            stkout(i)=stakp
            velout(i)=sumvp/float(nst)
            if(sumvp.le.zero)velout(i)=vmin
          else
            Live(i)=liven
            stkout(i)=stakn
            velout(i)=sumvn/float(nst)
            if(sumvn.ge.zero)velout(i)=vmin
          end if
   85    CONTINUE
         call vdivz(stkout,1, Live,1,zero,stkout,1,nsamp)
        endif
        do k=1,ITRWRD
         itr(k)=trhd(k)
        end do
c       itr2(l_RecNum)=irec
c       itr2(l_TrcNum)=1
c       itr2(l_StaCor)=0
        call savew2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              irec , 1)
        call savew2(itr2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              1    , 1)
        call savew2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              0    , 1)
        call vmov(stkout,1,itr(ITHWP1),1,nsamp)
        call wrtape(luout,itr,mbytes)
        IF(VOUT)THEN
         if(lmed.eq.0)then
          call vmov(vels,1,itr(ITHWP1),1,nsamp)
         else
          call medfil(vels,nsamp,lmed,itr(ITHWP1))
         endif
         call wrtape(luoutv,itr,mbytes)
        ENDIF
  100 CONTINUE
      call gfree(p1)
      call gfree(pen)
      if(inv.ne.0)then
        call gfree(p2)
        call gfree(ppn)
        call gfree(ph)
        call gfree(ps)
        call gfree(penn)
      endif
      return
      end
