C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C        SUBROUTINE EIGEN                                               EIG01000
C                                                                       EIG02000
C        PURPOSE                                                        EIG03000
C           COMPUTE EIGENVALUES AND EIGENVECTORS OF A REAL SYMMETRIC    EIG04000
C           MATRIX                                                      EIG05000
C                                                                       EIG06000
C        USAGE                                                          EIG07000
C           CALL EIGEN(A,R,N,MV)                                        EIG08000
C                                                                       EIG09000
C        DESCRIPTION OF PARAMETERS                                      EIG10000
C           A - ORIGINAL MATRIX (SYMMETRIC), DESTROYED IN COMPUTATION.  EIG11000
C               RESULTANT EIGENVALUES ARE DEVELOPED IN DIAGONAL OF      EIG12000
C               MATRIX A IN DESCENDING ORDER.                           EIG13000
C           R - RESULTANT MATRIX OF EIGENVECTORS (STORED COLUMNWISE,    EIG14000
C               IN SAME SEQUENCE AS EIGENVALUES)                        EIG15000
C           N - ORDER OF MATRICES A AND R                               EIG16000
C           MV- INPUT CODE                                              EIG17000
C                   0   COMPUTE EIGENVALUES AND EIGENVECTORS            EIG18000
C                   1   COMPUTE EIGENVALUES ONLY (R NEED NOT BE         EIG19000
C                       DIMENSIONED BUT MUST STILL APPEAR IN CALLING    EIG20000
C                       SEQUENCE)                                       EIG21000
C                                                                       EIG22000
C        REMARKS                                                        EIG23000
C           ORIGINAL MATRIX A MUST BE REAL SYMMETRIC (STORAGE MODE=1)   EIG24000
C           MATRIX A CANNOT BE IN THE SAME LOCATION AS MATRIX R         EIG25000
C                                                                       EIG26000
C           APPROXIMATE TIME (T) REQUIRED IS                            EIG27000
C                                                                       EIG28000
C              T = 0.101X10**-3 N**3 + 0.00292N SECONDS                 EIG29000
C                                                                       EIG30000
C           WHERE N IS THE ORDER OF THE GIVEN MATRIX A.                 EIG31000
C           FOR EXAMPLE, IF N = 10, THEN                                EIG32000
C                                                                       EIG33000
C              T = 0.101X10**-3 (10)**3 + 0.0292 = .124 SEC,            EIG34000
C           AND IF N = 100,                                             EIG35000
C                                                                       EIG36000
C              T = .101X10**-3 (100)**3 + 0.292 = 104 SEC               EIG37000
C                = 1 MIN 44 SEC.                                        EIG38000
C           THIS EXPERIMENTAL EQUATION WAS DERIVED BY R. WANG USING     EIG39000
C           UNIVAC 1108 COMPUTER.  DATE - JULY 2, 1970.                 EIG40000
C                                                                       EIG41000
C           THIS RELATION HOLDS ONLY WHEN MV = 1                        EIG42000
C                                                                       EIG43000
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED                  EIG44000
C           NONE                                                        EIG45000
C                                                                       EIG46000
C        METHOD                                                         EIG47000
C           DIAGONALIZATION METHOD ORIGINATED BY JACOBI AND ADAPTED     EIG48000
C           BY VON NEUMANN FOR LARGE COMPUTERS AS FOUND IN 'MATHEMATICALEIG49000
C           METHODS FOR DIGITAL COMPUTERS', EDITED BY A. RALSTON AND    EIG50000
C           H.S. WILF, JOHN WILEY AND SONS, NEW YORK, 1962, CHAPTER 7   EIG51000
C                                                                       EIG52000
C     ..................................................................EIG53000
C                                                                       EIG54000
      SUBROUTINE EIGEN(A,R,N,MV)                                        EIG55000
      DIMENSION A(1),R(1)                                               EIG56000
C                                                                       EIG57000
C        ...............................................................EIG58000
C                                                                       EIG59000
C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THE  EIG60000
C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION      EIG61000
C        STATEMENT WHICH FOLLOWS.                                       EIG62000
C                                                                       EIG63000
C     DOUBLE PRECISION A,R,ANORM,ANRMX,THR,X,Y,SINX,SINX2,COSX,         EIG64000
C    1                 COSX2,SINCS                                      EIG65000
C                                                                       EIG66000
C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTS    EIG67000
C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS      EIG68000
C        ROUTINE.                                                       EIG69000
C                                                                       EIG70000
C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSO      EIG71000
C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENTSEIG72000
C        40, 68, 75, AND 78 MUST BE CHANGED TO DSQRT.  ABS IN STATEMENT EIG73000
C        62 MUST BE CHANGED TO DABS.                                    EIG74000
C                                                                       EIG75000
C        ...............................................................EIG76000
C                                                                       EIG77000
C        GENERATE IDENTITY MATRIX                                       EIG78000
C                                                                       EIG79000
    5 RANGE=1.E-1                                                       EIG80000
C   5 RANGE=1.E-6                                                       EIG81000
      IF(MV-1) 10,25,10                                                 EIG82000
   10 IQ=-N                                                             EIG83000
      DO 20 J=1,N                                                       EIG84000
      IQ=IQ+N                                                           EIG85000
      DO 20 I=1,N                                                       EIG86000
      IJ=IQ+I                                                           EIG87000
      R(IJ)=0.0                                                         EIG88000
      IF(I-J) 20,15,20                                                  EIG89000
   15 R(IJ)=1.0                                                         EIG90000
   20 CONTINUE                                                          EIG91000
C                                                                       EIG92000
C        COMPUTE INITIAL AND FINAL NORMS (ANORM AND ANORMX)             EIG93000
C                                                                       EIG94000
   25 ANORM=0.0                                                         EIG95000
      DO 35 I=1,N                                                       EIG96000
      DO 35 J=I,N                                                       EIG97000
      IF(I-J) 30,35,30                                                  EIG98000
   30 IA=I+(J*J-J)/2                                                    EIG99000
      ANORM=ANORM+A(IA)*A(IA)                                           EIG00000
   35 CONTINUE                                                          EIG01000
      IF(ANORM) 165,165,40                                              EIG02000
   40 ANORM=1.414* SQRT(ANORM)                                          EIG03000
      ANRMX=ANORM*RANGE/FLOAT(N)                                        EIG04000
C                                                                       EIG05000
C        INITIALIZE INDICATORS AND COMPUTE THRESHOLD, THR               EIG06000
C                                                                       EIG07000
      IND=0                                                             EIG08000
      THR=ANORM                                                         EIG09000
   45 THR=THR/FLOAT(N)                                                  EIG10000
   50 L=1                                                               EIG11000
   55 M=L+1                                                             EIG12000
C                                                                       EIG13000
C        COMPUTE SIN AND COS                                            EIG14000
C                                                                       EIG15000
   60 MQ=(M*M-M)/2                                                      EIG16000
      LQ=(L*L-L)/2                                                      EIG17000
      LM=L+MQ                                                           EIG18000
   62 IF(  ABS(A(LM))-THR) 130,65,65                                    EIG19000
   65 IND=1                                                             EIG20000
      LL=L+LQ                                                           EIG21000
      MM=M+MQ                                                           EIG22000
      X=0.5*(A(LL)-A(MM))                                               EIG23000
   68 Y=-A(LM)/  SQRT(A(LM)*A(LM)+X*X)                                  EIG24000
      IF(X) 70,75,75                                                    EIG25000
   70 Y=-Y                                                              EIG26000
   75 SINX=Y/  SQRT(2.0*(1.0+( SQRT(1.0-Y*Y))))                         EIG27000
      SINX2=SINX*SINX                                                   EIG28000
   78 COSX=  SQRT(1.0-SINX2)                                            EIG29000
      COSX2=COSX*COSX                                                   EIG30000
      SINCS =SINX*COSX                                                  EIG31000
C                                                                       EIG32000
C        ROTATE L AND M COLUMNS                                         EIG33000
C                                                                       EIG34000
      ILQ=N*(L-1)                                                       EIG35000
      IMQ=N*(M-1)                                                       EIG36000
      DO 125 I=1,N                                                      EIG37000
      IQ=(I*I-I)/2                                                      EIG38000
      IF(I-L) 80,115,80                                                 EIG39000
   80 IF(I-M) 85,115,90                                                 EIG40000
   85 IM=I+MQ                                                           EIG41000
      GO TO 95                                                          EIG42000
   90 IM=M+IQ                                                           EIG43000
   95 IF(I-L) 100,105,105                                               EIG44000
  100 IL=I+LQ                                                           EIG45000
      GO TO 110                                                         EIG46000
  105 IL=L+IQ                                                           EIG47000
  110 X=A(IL)*COSX-A(IM)*SINX                                           EIG48000
      A(IM)=A(IL)*SINX+A(IM)*COSX                                       EIG49000
      A(IL)=X                                                           EIG50000
  115 IF(MV-1) 120,125,120                                              EIG51000
  120 ILR=ILQ+I                                                         EIG52000
      IMR=IMQ+I                                                         EIG53000
      X=R(ILR)*COSX-R(IMR)*SINX                                         EIG54000
      R(IMR)=R(ILR)*SINX+R(IMR)*COSX                                    EIG55000
      R(ILR)=X                                                          EIG56000
  125 CONTINUE                                                          EIG57000
      X=2.0*A(LM)*SINCS                                                 EIG58000
      Y=A(LL)*COSX2+A(MM)*SINX2-X                                       EIG59000
      X=A(LL)*SINX2+A(MM)*COSX2+X                                       EIG60000
      A(LM)=(A(LL)-A(MM))*SINCS+A(LM)*(COSX2-SINX2)                     EIG61000
      A(LL)=Y                                                           EIG62000
      A(MM)=X                                                           EIG63000
C                                                                       EIG64000
C        TESTS FOR COMPLETION                                           EIG65000
C                                                                       EIG66000
C        TEST FOR M = LAST COLUMN                                       EIG67000
C                                                                       EIG68000
  130 IF(M-N) 135,140,135                                               EIG69000
  135 M=M+1                                                             EIG70000
      GO TO 60                                                          EIG71000
C                                                                       EIG72000
C        TEST FOR L = SECOND FROM LAST COLUMN                           EIG73000
C                                                                       EIG74000
  140 IF(L-(N-1)) 145,150,145                                           EIG75000
  145 L=L+1                                                             EIG76000
      GO TO 55                                                          EIG77000
  150 IF(IND-1) 160,155,160                                             EIG78000
  155 IND=0                                                             EIG79000
      GO TO 50                                                          EIG80000
C                                                                       EIG81000
C        COMPARE THRESHOLD WITH FINAL NORM                              EIG82000
C                                                                       EIG83000
  160 IF(THR-ANRMX) 165,165,45                                          EIG84000
C                                                                       EIG85000
C        SORT EIGENVALUES AND EIGENVECTORS                              EIG86000
C                                                                       EIG87000
  165 IQ=-N                                                             EIG88000
      DO 185 I=1,N                                                      EIG89000
      IQ=IQ+N                                                           EIG90000
      LL=I+(I*I-I)/2                                                    EIG91000
      JQ=N*(I-2)                                                        EIG92000
      DO 185 J=I,N                                                      EIG93000
      JQ=JQ+N                                                           EIG94000
      MM=J+(J*J-J)/2                                                    EIG95000
      IF(A(LL)-A(MM)) 170,185,185                                       EIG96000
  170 X=A(LL)                                                           EIG97000
      A(LL)=A(MM)                                                       EIG98000
      A(MM)=X                                                           EIG99000
      IF(MV-1) 175,185,175                                              EIG00000
  175 DO 180 K=1,N                                                      EIG01000
      ILR=IQ+K                                                          EIG02000
      IMR=JQ+K                                                          EIG03000
      X=R(ILR)                                                          EIG04000
      R(ILR)=R(IMR)                                                     EIG05000
  180 R(IMR)=X                                                          EIG06000
  185 CONTINUE                                                          EIG07000
      RETURN                                                            EIG08000
      END                                                               EIG09000
