      program dspec8
c---------------------------------------------------------------------c
c                                                                     c
c      COMPUTER PROGRAMS IN SEISMOLOGY                                c
c      VOLUME VI                                                      c
c                                                                     c
c      PROGRAM: DSPEC8                                                c
c                                                                     c
c      COPYRIGHT 1985                                                 c
c      R. B. Herrmann                                                 c
c      Department of Earth and Atmospheric Sciences                   c
c      Saint Louis University                                         c
c      221 North Grand Boulevard                                      c
c      St. Louis, Missouri 63103                                      c
c      U. S. A.                                                       c
c                                                                     c
c---------------------------------------------------------------------c
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c     parameter (LER=0, LIN=5, LOT=6)
c-----
c     This programs prepares a data set for hspec8, e.g., hspec8.dat
c     It also estimates the size of the hspec8 data output file
c     It also examines previous output of hspec8 to determine
c     the extent of good output in the case hspec8 was abnormally
c     terminated. This is placed into hspec8.dat which allows computations
c     to restart where they were interrupted
      integer RECSIZ, FLTSIZ, CHRSIZ
      parameter(NL=100)
      parameter (RECSIZ=2*SZSMPD,INTSIZ=SZSMPD,FLTSIZ=SZSMPD)
#ifdef SUNSYSTEM
      parameter  (CHRSIZ=1)
#else
#ifdef CRAYSYSTEM
      parameter  (CHRSIZ=8)
#endif
#endif
      common/source/depth,lmax,dph,vamin,vamax,vbmin,vbmax,hvert
      common/damp/alpha
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL),ns(NL)
      common/jout/jsrc(16),jbdry,jbhaf
      character*50 name2, names
      character*3 istat2,istat3
      character*80 card
      integer     ordfft
#include <f77/pid.h>
      character   name*17
      common/count/intcnt,reccnt,fltcnt,chrcnt,exccnt,rshcnt
      integer   intcnt,reccnt,fltcnt,chrcnt,exccnt,rshcnt,ieqex
      integer   argis
      dimension ffreq(8)
      logical ixst2,ixst3,plane,acoust,cmdln,query
      data    plane/.false./, cmdln/.false./
      data    name/'OFFSET_MOD_DSPEC8'/
      intcnt = 0
      reccnt = 0
      fltcnt = 0
      chrcnt = 0
      exccnt = 0
      rshcnt = 0

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 .or. argis ('-h') .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif
c
c-----
c     open printout file
c-----
#include <f77/open.h>
     
      cmdln = (argis('-C') .gt. 0)
      acoust = .false.


   59 format(' ',a)
   60 format(a)
      if (cmdln) then
         call argstr('-M',names,' ',' ')
         if (names(1:1) .ne. ' ') then
            lumod = 1
         else
            lumod = LIN
         endif
      else
         write(LERR,*)' enter name of hspecX model file'
         read(LIN,60)names
         lumod = 1
      endif

c------
c  For cmdln option:
c  model comes in from a named disk file
c  else model comes in from stdin

      if (lumod .eq. 1) then
         open(unit=lumod,file=names,status='old',form='formatted',
     1            access='sequential')
         rewind 1
      endif
c------

      if (cmdln) then
         call argstr('-H',name2,' ',' ')
      else
         write(LERR,*)' enter name of spectra output file for hspec8'
         read(LIN,60)name2
      endif

c-----check if the output file exists. If it does, attempt
c-----recovery.
c-----assume it does not exist
      ixst2= .false.
      inquire(file=name2,exist=ixst2)
c-----
c     if the file does not exist set up output data fil
      write(LERR,59)name2
      ierr = -1
      if(ixst2)then
            istat2 = 'old'
      else
            istat2 = 'new'
      endif
      if(ixst2)then
            open(unit=2,file=name2,status='old',access='sequential',
     1                  form='unformatted')
            rewind 2
      endif
c-----
c     open output file for hspec8 input data stream
c-----
      if (plane) then
          inquire(file='hspecp.dat',exist=ixst3)
          if (ixst3) then
             write(LERR,*)'WARNING: hspecp.dat already exists'
             write(LERR,*)'hspecp will over write this file'
          endif
      else
          inquire(file='hspec9.dat',exist=ixst3)
      endif

      if(ixst3)then
            istat3='old'
      else
            istat3='new'
      endif

c     if (plane) then
c       open(unit=3,file='hspecp.dat',status=istat3,access='sequential',
c    1               form='formatted')
c     else
c       open(unit=3,file='hspec8.dat',status=istat3,access='sequential',
c    1               form='formatted')
c     endif

c     rewind 3


914   format(i5)
915   format(i5,5x,2f15.8)
c------

c     read in focal depth, lower and upper frequency bounds, dt,n
c           alpha,pct and dk
c-----
      if (cmdln) then
         call argr4('-ds',depth,0.0,0.0)
         call argr4('-fl',fl,1.0,1.0)
         call argr4('-fu',fu,0.0,0.0)
         call argr4('-dt',dt,.004,.004)
         if (fu .eq. 0.) then
            fu = 250./(1000.*dt)
            write(LERR,*)'High cut frequency set to ',fu,' Hz'
         endif
         call argi4('-lt',n,0,0)
         if (n .eq. 0) then
            write(LERR,*)'Must enter length of traces in samples'
            write(LERR,*)'and it should be a power of 2: 256, 512,'
         endif
c        if (mod(n,2) .ne. 0) then
            nu = ordfft(n)
             n = 2 ** nu
            write(LERR,*)'Power of 2 trace length=  ',n
c        endif
         call argr4('-a',alpha,0.5,0.5)
         call argr4('-xl',xleng,35000.,35000.)
         call argr4('-xf',xfac,4.0,4.0)
         call argr4('-dr',depthr,0.0,0.0)
c---------
c ieqex = 0  - EARTHQUAKE + EXPLOSION
c       = 1  - POINT FORCES + EXPLOSION
c       = 2  - ALL GREEN FUNCTIONS
c       = 3  - EXPLOSION ONLY
c       = 4  - EARTHQUAKE ONLY
c       = 5  - POINT FORCES ONLY

         call argi4('-E',ieqex, 3, 3)

c-----
c       provide names for output Green's functions in order of output
c-----
        if(ieqex.eq.0)then
                do 1234 i=1,16
                        if(i.le.8)then
                                jsrc(i) = 1
                        else
                                jsrc(i) = 0
                        endif
 1234           continue
                jsrc(13) = 1
                jsrc(14) = 1
                jsrc(16) = 1
        else if(ieqex.eq.1)then
                do 1235 i=1,16
                        if(i.ge.7)then
                                jsrc(i) = 1
                        else
                                jsrc(i) = 0
                        endif
 1235           continue
                jsrc(13) = 0
                jsrc(14) = 0
        else if(ieqex.eq.2)then
                do 1236 i=1,16
                        jsrc(i) = 1
 1236           continue
        else if(ieqex.eq.3)then
                do 1237 i=1,16
                        if(i.eq.7 .or. i.eq.8 .or. i.eq.16)then
                                jsrc(i) = 1
                        else
                                jsrc(i) = 0
                        endif
 1237           continue
        else if(ieqex.eq.4)then
                do 1238 i=1,16
                        if(i.le.6 .or. i.eq.13 .or. i.eq.14)then
                                jsrc(i) = 1
                        else
                                jsrc(i) = 0
                        endif
 1238           continue
        else if(ieqex.eq.5)then
                do 1239 i=1,16
                        if(i.ge.9)then
                                jsrc(i) = 1
                        else
                                jsrc(i) = 0
                        endif
 1239           continue
                jsrc(13) = 0
                jsrc(14) = 0
                jsrc(16) = 0
        endif


c---------

c        if (lumod .eq. 1) rewind 1
      else
c------
c     read in card field guides
c     read in field identifiers
    1    format(4f10.5,i5,5x,4f10.5)
         read(lumod,911) card
911      format(80a1)
         read(lumod,1)depth,fl,fu,dt,n,alpha,xleng,xfac,depthr
         ieqex = 1
      endif

      if(xfac.eq.0.0)xfac = 2.0
      if(xleng.eq.0.0)then
            write(LERR,*)' LENGTH factor for sampling not specified'
            stop
      endif
c-----
c     read in output list
c-----
      call srcout(acoust,cmdln,lumod)
c-----
c     read in earth model
c-----
      call srcmod (acoust,lumod)
      call srclyr
      fuu = 1./(2.*dt)
      if(fu.gt.fuu) fu = fuu
      df = 1./(n*dt)
      nyq = (n/2) + 1
      nyq2 = 2*nyq
      n1 = (fl/df + 1.000001)
      n2 = (fu/df + 1.000001)
      if(n2.gt.nyq) n2 = nyq
c------
c     check bouchon length (the "2.0" used to be "4.0"
c------
      xlt = 2. * vamax * float(n) * dt
      if(xleng .lt. xlt) then
         xleng = xlt
         write(LERR,*)' '
         write(LERR,*)'Bouchon length given too small.  Changed to ',
     1                xleng
         write(LERR,*)' '
      endif

      write(LERR,2)  fl,fu,df,n1,n2,depth,n,nyq,nyq2 
    2 format(1h ,'fl =',f10.5,5x,'fu =',f10.5,5x,'df =',f10.5,/ 
     1       5x,'n1 =',i4,5x,'n2 =',i4,5x,'depth =',f10.2,' n= ',i5,/
     2       5x,'nyq= ',i5,5x,'nyq2= ',i5 )
      write(LERR,5)alpha,dt ,xleng, xfac
    5 format(1h ,'alpha =',f10.5,5x,'dt =',f10.3,' xleng=',e10.3, 
     1      ' xfac=',f10.3)
      write(LERR,*)' '
      if (alpha .lt. .5) then
         write(LERR,*)'Warning:  your alpha is small and may result in'
         write(LERR,*)' spurious responses in the output record'
         write(LERR,*)'If this occurs use an alpha >= 0.5'
      endif
      write(LERR,*)' '
      write(LERR,4) 
    4 format(1h ,'frequencies for which response computed'     ) 
c-----
c     write information onto data file for hspec9 or hspecp
c-----
         write(LOT,18)name2
         write(LOT,18)istat2
         write(LOT,19)ierr,ifreq,ieqex

   18 format(a)
   19 format(3i5)
      write(LOT,20) alpha,depth,fl,fu,dt,n,n1,n2,df,nyq2,mmax,depthr
      reccnt=reccnt+1
      intcnt=intcnt+5
      fltcnt=fltcnt+6
   20 format(5e15.7/3i10,e15.7,i10,i10,5x,f10.5)
      write(LOT,21)jsrc ,jbdry,jbhaf
      reccnt=reccnt+1
      intcnt=intcnt+10
   21 format(18i5)
      write(LOT,22)(d(i),a(i),b(i),rho(i),qa(i),qb(i),i=1,mmax)
      reccnt=reccnt+1
      fltcnt=fltcnt + NL*6
   22 format(6e11.4)
c     write(LOT,23)lmax,dph,vamin,vamax,vbmin,vbmax,hvert
c  23 format(i10,6e11.4)
      write(LOT,24)xleng, xfac
   24 format(2e15.7)
c     close(3)
c-----
c     if spectra file exists already, the maximum size
c     is already known, do not recompute
c     just bypass this feature
c-----
      if(ixst2 .or. cmdln)goto 9999
c-----
c     go through exercise of computing frequencies to
c     estimate storage requirements
c-----
      ilow=mod(n1,8) 
       if(ilow.eq.0)ilow=8 
      iup=mod(n2,8) 
      if(iup.eq.0)iup=8 
      do 101 i=1,8 
  101 ffreq(i)=-1.0 
      n11 = n1
c      if(ifreq.gt.n1)n11 = ifreq + 1
      do 100 i = n11,n2 
      freq=(i-1)*df 
      if(freq.lt.0.001) freq = 0.001 
      call excit(freq,xleng,xfac) 
      index=mod(i,8) 
      if(index.eq.0)index=8 
      ffreq(index)=freq 
      if (index.eq.8) then 
                write(LERR,3)ffreq 
                do 102 ii=1,8 
  102   ffreq(ii)=-1. 
        endif 
    3 format(8f10.5) 
  100 continue 
      write(LERR,3)ffreq 
c-----
c     compute storage requirements
c-----
      write(LERR,*)'EXCIT called',exccnt,' times'
      write(LERR,*)'RSHOF called',rshcnt,' times'
      write(LERR,*)'reccnt,intcnt,fltcnt,chrcnt',reccnt,intcnt,
     1            fltcnt,chrcnt
      write(LERR,*)' '
      write(LERR,*)'RECSIZ =  ',RECSIZ,'   reccnt =  ',reccnt
      write(LERR,*)'INTSIZ =  ',INTSIZ,'   intcnt =  ',intcnt
      write(LERR,*)'FLTSIZ =  ',FLTSIZ,'   fltcnt =  ',fltcnt
      write(LERR,*)'CHRSIZ =  ',CHRSIZ,'   chrcnt =  ',chrcnt
      write(LERR,*)' '
 9999 continue
      close(1)
      if(ixst2)close(2)
      stop
      end

      subroutine srcout(acoust,cmdln,lumod)
#include <f77/iounit.h>
c     parameter (LER=0, LIN=5, LOT=6)
      common/jout/jsrc(16) ,jbdry,jbhaf
      character*80 card
      logical acoust, cmdln
c to save space on output, any of the first ten 
c solutions can be output 
c rule: output if jsrc(i) = 1 ; do not if = 0 
      if (cmdln) then
         call argi4('-jb',jbdry,1,1)
         call argi4('-jh',jbhaf,0,0)
      else
         read(lumod,911) card
911      format(80a1)
         read(lumod,1)jbdry, jbhaf
    1    format(12i5) 
      endif

      write(LERR,2)(j,jsrc(j),j=1,10) ,  jbdry,jbhaf
    2 format(' srcout:jsrc ', 10(i3,':',i2), ' jbdry=',i2,' jbhaf= ',i2) 
      return 
      end 

      subroutine srclyr 
#include <f77/iounit.h>
c     parameter (LER=0, LIN=5, LOT=6)
      parameter(NL=100)
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL),ns(NL)
      common/source/depth,lmax,dph,vamin,vamax,vbmin,vbmax,hvert
c     lmax = source layer 
c     depth = source depth 
c     dph = height of  source above lmax + 1 interface 
c     lmax = 0 is the free surface 
      dep = 0.0 
      mmx1 = mmax - 1 
      do 100 m = 1,mmx1 
      dep = dep + d(m) 
      dph = dep - depth 
      lmax = m 
      if(dph.ge.0.0) go to 101 
  100 continue 
  101 continue 
      return 
      end 

      subroutine srcmod (acoust,lumod)
#include <f77/iounit.h>
c     parameter (LER=0, LIN=5, LOT=6)
c     read in earth model 
      parameter(NL=100)
      character*80  card
      logical  acoust
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL),ns(NL)
      common/source/depth,lmax,dph,vamin,vamax,vbmin,vbmax,hvert
      common/jout/jsrc(16) ,jbdry,jbhaf
c      read(lumod,911) card
c911   format(80a1)
      do 20 i = 1,NL 
c     read(lumod,1,end=21) d(i),a(i),b(i),rho(i),qa(i),qb(i)
      read(lumod,1,end=21) d(i),a(i),b(i),rho(i),qai,qbi
      qa(i) = 1/qai
      qb(i) = 1/qbi
    1 format(6f10.3) 
c     if(qa(i).eq.0.0) qa(i) = 0.5*qb(i) 
      mmax = i 
      if(d(i).le.0.0) go to 21 
   20 continue 
   21 continue 
      mmx1 = mmax - 1 
c     mmx1 = mmax 
      write(LERR,2) 
    2 format(1h ,7x,'d',9x,'a',9x,'b',9x,'rho',6x,'1/qa',6x,'1/qb')
      hvert = 0.0
      do 400 i = 1,mmx1 
      hvert = hvert + d(i)
      write(LERR,3)d(i),a(i),b(i),rho(i),qa(i),qb(i)
    3 format(1h ,4f10.2,2f10.6) 
  400 continue 
      write(LERR,5)a(mmax),b(mmax),rho(mmax),qa(mmax),qb(mmax) 
    5 format(1h ,10x,3f10.2,2f10.6/1h ) 
c-----
c     obtain extreme velocity limits
c-----
      if (acoust) then
         do 99  i=1,mmax
                b(i) = 0.
99       continue
      endif

      vamin = 1.0e+31
      vbmin = 1.0e+31
      vamax = 0.0
      vbmax = 0.0
      do 100 i=1,mmax
c           if (b(i) .le. 0.0) acoust = .true.
            if(a(i).gt.vamax)vamax=a(i)
            if(b(i).gt.vbmax)vbmax=b(i)
            if(a(i).lt.vamin)vamin=a(i)
            if(b(i).lt.vbmin .and. b(i).ne.0.0)vbmin=b(i)
  100 continue
            if(vbmax .le. 0.) vbmax = vamax
            if(vbmin .le. 0.) vbmin = vamin

      if (acoust) then
         do 101  i = 1, 16
             jsrc(i) = 0
101      continue
         jsrc(7) = 1
      endif

      write(LERR,*)' '
      write(LERR,6)vamax,vamin,vbmax,vbmin
    6 format(' vamax =',f10.2,' vamin =',f10.2/
     1             ' vbmax =',f10.2,' vbmin =',f10.2)
      write(LERR,*)' '
      if (acoust) then
         write(LERR,*)'***  ACOUSTIC CASE ASSUMED  ***'
      else
         write(LERR,*)'***  ELASTIC CASE ASSUMED  ***'
      endif
      write(LERR,*)' '
      return 
      end 

      subroutine excit(freq,xleng,xfac) 
#include <f77/iounit.h>
c-----
c     sample response for all wavenumbers at a given frequency
c     using Bouchon equal wavenumber sampling = dk
c-----
c     integer*4 LER,LIN,LOT,NL
c     parameter(LER=0,LIN=5,LOT=6)
      parameter(NL=100)
      common/source/depth,lmax,dph ,vamin,vamax,vbmin,vbmax,hvert
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL),ns(NL)
      common/jout/jsrc(16) ,jbdry,jbhaf
      common/damp/alpha 
      common/count/intcnt,reccnt,fltcnt,chrcnt,exccnt,rshcnt
      integer*4 intcnt,reccnt,fltcnt,chrcnt,exccnt,rshcnt
      exccnt = exccnt + 1
      dk = 6.2831853/xleng
      omega=6.2831853*freq 
      wvbm = omega/vbmin
      wvmm = (5.0/depth) + xfac*wvbm
      nk = wvmm / dk
        mk=nk+2 
      mk1=nk+1
c      write(2)omega,mk 
      reccnt = reccnt +1
      fltcnt = fltcnt +1
      intcnt = intcnt +1
c-----output wavenumber in reverse order
c     also output first two wavenumbers to control
c     low frequency asymptotic integration
c-----to save space in sequential i/o buffer output stream
c     call bufini(1,ierr)
      do 3998 ii=mk,1,-1
c            if(ii.eq.mk)then
c                  wv = 6.0/depth
c            elseif(ii.eq.mk1)then
c                  wv = 2.5/depth
c            else
c                  wv = (ii-1)*dk + 0.281*dk
c            endif
c#ifdef SUNSYSTEM
c            wvn=dcmplx(dble(wv),0.0d+00) 
c            om=dcmplx(dble(omega),-dble(alpha)) 
c#else
c#ifdef CRAYSYSTEM
c            wvn=cmplx((wv),0.0e+00) 
c            om=cmplx((omega),-(alpha)) 
c#endif
c#endif
c           call rshof(gg,om,wvn) 
            rshcnt = rshcnt +1
c            call bufwr(wv)
c            do 3998 j=1,16 
c                  if(jsrc(j).eq.1)then
c                  call bufwr(real(gg(j)))
c                  call bufwr(aimag(gg(j)))
c            endif
3998   continue 
c      call buflsh
      return 
      end 

      subroutine help
#include <f77/iounit.h>
c-----------------------------------------------------------------------------
c     online help screen
c-----------------------------------------------------------------------------
c
       write(ler,*)' '
       write(ler,*)'Command Line Arguments for DSPEC8: '
       write(ler,*)'      set up data for programs hspec9 and hspecp'
       write(ler,*)' '
       write(ler,*)'-C         -- bring global parms from cmd line'
       write(ler,*)'-M[names]  -- name of file containing earth model'
       write(ler,*)'              <default is to read from stdin>'
       write(ler,*)'-H[name2]  -- name of spectrup file created by '
       write(ler,*)'              hspecX to be in input to rhfoc'
       write(ler,*)'-ds[depth] -- initial depth of source (def=0)'
       write(ler,*)'-dr[depthr]-- initial depth of receiver (def=0)'
       write(ler,*)'-fl[fl]    -- low cut frequency (def=1.0)'
       write(ler,*)'-fu[fu]    -- hight cut frequency (def=Nyquist/2)'
       write(ler,*)'-dt[dt]    -- sample interval in secs (def=.004)'
       write(ler,*)'-lt[lt]    -- length of traces in samples. (should'
       write(ler,*)'              be a power of two. - no default)'
       write(ler,*)'-a[alpha]  -- damping parameter (def=.5)'
       write(ler,*)'-xl[xleng] -- spatial length parameter (def=35000)'
       write(ler,*)'-xf[xfac]  -- wave number sampling (def=4.)'
       write(ler,*)'-jb[jbdry] -- topmost boundary flag (def=0;',
     1             ' elastic halfspace)'
       write(ler,*)'-jh[jbhaf] -- halfspace boundary flag (def=0;',
     1             ' elastic halfspace)'
       write(ler,*)'-E[ieqex]  -- source type flag (refer to manpage)'
       write(ler,*)' '
       write(ler,*)'Usage:'
       write(ler,*)'    dspec8 [-C] [-Mnames]  [-Hname2]  [-dsdepth] ',
     1             '[-drdepthr] [-flfl] [-fufu]'
       write(ler,*)' 	  [-dtdt] [-ltlt]',
     1             '[-aalpha] [-xlxleng] [-xfxfac] [-Eieqex]'
       write(ler,*)' '
      return
      end


