        program rhfocsis
c---------------------------------------------------------------------c
c                                                                     c
c      COMPUTER PROGRAMS IN SEISMOLOGY                                c
c      VOLUME VI                                                      c
c                                                                     c
c      PROGRAM: RHFOCSIS                                              c
c                                                                     c
c      COPYRIGHT 1991                                                 c
c      R. B. Herrmann                                                 c
c      Department of Earth and Atmospheric Sciences                   c
c      Saint Louis University                                         c
c      221 North Grand Boulevard                                      c
c      St. Louis, Missouri 63103                                      c
c      U. S. A.                                                       c
c                                                                     c
c---------------------------------------------------------------------c
c-----
c
c     rhfocsis -fFILE  [ -t -o -p -i ] -aALP -lL [ -D -V -A ] -Osisfile
c
c       This convolves output of hspec91 with the
c       far-field displacement
c       pulses to yield velocity time
c       histories
c     The symmetric parabolic pulse ( -p )
c     of Wang and Herrmann (1980) is used.
c     A simple triangular pulse ( -t ) is also available.
c     as is the Ohnaka source time function ( -o )
c     The total duration of the pulse is 4L dt for the parabolic pulse
c     and 2L dt for the triangular pulse.
c
c     L is the number of dt's per tau, e.g.
c           tau = L dt . If -n is not specified,
c           then tau = dt by default
c     
c     ALP is the constant in the ohnaka time function whose
c     far field displacement is alpha*alpha*t*exp(-alpha*t)
c           and whose Fourier  spectrum is
c           [ ALP / ( j2pif + ALP ] ** 2
c           This has a corner frequency of fc=ALP/2pi
c
c     Other pulses might be able to be used. But this
c     one is stable. Note that for tau = dt,
c     -v indicates verby output on device LER
c
c     -i = impulse source
c     -D = output displacement time history
c     -V = output velocity time history (default)
c     -A = output acceleration time history
c
c     The pulses are such that the far-field dispacements would
c     have unit area
c
c     The pulses used correspond to the dislocation
c               far-field displacement to get velocity history
c
c
c-----
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

	common/jout/jsrc(16),lsrc(16),ksrc(16)
	character*256 names 
	integer ntau, ipt, alp,ifile,idva,ndist,ngrn
#include <f77/pid.h>
C**********************************************************************C
C
C     PROGRAM SYNTH make synthetic time history
C
C**********************************************************************C
C
C  UPOLF READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C
C SUBROUTINE CALLS: RTAPE, WRTAPE, HLH, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C-----
	integer      itr1 (SZLNHD)
	integer      luout, lbyout
	integer      lbyte
	integer      statc1
	real         tri  (SZLNHD)
	real         work (SZLNHD)
	real         coefs(2,32), wrk1(3), wrk2(96)
	integer      nsamp, nsi, ntrc, nrec, iform
	character    name * 8
	integer      ns, ne, rs, re
	character    otap1*256
	logical      verbos
	logical      plane
	logical      query
	integer      argis
 
c	equivalence ( itr1(129), tri (1) )
	data name /'RHFOCSIS'/, lbyout  / 0 /
	data verbos/.true./
	norder = 4
	init   = 1
c-----
c	read program parameters from command line
c-----
	query = (argis('-?') .gt. 0)
	if(query) then
		call help()
		stop
	endif
c-----
c-----
c	open printout file
c-----
#include <f77/open.h>

c	parse command line arguments
c-----
	call gcmdln(ntau,ipt,alp,ifile,names,idva,
     1		otap1,verbos,plane,ishft,fl,fh)
c-----
c	read in output of hspec9, determine number of distances
c	and number of green's function
c-----
	open(unit=2,status='scratch',form='unformatted')
	rewind 2
	call getgrn(ntau,ipt,alp,ifile,names,idva,ndist,ngrn,nsamp,
     1		    dt)
	nrec = ngrn
	ntrc = ndist
	nsi = (1000.0 * dt)
	iform = 3
	fnyq = .5 / dt
	if (fh .eq. 0.0) then
	    fh = .8 * fnyq
	endif
	write(LERR,*)nrec,ntrc,nsi,iform,ngrn,ndist

	call bwcoef ( fl, fh, dt, coefs, xnorm, norder, ift)
c-----
c	get logical unit numbers for output
c-----
	call getln(luout, otap1,'w', 1)
c-----
c	read line header of input
c	save certain parameters
c-----
      
	rs = 1
	re = 1
	ns = 1
	ne = ndist
c-----
c	update line header for output file 1
c-----
	call savew(itr1, 'NumRec', nrec,  LINHED)
	call savew(itr1, 'NumTrc', ntrc,  LINHED)
	call savew(itr1, 'NumSmp', nsamp, LINHED)
	call savew(itr1, 'SmpInt', nsi,   LINHED)
	call savew(itr1, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)

c-----
c	set up default byte count
c	1000 for line header and velocity, +2 for number of headers in HLH
c	+2 for number of bytes in HLH
c-----
        unitsc = .001
	lbyte  = HSTOFF
        nbyt   = 2 * SZHFWD
        nbytes = SZTRHD + SZSMPD * nsamp
	call savew(itr1, 'HlhEnt',    0, LINHED)
	call savew(itr1, 'HlhByt', nbyt, LINHED)
	call savew(itr1, 'UnitSc', unitsc, LINHED)
	call savhlh(itr1,lbyte,lbyout)
        call wrtape(luout, itr1, lbyout)
c-----
c	modify line header to reflect actual number of traces output
c-----
        ishft = ishft / nsi

        if (ishft .eq. 0) then
           if (ipt .eq. 0 .OR. ipt .eq. 1) then
               ishft = ntau
           endif
        endif

        shft = ishft

	do 9000 jrec=1,nrec
	rewind 2
	do 9005 jtrc = 1,ntrc

           if (plane) then
              write(LERR,*)'Writing trace ',jtrc,' for ray param= ',r,
     1                     ' Greens function= ',jrec
              write(LER ,*)'Writing trace ',jtrc,' for ray param= ',r,
     1                     ' Greens function= ',jrec
           else
              write(LERR,*)'Writing trace ',jtrc,' for range= ',r,
     1                     ' Greens function= ',jrec
              write(LER ,*)'Writing trace ',jtrc,' for range= ',r,
     1                     ' Greens function= ',jrec
           endif
	do 9010 jgrn=1,ngrn

                write(LERR,*)'Writing greens fctn= ',jgrn
		read(2)r,jk
		read(2)(work(i),i=1,nsamp)

		call vclr (tri, 1, nsamp)
                if (plane) r = r * 10000000.

c               if (plane) then
c   		    do  i = 1, ishft
c   		        ii = nsamp - ishft
c   		        scl = float(ishft - i) / shft
c                       work (ii + i) = scl * work (ii + i)
c                   enddo
c		    call vmov (work(ishft), 1, tri, 1, nsamp-ishft+1)
c               else
c                   do  i = 1, ishft
c                       ii = nsamp - ishft
c                       scl = float(ishft - i) / shft
c                       work (ii + i) = scl * work (ii + i)
c                       enddo
c               endif

                if (ishft .gt. 0) then
                   call vmov (work(ishft), 1, tri, 1, nsamp-ishft)
                elseif (ishft .lt. 0) then
                   call vmov (work, 1, tri(ishft), 1, nsamp-ishft)
                else
                   call vmov (work, 1, tri, 1, nsamp)
                endif

		call vclr (wrk1, 1, 3)
		call vclr (wrk2, 1, 96)
                call bwfilt ( tri, tri, wrk1, wrk2, coefs,
     1                        xnorm, norder, nsamp, init, 0)
		init = 0
		call vrvrs (tri,  1, nsamp)
		call bwfilt ( tri, tri, wrk1, wrk2, coefs,
     1                        xnorm, norder, nsamp, init, 0)
		call vrvrs (tri,  1, nsamp)
		call vmov (tri, 1, itr1(ITHWP1), 1, nsamp)
		idist =  ifix(r)
		if( jgrn.eq.jrec)then
			statc1 = 0
                        call savew2(itr1,ifmt_StaCor,l_StaCor,
     1                              ln_StaCor, statc1 , TRACEHEADER)
                        call savew2(itr1,ifmt_PrRcNm,l_PrRcNm,
     1                              ln_PrRcNm, jrec   , TRACEHEADER)
                        call savew2(itr1,ifmt_RecNum,l_RecNum,
     1                              ln_RecNum, jrec   , TRACEHEADER)
                        call savew2(itr1,ifmt_PrTrNm,l_PrTrNm,
     1                              ln_PrTrNm, jtrc   , TRACEHEADER)
                        call savew2(itr1,ifmt_TrcNum,l_TrcNum,
     1                              ln_TrcNum, jtrc   , TRACEHEADER)
                        call savew2(itr1,ifmt_DstSgn,l_DstSgn,
     1                              ln_DstSgn, idist  , TRACEHEADER)
                        call savew2(itr1,ifmt_DstUsg,l_DstUsg,
     1                              ln_DstUsg, idist  , TRACEHEADER)
                        call savew2(itr1,ifmt_SGRNum,l_SGRNum,
     1                              ln_SGRNum, jk     , TRACEHEADER)
			call wrtape(luout, itr1, nbytes)
		endif
 9010	continue
 9005	continue
 9000	continue
        call lbclos(luout)
	close(2)
      stop
      end


	subroutine getgrn(ntau,ipt,alp,ifile,names,idva,
     1		          ndist,ngrn,nsamp,dt)
	integer ntau, ipt, alp,ifile,idva,ndist,ngrn,nsamp
	common/jout/jsrc(16),lsrc(16),ksrc(16)
	common/source/z(2048)
	parameter(NL=100)
	common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL) 
	dimension ar(16),ai(16)
	character*4 icchar (16)
	character*50 names 
	complex data(2048),datas(1025)
#include <f77/iounit.h>
c-----
c	do some error checking
c-----
	if(ifile.lt.0)then
		write(LER,*)'no data file'
		call help()
		stop
	endif
	if(ipt.eq.2 .and. alp.lt.0.0)then
		write(LER,*)' alp not given for ohnaka pulse'
		call help()
		stop
	endif
        npuls=1 
	open(unit=3,file=names,access='sequential',form='unformatted' 
     1		,status='old') 
	open(unit=4,status='scratch',form='unformatted')
	rewind 3
	rewind 4
	do 99 i=1,n 
		z(i)=0.0 
   99	continue
c-----
c	get header from hspec91
c-----
	read(3) alpha,fl,fu,dt,n,n1,n2,df,nyq2 
	read(3)jsrc 
	read(3)lsrc 
	read(3)d,a,b,rho,mmax,qa,qb 
	nyq=nyq2/2 
	nsamp = n
c-----
c	form list of output Green functions
c-----
	do 199 i=1,16
		if(jsrc(lsrc(i)).eq.1)then
			ksrc(i) = 1
		else
			ksrc(i) = 0
		endif
  199	continue
c-----
c	default for filter
c-----
	if(ntau.le.0)then
		tau = dt
	else
		tau = ntau * dt
	endif
	if(ipt.eq.0)then
		call pultd(tau,dt,n,l)
	elseif(ipt.eq.1)then
		call pulpd(tau,dt,n,l)
	elseif(ipt.eq.2)then
		call pulod(alp,dt,n,l)
	elseif(ipt.eq.3)then
		call puldd(dt,n,l)
	endif
	fmax = fu 
c-----
c	plot source pulse and spectra 
c	since omega is complex time series has to be damped 
c-----
	fac = 1.0 
	dfac = exp(-alpha*dt) 
	do 200 i = 1,n 
		data(i) = cmplx(fac*z(i),0.0)
		fac = fac * dfac 
  200	continue
	call four1(data,n,-1,dt,df) 
	do 310 i = 1,nyq 
		freq=(i-1)*df 
		if(freq.gt.fmax .or. i.lt.n1 .or. i.gt.n2)then
			data(i) = cmplx(0.0,0.0)
		endif
  310	continue 
	do 206 i = 1,nyq 
		datas(i) = data(i) 
  206	continue
c----
c	get number of green's functions, e.g., records
c-----
	ngrn = 0
	do 411 i=1,16
		if(jsrc(lsrc(i)).gt.0)ngrn = ngrn + 1
  411	continue
c-----
c	beginning of distance loop
c-----
	ndist = 0
 9997	continue 
      read(3,err=9999,end=9999)r,t0,depths,depthr
      if(r.lt.0.0) go to 9999 
c		read(3,err=9999,end=9999)r,t0
c		if(r.lt.0.0) go to 9999 
		ndist = ndist + 1
c-----
c	set up output stream
c-----
		do 249 jj=1,16
			read(3,err=9999,end=9999)icchar(jj)
  249		continue
		rewind 4
		do 300 i=n1,n2
			do 305 j=1,16
				ar(j)=0.0
				ai(j)=0.0
				if(jsrc(lsrc(j)).eq.1) then
					read(3,err=9999,end=9999)ar(j),ai(j)
				endif
  305			continue
			write(4)ar,ai
  300		continue
c-----
c	Now that all spectra for a given distance are in
c	make time history and output in desired order
c-----
		do 1300 jk=1,16
			if(jsrc(lsrc(jk)).eq.1) then
			do 1301 i=1,n
				data(i)=cmplx(0.0,0.0)
 1301			continue
			rewind 4
			do 1302 i=n1,n2
				read(4)ar,ai
				data(i)=cmplx(ar(jk),ai(jk))*datas(i)
c-----
c	if integrate
c-----
				if(idva.eq.0)then
				  omega = 6.2831853*(i-1)*df	
				  data(i) = data(i) / cmplx(alpha,omega)
				elseif(idva.eq.2)then
				  omega = 6.2831853*(i-1)*df
				  data(i) = data(i) * cmplx(alpha,omega)
				endif
c-----
c	make a real time series
c-----
				if(i.ne.1)data(n+2-i)=conjg(data(i))
 1302			continue
			data(nyq)=cmplx(real(data(nyq)),0.0)
			call four1(data,n,+1,dt,df)
c-----
c	correct for damping 
c	output the time series to a temporary file
c	However, only output if the trace has information
c-----
			fac = exp(alpha*t0) 
			dfac = exp(alpha*dt) 
			do 425 i = 1,n 
				data(i)= data(i) * fac
				fac = fac * dfac 
  425			continue 
			write(2)r,jk
			write(2)(real(data(i)),i=1,n)
		endif
 1300		continue
	go to 9997 
 9999	continue 
	close(3) 
	close(4)
	return 
	end 

      subroutine four1(data,nn,isign,dt,df) 
      dimension data(1) 
      n = 2 * nn 
      if(dt.eq.0.0) dt = 1./(nn*df) 
      if(df.eq.0.0) df = 1./(nn*dt) 
      if(dt.ne.(nn*df)) df = 1./(nn*dt) 
      j = 1 
      do 5 i=1,n,2 
      if(i-j)1,2,2 
    1 tempr = data(j) 
      tempi = data(j+1) 
      data(j) = data(i) 
      data(j+1)=data(i+1) 
      data(i) = tempr 
      data(i+1) = tempi 
    2 m = n/2 
    3 if(j-m) 5,5,4 
    4 j = j-m 
      m = m/2 
      if(m-2)5,3,3 
    5 j=j+m 
      mmax = 2 
    6 if(mmax-n) 7,10,10 
    7 istep= 2 *mmax 
      theta = 6.283185307/float(isign*mmax) 
      sinth=sin(theta/2.) 
      wstpr=-2.*sinth*sinth 
      wstpi=sin(theta) 
      wr=1.0 
      wi=0.0 
      do 9 m=1,mmax,2 
      do 8 i=m,n,istep 
      j=i+mmax 
      tempr=wr*data(j)-wi*data(j+1) 
      tempi=wr*data(j+1)+wi*data(j) 
      data(j)=data(i)-tempr 
      data(j+1)=data(i+1)-tempi 
      data(i)=data(i)+tempr 
    8 data(i+1) = data(i+1)+tempi 
      tempr = wr 
      wr = wr*wstpr-wi*wstpi + wr 
    9 wi = wi*wstpr+tempr*wstpi + wi 
      mmax = istep 
      go to 6 
   10 continue 
      if(isign.lt.0) go to 1002 
c     frequency to time domain 
      do 1001 iiii = 1,n 
 1001 data(iiii) = data(iiii) * df 
      return 
 1002 continue 
c     time to frequency domain 
      do 1003 iiii = 1,n 
 1003 data(iiii) = data(iiii) * dt 
      return 
      end 

      subroutine pulpd(tau,dt,nt,l)
c     far field displacement
      common /source/ f(2048)
      ltest = 0
      tl = tau
      t1 = 0.01*dt
      t2 = t1 + tau
      t3 = t2 + tau
      t4 = t3 + tau
      t5 = t4 + tau
      do 100 i = 1,nt
      y=(i-1)*dt
      z = y - t1
      f(i) = 0.0
      if(y.gt.t1)go to 101
  101 if(y.gt.t2) go to 102
      f(i) = 0.5*(z/tl)**2
      go to 100
  102 if(y.gt.t3) go to 103
      f(i)= -0.5*(z/tl)**2 + 2.*(z/tl) - 1
      go to 100
  103 if(y.gt.t4) go to 104
      f(i)= -0.5*(z/tl)**2 + 2.*(z/tl) - 1.
      go to 100
  104 if(y.gt.t5) go to 105
      f(i)= 0.5*(z/tl)**2 - 4.*(z/tl) + 8.
      go to 100
  105 continue
      ltest = ltest + 1
      if(ltest.eq.1) l = i
  100 continue
c     pulse normalized so first integral has area of unity
      do 200 i = 1,nt
  200 f(i) = f(i)/(2.*tl)
      return
      end

      subroutine pulod(alp,dtt,nt,l)
c     far field displacement
c     for the ohnaka slip history
c     Harkrider (1976) Geophys J. 47, p 97.
      common/source/v(2048)
      ltest = 0
      do 100 i=1,nt
      t=(i-1)*dtt
      v(i)=0.0
      arg= alp*t
      al2=alp*alp
      v(i)=0.0
      if(arg.gt.25.)goto 101
        v(i)= al2*t*exp(-arg)
      goto 100
  101 continue
      ltest = ltest +1
      if(ltest.eq.1)l = i
  100 continue
      return
      end

      subroutine pultd(tau,dtt,nt,l)
c waveform is far-field displacement
c triangular pulse
c this is really a general trapezodal pulse, but only
c the symmetric triangular pulse is invoked
      common/source/d(2048)
      ltest = 0
      dt1=tau
      dt2=0.0
      dt3=tau
      t1=dt1
      t2=t1+dt2
      t3=t2+dt3
      fac = 0.5*dt1 + dt2 + 0.5*dt3
      fac = 1./fac
      v1 = fac/dt1
      v2 = 0.0
      v3 = - fac/dt3
      do 100 i=1,nt
      t = (i-1)*dtt
      d(i)=0.0
      if(t.le.t1)then
            dt = t - 0.0
            d(i) = dt*fac/dt1
      elseif(t.gt.t1.and.t.le.t2)then
            dt = t - t1
            d(i) = fac
      elseif(t.gt.t2.and.t.le.t3)then
            dt = t - t2
            d(i)= fac + v3*dt
      elseif(t.gt.t3)then
            d(i)=0.0
            ltest = ltest + 1
            if(ltest.eq.1)l = i
      endif
  100  continue
      return
      end

      subroutine puldd(dt,n,l)
      common/source/d(2048)
c-----
c	Dirac Delta Pulse
c-----
	do 100 i=1,n
		d(i) = 0.0
  100	continue
	d(1) = 1.0/dt
	return
	end

      subroutine help
#include <f77/iounit.h>

      write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'Execute rhfocsis  with the following arguments'
      write(LER,*)
     1' -f[names] (no default)     :Input HSPEC9 output data file name'
      write(LER,*)
     1' -O[otap1] (default stdout)   : output file for  '
      write(LER,*)
     1' -l[l],   (default=1)         : duration parameter'
	write(LER,*)
     1' -A      (default=false)      : acceleration time history'
	write(LER,*)
     1' -V      (default=true )      : velocity time history'
	write(LER,*)
     1' -D      (default=false)      : displacement time history'
      write(LER,*)
     1' -alp[alp]    (default=0)     : Ohnaka Pulse parameter'
	write(LER,*)
     1' -d           (default=true)  : Dirac delta function '
	write(LER,*)
     1' -t           (default=false) : triangular pulse wid=2*l*dt'
	write(LER,*)
     1' -p           (default=false) : parabolic pulse wid=4*l*dt'
	write(LER,*)
     1' -o       (default=forbidden) : ohnaka pulse '
	write(LER,*)
     1' -P           (default=false) : Plane wave output'
	write(LER,*)
     1'                                else X-T output'
      write(LER,*)
     1'Usage: rhfocsis -f[names]  -O[otap1]  '
     2,'  -A -V -D -d -t -o -p -P -a[alp] -l[l] '
      write(LER,*)
     1'***************************************************************'
      return
      end

	subroutine gcmdln(ntau,ipt,alp,ifile,names,idva,
     1		otap,verbos,plane,ishft,fl,fh)
	character names*(*), otap*(*)
	integer   ntau, ipt, alp, ifile,idva
	logical   plane
		integer argis
		logical verbos
		call argstr('-f', names, ' ', ' ' )
		call argstr('-O', otap, ' ', ' ')
		call argi4 ('-l' , ntau, 8, 8)
		call argi4 ('-s' , ishft, 0, 0)
		call argr4 ('-fl' , fl, 5.0, 5.0)
		call argr4 ('-fh' , fh, 0.0, 0.0)
		ipt = 3
		if(argis('-p').gt.0)then
			ipt = 1
		else if(argis('-t') .gt.0)then
			ipt = 0
		else if(argis('-o') .gt. 0)then
			ipt = 2
		else if(argis('-d') .gt. 0)then
			ipt = 3
		endif
                plane = (argis('-P') .gt. 0)
		idva = 1
		if(argis('-A') .gt. 0)then
			idva = 2
		else if(argis('-V') .gt. 0)then
			idva = 1
		else if(argis('-D') .gt. 0)then
			idva = 0
		endif
		call argr4('-a', alp, -1.0, -1.0)
		verbos = .true.
		ifile = 1
	return
	end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end

